package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TakeBreak invokes the ccc.TakeBreak API synchronously
func (client *Client) TakeBreak(request *TakeBreakRequest) (response *TakeBreakResponse, err error) {
	response = CreateTakeBreakResponse()
	err = client.DoAction(request, response)
	return
}

// TakeBreakWithChan invokes the ccc.TakeBreak API asynchronously
func (client *Client) TakeBreakWithChan(request *TakeBreakRequest) (<-chan *TakeBreakResponse, <-chan error) {
	responseChan := make(chan *TakeBreakResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TakeBreak(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TakeBreakWithCallback invokes the ccc.TakeBreak API asynchronously
func (client *Client) TakeBreakWithCallback(request *TakeBreakRequest, callback func(response *TakeBreakResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TakeBreakResponse
		var err error
		defer close(result)
		response, err = client.TakeBreak(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TakeBreakRequest is the request struct for api TakeBreak
type TakeBreakRequest struct {
	*requests.RpcRequest
	Code       string `position:"Query" name:"Code"`
	UserId     string `position:"Query" name:"UserId"`
	DeviceId   string `position:"Query" name:"DeviceId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// TakeBreakResponse is the response struct for api TakeBreak
type TakeBreakResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateTakeBreakRequest creates a request to invoke TakeBreak API
func CreateTakeBreakRequest() (request *TakeBreakRequest) {
	request = &TakeBreakRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "TakeBreak", "", "")
	request.Method = requests.POST
	return
}

// CreateTakeBreakResponse creates a response to parse from TakeBreak response
func CreateTakeBreakResponse() (response *TakeBreakResponse) {
	response = &TakeBreakResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
