package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTask invokes the dbfs.UpdateTask API synchronously
func (client *Client) UpdateTask(request *UpdateTaskRequest) (response *UpdateTaskResponse, err error) {
	response = CreateUpdateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskWithChan invokes the dbfs.UpdateTask API asynchronously
func (client *Client) UpdateTaskWithChan(request *UpdateTaskRequest) (<-chan *UpdateTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskWithCallback invokes the dbfs.UpdateTask API asynchronously
func (client *Client) UpdateTaskWithCallback(request *UpdateTaskRequest, callback func(response *UpdateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskRequest is the request struct for api UpdateTask
type UpdateTaskRequest struct {
	*requests.RpcRequest
	TaskProgress requests.Integer `position:"Query" name:"TaskProgress"`
	TaskIds      string           `position:"Query" name:"TaskIds"`
}

// UpdateTaskResponse is the response struct for api UpdateTask
type UpdateTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTaskRequest creates a request to invoke UpdateTask API
func CreateUpdateTaskRequest() (request *UpdateTaskRequest) {
	request = &UpdateTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "UpdateTask", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskResponse creates a response to parse from UpdateTask response
func CreateUpdateTaskResponse() (response *UpdateTaskResponse) {
	response = &UpdateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
