package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachLogStoreFromEndpointGroup invokes the ga.DetachLogStoreFromEndpointGroup API synchronously
func (client *Client) DetachLogStoreFromEndpointGroup(request *DetachLogStoreFromEndpointGroupRequest) (response *DetachLogStoreFromEndpointGroupResponse, err error) {
	response = CreateDetachLogStoreFromEndpointGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DetachLogStoreFromEndpointGroupWithChan invokes the ga.DetachLogStoreFromEndpointGroup API asynchronously
func (client *Client) DetachLogStoreFromEndpointGroupWithChan(request *DetachLogStoreFromEndpointGroupRequest) (<-chan *DetachLogStoreFromEndpointGroupResponse, <-chan error) {
	responseChan := make(chan *DetachLogStoreFromEndpointGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachLogStoreFromEndpointGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachLogStoreFromEndpointGroupWithCallback invokes the ga.DetachLogStoreFromEndpointGroup API asynchronously
func (client *Client) DetachLogStoreFromEndpointGroupWithCallback(request *DetachLogStoreFromEndpointGroupRequest, callback func(response *DetachLogStoreFromEndpointGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachLogStoreFromEndpointGroupResponse
		var err error
		defer close(result)
		response, err = client.DetachLogStoreFromEndpointGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachLogStoreFromEndpointGroupRequest is the request struct for api DetachLogStoreFromEndpointGroup
type DetachLogStoreFromEndpointGroupRequest struct {
	*requests.RpcRequest
	ClientToken      string    `position:"Query" name:"ClientToken"`
	ListenerId       string    `position:"Query" name:"ListenerId"`
	EndpointGroupIds *[]string `position:"Query" name:"EndpointGroupIds"  type:"Repeated"`
	AcceleratorId    string    `position:"Query" name:"AcceleratorId"`
}

// DetachLogStoreFromEndpointGroupResponse is the response struct for api DetachLogStoreFromEndpointGroup
type DetachLogStoreFromEndpointGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachLogStoreFromEndpointGroupRequest creates a request to invoke DetachLogStoreFromEndpointGroup API
func CreateDetachLogStoreFromEndpointGroupRequest() (request *DetachLogStoreFromEndpointGroupRequest) {
	request = &DetachLogStoreFromEndpointGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "DetachLogStoreFromEndpointGroup", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachLogStoreFromEndpointGroupResponse creates a response to parse from DetachLogStoreFromEndpointGroup response
func CreateDetachLogStoreFromEndpointGroupResponse() (response *DetachLogStoreFromEndpointGroupResponse) {
	response = &DetachLogStoreFromEndpointGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
