/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_bg extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ccp = "чакма";
        final String metaValue_gu = "гуджарати";
        final String metaValue_he = "иврит";
        final String metaValue_kn = "каннада";
        final String metaValue_ml = "малаялам";
        final String metaValue_or = "ория";
        final String metaValue_te = "телугу";
        final Object[][] data = new Object[][] {
            { "001", "свят" },
            { "002", "Африка" },
            { "003", "Северноамерикански континент" },
            { "005", "Южна Америка" },
            { "009", "Океания" },
            { "011", "Западна Афирка" },
            { "013", "Централна Америка" },
            { "014", "Източна Африка" },
            { "015", "Северна Африка" },
            { "017", "Централна Африка" },
            { "018", "Южноафрикански регион" },
            { "019", "Америка" },
            { "021", "Северна Америка" },
            { "029", "Карибски регион" },
            { "030", "Източна Азия" },
            { "034", "Южна Азия" },
            { "035", "Югоизточна Азия" },
            { "039", "Южна Европа" },
            { "053", "Австралазия" },
            { "054", "Меланезия" },
            { "057", "Микронезийски регион" },
            { "061", "Полинезия" },
            { "142", "Азия" },
            { "143", "Централна Азия" },
            { "145", "Западна Азия" },
            { "150", "Европа" },
            { "151", "Източна Европа" },
            { "154", "Северна Европа" },
            { "155", "Западна Европа" },
            { "202", "Субсахарска Африка" },
            { "419", "Латинска Америка" },
            { "AC", "остров Възнесение" },
            { "AD", "Андора" },
            { "AE", "Обединени арабски емирства" },
            { "AF", "Афганистан" },
            { "AG", "Антигуа и Барбуда" },
            { "AI", "Ангуила" },
            { "AL", "Албания" },
            { "AM", "Армения" },
            { "AO", "Ангола" },
            { "AQ", "Антарктика" },
            { "AR", "Аржентина" },
            { "AS", "Американска Самоа" },
            { "AT", "Австрия" },
            { "AU", "Австралия" },
            { "AW", "Аруба" },
            { "AX", "Оландски острови" },
            { "AZ", "Азербайджан" },
            { "BA", "Босна и Херцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Белгия" },
            { "BF", "Буркина Фасо" },
            { "BG", "България" },
            { "BH", "Бахрейн" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Сен Бартелеми" },
            { "BM", "Бермудски острови" },
            { "BN", "Бруней Даруссалам" },
            { "BO", "Боливия" },
            { "BQ", "Карибска Нидерландия" },
            { "BR", "Бразилия" },
            { "BS", "Бахамски острови" },
            { "BT", "Бутан" },
            { "BV", "остров Буве" },
            { "BW", "Ботсвана" },
            { "BY", "Беларус" },
            { "BZ", "Белиз" },
            { "CA", "Канада" },
            { "CC", "Кокосови острови (острови Кийлинг)" },
            { "CD", "Конго (Киншаса)" },
            { "CF", "Централноафриканска република" },
            { "CG", "Конго (Бразавил)" },
            { "CH", "Швейцария" },
            { "CI", "Кот д’Ивоар" },
            { "CK", "острови Кук" },
            { "CL", "Чили" },
            { "CM", "Камерун" },
            { "CN", "Китай" },
            { "CO", "Колумбия" },
            { "CP", "остров Клипертон" },
            { "CQ", "Сарк" },
            { "CR", "Коста Рика" },
            { "CU", "Куба" },
            { "CV", "Кабо Верде" },
            { "CW", "Кюрасао" },
            { "CX", "остров Рождество" },
            { "CY", "Кипър" },
            { "CZ", "Чехия" },
            { "DE", "Германия" },
            { "DG", "Диего Гарсия" },
            { "DJ", "Джибути" },
            { "DK", "Дания" },
            { "DM", "Доминика" },
            { "DO", "Доминиканска република" },
            { "DZ", "Алжир" },
            { "EA", "Сеута и Мелия" },
            { "EC", "Еквадор" },
            { "EE", "Естония" },
            { "EG", "Египет" },
            { "EH", "Западна Сахара" },
            { "ER", "Еритрея" },
            { "ES", "Испания" },
            { "ET", "Етиопия" },
            { "EU", "Европейски съюз" },
            { "EZ", "еврозона" },
            { "FI", "Финландия" },
            { "FJ", "Фиджи" },
            { "FK", "Фолкландски острови" },
            { "FM", "Микронезия" },
            { "FO", "Фарьорски острови" },
            { "FR", "Франция" },
            { "GA", "Габон" },
            { "GB", "Обединеното кралство" },
            { "GD", "Гренада" },
            { "GE", "Грузия" },
            { "GF", "Френска Гвиана" },
            { "GG", "Гърнзи" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренландия" },
            { "GM", "Гамбия" },
            { "GN", "Гвинея" },
            { "GP", "Гваделупа" },
            { "GQ", "Екваториална Гвинея" },
            { "GR", "Гърция" },
            { "GS", "Южна Джорджия и Южни Сандвичеви острови" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвинея-Бисау" },
            { "GY", "Гаяна" },
            { "HK", "Хонконг, САР на Китай" },
            { "HM", "острови Хърд и Макдоналд" },
            { "HN", "Хондурас" },
            { "HR", "Хърватия" },
            { "HT", "Хаити" },
            { "HU", "Унгария" },
            { "IC", "Канарски острови" },
            { "ID", "Индонезия" },
            { "IE", "Ирландия" },
            { "IL", "Израел" },
            { "IM", "остров Ман" },
            { "IN", "Индия" },
            { "IO", "Британска територия в Индийския океан" },
            { "IQ", "Ирак" },
            { "IR", "Иран" },
            { "IS", "Исландия" },
            { "IT", "Италия" },
            { "JE", "Джърси" },
            { "JM", "Ямайка" },
            { "JO", "Йордания" },
            { "JP", "Япония" },
            { "KE", "Кения" },
            { "KG", "Киргизстан" },
            { "KH", "Камбоджа" },
            { "KI", "Кирибати" },
            { "KM", "Коморски острови" },
            { "KN", "Сейнт Китс и Невис" },
            { "KP", "Северна Корея" },
            { "KR", "Южна Корея" },
            { "KW", "Кувейт" },
            { "KY", "Кайманови острови" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Ливан" },
            { "LC", "Сейнт Лусия" },
            { "LI", "Лихтенщайн" },
            { "LK", "Шри Ланка" },
            { "LR", "Либерия" },
            { "LS", "Лесото" },
            { "LT", "Литва" },
            { "LU", "Люксембург" },
            { "LV", "Латвия" },
            { "LY", "Либия" },
            { "MA", "Мароко" },
            { "MC", "Монако" },
            { "MD", "Молдова" },
            { "ME", "Черна гора" },
            { "MF", "Сен Мартен" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалови острови" },
            { "MK", "Северна Македония" },
            { "ML", "Мали" },
            { "MM", "Мианмар (Бирма)" },
            { "MN", "Монголия" },
            { "MO", "Макао, САР на Китай" },
            { "MP", "Северни Мариански острови" },
            { "MQ", "Мартиника" },
            { "MR", "Мавритания" },
            { "MS", "Монтсерат" },
            { "MT", "Малта" },
            { "MU", "Мавриций" },
            { "MV", "Малдиви" },
            { "MW", "Малави" },
            { "MX", "Мексико" },
            { "MY", "Малайзия" },
            { "MZ", "Мозамбик" },
            { "NA", "Намибия" },
            { "NC", "Нова Каледония" },
            { "NE", "Нигер" },
            { "NF", "остров Норфолк" },
            { "NG", "Нигерия" },
            { "NI", "Никарагуа" },
            { "NL", "Нидерландия" },
            { "NO", "Норвегия" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниуе" },
            { "NZ", "Нова Зеландия" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Френска Полинезия" },
            { "PG", "Папуа-Нова Гвинея" },
            { "PH", "Филипини" },
            { "PK", "Пакистан" },
            { "PL", "Полша" },
            { "PM", "Сен Пиер и Микелон" },
            { "PN", "Острови Питкерн" },
            { "PR", "Пуерто Рико" },
            { "PS", "Палестински територии" },
            { "PT", "Португалия" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Отдалечени острови на Океания" },
            { "RE", "Реюнион" },
            { "RO", "Румъния" },
            { "RS", "Сърбия" },
            { "RU", "Русия" },
            { "RW", "Руанда" },
            { "SA", "Саудитска Арабия" },
            { "SB", "Соломонови острови" },
            { "SC", "Сейшели" },
            { "SD", "Судан" },
            { "SE", "Швеция" },
            { "SG", "Сингапур" },
            { "SH", "Света Елена" },
            { "SI", "Словения" },
            { "SJ", "Свалбард и Ян Майен" },
            { "SK", "Словакия" },
            { "SL", "Сиера Леоне" },
            { "SM", "Сан Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомалия" },
            { "SR", "Суринам" },
            { "SS", "Южен Судан" },
            { "ST", "Сао Томе и Принсипи" },
            { "SV", "Салвадор" },
            { "SX", "Синт Мартен" },
            { "SY", "Сирия" },
            { "SZ", "Есватини" },
            { "TA", "Тристан да Куня" },
            { "TC", "острови Търкс и Кайкос" },
            { "TD", "Чад" },
            { "TF", "Френски южни територии" },
            { "TG", "Того" },
            { "TH", "Тайланд" },
            { "TJ", "Таджикистан" },
            { "TK", "Токелау" },
            { "TL", "Тимор Лесте" },
            { "TM", "Туркменистан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Турция" },
            { "TT", "Тринидад и Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тайван" },
            { "TZ", "Танзания" },
            { "UA", "Украйна" },
            { "UG", "Уганда" },
            { "UM", "Отдалечени острови на САЩ" },
            { "UN", "Организация на обединените нации" },
            { "US", "Съединени щати" },
            { "UY", "Уругвай" },
            { "UZ", "Узбекистан" },
            { "VA", "Ватикан" },
            { "VC", "Сейнт Винсънт и Гренадини" },
            { "VE", "Венецуела" },
            { "VG", "Британски Вирджински острови" },
            { "VI", "Американски Вирджински острови" },
            { "VN", "Виетнам" },
            { "VU", "Вануату" },
            { "WF", "Уолис и Футуна" },
            { "WS", "Самоа" },
            { "XA", "Псевдоакценти" },
            { "XB", "Псевдодвупосочни" },
            { "XK", "Косово" },
            { "YE", "Йемен" },
            { "YT", "Майот" },
            { "ZA", "Южна Африка" },
            { "ZM", "Замбия" },
            { "ZW", "Зимбабве" },
            { "ZZ", "непознат регион" },
            { "aa", "афарски" },
            { "ab", "абхазки" },
            { "ae", "авестски" },
            { "af", "африканс" },
            { "ak", "акан" },
            { "am", "амхарски" },
            { "an", "арагонски" },
            { "ar", "арабски" },
            { "as", "асамски" },
            { "av", "аварски" },
            { "ay", "аймара" },
            { "az", "азербайджански" },
            { "ba", "башкирски" },
            { "be", "беларуски" },
            { "bg", "български" },
            { "bi", "бислама" },
            { "bm", "бамбара" },
            { "bn", "бенгалски" },
            { "bo", "тибетски" },
            { "br", "бретонски" },
            { "bs", "босненски" },
            { "ca", "каталонски" },
            { "ce", "чеченски" },
            { "ch", "чаморо" },
            { "co", "корсикански" },
            { "cr", "крии" },
            { "cs", "чешки" },
            { "cu", "църковнославянски" },
            { "cv", "чувашки" },
            { "cy", "уелски" },
            { "da", "датски" },
            { "de", "немски" },
            { "dv", "дивехи" },
            { "dz", "дзонгкха" },
            { "ee", "еве" },
            { "el", "гръцки" },
            { "en", "английски" },
            { "eo", "есперанто" },
            { "es", "испански" },
            { "et", "естонски" },
            { "eu", "баски" },
            { "fa", "персийски" },
            { "ff", "фула" },
            { "fi", "фински" },
            { "fj", "фиджийски" },
            { "fo", "фарьорски" },
            { "fr", "френски" },
            { "fy", "западнофризийски" },
            { "ga", "ирландски" },
            { "gd", "шотландски келтски" },
            { "gl", "галисийски" },
            { "gn", "гуарани" },
            { "gu", metaValue_gu },
            { "gv", "манкски" },
            { "ha", "хауса" },
            { "he", metaValue_he },
            { "hi", "хинди" },
            { "ho", "хири моту" },
            { "hr", "хърватски" },
            { "ht", "хаитянски креолски" },
            { "hu", "унгарски" },
            { "hy", "арменски" },
            { "hz", "хереро" },
            { "ia", "интерлингва" },
            { "id", "индонезийски" },
            { "ie", "интерлингве" },
            { "ig", "игбо" },
            { "ii", "съчуански йи" },
            { "ik", "инупиак" },
            { "io", "идо" },
            { "is", "исландски" },
            { "it", "италиански" },
            { "iu", "инуктитут" },
            { "ja", "японски" },
            { "jv", "явански" },
            { "ka", "грузински" },
            { "kg", "конгоански" },
            { "ki", "кикую" },
            { "kj", "кваняма" },
            { "kk", "казахски" },
            { "kl", "гренландски" },
            { "km", "кхмерски" },
            { "kn", metaValue_kn },
            { "ko", "корейски" },
            { "kr", "канури" },
            { "ks", "кашмирски" },
            { "ku", "курманджи" },
            { "kv", "коми" },
            { "kw", "корнуолски" },
            { "ky", "киргизки" },
            { "la", "латински" },
            { "lb", "люксембургски" },
            { "lg", "ганда" },
            { "li", "лимбургски" },
            { "ln", "лингала" },
            { "lo", "лаоски" },
            { "lt", "литовски" },
            { "lu", "луба-катанга" },
            { "lv", "латвийски" },
            { "mg", "малгашки" },
            { "mh", "маршалезе" },
            { "mi", "маорски" },
            { "mk", "македонски" },
            { "ml", metaValue_ml },
            { "mn", "монголски" },
            { "mr", "марати" },
            { "ms", "малайски" },
            { "mt", "малтийски" },
            { "my", "бирмански" },
            { "na", "науру" },
            { "nb", "норвежки (букмол)" },
            { "nd", "северен ндебеле" },
            { "ne", "непалски" },
            { "ng", "ндонга" },
            { "nl", "нидерландски" },
            { "nn", "норвежки (нюношк)" },
            { "no", "норвежки" },
            { "nr", "южен ндебеле" },
            { "nv", "навахо" },
            { "ny", "нянджа" },
            { "oc", "окситански" },
            { "oj", "оджибва" },
            { "om", "оромо" },
            { "or", metaValue_or },
            { "os", "осетински" },
            { "pa", "пенджабски" },
            { "pi", "пали" },
            { "pl", "полски" },
            { "ps", "пущу" },
            { "pt", "португалски" },
            { "qu", "кечуа" },
            { "rm", "реторомански" },
            { "rn", "рунди" },
            { "ro", "румънски" },
            { "ru", "руски" },
            { "rw", "киняруанда" },
            { "sa", "санскрит" },
            { "sc", "сардински" },
            { "sd", "синдхи" },
            { "se", "северносаамски" },
            { "sg", "санго" },
            { "sh", "сърбохърватски" },
            { "si", "синхалски" },
            { "sk", "словашки" },
            { "sl", "словенски" },
            { "sm", "самоански" },
            { "sn", "шона" },
            { "so", "сомалийски" },
            { "sq", "албански" },
            { "sr", "сръбски" },
            { "ss", "свати" },
            { "st", "сото" },
            { "su", "сундански" },
            { "sv", "шведски" },
            { "sw", "суахили" },
            { "ta", "тамилски" },
            { "te", metaValue_te },
            { "tg", "таджикски" },
            { "th", "тайски" },
            { "ti", "тигриня" },
            { "tk", "туркменски" },
            { "tl", "тагалог" },
            { "tn", "тсвана" },
            { "to", "тонгански" },
            { "tr", "турски" },
            { "ts", "цонга" },
            { "tt", "татарски" },
            { "tw", "туи" },
            { "ty", "таитянски" },
            { "ug", "уйгурски" },
            { "uk", "украински" },
            { "ur", "урду" },
            { "uz", "узбекски" },
            { "ve", "венда" },
            { "vi", "виетнамски" },
            { "vo", "волапюк" },
            { "wa", "валонски" },
            { "wo", "волоф" },
            { "xh", "кхоса" },
            { "yi", "идиш" },
            { "yo", "йоруба" },
            { "za", "зуанг" },
            { "zh", "китайски" },
            { "zu", "зулуски" },
            { "ace", "ачешки" },
            { "ach", "аколи" },
            { "ada", "адангме" },
            { "ady", "адигейски" },
            { "afh", "африхили" },
            { "agq", "агем" },
            { "ain", "айну" },
            { "akk", "акадски" },
            { "ale", "алеутски" },
            { "alt", "южноалтайски" },
            { "ang", "староанглийски" },
            { "ann", "оболо" },
            { "anp", "ангика" },
            { "arc", "арамейски" },
            { "arn", "мапуче" },
            { "arp", "арапахо" },
            { "ars", "найди арабски" },
            { "arw", "аравак" },
            { "asa", "асу" },
            { "ast", "астурски" },
            { "atj", "атикамеку" },
            { "awa", "авади" },
            { "bal", "балучи" },
            { "ban", "балийски" },
            { "bas", "баса" },
            { "bej", "бея" },
            { "bem", "бемба" },
            { "bez", "бена" },
            { "bgc", "харианви" },
            { "bgn", "западен балочи" },
            { "bho", "боджпури" },
            { "bik", "биколски" },
            { "bin", "бини" },
            { "bla", "сиксика" },
            { "blo", "ании" },
            { "bra", "брадж" },
            { "brx", "бодо" },
            { "bua", "бурятски" },
            { "bug", "бугински" },
            { "byn", "биленски" },
            { "cad", "каддо" },
            { "car", "карибски" },
            { "cay", "каюга" },
            { "cch", "атсам" },
            { "ccp", metaValue_ccp },
            { "ceb", "себуански" },
            { "cgg", "чига" },
            { "chb", "чибча" },
            { "chg", "чагатай" },
            { "chk", "чуук" },
            { "chm", "марийски" },
            { "chn", "жаргон чинуук" },
            { "cho", "чокто" },
            { "chp", "чипеуански" },
            { "chr", "черокски" },
            { "chy", "шайенски" },
            { "ckb", "кюрдски (централен)" },
            { "clc", "чилкотин" },
            { "cop", "коптски" },
            { "crg", "мичиф" },
            { "crh", "кримскотатарски" },
            { "crj", "югоизточен крий" },
            { "crk", "плейнс крий" },
            { "crl", "североизточен крий" },
            { "crm", "муус крее" },
            { "crr", "каролински алгонкин" },
            { "crs", "сеселва, креолски френски" },
            { "csb", "кашубски" },
            { "csw", "суампи крий" },
            { "dak", "дакотски" },
            { "dar", "даргински" },
            { "dav", "таита" },
            { "del", "делауер" },
            { "den", "слейви" },
            { "dgr", "догриб" },
            { "din", "динка" },
            { "dje", "зарма" },
            { "doi", "догри" },
            { "dsb", "долнолужишки" },
            { "dua", "дуала" },
            { "dum", "средновековен холандски" },
            { "dyo", "диола-фони" },
            { "dyu", "диула" },
            { "dzg", "дазага" },
            { "ebu", "ембу" },
            { "efi", "ефик" },
            { "egy", "древноегипетски" },
            { "eka", "екажук" },
            { "elx", "еламитски" },
            { "enm", "средновековен английски" },
            { "ewo", "евондо" },
            { "fan", "фанг" },
            { "fat", "фанти" },
            { "fil", "филипински" },
            { "fon", "фон" },
            { "frc", "каджунски френски" },
            { "frm", "средновековен френски" },
            { "fro", "старофренски" },
            { "frr", "северен фризийски" },
            { "frs", "източнофризийски" },
            { "fur", "фриулски" },
            { "gaa", "га" },
            { "gag", "гагаузки" },
            { "gay", "гайо" },
            { "gba", "гбая" },
            { "gez", "гииз" },
            { "gil", "гилбертски" },
            { "gmh", "средновисоконемски" },
            { "goh", "старовисоконемски" },
            { "gon", "гонди" },
            { "gor", "горонтало" },
            { "got", "готически" },
            { "grb", "гребо" },
            { "grc", "древногръцки" },
            { "gsw", "швейцарски немски" },
            { "guz", "гусии" },
            { "gwi", "гвичин" },
            { "hai", "хайда" },
            { "haw", "хавайски" },
            { "hax", "южен хайда" },
            { "hil", "хилигайнон" },
            { "hit", "хитски" },
            { "hmn", "хмонг" },
            { "hsb", "горнолужишки" },
            { "hup", "хупа" },
            { "hur", "халкомелем" },
            { "iba", "ибан" },
            { "ibb", "ибибио" },
            { "ikt", "западноканадски инуктитут" },
            { "ilo", "илоко" },
            { "inh", "ингушетски" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачаме" },
            { "jpr", "юдео-персийски" },
            { "jrb", "юдео-арабски" },
            { "kaa", "каракалпашки" },
            { "kab", "кабилски" },
            { "kac", "качински" },
            { "kaj", "жжу" },
            { "kam", "камба" },
            { "kaw", "кави" },
            { "kbd", "кабардски" },
            { "kcg", "туап" },
            { "kde", "маконде" },
            { "kea", "кабовердиански" },
            { "kfo", "коро" },
            { "kgp", "кайнганг" },
            { "kha", "кхаси" },
            { "kho", "котски" },
            { "khq", "койра чиини" },
            { "kkj", "како" },
            { "kln", "календжин" },
            { "kmb", "кимбунду" },
            { "koi", "коми-пермякски" },
            { "kok", "конкани" },
            { "kos", "косраен" },
            { "kpe", "кпеле" },
            { "krc", "карачай-балкарски" },
            { "krl", "карелски" },
            { "kru", "курук" },
            { "ksb", "шамбала" },
            { "ksf", "бафия" },
            { "ksh", "кьолнски" },
            { "kum", "кумикски" },
            { "kut", "кутенай" },
            { "kwk", "куак’уала" },
            { "kxv", "кови" },
            { "lad", "ладино" },
            { "lag", "ланги" },
            { "lah", "лахнда" },
            { "lam", "ламба" },
            { "lez", "лезгински" },
            { "lij", "лигурски" },
            { "lil", "лилоует" },
            { "lkt", "лакота" },
            { "lmo", "ломбардски" },
            { "lol", "монго" },
            { "lou", "луизиански креолски" },
            { "loz", "лози" },
            { "lrc", "северен лури" },
            { "lsm", "саамски" },
            { "lua", "луба-лулуа" },
            { "lui", "луисеньо" },
            { "lun", "лунда" },
            { "luo", "луо" },
            { "lus", "мизо" },
            { "luy", "лухя" },
            { "mad", "мадурски" },
            { "mag", "магахи" },
            { "mai", "майтхили" },
            { "mak", "макасар" },
            { "man", "мандинго" },
            { "mas", "масайски" },
            { "mdf", "мокша" },
            { "mdr", "мандар" },
            { "men", "менде" },
            { "mer", "меру" },
            { "mfe", "морисиен" },
            { "mga", "средновековен ирландски" },
            { "mgh", "макуа мето" },
            { "mgo", "мета" },
            { "mic", "микмак" },
            { "min", "минангкабау" },
            { "mnc", "манджурски" },
            { "mni", "манипурски" },
            { "moe", "инну-аймун" },
            { "moh", "мохоук" },
            { "mos", "моси" },
            { "mua", "мунданг" },
            { "mul", "многоезични" },
            { "mus", "мускогски" },
            { "mwl", "мирандийски" },
            { "mwr", "марвари" },
            { "myv", "ерзиа" },
            { "mzn", "мазандерански" },
            { "nap", "неаполитански" },
            { "naq", "нама" },
            { "nds", "долнонемски" },
            { "new", "неварски" },
            { "nia", "ниас" },
            { "niu", "ниуеан" },
            { "nmg", "квасио" },
            { "nnh", "нгиембун" },
            { "nog", "ногаи" },
            { "non", "старонорвежки" },
            { "nqo", "нко" },
            { "nso", "северен сото" },
            { "nus", "нуер" },
            { "nwc", "класически невари" },
            { "nym", "ниамвези" },
            { "nyn", "нянколе" },
            { "nyo", "нуоро" },
            { "nzi", "нзима" },
            { "ojb", "северозападен оджибве" },
            { "ojc", "централен оджибва" },
            { "ojs", "оджи крий" },
            { "ojw", "западен оджибва" },
            { "oka", "оканаган" },
            { "osa", "осейджи" },
            { "ota", "отомански турски" },
            { "pag", "пангасинан" },
            { "pal", "пахлави" },
            { "pam", "пампанга" },
            { "pap", "папиаменто" },
            { "pau", "палауан" },
            { "pcm", "нигерийски пиджин" },
            { "peo", "староперсийски" },
            { "phn", "финикийски" },
            { "pis", "пиджин" },
            { "pon", "понапеан" },
            { "pqm", "малисеет-пасамакуоди" },
            { "prg", "пруски" },
            { "pro", "старопровансалски" },
            { "quc", "киче" },
            { "raj", "раджастански" },
            { "rap", "рапа нуи" },
            { "rar", "раротонга" },
            { "rhg", "рохинга" },
            { "rof", "ромбо" },
            { "rom", "ромски" },
            { "rup", "арумънски" },
            { "rwk", "рва" },
            { "sad", "сандаве" },
            { "sah", "саха" },
            { "sam", "самаритански арамейски" },
            { "saq", "самбуру" },
            { "sas", "сасак" },
            { "sat", "сантали" },
            { "sba", "нгамбай" },
            { "sbp", "сангу" },
            { "scn", "сицилиански" },
            { "sco", "шотландски" },
            { "sdh", "южнокюрдски" },
            { "seh", "сена" },
            { "sel", "селкуп" },
            { "ses", "койраборо сени" },
            { "sga", "староирландски" },
            { "shi", "ташелхит" },
            { "shn", "шан" },
            { "sid", "сидамо" },
            { "slh", "южен лашутсийд" },
            { "sma", "южносаамски" },
            { "smj", "луле-саамски" },
            { "smn", "инари-саамски" },
            { "sms", "сколт-саамски" },
            { "snk", "сонинке" },
            { "sog", "согдийски" },
            { "srn", "сранан тонго" },
            { "srr", "серер" },
            { "ssy", "сахо" },
            { "str", "стрейтс салиш" },
            { "suk", "сукума" },
            { "sus", "сусу" },
            { "sux", "шумерски" },
            { "swb", "коморски" },
            { "syc", "класически сирийски" },
            { "syr", "сирийски" },
            { "szl", "силезийски" },
            { "tce", "южен тучоне" },
            { "tem", "темне" },
            { "teo", "тесо" },
            { "ter", "терено" },
            { "tet", "тетум" },
            { "tgx", "тагиш" },
            { "tht", "талтан" },
            { "tig", "тигре" },
            { "tiv", "тив" },
            { "tkl", "токелайски" },
            { "tlh", "клингонски" },
            { "tli", "тлингит" },
            { "tmh", "тамашек" },
            { "tog", "нианса тонга" },
            { "tok", "токи пона" },
            { "tpi", "ток писин" },
            { "trv", "тароко" },
            { "tsi", "цимшиански" },
            { "ttm", "северен тучоне" },
            { "tum", "тумбука" },
            { "tvl", "тувалуански" },
            { "twq", "тасавак" },
            { "tyv", "тувински" },
            { "tzm", "централноатласки тамазигт" },
            { "udm", "удмуртски" },
            { "uga", "угаритски" },
            { "umb", "умбунду" },
            { "und", "непознат език" },
            { "vai", "ваи" },
            { "vec", "венециански" },
            { "vmw", "макува" },
            { "vot", "вотик" },
            { "vun", "вунджо" },
            { "wae", "валзерски немски" },
            { "wal", "валамо" },
            { "war", "варай" },
            { "was", "уашо" },
            { "wbp", "валпири" },
            { "wuu", "ву китайски" },
            { "xal", "калмик" },
            { "xnr", "кангри" },
            { "xog", "сога" },
            { "yao", "яо" },
            { "yap", "япезе" },
            { "yav", "янгбен" },
            { "ybb", "йемба" },
            { "yrl", "ненгату" },
            { "yue", "кантонски" },
            { "zap", "запотек" },
            { "zbl", "блис символи" },
            { "zen", "зенага" },
            { "zgh", "стандартен марокански тамазигт" },
            { "zun", "зуни" },
            { "zxx", "без лингвистично съдържание" },
            { "zza", "заза" },
            { "Adlm", "адлам" },
            { "Arab", "арабска" },
            { "Aran", "aранска" },
            { "Armi", "Арамейска" },
            { "Armn", "арменска" },
            { "Avst", "Авестанска" },
            { "Bali", "Балийски" },
            { "Batk", "Батакска" },
            { "Beng", "бенгалска" },
            { "Blis", "Блис символи" },
            { "Bopo", "бопомофо" },
            { "Brah", "Брахми" },
            { "Brai", "брайлова" },
            { "Bugi", "Бугинска" },
            { "Buhd", "Бухид" },
            { "Cakm", metaValue_ccp },
            { "Cans", "унифицирани символи на канадски аборигени" },
            { "Cari", "Карийска" },
            { "Cham", "Хамитска" },
            { "Cher", "чероки" },
            { "Cirt", "Кирт" },
            { "Copt", "Коптска" },
            { "Cprt", "Кипърска" },
            { "Cyrl", "кирилица" },
            { "Deva", "деванагари" },
            { "Dsrt", "Дезерет" },
            { "Egyd", "Египетско демотично писмо" },
            { "Egyh", "Египетско йератично писмо" },
            { "Egyp", "Египетски йероглифи" },
            { "Ethi", "етиопска" },
            { "Geok", "Грузинска хуцури" },
            { "Geor", "грузинска" },
            { "Glag", "Глаголическа" },
            { "Goth", "Готическа" },
            { "Grek", "гръцка" },
            { "Gujr", metaValue_gu },
            { "Guru", "гурмукхи" },
            { "Hanb", "ханб" },
            { "Hang", "хангъл" },
            { "Hani", "хан" },
            { "Hano", "Хануну" },
            { "Hans", "опростена" },
            { "Hant", "традиционна" },
            { "Hebr", metaValue_he },
            { "Hira", "хирагана" },
            { "Hmng", "Пахау хмонг" },
            { "Hrkt", "японска сричкова" },
            { "Hung", "Староунгарска" },
            { "Inds", "Харапска" },
            { "Ital", "Древно италийска" },
            { "Jamo", "джамо" },
            { "Java", "Яванска" },
            { "Jpan", "японска" },
            { "Kali", "Кая Ли" },
            { "Kana", "катакана" },
            { "Khar", "Кхароштхи" },
            { "Khmr", "кхмерска" },
            { "Knda", metaValue_kn },
            { "Kore", "корейска" },
            { "Kthi", "Кайтхи" },
            { "Lana", "Ланна" },
            { "Laoo", "лаоска" },
            { "Latf", "Латинска фрактура" },
            { "Latg", "Галска латинска" },
            { "Latn", "латиница" },
            { "Lepc", "Лепча" },
            { "Limb", "Лимбу" },
            { "Lina", "Линейна А" },
            { "Linb", "Линейна Б" },
            { "Lyci", "Лицийска" },
            { "Lydi", "Лидийска" },
            { "Mand", "Мандаринска" },
            { "Mani", "Манихейска" },
            { "Maya", "Йероглифи на Маите" },
            { "Mero", "Мероитска" },
            { "Mlym", metaValue_ml },
            { "Mong", "монголска" },
            { "Moon", "Мун" },
            { "Mtei", "манипури" },
            { "Mymr", "бирманска" },
            { "Nkoo", "Н’Ко" },
            { "Ogam", "Огамическа" },
            { "Olck", "Ол Чики" },
            { "Orkh", "Орхоно-енисейска" },
            { "Orya", metaValue_or },
            { "Osma", "Османска" },
            { "Perm", "Древно пермска" },
            { "Phag", "Фагс-па" },
            { "Phlv", "Пахлавска" },
            { "Phnx", "Финикийска" },
            { "Plrd", "Писменост Полард" },
            { "Rohg", "харифи" },
            { "Roro", "Ронго-ронго" },
            { "Runr", "Руническа" },
            { "Samr", "Самаританска" },
            { "Sara", "Сарати" },
            { "Saur", "Саураштра" },
            { "Sinh", "синхалска" },
            { "Sund", "сунданска" },
            { "Sylo", "Силоти Нагри" },
            { "Syrc", "сирийска" },
            { "Syre", "Сирийска естрангело" },
            { "Syrj", "Западна сирийска" },
            { "Syrn", "Източна сирийска" },
            { "Tagb", "Тагбанва" },
            { "Tale", "Тай Ле" },
            { "Talu", "Нова Тай Ле" },
            { "Taml", "тамилска" },
            { "Telu", metaValue_te },
            { "Tfng", "тифинаг" },
            { "Tglg", "Тагалог" },
            { "Thaa", "таана" },
            { "Thai", "тайска" },
            { "Tibt", "тибетска" },
            { "Ugar", "Угаритска" },
            { "Vaii", "вайска" },
            { "Visp", "Видима реч" },
            { "Xpeo", "Староперсийска" },
            { "Xsux", "Шумеро-акадски клинопис" },
            { "Yiii", "Йи" },
            { "Zmth", "математически символи" },
            { "Zsye", "емоджи" },
            { "Zsym", "символи" },
            { "Zxxx", "без писменост" },
            { "Zyyy", "обща" },
            { "Zzzz", "непозната писменост" },
            { "en_AU", "австралийски английски" },
            { "en_CA", "канадски английски" },
            { "en_GB", "британски английски" },
            { "en_US", "американски английски" },
            { "fa_AF", "дари" },
            { "nl_BE", "фламандски" },
            { "ro_MD", "молдовски" },
            { "sw_CD", "конгоански суахили" },
            { "%%1901", "Традиционен немски правопис" },
            { "%%1994", "Стандартен резиански правопис" },
            { "%%1996", "Немски правопис от 1996" },
            { "ar_001", "съвременен стандартен арабски" },
            { "key.ca", "календар" },
            { "key.cf", "формат на валута" },
            { "key.co", "ред на сортиране" },
            { "key.cu", "валута" },
            { "key.em", "Представяне на емотикон" },
            { "key.hc", "Часови формат (12- или 24-часов)" },
            { "key.lb", "Стил за нов ред" },
            { "key.lw", "Нов ред в средата на думите" },
            { "key.ms", "Мерна система" },
            { "key.nu", "цифри" },
            { "key.ss", "прекъсване на изречение след съкращение" },
            { "key.tz", "Часова зона" },
            { "key.va", "Вариант на локала" },
            { "nds_NL", "долносаксонски" },
            { "%%BISKE", "Диалект Сан Джорджио/Била" },
            { "%%BOONT", "Бунтлинг" },
            { "%%LIPAW", "Диалект Липовац" },
            { "%%NEDIS", "Диалект Натисоне" },
            { "%%NJIVA", "Диалект Нджива" },
            { "%%OSOJS", "Диалект Осеако/Осояне" },
            { "%%POSIX", "Компютърен" },
            { "%%ROZAJ", "Резиански" },
            { "%%SAAHO", "Сахо" },
            { "%%SOLBA", "Диалект Столвиза" },
            { "zh_Hans", "китайски (опростен)" },
            { "zh_Hant", "китайски (традиционен)" },
            { "%%FONIPA", "Международна фонетична азбука" },
            { "%%FONUPA", "Уралска фонетична азбука" },
            { "%%PINYIN", "Пинин романизация" },
            { "%%SCOUSE", "Ливърпулски диалект" },
            { "%%TARASK", "Тарашкевица" },
            { "%%AREVELA", "Източно арменски" },
            { "%%AREVMDA", "Западно арменски" },
            { "%%MONOTON", "Монотонично" },
            { "%%POLYTON", "Политонично" },
            { "%%REVISED", "Променен правопис" },
            { "%%1606NICT", "Късен средновековен френски до 1606" },
            { "%%1694ACAD", "Ранен съвременен френски" },
            { "%%BAKU1926", "Унифицирана тюркска азбука" },
            { "%%SCOTLAND", "Шотландски английски" },
            { "%%VALENCIA", "Валенсиански" },
            { "%%WADEGILE", "Уейд-Джайлс романизация" },
            { "type.ca.roc", "календар на Република Китай" },
            { "type.hc.h11", "12-часова система (0 – 11)" },
            { "type.hc.h12", "12-часова система (1 – 12)" },
            { "type.hc.h23", "24-часова система (0 – 23)" },
            { "type.hc.h24", "24-часова система (1 – 24)" },
            { "type.m0.bgn", "АКГН (BGN)" },
            { "type.nu.arab", "арабско-индийски цифри" },
            { "type.nu.armn", "арменски цифри" },
            { "type.nu.beng", "бенгалски цифри" },
            { "type.nu.cakm", "цифри в чакма" },
            { "type.nu.deva", "цифри в деванагари" },
            { "type.nu.ethi", "етиопски цифри" },
            { "type.nu.geor", "грузински цифри" },
            { "type.nu.grek", "гръцки цифри" },
            { "type.nu.gujr", "цифри в гуджарати" },
            { "type.nu.guru", "цифри в гурмукхи" },
            { "type.nu.hans", "цифри в китайски (опростен)" },
            { "type.nu.hant", "цифри в китайски (традиционен)" },
            { "type.nu.hebr", "цифри в иврит" },
            { "type.nu.java", "явански цифри" },
            { "type.nu.jpan", "японски цифри" },
            { "type.nu.khmr", "кхмерски цифри" },
            { "type.nu.knda", "цифри в каннада" },
            { "type.nu.laoo", "лаоски цифри" },
            { "type.nu.latn", "западни цифри" },
            { "type.nu.mlym", "цифри в малаялам" },
            { "type.nu.mong", "Монголски цифри" },
            { "type.nu.mtei", "цифри в меетеи майтек" },
            { "type.nu.mymr", "бирмански цифри" },
            { "type.nu.olck", "цифри в ол чики" },
            { "type.nu.orya", "цифри в одия" },
            { "type.nu.taml", "традиционни тамилски цифри" },
            { "type.nu.telu", "цифри в телугу" },
            { "type.nu.thai", "тайландски цифри" },
            { "type.nu.tibt", "тибетски цифри" },
            { "type.nu.vaii", "цифри във ваи" },
            { "type.ca.dangi", "корейски календар" },
            { "type.co.ducet", "ред на сортиране в Unicode по подразбиране" },
            { "type.lb.loose", "Свободен стил за нов ред" },
            { "type.nu.roman", "римски цифри" },
            { "type.ca.coptic", "коптски календар" },
            { "type.ca.hebrew", "еврейски календар" },
            { "type.ca.indian", "Индийски граждански календар" },
            { "type.co.compat", "предишен ред на сортиране, за съвместимост" },
            { "type.co.pinyin", "Сортиране Пинин" },
            { "type.co.search", "търсене с общо предназначение" },
            { "type.co.stroke", "Сортиране по щрих" },
            { "type.co.unihan", "Ред на сортиране по ключове и черти" },
            { "type.co.zhuyin", "ред на сортиране Бопомофо" },
            { "type.d0.fwidth", "С пълна ширина" },
            { "type.d0.hwidth", "С половин ширина" },
            { "type.lb.normal", "Нормален стил за нов ред" },
            { "type.lb.strict", "Строг стил за нов ред" },
            { "type.m0.ungegn", "ГЕСГИ ООН (UNGEGN)" },
            { "type.ms.metric", "Метрична система" },
            { "type.nu.native", "Местни цифри" },
            { "type.ca.chinese", "китайски календар" },
            { "type.ca.islamic", "ислямски календар" },
            { "type.ca.iso8601", "календар съгласно ISO 8601" },
            { "type.ca.persian", "персийски календар" },
            { "type.cf.account", "формат на валута за счетоводни цели" },
            { "type.d0.npinyin", "Цифрови" },
            { "type.nu.arabext", "разширени арабско-индийски цифри" },
            { "type.nu.armnlow", "арменски цифри в долен регистър" },
            { "type.nu.finance", "Финансови цифри" },
            { "type.nu.greklow", "гръцки цифри в долен регистър" },
            { "type.nu.hanidec", "китайски десетични цифри" },
            { "type.nu.hansfin", "финансови цифри в китайски (опростен)" },
            { "type.nu.hantfin", "финансови цифри в китайски (традиционен)" },
            { "type.nu.jpanfin", "японски финансови цифри" },
            { "type.nu.tamldec", "тамилски цифри" },
            { "type.ca.buddhist", "будистки календар" },
            { "type.ca.ethiopic", "етиопски календар" },
            { "type.ca.japanese", "японски календар" },
            { "type.cf.standard", "стандартен формат на валута" },
            { "type.co.phonetic", "Фонетичен ред на сортиране" },
            { "type.co.searchjl", "Търсене по първоначални съгласни в хангул" },
            { "type.co.standard", "стандартен ред на сортиране" },
            { "type.ms.uksystem", "Имперска мерна система" },
            { "type.ms.ussystem", "Мерна система на САЩ" },
            { "type.nu.fullwide", "цифри с пълна ширина" },
            { "type.nu.romanlow", "римски цифри в долен регистър" },
            { "type.ca.gregorian", "григориански календар" },
            { "type.co.phonebook", "Азбучен ред" },
            { "type.co.dictionary", "Речников ред на сортиране" },
            { "type.co.traditional", "Традиционно сортиране" },
            { "type.nu.traditional", "Традиционни цифри" },
            { "type.ca.islamic-civil", "ислямски календар Хиджра" },
            { "type.ca.islamic-umalqura", "ислямски календар Хиджра (Ум ал-Кура)" },
            { "type.ca.ethiopic-amete-alem", "етиопски календар Амит Алем" },
        };
        return data;
    }
}
