# web package
# Matthew Bertucci 2022/05/10 for v6.1.7

#include:xkeyval
#include:ifpdf
#include:ifxetex
#include:xcolor
#include:calc
#include:amssymb
#include:hyperref
#include:aeb-comment

#keyvals:\usepackage/web#c
noxcolor
dutch
french
german
italian
norsk
russian
spanish
dansk
polish
finnish
czech
catalan
brazil
turkish
dvips
dvipsone
dviwindo
textures
pdftex
dvipdfm
dvipdfmx
xetex
luatex
forpaper
forcolorpaper
latexlayout
uselatexsectioning
weblikeclass
nodirectory
usedirectory
latextoc
nobullets
designi
designii
designiii
designiv
designv
designvi
designvii
designviii
designix
usesf
unicode
xhyperref
addtoHyOpts={%<hyperref options%>}
addtoHyOpts*={%<hyperref options%>}
useui
forceSubSubNumbers
centertitlepage
centertitlepagefull
pro
extended
draft
usetemplates
leftpanel
rightpanel
templatesforpaper
rightpanelprt
leftpanelprt
navibar
navibar*
tight
tight*
uselatexparts
uselatexchapters
# options passed to xcolor package
natural
rgb
cmy
cmyk
hsb
gray
RGB
HTML
HSB
Gray
monochrome
dvipsnames
dvipsnames*
svgnames
svgnames*
x11names
x11names*
table
fixpdftex
hyperref
prologue
kernelfbox
xcdraw
noxcdraw
fixinclude
showerrors
hideerrors
#endkeyvals

#ifOption:usetemplates
#include:eso-pic
#include:graphicx
#endif
#ifOption:leftpanel
#include:eso-pic
#include:graphicx
#endif
#ifOption:rightpanel
#include:eso-pic
#include:graphicx
#endif
#ifOption:leftpanelprt
#include:eso-pic
#include:graphicx
#endif
#ifOption:rightpanelprt
#include:eso-pic
#include:graphicx
#endif

#ifOption:useui
\ui{keyvals}
#keyvals:\ui
border=#visible,invisible
linewidth=#thin,medium,thick
highlight=#none,invert,outline,inset,push
bordercolor={%<R G B%>}
linestyle=#solid,dashed,underlined,beveled,inset
dasharray=%<number%>
linktxtcolor=#%color
annotflags=#hidden,print,-print,noview,lock
fieldflags=#readonly,required,noexport,multiline,password,notoggleoff,radio,pushbutton,combo,edit,sort,fileselect,multiselect,nospellcheck,noscrolling,comb,radiosinunison,commitonchange,richtext
maxlength=%<number%>
tooltip={%<text%>}
default=%<text%>
value=%<text%>
rotate=#0,90,180,270
bgcolor={%<R G B%>}
uptxt={%<text%>}
downtxt={%<text%>}
rollovertxt={%<text%>}
normappr=%<string%>
rollappr=%<string%>
downappr=%<string%>
importicons=#yes,no
layout=#labelonly,icononly,icontop,iconbottom,iconleft,iconright,labelover
scalewhen=#always,never,iconbig,iconsmall
scale=#proportional,nonproportional
position={%<x y%>}
fitbounds#true,false
appr={%<specs%>}
align=#left,centered,right
textfont=%<font name%>
textsize=%<number%>
textcolor=%<number%>
autocenter=#yes,no
inline=#yes,no
presets=%<\cmd%>
symbolchoice=#check,circle,cross,diamond,square,star
rectW=##L
rectH=##L
width=##L
height=##L
scalefactor=%<factor%>
goto={%<KV-pairs%>}
js={%<script%>}
mouseup={%<script%>}
mousedown={%<script%>}
onenter={%<script%>}
onexit={%<script%>}
onfocus={%<script%>}
onblur={%<script%>}
format={%<script%>}
keystroke={%<script%>}
validate={%<script%>}
calculate={%<script%>}
pageopen={%<script%>}
pageclose={%<script%>}
pagevisible={%<script%>}
pageinvisible={%<script%>}
lock={%<KV-pairs%>}
#endkeyvals
#endif

\screensize{height}{width}
\margins{left}{right}{top}{bottom}
\margins[panel width]{left}{right}{top}{bottom}

\setScreensizeFromGraphic{imagefile}#g
\setScreensizeFromGraphic[options%keyvals]{imagefile}#g
\addtoWebHeight{length}
\addtoWebWidth{length}
\panelwidth{width}
\lheader{text}
\cheader{text}
\rheader{text}
\lfooter{text}
\cfooter{text}
\rfooter{text}
\headerformat{font commands}
\footerformat{font commands}
\webheadwrapper{code}#*
\webfootwrapper{code}#*
\clearHeaders
\restoreHeaders
\clearFooters
\restoreFooters
\headersOnSectionPage
\noHeadersOnSectionPage
\subject{subject%text}
\university{university%text}
\email{email%URL}#U
\version{version}
\copyrightyears{years}
\universityColor{color}
\titleColor{color}
\authorColor{color}
\keywords{word1,word2,...%text}
\topTitlePage
\titlepageTrailer
\optionalPageMatter{content%text}
\optionalPageMatter[vspace]{content%text}
\nocopyright
\minimumskip#*
\copyrightLabel{text}
\revisionLabel{text}
\versionLabel{text}
\webtitle#*
\webauthor#*
\websubject#*
\webkeywords#*
\webuniversity#*
\webemail#*
\webversion#*
\webcopyrightyears#*
\directoryName{name%text}
\tocName{name%text}
\dirContentLink{text}
\formatWordDirectory{font commands}
\formatDirectoryItems{font commands}
\removeDirTOC
\removeDirArticle
\addtoDirList{new item%text}
\dirTOCItem
\dirArticleItem
\priorDirMatter{content%text}
\afterDirMatter{content%text}
\priorDirList{content%text}
\afterDirList{content%text}
\directoryhook{code}
\tocindent{indent}
\widestNumber{number}
\tocColor{color}
\coverpagemargin#*
\makeinlinetitle
\NaviBarOn
\NaviBarOff
\navibarTextColor{color}
\navibarBgColor{color}
\navibariconHeight{height}
\navibariconWidth{width}
\newNaviIcon{cmd}{width}{height}{text}{action%definition}#d
\newNaviIcon[m|j|l]{cmd}{width}{height}{text}{action%definition}#d
\insertnaviiconhere{code}
\insertnaviiconhereafter{code}
\ArrowUp{code}
\ArrowDown{code}
\defaultpageheader
\directionIconTextColor{color}
\directionIconBgColor{color}
\panelNaviGroup
\ifeqforpaper#*
\eqforpapertrue#*
\eqforpaperfalse#*
\useFullWidthForPaper
\prtscr{print text%text}{screen text%text}
\begin{forscreen}
\end{forscreen}
\begin{forpaper}
\end{forpaper}
\NewPage
\template{imagefile}#g
\template[options%keyvals]{imagefile}#g
\textBgColor{color}
\AddToTemplate{template name}
\paneltemplate{imagefile}#g
\paneltemplate[options%keyvals]{imagefile}#g
\panelBgColor{color}
\AddToPanelTemplate{template name}
\buildpanel{content%text}
\minPanelWidth{length}
\disableTemplate{template name}
\enableTemplate{template name}
\disablePanelTemplate{template name}
\enablePanelTemplate{template name}
\ClearTextTemplate
\ClearPanelTemplate
\ClearBuildPanel
\ClearAllTemplates
\ClearTextTemplateBuffer
\ClearPanelTemplateBuffer
\aboveTopTitleSkip{skip}
\noFinalDot

#keyvals:\setScreensizeFromGraphic,\template
actualtext={%<text%>}
alt={%<alt text%>}
artifact#true,false
bb=%<llx lly urx ury%>
bbllx=
bblly=
bburx=
bbury=
natwidth=
natheight=
hiresbb#true,false
pagebox=#mediabox,cropbox,bleedbox,trimbox,artbox
viewport=%<llx lly urx ury%>
trim=%<llx lly urx ury%>
angle=%<degrees%>
origin=
width=##L
height=##L
totalheight=##L
keepaspectratio#true,false
scale=%<factor%>
clip#true,false
draft#true,false
type=%<file type%>
ext=%<file extension%>
read=%<read-file extension%>
command=
quiet
page=%<page number%>
interpolate#true,false
decodearray={%<color array%>}
#endkeyvals

# from websec.def (loaded by default)
\tocPartTitle{TeX code}
\formatPartTitle{TeX code}
\restorePartTitleFormat
\noPartNumbers
\formatChapterNumber{TeX code}
\formatChapterTitle{TeX code}

# from webpro.def (loaded with pro or extended options)
#ifOption:pro
#include:pifont
\DeclareDocInfo{keyvals}
#keyvals:\DeclareDocInfo
title={%<text%>}
author={%<name%>}
university={%<university%>}
email=%<email%>
talksite={%<site%>}
talkdate=%<date%>
talkdateLabel={%<text%>}
version=%<version%>
versionLabel={%<text%>}
subject={%<subject%>}
keywords={%<word1,word2,...%>}
copyrightyears={%<years%>}
prepared=%<date%>
preparedLabel={%<text%>}
Title={%<text%>}
authors={%<name1%>}{%<name2%>}%<...%>
Subject={%<subject%>}
Keywords={%<word1,word2,...%>}
lang=%<language%>
copyrightStatus=#True,False
copyrightNotice={%<text%>}
copyrightInfoURL=%<URL%>
authortitle={%<text%>}
descriptionwriter={%<text%>}
customProperties={name=%<name1%>,value=%<value1%>}%<{name=name2,value=value2}...%>
#endkeyvals
\DeclarePageLayout{keyvals}
#keyvals:\DeclarePageLayout
design=#designi,designii,designiii,designiv,designv,designvi,designvii,designviii,designix
screensizeOf=#designi,designii,designiii,designiv,designv,designvi,designvii,designviii,designix
screensize={%<height%>}{%<width%>}
margins={%<left%>}{%<right%>}{%<top%>}{%<bottom%>}
headheight=##L
topmargin=##L
additionalheadsep=##L
marginparsep=##L
marginparwidth=##L
marginparpush=##L
footskip=##L
webfootskip=##L
panelwidth=##L
panelsep=##L
#endkeyvals
\universityLayout{keyvals}
\titleLayout{keyvals}
\authorLayout{keyvals}
#keyvals:\universityLayout,\titleLayout,\authorLayout
fontfamily=#rmfamily,sffamily,ttfamily
fontseries=#bfseries,mdseries
fontshape=#upshape,itshape,scshape,slshape
fontsize=#tiny,scriptsize,footnotesize,small,normalsize,large,Large,LARGE,huge,Huge
halign=#l,c,r
color=#%color
special=#shadow,framebox,colorbox,fcolorbox,frameboxfit,colorboxfit,fcolorboxfit,custom,default
framecolor=#%color
bgcolor=#%color
shadowcolor=#%color
beforeskip=##L
afterskip=##L
usefont={%<encoding%>}{%<family%>}{%<series%>}{%<shape%>}{%<size%>}
hproportion=%<factor%>
xhalign=#l,c,r
#endkeyvals
\topTitlePageProportion{factor}
\DesignTitlePageTrailer{keyvals}
#keyvals:\DesignTitlePageTrailer
ul=%<text%>
ur=%<text%>
ll=%<text%>
lr=%<text%>
textColor=#%color
bgColor=#%color
borderColor=#%color
fboxsep=##L
fboxrule=##L
graphic=%<imagefile%>
namedgraphic=%<name%>
raise=##L
fontSize=%<fontsize cmd%>
formatting=%<font commands%>
#endkeyvals
\selectTocDings{keyvals}
#keyvals:\selectTocDings
dDing=%<symbol%>
ddDing=%<symbol%>
dddDing=%<symbol%>
dDingColor=#%color
ddDingColor=#%color
dddDingColor=#%color
#endkeyvals
\selectColors{keyvals}
#keyvals:\selectColors
universityColor=#%color
titleColor=#%color
textBgColor=#%color
panelBgColor=#%color
urlColor=#%color
linkColor=#%color
fileColor=#%color
#endkeyvals
\noSectionNumbers
\tocLayout{keyvals}
\sectionLayout{keyvals}
\subsectionLayout{keyvals}
\subsubsectionLayout{keyvals}
#keyvals:\tocLayout,\sectionLayout,\subsectionLayout,\subsubsectionLayout
fontfamily=#rmfamily,sffamily,ttfamily
fontseries=#bfseries,mdseries
fontshape=#upshape,itshape,scshape,slshape
fontsize=#tiny,scriptsize,footnotesize,small,normalsize,large,Large,LARGE,huge,Huge
halign=#l,c,r
ding=%<symbol%>
color=#%color
special=#shadow,framebox,colorbox,fcolorbox,frameboxfit,colorboxfit,fcolorboxfit,custom,default
framecolor=#%color
bgcolor=#%color
shadowcolor=#%color
beforeskip=##L
afterskip=##L
usefont={%<encoding%>}{%<family%>}{%<series%>}{%<shape%>}{%<size%>}
numdingcolor=#%color
reset=#font,all
#endkeyvals
\shadowhoffset{length}
\shadowvoffset{length}
\customSecHead{TeX code}
\customSubsecHead{TeX code}
\customSubsubsecHead{TeX code}
\preparedLabel{text}#*
\prepared{date}#*
\talkdate{date}#*
\webtalkdate#*
\talkdateLabel{text}#*
\talksite{site}#*
\customUniversity{TeX code}#*
\customTitle{TeX code}#*
\customAuthor{TeX code}#*
\customToc{TeX code}#*
\halignuniversity#*
\haligntitle#*
\halignauthor#*
\halignsection#*
\halignsubsection#*
\halignsubsubsection#*
\haligntoc#*
\subsubDefaultDing{symbol}#*
\sectionTitle#*
\sectionAuthor#*
\sectionUniversity#*
\sectionToc#*
\ifShadow#*
\Shadowtrue#*
\Shadowfalse#*
\useSectionNumbers#*
\dDingToc{symbol}#*
\ddDingToc{symbol}#*
\dddDingToc{symbol}#*
\dDingTocColor{color}#*
\ddDingTocColor{color}#*
\dddDingTocColor{color}#*
#endif

#ifOption:extended
#include:pifont
\DeclareDocInfo{keyvals}
#keyvals:\DeclareDocInfo
title={%<text%>}
author={%<name%>}
university={%<university%>}
email=%<email%>
talksite={%<site%>}
talkdate=%<date%>
talkdateLabel={%<text%>}
version=%<version%>
versionLabel={%<text%>}
subject={%<subject%>}
keywords={%<word1,word2,...%>}
copyrightyears={%<years%>}
prepared=%<date%>
preparedLabel={%<text%>}
Title={%<text%>}
authors={%<name1%>}{%<name2%>}%<...%>
Subject={%<subject%>}
Keywords={%<word1,word2,...%>}
lang=%<language%>
copyrightStatus=#True,False
copyrightNotice={%<text%>}
copyrightInfoURL=%<URL%>
authortitle={%<text%>}
descriptionwriter={%<text%>}
customProperties={name=%<name1%>,value=%<value1%>}%<{name=name2,value=value2}...%>
#endkeyvals
\DeclarePageLayout{keyvals}
#keyvals:\DeclarePageLayout
design=#designi,designii,designiii,designiv,designv,designvi,designvii,designviii,designix
screensizeOf=#designi,designii,designiii,designiv,designv,designvi,designvii,designviii,designix
screensize={%<height%>}{%<width%>}
margins={%<left%>}{%<right%>}{%<top%>}{%<bottom%>}
headheight=##L
topmargin=##L
additionalheadsep=##L
marginparsep=##L
marginparwidth=##L
marginparpush=##L
footskip=##L
webfootskip=##L
panelwidth=##L
panelsep=##L
#endkeyvals
\universityLayout{keyvals}
\titleLayout{keyvals}
\authorLayout{keyvals}
#keyvals:\universityLayout,\titleLayout,\authorLayout
fontfamily=#rmfamily,sffamily,ttfamily
fontseries=#bfseries,mdseries
fontshape=#upshape,itshape,scshape,slshape
fontsize=#tiny,scriptsize,footnotesize,small,normalsize,large,Large,LARGE,huge,Huge
halign=#l,c,r
color=#%color
special=#shadow,framebox,colorbox,fcolorbox,frameboxfit,colorboxfit,fcolorboxfit,custom,default
framecolor=#%color
bgcolor=#%color
shadowcolor=#%color
beforeskip=##L
afterskip=##L
usefont={%<encoding%>}{%<family%>}{%<series%>}{%<shape%>}{%<size%>}
hproportion=%<factor%>
xhalign=#l,c,r
#endkeyvals
\topTitlePageProportion{factor}
\DesignTitlePageTrailer{keyvals}
#keyvals:\DesignTitlePageTrailer
ul=%<text%>
ur=%<text%>
ll=%<text%>
lr=%<text%>
textColor=#%color
bgColor=#%color
borderColor=#%color
fboxsep=##L
fboxrule=##L
graphic=%<imagefile%>
namedgraphic=%<name%>
raise=##L
fontSize=%<fontsize cmd%>
formatting=%<font commands%>
#endkeyvals
\selectTocDings{keyvals}
#keyvals:\selectTocDings
dDing=%<symbol%>
ddDing=%<symbol%>
dddDing=%<symbol%>
dDingColor=#%color
ddDingColor=#%color
dddDingColor=#%color
#endkeyvals
\selectColors{keyvals}
#keyvals:\selectColors
universityColor=#%color
titleColor=#%color
textBgColor=#%color
panelBgColor=#%color
urlColor=#%color
linkColor=#%color
fileColor=#%color
#endkeyvals
\noSectionNumbers
\tocLayout{keyvals}
\sectionLayout{keyvals}
\subsectionLayout{keyvals}
\subsubsectionLayout{keyvals}
#keyvals:\tocLayout,\sectionLayout,\subsectionLayout,\subsubsectionLayout
fontfamily=#rmfamily,sffamily,ttfamily
fontseries=#bfseries,mdseries
fontshape=#upshape,itshape,scshape,slshape
fontsize=#tiny,scriptsize,footnotesize,small,normalsize,large,Large,LARGE,huge,Huge
halign=#l,c,r
ding=%<symbol%>
color=#%color
special=#shadow,framebox,colorbox,fcolorbox,frameboxfit,colorboxfit,fcolorboxfit,custom,default
framecolor=#%color
bgcolor=#%color
shadowcolor=#%color
beforeskip=##L
afterskip=##L
usefont={%<encoding%>}{%<family%>}{%<series%>}{%<shape%>}{%<size%>}
numdingcolor=#%color
reset=#font,all
#endkeyvals
\shadowhoffset{length}
\shadowvoffset{length}
\customSecHead{TeX code}
\customSubsecHead{TeX code}
\customSubsubsecHead{TeX code}
\preparedLabel{text}#*
\prepared{date}#*
\talkdate{date}#*
\webtalkdate#*
\talkdateLabel{text}#*
\talksite{site}#*
\customUniversity{TeX code}#*
\customTitle{TeX code}#*
\customAuthor{TeX code}#*
\customToc{TeX code}#*
\halignuniversity#*
\haligntitle#*
\halignauthor#*
\halignsection#*
\halignsubsection#*
\halignsubsubsection#*
\haligntoc#*
\subsubDefaultDing{symbol}#*
\sectionTitle#*
\sectionAuthor#*
\sectionUniversity#*
\sectionToc#*
\ifShadow#*
\Shadowtrue#*
\Shadowfalse#*
\useSectionNumbers#*
\dDingToc{symbol}#*
\ddDingToc{symbol}#*
\dddDingToc{symbol}#*
\dDingTocColor{color}#*
\ddDingTocColor{color}#*
\dddDingTocColor{color}#*
#endif

webgreen#B
webbrown#B
webyellow#B
webgray#B
webgrey#B
webblue#B
wheat#B
oldlace#B
snow#B
ghostwhite#B
cornsilk#B
honeydew#B
lavenderdark#B
lavender#B
lightblue#B
lightgray#B
lightsteelblue#B
lightturquoise#B
darkgreen#B
yellowgreen#B
vlightblue#B
khaki#B

# not documented
\BGColorAndGraphic#*
\BGColorAndGraphicFullWidth#*
\FALSEACTIONii#S
\FALSEACTIONiia#S
\InitLayout#*
\SETTEMPBOXi#S
\SETTEMPBOXii#S
\SHOWTEMPBOXi#S
\TRUEACTIONi#S
\TRUEACTIONia#S
\aboveOPMvspace
\addToWebHWError
\addtofullwidthtemplateArgs{arg}#*
\addtopaneltemplateArgs{arg}#*
\addtotemplateArgs{arg}#*
\aebwritelastpage#*
\allowTransparency#*
\bWebCustomize#*
\begin{Fullwidthtext}#*
\end{Fullwidthtext}#*
\calculatefullwidth#*
\centertextonpage#*
\chkpanelgroup#*
\clearfullwidthtemplateArgs#*
\clearpaneltemplateArgs#*
\cleartemplateArgs#*
\currLeftMarg#*
\currPanelWidth#*
\currTopMarg#*
\cyrCommand#*
\disablePanels{arg}#*
\disableScreens{arg}#*
\eWebCustomize#*
\forceSubSubNumbers#*
\fullscreenwidth#*
\fullscreenwidthadj#*
\fullwidthtemplate{arg1}{arg2}#*
\get#*
\getDimsFromGraphic{arg1}{arg2}{arg3}{arg4}#*
\getargsii#*
\getargs{arg1}{arg2}#*
\hproportionwebauthor#*
\hproportionwebtitle#*
\hproportionwebuniversity#*
\incby#*
\inputWebCfg#*
\insNaviBar#*
\insertwebtoc#*
\isChapter#*
\listAddToPanelTemplates#*
\listAddToTemplates#*
\loadwebpro#*
\makeFullwidthhead#*
\maketitlepostamble#*
\maketitlepreamble#*
\marginsize#*
\maxtextscreentext#*
\newBottomMarg#*
\newLeftMarg#*
\newPanelWidth#*
\newRightMarg#*
\newTopMarg#*
\nocopyrightNotice#*
\nocopyrightsymbol#*
\norevisionLabel#*
\optionalpagematter#*
\origpaperheight#*
\origpaperwidth#*
\panelIconGroup#*
\panelNavigroupWidth#*
\panelSep#*
\panelgroupHeight{arg}#*
\panelgroupSep{arg}#*
\panelgroupWidth{arg}#*
\panelrowsep#*
\panelscreenwidth#*
\panelsep{arg}#*
\pdfLang{arg}#*
\placePanelTemplateInLayer[opt]{arg}#*
\placePanelTemplateInLayer{arg}#*
\placeScreenNavibar#*
\placeTemplateInLayer[opt]{arg}#*
\placeTemplateInLayer{arg}#*
\popFromFullWidthPage#*
\prtscrA{arg1}{arg2}#*
\prtscrV#*
\pushToFullWidthPage#*
\removehereaftericon#*
\resetmargins[opt]{arg1}{arg2}{arg3}{arg4}#*
\resetmargins{arg1}{arg2}{arg3}{arg4}#*
\restoreElements{arg}#*
\restorePanels{arg}#*
\restoreSavedHead#*
\restoreScreens{arg}#*
\restorenormalsettings#*
\saveClearElements{arg}#*
\saveElements{arg}#*
\setPageDevice[opt]{arg1}{arg2}#*
\setPageDevice{arg1}{arg2}#*
\shortwebsubject#*
\shortwebtitle#*
\stdPanelBG#*
\stdbldpanel#*
\templatedefaults#*
\textscreenwidth#*
\thewebemail#*
\tightsettings#*
\titleauthorproportion#*
\tocIndentByNumber{arg}#*
\tocindentByNumber#*
\trailerFontSize#*
\useStandardPanel#*
\vspaceAfterDirName#*
\webArg#*
\webNotPaneledWarning#*
\webSaveMargDim#*
\webSaveSSDim#*
\webdirectory#*
\websetheadheight#*
\webtableofcontents#*

# from xcolor options
#ifOption:table
#include:colortbl
#endif

#ifOption:fixpdftex
#include:pdfcolmk
#endif

#ifOption:svgnames
AliceBlue#B
DarkKhaki#B
Green#B
LightSlateGrey#B
AntiqueWhite#B
DarkMagenta#B
GreenYellow#B
LightSteelBlue#B
Aqua#B
DarkOliveGreen#B
Grey#B
LightYellow#B
Aquamarine#B
DarkOrange#B
Honeydew#B
Lime#B
Azure#B
DarkOrchid#B
HotPink#B
LimeGreen#B
Beige#B
DarkRed#B
IndianRed#B
Linen#B
Bisque#B
DarkSalmon#B
Indigo#B
Magenta#B
Black#B
DarkSeaGreen#B
Ivory#B
Maroon#B
BlanchedAlmond#B
DarkSlateBlue#B
Khaki#B
MediumAquamarine#B
Blue#B
DarkSlateGray#B
Lavender#B
MediumBlue#B
BlueViolet#B
DarkSlateGrey#B
LavenderBlush#B
MediumOrchid#B
Brown#B
DarkTurquoise#B
LawnGreen#B
MediumPurple#B
BurlyWood#B
DarkViolet#B
LemonChiffon#B
MediumSeaGreen#B
CadetBlue#B
DeepPink#B
LightBlue#B
MediumSlateBlue#B
Chartreuse#B
DeepSkyBlue#B
LightCoral#B
MediumSpringGreen#B
Chocolate#B
DimGray#B
LightCyan#B
MediumTurquoise#B
Coral#B
DimGrey#B
LightGoldenrod#B
MediumVioletRed#B
CornflowerBlue#B
DodgerBlue#B
LightGoldenrodYellow#B
MidnightBlue#B
Cornsilk#B
FireBrick#B
LightGray#B
MintCream#B
Crimson#B
FloralWhite#B
LightGreen#B
MistyRose#B
Cyan#B
ForestGreen#B
LightGrey#B
Moccasin#B
DarkBlue#B
Fuchsia#B
LightPink#B
NavajoWhite#B
DarkCyan#B
Gainsboro#B
LightSalmon#B
Navy#B
DarkGoldenrod#B
GhostWhite#B
LightSeaGreen#B
NavyBlue#B
DarkGray#B
Gold#B
LightSkyBlue#B
OldLace#B
DarkGreen#B
Goldenrod#B
LightSlateBlue#B
Olive#B
DarkGrey#B
Gray#B
LightSlateGray#B
OliveDrab#B
Orange#B
Plum#B
Sienna#B
Thistle#B
OrangeRed#B
PowderBlue#B
Silver#B
Tomato#B
Orchid#B
Purple#B
SkyBlue#B
Turquoise#B
PaleGoldenrod#B
Red#B
SlateBlue#B
Violet#B
PaleGreen#B
RosyBrown#B
SlateGray#B
VioletRed#B
PaleTurquoise#B
RoyalBlue#B
SlateGrey#B
Wheat#B
PaleVioletRed#B
SaddleBrown#B
Snow#B
White#B
PapayaWhip#B
Salmon#B
SpringGreen#B
WhiteSmoke#B
PeachPuff#B
SandyBrown#B
SteelBlue#B
Yellow#B
Peru#B
SeaGreen#B
Tan#B
YellowGreen#B
Pink#B
Seashell#B
Teal#B
#endif

## color names via "dvipsnames" option
#ifOption:dvipsnames
Apricot#B
Aquamarine#B
Bittersweet#B
Black#B
Blue#B
BlueGreen#B
BlueViolet#B
BrickRed#B
Brown#B
BurntOrange#B
CadetBlue#B
CarnationPink#B
Cerulean#B
CornflowerBlue#B
Cyan#B
Dandelion#B
DarkOrchid#B
Emerald#B
ForestGreen#B
Fuchsia#B
Goldenrod#B
Gray#B
Green#B
GreenYellow#B
JungleGreen#B
Lavender#B
LimeGreen#B
Magenta#B
Mahogany#B
Maroon#B
Melon#B
MidnightBlue#B
Mulberry#B
NavyBlue#B
OliveGreen#B
Orange#B
OrangeRed#B
Orchid#B
Peach#B
Periwinkle#B
PineGreen#B
Plum#B
ProcessBlue#B
Purple#B
RawSienna#B
Red#B
RedOrange#B
RedViolet#B
Rhodamine#B
RoyalBlue#B
RoyalPurple#B
RubineRed#B
Salmon#B
SeaGreen#B
Sepia#B
SkyBlue#B
SpringGreen#B
Tan#B
TealBlue#B
Thistle#B
Turquoise#B
Violet#B
VioletRed#B
White#B
WildStrawberry#B
Yellow#B
YellowGreen#B
YellowOrange#B
#endif

## color names via "x11names" option
#ifOption:x11names
AntiqueWhite1#B
AntiqueWhite2#B
AntiqueWhite3#B
AntiqueWhite4#B
Aquamarine1#B
Aquamarine2#B
Aquamarine3#B
Aquamarine4#B
Azure1#B
Azure2#B
Azure3#B
Azure4#B
Bisque1#B
Bisque2#B
Bisque3#B
Bisque4#B
Blue1#B
Blue2#B
Blue3#B
Blue4#B
Brown1#B
Brown2#B
Brown3#B
Brown4#B
Burlywood1#B
Burlywood2#B
Burlywood3#B
Burlywood4#B
CadetBlue1#B
CadetBlue2#B
CadetBlue3#B
CadetBlue4#B
Chartreuse1#B
Chartreuse2#B
Chartreuse3#B
Chartreuse4#B
Chocolate1#B
Chocolate2#B
Chocolate3#B
Chocolate4#B
Coral1#B
Coral2#B
Coral3#B
Coral4#B
Cornsilk1#B
Cornsilk2#B
Cornsilk3#B
Cornsilk4#B
Cyan1#B
Cyan2#B
Cyan3#B
Cyan4#B
DarkGoldenrod1#B
DarkGoldenrod2#B
DarkGoldenrod3#B
DarkGoldenrod4#B
DarkOliveGreen1#B
DarkOliveGreen2#B
DarkOliveGreen3#B
DarkOliveGreen4#B
DarkOrange1#B
DarkOrange2#B
DarkOrange3#B
DarkOrange4#B
DarkOrchid1#B
DarkOrchid2#B
DarkOrchid3#B
DarkOrchid4#B
DarkSeaGreen1#B
DarkSeaGreen2#B
DarkSeaGreen3#B
DarkSeaGreen4#B
DarkSlateGray1#B
DarkSlateGray2#B
DarkSlateGray3#B
DarkSlateGray4#B
DeepPink1#B
DeepPink2#B
DeepPink3#B
DeepPink4#B
DeepSkyBlue1#B
DeepSkyBlue2#B
DeepSkyBlue3#B
DeepSkyBlue4#B
DodgerBlue1#B
DodgerBlue2#B
DodgerBlue3#B
DodgerBlue4#B
Firebrick1#B
Firebrick2#B
Firebrick3#B
Firebrick4#B
Gold1#B
Gold2#B
Gold3#B
Gold4#B
Goldenrod1#B
Goldenrod2#B
Goldenrod3#B
Goldenrod4#B
Green1#B
Green2#B
Green3#B
Green4#B
Honeydew1#B
Honeydew2#B
Honeydew3#B
Honeydew4#B
HotPink1#B
HotPink2#B
HotPink3#B
HotPink4#B
IndianRed1#B
IndianRed2#B
IndianRed3#B
IndianRed4#B
Ivory1#B
Ivory2#B
Ivory3#B
Ivory4#B
Khaki1#B
Khaki2#B
Khaki3#B
Khaki4#B
LavenderBlush1#B
LavenderBlush2#B
LavenderBlush3#B
LavenderBlush4#B
LemonChiffon1#B
LemonChiffon2#B
LemonChiffon3#B
LemonChiffon4#B
LightBlue1#B
LightBlue2#B
LightBlue3#B
LightBlue4#B
LightCyan1#B
LightCyan2#B
LightCyan3#B
LightCyan4#B
LightGoldenrod1#B
LightGoldenrod2#B
LightGoldenrod3#B
LightGoldenrod4#B
LightPink1#B
LightPink2#B
LightPink3#B
LightPink4#B
LightSalmon1#B
LightSalmon2#B
LightSalmon3#B
LightSalmon4#B
LightSkyBlue1#B
LightSkyBlue2#B
LightSkyBlue3#B
LightSkyBlue4#B
LightSteelBlue1#B
LightSteelBlue2#B
LightSteelBlue3#B
LightSteelBlue4#B
LightYellow1#B
LightYellow2#B
LightYellow3#B
LightYellow4#B
Magenta1#B
Magenta2#B
Magenta3#B
Magenta4#B
Maroon1#B
Maroon2#B
Maroon3#B
Maroon4#B
MediumOrchid1#B
MediumOrchid2#B
MediumOrchid3#B
MediumOrchid4#B
MediumPurple1#B
MediumPurple2#B
MediumPurple3#B
MediumPurple4#B
MistyRose1#B
MistyRose2#B
MistyRose3#B
MistyRose4#B
NavajoWhite1#B
NavajoWhite2#B
NavajoWhite3#B
NavajoWhite4#B
OliveDrab1#B
OliveDrab2#B
OliveDrab3#B
OliveDrab4#B
Orange1#B
Orange2#B
Orange3#B
Orange4#B
OrangeRed1#B
OrangeRed2#B
OrangeRed3#B
OrangeRed4#B
Orchid1#B
Orchid2#B
Orchid3#B
Orchid4#B
PaleGreen1#B
PaleGreen2#B
PaleGreen3#B
PaleGreen4#B
PaleTurquoise1#B
PaleTurquoise2#B
PaleTurquoise3#B
PaleTurquoise4#B
PaleVioletRed1#B
PaleVioletRed2#B
PaleVioletRed3#B
PaleVioletRed4#B
PeachPuff1#B
PeachPuff2#B
PeachPuff3#B
PeachPuff4#B
Pink1#B
Pink2#B
Pink3#B
Pink4#B
Plum1#B
Plum2#B
Plum3#B
Plum4#B
Purple1#B
Purple2#B
Purple3#B
Purple4#B
Red1#B
Red2#B
Red3#B
Red4#B
RosyBrown1#B
RosyBrown2#B
RosyBrown3#B
RosyBrown4#B
RoyalBlue1#B
RoyalBlue2#B
RoyalBlue3#B
RoyalBlue4#B
Salmon1#B
Salmon2#B
Salmon3#B
Salmon4#B
SeaGreen1#B
SeaGreen2#B
SeaGreen3#B
SeaGreen4#B
Seashell1#B
Seashell2#B
Seashell3#B
Seashell4#B
Sienna1#B
Sienna2#B
Sienna3#B
Sienna4#B
SkyBlue1#B
SkyBlue2#B
SkyBlue3#B
SkyBlue4#B
SlateBlue1#B
SlateBlue2#B
SlateBlue3#B
SlateBlue4#B
SlateGray1#B
SlateGray2#B
SlateGray3#B
SlateGray4#B
Snow1#B
Snow2#B
Snow3#B
Snow4#B
SpringGreen1#B
SpringGreen2#B
SpringGreen3#B
SpringGreen4#B
SteelBlue1#B
SteelBlue2#B
SteelBlue3#B
SteelBlue4#B
Tan1#B
Tan2#B
Tan3#B
Tan4#B
Thistle1#B
Thistle2#B
Thistle3#B
Thistle4#B
Tomato1#B
Tomato2#B
Tomato3#B
Tomato4#B
Turquoise1#B
Turquoise2#B
Turquoise3#B
Turquoise4#B
VioletRed1#B
VioletRed2#B
VioletRed3#B
VioletRed4#B
Wheat1#B
Wheat2#B
Wheat3#B
Wheat4#B
Yellow1#B
Yellow2#B
Yellow3#B
Yellow4#B
Gray0#B
Green0#B
Grey0#B
Maroon0#B
Purple0#B
#endif
