//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckshareparticipantacceptancestatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKShareParticipantAcceptanceStatus(pub NSInteger);
impl CKShareParticipantAcceptanceStatus {
    #[doc(alias = "CKShareParticipantAcceptanceStatusUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "CKShareParticipantAcceptanceStatusPending")]
    pub const Pending: Self = Self(1);
    #[doc(alias = "CKShareParticipantAcceptanceStatusAccepted")]
    pub const Accepted: Self = Self(2);
    #[doc(alias = "CKShareParticipantAcceptanceStatusRemoved")]
    pub const Removed: Self = Self(3);
}

unsafe impl Encode for CKShareParticipantAcceptanceStatus {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKShareParticipantAcceptanceStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// These permissions determine what share participants can do with records inside that share
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckshareparticipantpermission?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKShareParticipantPermission(pub NSInteger);
impl CKShareParticipantPermission {
    #[doc(alias = "CKShareParticipantPermissionUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "CKShareParticipantPermissionNone")]
    pub const None: Self = Self(1);
    #[doc(alias = "CKShareParticipantPermissionReadOnly")]
    pub const ReadOnly: Self = Self(2);
    #[doc(alias = "CKShareParticipantPermissionReadWrite")]
    pub const ReadWrite: Self = Self(3);
}

unsafe impl Encode for CKShareParticipantPermission {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKShareParticipantPermission {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Defines the participant role in a share:
/// - `owner`: Can add private users.
/// - `privateUser`: Can access the share.
/// - `publicUser`: Self-added when accessing the share URL (owners cannot add public users).
/// - `administrator`: Can add and remove participants and change their permissions.
///
/// Shares with ``CloudKit/CKShareParticipantRole/CKShareParticipantRoleAdministrator`` participants will be returned as read-only to devices running OS versions prior to this role being introduced.
/// Administrator participants on these read-only shares will be returned as ``CloudKit/CKShareParticipantRole/CKShareParticipantRolePrivateUser``.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckshareparticipantrole?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKShareParticipantRole(pub NSInteger);
impl CKShareParticipantRole {
    #[doc(alias = "CKShareParticipantRoleUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "CKShareParticipantRoleOwner")]
    pub const Owner: Self = Self(1);
    #[doc(alias = "CKShareParticipantRolePrivateUser")]
    pub const PrivateUser: Self = Self(3);
    #[doc(alias = "CKShareParticipantRolePublicUser")]
    pub const PublicUser: Self = Self(4);
    #[doc(alias = "CKShareParticipantRoleAdministrator")]
    pub const Administrator: Self = Self(2);
}

unsafe impl Encode for CKShareParticipantRole {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKShareParticipantRole {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckshareparticipanttype?language=objc)
// NS_ENUM
#[deprecated]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKShareParticipantType(pub NSInteger);
impl CKShareParticipantType {
    #[doc(alias = "CKShareParticipantTypeUnknown")]
    #[deprecated]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "CKShareParticipantTypeOwner")]
    #[deprecated]
    pub const Owner: Self = Self(1);
    #[doc(alias = "CKShareParticipantTypePrivateUser")]
    #[deprecated]
    pub const PrivateUser: Self = Self(3);
    #[doc(alias = "CKShareParticipantTypePublicUser")]
    #[deprecated]
    pub const PublicUser: Self = Self(4);
}

unsafe impl Encode for CKShareParticipantType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKShareParticipantType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckshareparticipant?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKShareParticipant;
);

extern_conformance!(
    unsafe impl NSCoding for CKShareParticipant {}
);

extern_conformance!(
    unsafe impl NSCopying for CKShareParticipant {}
);

unsafe impl CopyingHelper for CKShareParticipant {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKShareParticipant {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKShareParticipant {}
);

impl CKShareParticipant {
    extern_methods!(
        /// Use
        /// `CKFetchShareParticipantsOperation`to create a
        /// `CKShareParticipant`object
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[cfg(feature = "CKUserIdentity")]
        #[unsafe(method(userIdentity))]
        #[unsafe(method_family = none)]
        pub unsafe fn userIdentity(&self) -> Retained<CKUserIdentity>;

        /// The default participant role is
        /// `CKShareParticipantRolePrivateUser.`
        #[unsafe(method(role))]
        #[unsafe(method_family = none)]
        pub unsafe fn role(&self) -> CKShareParticipantRole;

        /// Setter for [`role`][Self::role].
        #[unsafe(method(setRole:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRole(&self, role: CKShareParticipantRole);

        /// The default participant type is ``CloudKit/CKShareParticipantType/CKShareParticipantTypePrivateUser``.
        #[deprecated]
        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub unsafe fn r#type(&self) -> CKShareParticipantType;

        /// Setter for [`type`][Self::type].
        #[deprecated]
        #[unsafe(method(setType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setType(&self, r#type: CKShareParticipantType);

        #[unsafe(method(acceptanceStatus))]
        #[unsafe(method_family = none)]
        pub unsafe fn acceptanceStatus(&self) -> CKShareParticipantAcceptanceStatus;

        /// The default permission for a new participant is
        /// `CKShareParticipantPermissionReadOnly.`
        #[unsafe(method(permission))]
        #[unsafe(method_family = none)]
        pub unsafe fn permission(&self) -> CKShareParticipantPermission;

        /// Setter for [`permission`][Self::permission].
        #[unsafe(method(setPermission:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPermission(&self, permission: CKShareParticipantPermission);

        /// A unique identifier for this participant.
        #[unsafe(method(participantID))]
        #[unsafe(method_family = none)]
        pub unsafe fn participantID(&self) -> Retained<NSString>;

        /// Indicates whether the participant was originally a requester who was approved to join the share.
        #[unsafe(method(isApprovedRequester))]
        #[unsafe(method_family = none)]
        pub unsafe fn isApprovedRequester(&self) -> bool;

        /// The date and time when the participant was added to the share.
        ///
        /// This timestamp is set when the share is successfully saved to the server.
        #[unsafe(method(dateAddedToShare))]
        #[unsafe(method_family = none)]
        pub unsafe fn dateAddedToShare(&self) -> Option<Retained<NSDate>>;

        /// Generate a unique URL for inviting a participant without knowing their handle
        ///
        /// When a participant's email address / phone number / userRecordID isn't known up-front, a ``CKShareParticipant/oneTimeURLParticipant`` can be added
        /// to the share. Once the share is saved, a custom invitation link or one-time URL is available for the added participant via ``CKShare/oneTimeURLForParticipantID:``.
        /// This custom link can be used by any recipient user to fetch share metadata and accept the share.
        ///
        /// Note that a one-time URL participant in the ``ParticipantAcceptanceStatus/pending`` state has empty ``CKUserIdentity/nameComponents``
        /// and a nil ``CKUserIdentity/lookupInfo``.
        #[unsafe(method(oneTimeURLParticipant))]
        #[unsafe(method_family = none)]
        pub unsafe fn oneTimeURLParticipant() -> Retained<Self>;
    );
}
