/// <reference path="./gtk-4.0.d.ts" />
/// <reference path="./gsk-4.0.d.ts" />
/// <reference path="./graphene-1.0.d.ts" />
/// <reference path="./gobject-2.0.d.ts" />
/// <reference path="./glib-2.0.d.ts" />
/// <reference path="./gdk-4.0.d.ts" />
/// <reference path="./cairo-1.0.d.ts" />
/// <reference path="./cairo.d.ts" />
/// <reference path="./pangocairo-1.0.d.ts" />
/// <reference path="./pango-1.0.d.ts" />
/// <reference path="./harfbuzz-0.0.d.ts" />
/// <reference path="./freetype2-2.0.d.ts" />
/// <reference path="./gio-2.0.d.ts" />
/// <reference path="./gmodule-2.0.d.ts" />
/// <reference path="./gdkpixbuf-2.0.d.ts" />

/**
 * Type Definitions for Gjs (https://gjs.guide/)
 *
 * These type definitions are automatically generated, do not edit them by hand.
 * If you found a bug fix it in `ts-for-gir` or create a bug report on https://github.com/gjsify/ts-for-gir
 *
 * The based EJS template file is used for the generated .d.ts file of each GIR module like Gtk-4.0, GObject-2.0, ...
 */

declare module 'gi://Adw?version=1' {
    // Module dependencies
    import type Gtk from 'gi://Gtk?version=4.0';
    import type Gsk from 'gi://Gsk?version=4.0';
    import type Graphene from 'gi://Graphene?version=1.0';
    import type GObject from 'gi://GObject?version=2.0';
    import type GLib from 'gi://GLib?version=2.0';
    import type Gdk from 'gi://Gdk?version=4.0';
    import type cairo from 'cairo';
    import type PangoCairo from 'gi://PangoCairo?version=1.0';
    import type Pango from 'gi://Pango?version=1.0';
    import type HarfBuzz from 'gi://HarfBuzz?version=0.0';
    import type freetype2 from 'gi://freetype2?version=2.0';
    import type Gio from 'gi://Gio?version=2.0';
    import type GModule from 'gi://GModule?version=2.0';
    import type GdkPixbuf from 'gi://GdkPixbuf?version=2.0';

    export namespace Adw {
        /**
         * Adw-1
         */

        /**
         * Describes the available system accent colors.
         */

        /**
         * Describes the available system accent colors.
         */
        export namespace AccentColor {
            export const $gtype: GObject.GType<AccentColor>;
        }

        enum AccentColor {
            /**
             * Use a blue color (`#3584e4`). This is the default value.
             */
            BLUE,
            /**
             * Use a teal color (`#2190a4`).
             */
            TEAL,
            /**
             * Use a green color (`#3a944a`).
             */
            GREEN,
            /**
             * Use a yellow color (`#c88800`).
             */
            YELLOW,
            /**
             * Use a orange color (`#ed5b00`).
             */
            ORANGE,
            /**
             * Use a red color (`#e62d42`).
             */
            RED,
            /**
             * Use a pink color (`#d56199`).
             */
            PINK,
            /**
             * Use a purple color (`#9141ac`).
             */
            PURPLE,
            /**
             * Use a slate color (`#6f8396`).
             */
            SLATE,
        }
        /**
         * Describes the possible states of an [class`Animation]`.
         *
         * The state can be controlled with [method`Animation`.play],
         * [method`Animation`.pause], [method`Animation`.resume],
         * [method`Animation`.reset] and [method`Animation`.skip].
         */

        /**
         * Describes the possible states of an [class`Animation]`.
         *
         * The state can be controlled with [method`Animation`.play],
         * [method`Animation`.pause], [method`Animation`.resume],
         * [method`Animation`.reset] and [method`Animation`.skip].
         */
        export namespace AnimationState {
            export const $gtype: GObject.GType<AnimationState>;
        }

        enum AnimationState {
            /**
             * The animation hasn't started yet.
             */
            IDLE,
            /**
             * The animation has been paused.
             */
            PAUSED,
            /**
             * The animation is currently playing.
             */
            PLAYING,
            /**
             * The animation has finished.
             */
            FINISHED,
        }
        /**
         * Describes the available button styles for [class`Banner]`.
         *
         * New values may be added to this enumeration over time.
         *
         * See [property`Banner:`button-style].
         */

        /**
         * Describes the available button styles for [class`Banner]`.
         *
         * New values may be added to this enumeration over time.
         *
         * See [property`Banner:`button-style].
         */
        export namespace BannerButtonStyle {
            export const $gtype: GObject.GType<BannerButtonStyle>;
        }

        enum BannerButtonStyle {
            /**
             * The default button style.
             */
            DEFAULT,
            /**
             * A button in the suggested action style.
             */
            SUGGESTED,
        }
        /**
         * Describes length types for [struct`BreakpointCondition]`.
         *
         * See [ctor`BreakpointCondition`.new_length].
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * Describes length types for [struct`BreakpointCondition]`.
         *
         * See [ctor`BreakpointCondition`.new_length].
         *
         * New values may be added to this enumeration over time.
         */
        export namespace BreakpointConditionLengthType {
            export const $gtype: GObject.GType<BreakpointConditionLengthType>;
        }

        enum BreakpointConditionLengthType {
            /**
             * true if the width is greater than or
             *   equal to the condition value
             */
            MIN_WIDTH,
            /**
             * true if the width is less than or
             *   equal to the condition value
             */
            MAX_WIDTH,
            /**
             * true if the height is greater than or
             *   equal to the condition value
             */
            MIN_HEIGHT,
            /**
             * true if the height is less than or
             *   equal to the condition value
             */
            MAX_HEIGHT,
        }
        /**
         * Describes ratio types for [struct`BreakpointCondition]`.
         *
         * See [ctor`BreakpointCondition`.new_ratio].
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * Describes ratio types for [struct`BreakpointCondition]`.
         *
         * See [ctor`BreakpointCondition`.new_ratio].
         *
         * New values may be added to this enumeration over time.
         */
        export namespace BreakpointConditionRatioType {
            export const $gtype: GObject.GType<BreakpointConditionRatioType>;
        }

        enum BreakpointConditionRatioType {
            /**
             * true if the aspect ratio is
             *   greater than or equal to the condition value
             */
            MIN_ASPECT_RATIO,
            /**
             * true if the aspect ratio is
             *   less than or equal to the condition value
             */
            MAX_ASPECT_RATIO,
        }
        /**
         * Describes title centering behavior of a [class`HeaderBar]` widget.
         */

        /**
         * Describes title centering behavior of a [class`HeaderBar]` widget.
         */
        export namespace CenteringPolicy {
            export const $gtype: GObject.GType<CenteringPolicy>;
        }

        enum CenteringPolicy {
            /**
             * Keep the title centered when possible
             */
            LOOSE,
            /**
             * Keep the title centered at all cost
             */
            STRICT,
        }
        /**
         * Application color schemes for [property`StyleManager:`color-scheme].
         */

        /**
         * Application color schemes for [property`StyleManager:`color-scheme].
         */
        export namespace ColorScheme {
            export const $gtype: GObject.GType<ColorScheme>;
        }

        enum ColorScheme {
            /**
             * Inherit the parent color-scheme. When set on the
             *   `AdwStyleManager` returned by [func`StyleManager`.get_default], it's
             *   equivalent to `ADW_COLOR_SCHEME_PREFER_LIGHT`.
             */
            DEFAULT,
            /**
             * Always use light appearance.
             */
            FORCE_LIGHT,
            /**
             * Use light appearance unless the system
             *   prefers dark colors.
             */
            PREFER_LIGHT,
            /**
             * Use dark appearance unless the system prefers
             *   prefers light colors.
             */
            PREFER_DARK,
            /**
             * Always use dark appearance.
             */
            FORCE_DARK,
        }
        /**
         * Describes the available presentation modes for [class`Dialog]`.
         *
         * New values may be added to this enumeration over time.
         *
         * See [property`Dialog:`presentation-mode].
         */

        /**
         * Describes the available presentation modes for [class`Dialog]`.
         *
         * New values may be added to this enumeration over time.
         *
         * See [property`Dialog:`presentation-mode].
         */
        export namespace DialogPresentationMode {
            export const $gtype: GObject.GType<DialogPresentationMode>;
        }

        enum DialogPresentationMode {
            /**
             * Switch between `ADW_DIALOG_FLOATING` and
             *   `ADW_DIALOG_BOTTOM_SHEET` depending on available size.
             */
            AUTO,
            /**
             * Present dialog as a centered floating window.
             */
            FLOATING,
            /**
             * Present dialog as a bottom sheet.
             */
            BOTTOM_SHEET,
        }
        /**
         * Describes the available easing functions for use with
         * [class`TimedAnimation]`.
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * Describes the available easing functions for use with
         * [class`TimedAnimation]`.
         *
         * New values may be added to this enumeration over time.
         */
        export namespace Easing {
            export const $gtype: GObject.GType<Easing>;
        }

        enum Easing {
            /**
             * Linear tweening.
             */
            LINEAR,
            /**
             * Quadratic tweening.
             */
            EASE_IN_QUAD,
            /**
             * Quadratic tweening, inverse of `ADW_EASE_IN_QUAD`.
             */
            EASE_OUT_QUAD,
            /**
             * Quadratic tweening, combining `ADW_EASE_IN_QUAD` and
             *   `ADW_EASE_OUT_QUAD`.
             */
            EASE_IN_OUT_QUAD,
            /**
             * Cubic tweening.
             */
            EASE_IN_CUBIC,
            /**
             * Cubic tweening, inverse of `ADW_EASE_IN_CUBIC`.
             */
            EASE_OUT_CUBIC,
            /**
             * Cubic tweening, combining `ADW_EASE_IN_CUBIC` and
             *   `ADW_EASE_OUT_CUBIC`.
             */
            EASE_IN_OUT_CUBIC,
            /**
             * Quartic tweening.
             */
            EASE_IN_QUART,
            /**
             * Quartic tweening, inverse of `ADW_EASE_IN_QUART`.
             */
            EASE_OUT_QUART,
            /**
             * Quartic tweening, combining `ADW_EASE_IN_QUART` and
             *   `ADW_EASE_OUT_QUART`.
             */
            EASE_IN_OUT_QUART,
            /**
             * Quintic tweening.
             */
            EASE_IN_QUINT,
            /**
             * Quintic tweening, inverse of `ADW_EASE_IN_QUINT`.
             */
            EASE_OUT_QUINT,
            /**
             * Quintic tweening, combining `ADW_EASE_IN_QUINT` and
             *   `ADW_EASE_OUT_QUINT`.
             */
            EASE_IN_OUT_QUINT,
            /**
             * Sine wave tweening.
             */
            EASE_IN_SINE,
            /**
             * Sine wave tweening, inverse of `ADW_EASE_IN_SINE`.
             */
            EASE_OUT_SINE,
            /**
             * Sine wave tweening, combining `ADW_EASE_IN_SINE` and
             *   `ADW_EASE_OUT_SINE`.
             */
            EASE_IN_OUT_SINE,
            /**
             * Exponential tweening.
             */
            EASE_IN_EXPO,
            /**
             * Exponential tweening, inverse of `ADW_EASE_IN_EXPO`.
             */
            EASE_OUT_EXPO,
            /**
             * Exponential tweening, combining `ADW_EASE_IN_EXPO` and
             *   `ADW_EASE_OUT_EXPO`.
             */
            EASE_IN_OUT_EXPO,
            /**
             * Circular tweening.
             */
            EASE_IN_CIRC,
            /**
             * Circular tweening, inverse of `ADW_EASE_IN_CIRC`.
             */
            EASE_OUT_CIRC,
            /**
             * Circular tweening, combining `ADW_EASE_IN_CIRC` and
             *   `ADW_EASE_OUT_CIRC`.
             */
            EASE_IN_OUT_CIRC,
            /**
             * Elastic tweening, with offshoot on start.
             */
            EASE_IN_ELASTIC,
            /**
             * Elastic tweening, with offshoot on end, inverse of
             *   `ADW_EASE_IN_ELASTIC`.
             */
            EASE_OUT_ELASTIC,
            /**
             * Elastic tweening, with offshoot on both ends,
             *   combining `ADW_EASE_IN_ELASTIC` and `ADW_EASE_OUT_ELASTIC`.
             */
            EASE_IN_OUT_ELASTIC,
            /**
             * Overshooting cubic tweening, with backtracking on start.
             */
            EASE_IN_BACK,
            /**
             * Overshooting cubic tweening, with backtracking on end,
             *   inverse of `ADW_EASE_IN_BACK`.
             */
            EASE_OUT_BACK,
            /**
             * Overshooting cubic tweening, with backtracking on both
             *   ends, combining `ADW_EASE_IN_BACK` and `ADW_EASE_OUT_BACK`.
             */
            EASE_IN_OUT_BACK,
            /**
             * Exponentially decaying parabolic (bounce) tweening,
             *   on start.
             */
            EASE_IN_BOUNCE,
            /**
             * Exponentially decaying parabolic (bounce) tweening,
             *   with bounce on end, inverse of `ADW_EASE_IN_BOUNCE`.
             */
            EASE_OUT_BOUNCE,
            /**
             * Exponentially decaying parabolic (bounce) tweening,
             *   with bounce on both ends, combining `ADW_EASE_IN_BOUNCE` and
             *   `ADW_EASE_OUT_BOUNCE`.
             */
            EASE_IN_OUT_BOUNCE,
            /**
             * Cubic bezier tweening, with control points in (0.25, 0.1) and (0.25, 1.0).
             *
             * Increases in velocity towards the middle of the animation, slowing back down
             * at the end.
             */
            EASE,
            /**
             * Cubic bezier tweening, with control points in (0.42, 0.0) and (1.0, 1.0).
             *
             * Starts off slowly, with the speed of the animation increasing until complete.
             */
            EASE_IN,
            /**
             * Cubic bezier tweening, with control points in (0.0, 0.0) and (0.58, 1.0).
             *
             * Starts quickly, slowing down the animation until complete.
             */
            EASE_OUT,
            /**
             * Cubic bezier tweening, with control points in (0.42, 0.0) and (0.58, 1.0).
             *
             * Starts off slowly, speeds up in the middle, and then slows down again.
             */
            EASE_IN_OUT,
        }
        /**
         * Describes the possible folding behavior of a [class`Flap]` widget.
         */

        /**
         * Describes the possible folding behavior of a [class`Flap]` widget.
         */
        export namespace FlapFoldPolicy {
            export const $gtype: GObject.GType<FlapFoldPolicy>;
        }

        enum FlapFoldPolicy {
            /**
             * Disable folding, the flap cannot reach narrow
             *   sizes.
             */
            NEVER,
            /**
             * Keep the flap always folded.
             */
            ALWAYS,
            /**
             * Fold and unfold the flap based on available
             *   space.
             */
            AUTO,
        }
        /**
         * Describes transitions types of a [class`Flap]` widget.
         *
         * It determines the type of animation when transitioning between children in a
         * [class`Flap]` widget, as well as which areas can be swiped via
         * [property`Flap:`swipe-to-open] and [property`Flap:`swipe-to-close].
         */

        /**
         * Describes transitions types of a [class`Flap]` widget.
         *
         * It determines the type of animation when transitioning between children in a
         * [class`Flap]` widget, as well as which areas can be swiped via
         * [property`Flap:`swipe-to-open] and [property`Flap:`swipe-to-close].
         */
        export namespace FlapTransitionType {
            export const $gtype: GObject.GType<FlapTransitionType>;
        }

        enum FlapTransitionType {
            /**
             * The flap slides over the content, which is
             *   dimmed. When folded, only the flap can be swiped.
             */
            OVER,
            /**
             * The content slides over the flap. Only the
             *   content can be swiped.
             */
            UNDER,
            /**
             * The flap slides offscreen when hidden,
             *   neither the flap nor content overlap each other. Both widgets can be
             *   swiped.
             */
            SLIDE,
        }
        /**
         * Determines when [class`Flap]` and [class`Leaflet]` will fold.
         */

        /**
         * Determines when [class`Flap]` and [class`Leaflet]` will fold.
         */
        export namespace FoldThresholdPolicy {
            export const $gtype: GObject.GType<FoldThresholdPolicy>;
        }

        enum FoldThresholdPolicy {
            /**
             * Folding is based on the minimum size
             */
            MINIMUM,
            /**
             * Folding is based on the natural size
             */
            NATURAL,
        }
        /**
         * Describes what [class`InlineViewSwitcher]` toggles display.
         *
         * <picture>
         *   <source srcset="inline-view-switcher-display-modes-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="inline-view-switcher-display-modes.png" alt="inline-view-switcher-display-modes">
         * </picture>
         */

        /**
         * Describes what [class`InlineViewSwitcher]` toggles display.
         *
         * <picture>
         *   <source srcset="inline-view-switcher-display-modes-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="inline-view-switcher-display-modes.png" alt="inline-view-switcher-display-modes">
         * </picture>
         */
        export namespace InlineViewSwitcherDisplayMode {
            export const $gtype: GObject.GType<InlineViewSwitcherDisplayMode>;
        }

        enum InlineViewSwitcherDisplayMode {
            /**
             * Toggles only display labels.
             */
            LABELS,
            /**
             * Toggles only display icons.
             */
            ICONS,
            /**
             * Toggles display both icons and labels.
             */
            BOTH,
        }
        /**
         * Describes line justify behaviors in a [class`WrapLayout]` or [class`WrapBox]`.
         *
         * See [property`WrapLayout:`justify] and [property`WrapBox:`justify].
         */

        /**
         * Describes line justify behaviors in a [class`WrapLayout]` or [class`WrapBox]`.
         *
         * See [property`WrapLayout:`justify] and [property`WrapBox:`justify].
         */
        export namespace JustifyMode {
            export const $gtype: GObject.GType<JustifyMode>;
        }

        enum JustifyMode {
            /**
             * Don't justify children within a line.
             */
            NONE,
            /**
             * Stretch each child within the line, keeping consistent
             *     spacing, so that the line fills the entire length.
             */
            FILL,
            /**
             * Increase spacing between children, moving the children
             *     so that the first and last child are aligned with the beginning and end
             *     of the line. If the line only contains a single widget, it will be
             *     stretched regardless.
             */
            SPREAD,
        }
        /**
         * Describes the possible transitions in a [class`Leaflet]` widget.
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * Describes the possible transitions in a [class`Leaflet]` widget.
         *
         * New values may be added to this enumeration over time.
         */
        export namespace LeafletTransitionType {
            export const $gtype: GObject.GType<LeafletTransitionType>;
        }

        enum LeafletTransitionType {
            /**
             * Cover the old page or uncover the new page, sliding from or towards the end according to orientation, text direction and children order
             */
            OVER,
            /**
             * Uncover the new page or cover the old page, sliding from or towards the start according to orientation, text direction and children order
             */
            UNDER,
            /**
             * Slide from left, right, up or down according to the orientation, text direction and the children order
             */
            SLIDE,
        }
        /**
         * Describes length units.
         *
         * | Unit | Regular Text | Large Text |
         * | ---- | ------------ | ---------- |
         * | 1px  | 1px          | 1px        |
         * | 1pt  | 1.333333px   | 1.666667px |
         * | 1sp  | 1px          | 1.25px     |
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * Describes length units.
         *
         * | Unit | Regular Text | Large Text |
         * | ---- | ------------ | ---------- |
         * | 1px  | 1px          | 1px        |
         * | 1pt  | 1.333333px   | 1.666667px |
         * | 1sp  | 1px          | 1.25px     |
         *
         * New values may be added to this enumeration over time.
         */
        export namespace LengthUnit {
            export const $gtype: GObject.GType<LengthUnit>;
        }

        enum LengthUnit {
            /**
             * pixels
             */
            PX,
            /**
             * points, changes with text scale factor
             */
            PT,
            /**
             * scale independent pixels, changes with text scale factor
             */
            SP,
        }
        /**
         * Describes the direction of a swipe navigation gesture.
         */

        /**
         * Describes the direction of a swipe navigation gesture.
         */
        export namespace NavigationDirection {
            export const $gtype: GObject.GType<NavigationDirection>;
        }

        enum NavigationDirection {
            /**
             * Corresponds to start or top, depending on orientation and text direction
             */
            BACK,
            /**
             * Corresponds to end or bottom, depending on orientation and text direction
             */
            FORWARD,
        }
        /**
         * Describes child packing behavior in a [class`WrapLayout]` or [class`WrapBox]`.
         *
         * See [property`WrapLayout:`pack-direction] and
         * [property`WrapBox:`pack-direction].
         */

        /**
         * Describes child packing behavior in a [class`WrapLayout]` or [class`WrapBox]`.
         *
         * See [property`WrapLayout:`pack-direction] and
         * [property`WrapBox:`pack-direction].
         */
        export namespace PackDirection {
            export const $gtype: GObject.GType<PackDirection>;
        }

        enum PackDirection {
            /**
             * Pack children from left to right for LTR languages,
             *     or top to bottom vertically.
             */
            START_TO_END,
            /**
             * Pack children from right to left for LTR languages,
             *     or bottom to top vertically.
             */
            END_TO_START,
        }
        /**
         * Describes the possible styles of [class`AlertDialog]` response buttons.
         *
         * See [method`AlertDialog`.set_response_appearance].
         */

        /**
         * Describes the possible styles of [class`AlertDialog]` response buttons.
         *
         * See [method`AlertDialog`.set_response_appearance].
         */
        export namespace ResponseAppearance {
            export const $gtype: GObject.GType<ResponseAppearance>;
        }

        enum ResponseAppearance {
            /**
             * the default appearance.
             */
            DEFAULT,
            /**
             * used to denote important responses such as the
             *     affirmative action.
             */
            SUGGESTED,
            /**
             * used to draw attention to the potentially damaging
             *     consequences of using the response. This appearance acts as a warning to
             *     the user.
             */
            DESTRUCTIVE,
        }
        /**
         * Describes the possible transitions in a [class`Squeezer]` widget.
         */

        /**
         * Describes the possible transitions in a [class`Squeezer]` widget.
         */
        export namespace SqueezerTransitionType {
            export const $gtype: GObject.GType<SqueezerTransitionType>;
        }

        enum SqueezerTransitionType {
            /**
             * No transition
             */
            NONE,
            /**
             * A cross-fade
             */
            CROSSFADE,
        }
        /**
         * [class`Toast]` behavior when another toast is already displayed.
         */

        /**
         * [class`Toast]` behavior when another toast is already displayed.
         */
        export namespace ToastPriority {
            export const $gtype: GObject.GType<ToastPriority>;
        }

        enum ToastPriority {
            /**
             * the toast will be queued if another toast is
             *   already displayed.
             */
            NORMAL,
            /**
             * the toast will be displayed immediately, pushing
             *   the previous toast into the queue instead.
             */
            HIGH,
        }
        /**
         * Describes the possible top or bottom bar styles in an [class`ToolbarView]`
         * widget.
         *
         * `ADW_TOOLBAR_FLAT` is suitable for simple content, such as
         * [class`StatusPage]` or [class`PreferencesPage]`, where the background at the
         * top and bottom parts of the page is uniform. Additionally, windows with
         * sidebars should always use this style.
         *
         * <picture style="min-width: 33%; display: inline-block;">
         *   <source srcset="toolbar-view-flat-1-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="toolbar-view-flat-1.png" alt="toolbar-view-flat-1">
         * </picture>
         * <picture style="min-width: 33%; display: inline-block;">
         *   <source srcset="toolbar-view-flat-2-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="toolbar-view-flat-2.png" alt="toolbar-view-flat-2">
         * </picture>
         *
         * `ADW_TOOLBAR_RAISED` style is suitable for content such as
         * [utility panes](https://developer.gnome.org/hig/patterns/containers/utility-panes.html),
         * where some elements are directly adjacent to the top/bottom bars, or
         * [class`TabView]`, where each page can have a different background.
         *
         * `ADW_TOOLBAR_RAISED_BORDER` style is similar to `ADW_TOOLBAR_RAISED`, but
         * with the shadow replaced with a more subtle border. It's intended to be used
         * in applications like image viewers, where a shadow over the content might be
         * undesired.
         *
         * <picture style="min-width: 33%; display: inline-block;">
         *   <source srcset="toolbar-view-raised-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="toolbar-view-raised.png" alt="toolbar-view-raised">
         * </picture>
         * <picture style="min-width: 33%; display: inline-block;">
         *   <source srcset="toolbar-view-raised-border-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="toolbar-view-raised-border.png" alt="toolbar-view-raised-border">
         * </picture>
         *
         * See [property`ToolbarView:`top-bar-style] and
         * [property`ToolbarView:`bottom-bar-style].
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * Describes the possible top or bottom bar styles in an [class`ToolbarView]`
         * widget.
         *
         * `ADW_TOOLBAR_FLAT` is suitable for simple content, such as
         * [class`StatusPage]` or [class`PreferencesPage]`, where the background at the
         * top and bottom parts of the page is uniform. Additionally, windows with
         * sidebars should always use this style.
         *
         * <picture style="min-width: 33%; display: inline-block;">
         *   <source srcset="toolbar-view-flat-1-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="toolbar-view-flat-1.png" alt="toolbar-view-flat-1">
         * </picture>
         * <picture style="min-width: 33%; display: inline-block;">
         *   <source srcset="toolbar-view-flat-2-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="toolbar-view-flat-2.png" alt="toolbar-view-flat-2">
         * </picture>
         *
         * `ADW_TOOLBAR_RAISED` style is suitable for content such as
         * [utility panes](https://developer.gnome.org/hig/patterns/containers/utility-panes.html),
         * where some elements are directly adjacent to the top/bottom bars, or
         * [class`TabView]`, where each page can have a different background.
         *
         * `ADW_TOOLBAR_RAISED_BORDER` style is similar to `ADW_TOOLBAR_RAISED`, but
         * with the shadow replaced with a more subtle border. It's intended to be used
         * in applications like image viewers, where a shadow over the content might be
         * undesired.
         *
         * <picture style="min-width: 33%; display: inline-block;">
         *   <source srcset="toolbar-view-raised-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="toolbar-view-raised.png" alt="toolbar-view-raised">
         * </picture>
         * <picture style="min-width: 33%; display: inline-block;">
         *   <source srcset="toolbar-view-raised-border-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="toolbar-view-raised-border.png" alt="toolbar-view-raised-border">
         * </picture>
         *
         * See [property`ToolbarView:`top-bar-style] and
         * [property`ToolbarView:`bottom-bar-style].
         *
         * New values may be added to this enumeration over time.
         */
        export namespace ToolbarStyle {
            export const $gtype: GObject.GType<ToolbarStyle>;
        }

        enum ToolbarStyle {
            /**
             * No background, shadow only for scrolled content
             */
            FLAT,
            /**
             * Opaque background with a persistent shadow
             */
            RAISED,
            /**
             * Opaque background with a persistent border
             */
            RAISED_BORDER,
        }
        /**
         * Describes the adaptive modes of [class`ViewSwitcher]`.
         */

        /**
         * Describes the adaptive modes of [class`ViewSwitcher]`.
         */
        export namespace ViewSwitcherPolicy {
            export const $gtype: GObject.GType<ViewSwitcherPolicy>;
        }

        enum ViewSwitcherPolicy {
            /**
             * Force the narrow mode
             */
            NARROW,
            /**
             * Force the wide mode
             */
            WIDE,
        }
        /**
         * Describes line wrapping behavior in a [class`WrapLayout]` or [class`WrapBox]`.
         *
         * See [property`WrapLayout:`wrap-policy] and [property`WrapBox:`wrap-policy].
         */

        /**
         * Describes line wrapping behavior in a [class`WrapLayout]` or [class`WrapBox]`.
         *
         * See [property`WrapLayout:`wrap-policy] and [property`WrapBox:`wrap-policy].
         */
        export namespace WrapPolicy {
            export const $gtype: GObject.GType<WrapPolicy>;
        }

        enum WrapPolicy {
            /**
             * Fit as many children into each line as possible, shrinking
             *     them down to their minimum size before wrapping to the next line.
             */
            MINIMUM,
            /**
             * Wrap to the next line as soon as the previous line cannot
             *     fit any more children without shrinking them past their natural size.
             */
            NATURAL,
        }
        /**
         * Indicates an [class`Animation]` with an infinite duration.
         *
         * This value is mostly used internally.
         */
        const DURATION_INFINITE: number;
        /**
         * Adwaita major version component (e.g. 1 if the version is 1.2.3).
         */
        const MAJOR_VERSION: number;
        /**
         * Adwaita micro version component (e.g. 3 if the version is 1.2.3).
         */
        const MICRO_VERSION: number;
        /**
         * Adwaita minor version component (e.g. 2 if the version is 1.2.3).
         */
        const MINOR_VERSION: number;
        /**
         * Adwaita version, encoded as a string, useful for printing and
         * concatenation.
         */
        const VERSION_S: string;
        /**
         * Converts `self` to a `GdkRGBA` representing its background color.
         *
         * The matching foreground color is white.
         * @param self an accent color
         */
        function accent_color_to_rgba(self: AccentColor | null): Gdk.RGBA;
        /**
         * Converts `self` to a `GdkRGBA` representing its standalone color.
         *
         * It will typically be darker for light background, and lighter for dark
         * background, ensuring contrast.
         * @param self an accent color
         * @param dark Whether to calculate standalone color for light or dark background
         */
        function accent_color_to_standalone_rgba(self: AccentColor | null, dark: boolean): Gdk.RGBA;
        /**
         * Parses a condition from a string.
         *
         * Length conditions are specified as `<type>: <value>[<unit>]`, where:
         *
         * - `<type>` can be `min-width`, `max-width`, `min-height` or `max-height`
         * - `<value>` is a fractional number
         * - `<unit>` can be `px`, `pt` or `sp`
         *
         * If the unit is omitted, `px` is assumed.
         *
         * See [ctor`BreakpointCondition`.new_length].
         *
         * Examples:
         *
         * - `min-width: 500px`
         * - `min-height: 400pt`
         * - `max-width: 100sp`
         * - `max-height: 500`
         *
         * Ratio conditions are specified as `<type>: <width>[/<height>]`, where:
         *
         * - `<type>` can be `min-aspect-ratio` or `max-aspect-ratio`
         * - `<width>` and `<height>` are integer numbers
         *
         * See [ctor`BreakpointCondition`.new_ratio].
         *
         * The ratio is represented as `<width>` divided by `<height>`.
         *
         * If `<height>` is omitted, it's assumed to be 1.
         *
         * Examples:
         *
         * - `min-aspect-ratio: 4/3`
         * - `max-aspect-ratio: 1`
         *
         * The logical operators `and`, `or` can be used to compose a complex condition
         * as follows:
         *
         * - `<condition> and <condition>`: the condition is true when both
         *   `<condition>`s are true, same as when using
         *   [ctor`BreakpointCondition`.new_and]
         * - `<condition> or <condition>`: the condition is true when either of the
         *   `<condition>`s is true, same as when using
         *   [ctor`BreakpointCondition`.new_or]
         *
         * Examples:
         *
         * - `min-width: 400px and max-aspect-ratio: 4/3`
         * - `max-width: 360sp or max-width: 360px`
         *
         * Conditions can be further nested using parentheses, for example:
         *
         * - `min-width: 400px and (max-aspect-ratio: 4/3 or max-height: 400px)`
         *
         * If parentheses are omitted, the first operator takes priority.
         * @param str the string specifying the condition
         * @returns the parsed condition
         */
        function breakpoint_condition_parse(str: string): BreakpointCondition;
        /**
         * Computes easing with `easing` for `value`.
         *
         * `value` should generally be in the [0, 1] range.
         * @param self an easing value
         * @param value a value to ease
         * @returns the easing for @value
         */
        function easing_ease(self: Easing | null, value: number): number;
        /**
         * Checks whether animations are enabled for `widget`.
         *
         * This should be used when implementing an animated widget to know whether to
         * animate it or not.
         * @param widget a `GtkWidget`
         * @returns whether animations are enabled for @widget
         */
        function get_enable_animations(widget: Gtk.Widget): boolean;
        /**
         * Returns the major version number of the Adwaita library.
         *
         * For example, in libadwaita version 1.2.3 this is 1.
         *
         * This function is in the library, so it represents the libadwaita library your
         * code is running against. Contrast with the [const`MAJOR_VERSION]` constant,
         * which represents the major version of the libadwaita headers you have
         * included when compiling your code.
         * @returns the major version number of the Adwaita library
         */
        function get_major_version(): number;
        /**
         * Returns the micro version number of the Adwaita library.
         *
         * For example, in libadwaita version 1.2.3 this is 3.
         *
         * This function is in the library, so it represents the libadwaita library your
         * code is running against. Contrast with the [const`MAJOR_VERSION]` constant,
         * which represents the micro version of the libadwaita headers you have
         * included when compiling your code.
         * @returns the micro version number of the Adwaita library
         */
        function get_micro_version(): number;
        /**
         * Returns the minor version number of the Adwaita library.
         *
         * For example, in libadwaita version 1.2.3 this is 2.
         *
         * This function is in the library, so it represents the libadwaita library your
         * code is running against. Contrast with the [const`MAJOR_VERSION]` constant,
         * which represents the minor version of the libadwaita headers you have
         * included when compiling your code.
         * @returns the minor version number of the Adwaita library
         */
        function get_minor_version(): number;
        /**
         * Initializes Libadwaita.
         *
         * This function can be used instead of [func`Gtk`.init] as it initializes GTK
         * implicitly.
         *
         * There's no need to call this function if you're using [class`Application]`.
         *
         * If Libadwaita has already been initialized, the function will simply return.
         *
         * This makes sure translations, types, themes, and icons for the Adwaita
         * library are set up properly.
         */
        function init(): void;
        /**
         * Use this function to check if libadwaita has been initialized with
         * [func`init]`.
         * @returns the initialization status
         */
        function is_initialized(): boolean;
        /**
         * Converts `value` from pixels to `unit`.
         * @param unit a length unit
         * @param value a value in pixels
         * @param settings settings to use, or `NULL` for default settings
         * @returns the length in @unit
         */
        function length_unit_from_px(unit: LengthUnit | null, value: number, settings?: Gtk.Settings | null): number;
        /**
         * Converts `value` from `unit` to pixels.
         * @param unit a length unit
         * @param value a value in @unit
         * @param settings settings to use, or `NULL` for default settings
         * @returns the length in pixels
         */
        function length_unit_to_px(unit: LengthUnit | null, value: number, settings?: Gtk.Settings | null): number;
        /**
         * Computes the linear interpolation between `a` and `b` for `t`.
         * @param a the start
         * @param b the end
         * @param t the interpolation rate
         * @returns the computed value
         */
        function lerp(a: number, b: number, t: number): number;
        /**
         * Adjusts `rgba` to be suitable as a standalone color.
         *
         * It will typically be darker for light background, and lighter for dark
         * background, ensuring contrast.
         * @param rgba a background color
         * @param dark Whether to calculate standalone color for light or dark background
         */
        function rgba_to_standalone(rgba: Gdk.RGBA, dark: boolean): Gdk.RGBA;
        interface AnimationTargetFunc {
            (value: number): void;
        }
        /**
         * Describes available shortcuts in an [class`TabView]`.
         *
         * Shortcuts can be set with [property`TabView:`shortcuts], or added/removed
         * individually with [method`TabView`.add_shortcuts] and
         * [method`TabView`.remove_shortcuts].
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * Describes available shortcuts in an [class`TabView]`.
         *
         * Shortcuts can be set with [property`TabView:`shortcuts], or added/removed
         * individually with [method`TabView`.add_shortcuts] and
         * [method`TabView`.remove_shortcuts].
         *
         * New values may be added to this enumeration over time.
         */
        export namespace TabViewShortcuts {
            export const $gtype: GObject.GType<TabViewShortcuts>;
        }

        enum TabViewShortcuts {
            /**
             * No shortcuts
             */
            NONE,
            /**
             * <kbd>Ctrl</kbd>+<kbd>Tab</kbd> - switch to the next page
             */
            CONTROL_TAB,
            /**
             * <kbd>Shift</kbd>+<kbd>Ctrl</kbd>+<kbd>Tab</kbd> - switch to the previous
             *   page
             */
            CONTROL_SHIFT_TAB,
            /**
             * <kbd>Ctrl</kbd>+<kbd>Page Up</kbd> - switch to the previous page
             */
            CONTROL_PAGE_UP,
            /**
             * <kbd>Ctrl</kbd>+<kbd>Page Down</kbd> - switch to the next page
             */
            CONTROL_PAGE_DOWN,
            /**
             * <kbd>Ctrl</kbd>+<kbd>Home</kbd> - switch to the first page
             */
            CONTROL_HOME,
            /**
             * <kbd>Ctrl</kbd>+<kbd>End</kbd> - switch to the last page
             */
            CONTROL_END,
            /**
             * <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>Page Up</kbd> - move the selected
             *   page backward
             */
            CONTROL_SHIFT_PAGE_UP,
            /**
             * <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>Page Down</kbd> - move the selected
             *   page forward
             */
            CONTROL_SHIFT_PAGE_DOWN,
            /**
             * <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>Home</kbd> - move the selected page
             *   at the start
             */
            CONTROL_SHIFT_HOME,
            /**
             * <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>End</kbd> - move the current page at
             *   the end
             */
            CONTROL_SHIFT_END,
            /**
             * <kbd>Alt</kbd>+<kbd>1</kbd>⋯<kbd>9</kbd> - switch to pages 1-9
             */
            ALT_DIGITS,
            /**
             * <kbd>Alt</kbd>+<kbd>0</kbd> - switch to page 10
             */
            ALT_ZERO,
            /**
             * All of the shortcuts
             */
            ALL_SHORTCUTS,
        }
        namespace AboutDialog {
            // Signal callback interfaces

            interface ActivateLink {
                (uri: string): boolean;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Dialog.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps,
                    Gtk.ShortcutManager.ConstructorProps {
                application_icon: string;
                applicationIcon: string;
                application_name: string;
                applicationName: string;
                artists: string[];
                comments: string;
                copyright: string;
                debug_info: string;
                debugInfo: string;
                debug_info_filename: string;
                debugInfoFilename: string;
                designers: string[];
                developer_name: string;
                developerName: string;
                developers: string[];
                documenters: string[];
                issue_url: string;
                issueUrl: string;
                license: string;
                license_type: Gtk.License;
                licenseType: Gtk.License;
                release_notes: string;
                releaseNotes: string;
                release_notes_version: string;
                releaseNotesVersion: string;
                support_url: string;
                supportUrl: string;
                translator_credits: string;
                translatorCredits: string;
                version: string;
                website: string;
            }
        }

        /**
         * A dialog showing information about the application.
         *
         * <picture>
         *   <source srcset="about-dialog-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="about-dialog.png" alt="about-dialog">
         * </picture>
         *
         * an about dialog is typically opened when the user activates the `About …`
         * item in the application's primary menu. All parts of the dialog are optional.
         *
         * ## Main page
         *
         * `AdwAboutDialog` prominently displays the application's icon, name, developer
         * name and version. They can be set with the [property`AboutDialog:`application-icon],
         * [property`AboutDialog:`application-name],
         * [property`AboutDialog:`developer-name] and [property`AboutDialog:`version]
         * respectively.
         *
         * ## What's New
         *
         * `AdwAboutDialog` provides a way for applications to display their release
         * notes, set with the [property`AboutDialog:`release-notes] property.
         *
         * Release notes are formatted the same way as
         * [AppStream descriptions](https://freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-description).
         *
         * The supported formatting options are:
         *
         * * Paragraph (`<p>`)
         * * Ordered list (`<ol>`), with list items (`<li>`)
         * * Unordered list (`<ul>`), with list items (`<li>`)
         *
         * Within paragraphs and list items, emphasis (`<em>`) and inline code
         * (`<code>`) text styles are supported. The emphasis is rendered in italic,
         * while inline code is shown in a monospaced font.
         *
         * Any text outside paragraphs or list items is ignored.
         *
         * Nested lists are not supported.
         *
         * Only one version can be shown at a time. By default, the displayed version
         * number matches [property`AboutDialog:`version]. Use
         * [property`AboutDialog:`release-notes-version] to override it.
         *
         * ## Details
         *
         * The Details page displays the application comments and links.
         *
         * The comments can be set with the [property`AboutDialog:`comments] property.
         * Unlike [property`Gtk`.AboutDialog:comments], this string can be long and
         * detailed. It can also contain links and Pango markup.
         *
         * To set the application website, use [property`AboutDialog:`website].
         * To add extra links below the website, use [method`AboutDialog`.add_link].
         *
         * If the Details page doesn't have any other content besides website, the
         * website will be displayed on the main page instead.
         *
         * ## Troubleshooting
         *
         * `AdwAboutDialog` displays the following two links on the main page:
         *
         * * Support Questions, set with the [property`AboutDialog:`support-url] property,
         * * Report an Issue, set with the [property`AboutDialog:`issue-url] property.
         *
         * Additionally, applications can provide debugging information. It will be
         * shown separately on the Troubleshooting page. Use the
         * [property`AboutDialog:`debug-info] property to specify it.
         *
         * It's intended to be attached to issue reports when reporting issues against
         * the application. As such, it cannot contain markup or links.
         *
         * `AdwAboutDialog` provides a quick way to save debug information to a file.
         * When saving, [property`AboutDialog:`debug-info-filename] would be used as
         * the suggested filename.
         *
         * ## Credits and Acknowledgements
         *
         * The Credits page has the following default sections:
         *
         * * Developers, set with the [property`AboutDialog:`developers] property,
         * * Designers, set with the [property`AboutDialog:`designers] property,
         * * Artists, set with the [property`AboutDialog:`artists] property,
         * * Documenters, set with the [property`AboutDialog:`documenters] property,
         * * Translators, set with the [property`AboutDialog:`translator-credits] property.
         *
         * When setting translator credits, use the strings `"translator-credits"` or
         * `"translator_credits"` and mark them as translatable.
         *
         * The default sections that don't contain any names won't be displayed.
         *
         * The Credits page can also contain an arbitrary number of extra sections below
         * the default ones. Use [method`AboutDialog`.add_credit_section] to add them.
         *
         * The Acknowledgements page can be used to acknowledge additional people and
         * organizations for their non-development contributions. Use
         * [method`AboutDialog`.add_acknowledgement_section] to add sections to it. For
         * example, it can be used to list backers in a crowdfunded project or to give
         * special thanks.
         *
         * Each of the people or organizations can have an email address or a website
         * specified. To add a email address, use a string like
         * `Edgar Allan Poe <edgar`poe`.com>`. To specify a website with a title, use a
         * string like `The GNOME Project https://www.gnome.org`:
         *
         * <picture>
         *   <source srcset="about-dialog-credits-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="about-dialog-credits.png" alt="about-dialog-credits">
         * </picture>
         *
         * ## Legal
         *
         * The Legal page displays the copyright and licensing information for the
         * application and other modules.
         *
         * The copyright string is set with the [property`AboutDialog:`copyright]
         * property and should be a short string of one or two lines, for example:
         * `© 2022 Example`.
         *
         * Licensing information can be quickly set from a list of known licenses with
         * the [property`AboutDialog:`license-type] property. If the application's
         * license is not in the list, [property`AboutDialog:`license] can be used
         * instead.
         *
         * To add information about other modules, such as application dependencies or
         * data, use [method`AboutDialog`.add_legal_section].
         *
         * ## Other applications
         *
         * `AdwAboutDialog` can show links to your other apps at the end of the main
         * page. To add them, use [method`AboutDialog`.add_other_app].
         *
         * ## Constructing
         *
         * To make constructing an `AdwAboutDialog` as convenient as possible, you can
         * use the function [func`show_about_dialog]` which constructs and shows a
         * dialog.
         *
         * ```c
         * static void
         * show_about (GtkApplication *app)
         * {
         *   const char *developers[] = {
         *     "Angela Avery",
         *     NULL
         *   };
         *
         *   const char *designers[] = {
         *     "GNOME Design Team",
         *     NULL
         *   };
         *
         *   adw_show_about_dialog (GTK_WIDGET (gtk_application_get_active_window (app)),
         *                          "application-name", _("Example"),
         *                          "application-icon", "org.example.App",
         *                          "version", "1.2.3",
         *                          "copyright", "© 2022 Angela Avery",
         *                          "issue-url", "https://gitlab.gnome.org/example/example/-/issues/",
         *                          "license-type", GTK_LICENSE_GPL_3_0,
         *                          "developers", developers,
         *                          "designers", designers,
         *                          "translator-credits", _("translator-credits"),
         *                          NULL);
         * }
         * ```
         *
         * ## CSS nodes
         *
         * `AdwAboutDialog` has a main CSS node with the name `dialog` and the
         * style class `.about`.
         */
        class AboutDialog
            extends Dialog
            implements Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.ShortcutManager
        {
            static $gtype: GObject.GType<AboutDialog>;

            // Properties

            /**
             * The name of the application icon.
             *
             * The icon is displayed at the top of the main page.
             */
            get application_icon(): string;
            set application_icon(val: string);
            /**
             * The name of the application icon.
             *
             * The icon is displayed at the top of the main page.
             */
            get applicationIcon(): string;
            set applicationIcon(val: string);
            /**
             * The name of the application.
             *
             * The name is displayed at the top of the main page.
             */
            get application_name(): string;
            set application_name(val: string);
            /**
             * The name of the application.
             *
             * The name is displayed at the top of the main page.
             */
            get applicationName(): string;
            set applicationName(val: string);
            /**
             * The list of artists of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`documenters]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             */
            get artists(): string[];
            set artists(val: string[]);
            /**
             * The comments about the application.
             *
             * Comments will be shown on the Details page, above links.
             *
             * Unlike [property`Gtk`.AboutDialog:comments], this string can be long and
             * detailed. It can also contain links and Pango markup.
             */
            get comments(): string;
            set comments(val: string);
            /**
             * The copyright information.
             *
             * This should be a short string of one or two lines, for example:
             * `© 2022 Example`.
             *
             * The copyright information will be displayed on the Legal page, above the
             * application license.
             *
             * [method`AboutDialog`.add_legal_section] can be used to add copyright
             * information for the application dependencies or other components.
             */
            get copyright(): string;
            set copyright(val: string);
            /**
             * The debug information.
             *
             * Debug information will be shown on the Troubleshooting page. It's intended
             * to be attached to issue reports when reporting issues against the
             * application.
             *
             * `AdwAboutDialog` provides a quick way to save debug information to a file.
             * When saving, [property`AboutDialog:`debug-info-filename] would be used as
             * the suggested filename.
             *
             * Debug information cannot contain markup or links.
             */
            get debug_info(): string;
            set debug_info(val: string);
            /**
             * The debug information.
             *
             * Debug information will be shown on the Troubleshooting page. It's intended
             * to be attached to issue reports when reporting issues against the
             * application.
             *
             * `AdwAboutDialog` provides a quick way to save debug information to a file.
             * When saving, [property`AboutDialog:`debug-info-filename] would be used as
             * the suggested filename.
             *
             * Debug information cannot contain markup or links.
             */
            get debugInfo(): string;
            set debugInfo(val: string);
            /**
             * The debug information filename.
             *
             * It will be used as the suggested filename when saving debug information to
             * a file.
             *
             * See [property`AboutDialog:`debug-info].
             */
            get debug_info_filename(): string;
            set debug_info_filename(val: string);
            /**
             * The debug information filename.
             *
             * It will be used as the suggested filename when saving debug information to
             * a file.
             *
             * See [property`AboutDialog:`debug-info].
             */
            get debugInfoFilename(): string;
            set debugInfoFilename(val: string);
            /**
             * The list of designers of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             */
            get designers(): string[];
            set designers(val: string[]);
            /**
             * The developer name.
             *
             * The developer name is displayed on the main page, under the application
             * name.
             *
             * If the application is developed by multiple people, the developer name can
             * be set to values like "AppName team", "AppName developers" or
             * "The AppName project", and the individual contributors can be listed on the
             * Credits page, with [property`AboutDialog:`developers] and related
             * properties.
             */
            get developer_name(): string;
            set developer_name(val: string);
            /**
             * The developer name.
             *
             * The developer name is displayed on the main page, under the application
             * name.
             *
             * If the application is developed by multiple people, the developer name can
             * be set to values like "AppName team", "AppName developers" or
             * "The AppName project", and the individual contributors can be listed on the
             * Credits page, with [property`AboutDialog:`developers] and related
             * properties.
             */
            get developerName(): string;
            set developerName(val: string);
            /**
             * The list of developers of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             */
            get developers(): string[];
            set developers(val: string[]);
            /**
             * The list of documenters of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             */
            get documenters(): string[];
            set documenters(val: string[]);
            /**
             * The URL for the application's issue tracker.
             *
             * The issue tracker link is displayed on the main page.
             */
            get issue_url(): string;
            set issue_url(val: string);
            /**
             * The URL for the application's issue tracker.
             *
             * The issue tracker link is displayed on the main page.
             */
            get issueUrl(): string;
            set issueUrl(val: string);
            /**
             * The license text.
             *
             * This can be used to set a custom text for the license if it can't be set
             * via [property`AboutDialog:`license-type].
             *
             * When set, [property`AboutDialog:`license-type] will be set to
             * `GTK_LICENSE_CUSTOM`.
             *
             * The license text will be displayed on the Legal page, below the copyright
             * information.
             *
             * License text can contain Pango markup and links.
             *
             * [method`AboutDialog`.add_legal_section] can be used to add license
             * information for the application dependencies or other components.
             */
            get license(): string;
            set license(val: string);
            /**
             * The license type.
             *
             * Allows to set the application's license froma list of known licenses.
             *
             * If the application's license is not in the list,
             * [property`AboutDialog:`license] can be used instead. The license type will
             * be automatically set to `GTK_LICENSE_CUSTOM` in that case.
             *
             * If set to `GTK_LICENSE_UNKNOWN`, no information will be displayed.
             *
             * If the license type is different from `GTK_LICENSE_CUSTOM`.
             * [property`AboutDialog:`license] will be cleared out.
             *
             * The license description will be displayed on the Legal page, below the
             * copyright information.
             *
             * [method`AboutDialog`.add_legal_section] can be used to add license
             * information for the application dependencies or other components.
             */
            get license_type(): Gtk.License;
            set license_type(val: Gtk.License);
            /**
             * The license type.
             *
             * Allows to set the application's license froma list of known licenses.
             *
             * If the application's license is not in the list,
             * [property`AboutDialog:`license] can be used instead. The license type will
             * be automatically set to `GTK_LICENSE_CUSTOM` in that case.
             *
             * If set to `GTK_LICENSE_UNKNOWN`, no information will be displayed.
             *
             * If the license type is different from `GTK_LICENSE_CUSTOM`.
             * [property`AboutDialog:`license] will be cleared out.
             *
             * The license description will be displayed on the Legal page, below the
             * copyright information.
             *
             * [method`AboutDialog`.add_legal_section] can be used to add license
             * information for the application dependencies or other components.
             */
            get licenseType(): Gtk.License;
            set licenseType(val: Gtk.License);
            /**
             * The release notes of the application.
             *
             * Release notes are displayed on the the What's New page.
             *
             * Release notes are formatted the same way as
             * [AppStream descriptions](https://freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-description).
             *
             * The supported formatting options are:
             *
             * * Paragraph (`<p>`)
             * * Ordered list (`<ol>`), with list items (`<li>`)
             * * Unordered list (`<ul>`), with list items (`<li>`)
             *
             * Within paragraphs and list items, emphasis (`<em>`) and inline code
             * (`<code>`) text styles are supported. The emphasis is rendered in italic,
             * while inline code is shown in a monospaced font.
             *
             * Any text outside paragraphs or list items is ignored.
             *
             * Nested lists are not supported.
             *
             * `AdwAboutDialog` displays the version above the release notes. If set, the
             * [property`AboutDialog:`release-notes-version] of the property will be used
             * as the version; otherwise, [property`AboutDialog:`version] is used.
             */
            get release_notes(): string;
            set release_notes(val: string);
            /**
             * The release notes of the application.
             *
             * Release notes are displayed on the the What's New page.
             *
             * Release notes are formatted the same way as
             * [AppStream descriptions](https://freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-description).
             *
             * The supported formatting options are:
             *
             * * Paragraph (`<p>`)
             * * Ordered list (`<ol>`), with list items (`<li>`)
             * * Unordered list (`<ul>`), with list items (`<li>`)
             *
             * Within paragraphs and list items, emphasis (`<em>`) and inline code
             * (`<code>`) text styles are supported. The emphasis is rendered in italic,
             * while inline code is shown in a monospaced font.
             *
             * Any text outside paragraphs or list items is ignored.
             *
             * Nested lists are not supported.
             *
             * `AdwAboutDialog` displays the version above the release notes. If set, the
             * [property`AboutDialog:`release-notes-version] of the property will be used
             * as the version; otherwise, [property`AboutDialog:`version] is used.
             */
            get releaseNotes(): string;
            set releaseNotes(val: string);
            /**
             * The version described by the application's release notes.
             *
             * The release notes version is displayed on the What's New page, above the
             * release notes.
             *
             * If not set, [property`AboutDialog:`version] will be used instead.
             *
             * For example, an application with the current version 2.0.2 might want to
             * keep the release notes from 2.0.0, and set the release notes version
             * accordingly.
             *
             * See [property`AboutDialog:`release-notes].
             */
            get release_notes_version(): string;
            set release_notes_version(val: string);
            /**
             * The version described by the application's release notes.
             *
             * The release notes version is displayed on the What's New page, above the
             * release notes.
             *
             * If not set, [property`AboutDialog:`version] will be used instead.
             *
             * For example, an application with the current version 2.0.2 might want to
             * keep the release notes from 2.0.0, and set the release notes version
             * accordingly.
             *
             * See [property`AboutDialog:`release-notes].
             */
            get releaseNotesVersion(): string;
            set releaseNotesVersion(val: string);
            /**
             * The URL of the application's support page.
             *
             * The support page link is displayed on the main page.
             */
            get support_url(): string;
            set support_url(val: string);
            /**
             * The URL of the application's support page.
             *
             * The support page link is displayed on the main page.
             */
            get supportUrl(): string;
            set supportUrl(val: string);
            /**
             * The translator credits string.
             *
             * It will be displayed on the Credits page.
             *
             * This string should be `"translator-credits"` or `"translator_credits"` and
             * should be marked as translatable.
             *
             * The string may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             */
            get translator_credits(): string;
            set translator_credits(val: string);
            /**
             * The translator credits string.
             *
             * It will be displayed on the Credits page.
             *
             * This string should be `"translator-credits"` or `"translator_credits"` and
             * should be marked as translatable.
             *
             * The string may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             */
            get translatorCredits(): string;
            set translatorCredits(val: string);
            /**
             * The version of the application.
             *
             * The version is displayed on the main page.
             *
             * If [property`AboutDialog:`release-notes-version] is not set, the version
             * will also be displayed above the release notes on the What's New page.
             */
            get version(): string;
            set version(val: string);
            /**
             * The URL of the application's website.
             *
             * Website is displayed on the Details page, below comments, or on the main
             * page if the Details page doesn't have any other content.
             *
             * Applications can add other links below, see [method`AboutDialog`.add_link].
             */
            get website(): string;
            set website(val: string);

            // Constructors

            constructor(properties?: Partial<AboutDialog.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): AboutDialog;

            static new_from_appdata(resource_path: string, release_notes_version?: string | null): AboutDialog;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'activate-link', callback: (_source: this, uri: string) => boolean): number;
            connect_after(signal: 'activate-link', callback: (_source: this, uri: string) => boolean): number;
            emit(signal: 'activate-link', uri: string): void;

            // Methods

            /**
             * Adds a section to the Acknowledgements page.
             *
             * This can be used to acknowledge additional people and organizations for their
             * non-development contributions - for example, backers in a crowdfunded
             * project.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * @param name the section name
             * @param people the list of names
             */
            add_acknowledgement_section(name: string | null, people: string[]): void;
            /**
             * Adds an extra section to the Credits page.
             *
             * Extra sections are displayed below the standard categories.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_acknowledgement_section]
             * @param name the section name
             * @param people the list of names
             */
            add_credit_section(name: string | null, people: string[]): void;
            /**
             * Adds an extra section to the Legal page.
             *
             * Extra sections will be displayed below the application's own information.
             *
             * The parameters `copyright,` `license_type` and `license` will be used to present
             * the it the same way as [property`AboutDialog:`copyright],
             * [property`AboutDialog:`license-type] and [property`AboutDialog:`license] are
             * for the application's own information.
             *
             * See those properties for more details.
             *
             * This can be useful to attribute the application dependencies or data.
             *
             * Examples:
             *
             * ```c
             * adw_about_dialog_add_legal_section (ADW_ABOUT_DIALOG (about),
             *                                     _("Copyright and a known license"),
             *                                     "© 2022 Example",
             *                                     GTK_LICENSE_LGPL_2_1,
             *                                     NULL);
             *
             * adw_about_dialog_add_legal_section (ADW_ABOUT_DIALOG (about),
             *                                     _("Copyright and custom license"),
             *                                     "© 2022 Example",
             *                                     GTK_LICENSE_CUSTOM,
             *                                     "Custom license text");
             *
             * adw_about_dialog_add_legal_section (ADW_ABOUT_DIALOG (about),
             *                                     _("Copyright only"),
             *                                     "© 2022 Example",
             *                                     GTK_LICENSE_UNKNOWN,
             *                                     NULL);
             *
             * adw_about_dialog_add_legal_section (ADW_ABOUT_DIALOG (about),
             *                                     _("Custom license only"),
             *                                     NULL,
             *                                     GTK_LICENSE_CUSTOM,
             *                                     "Something completely custom here.");
             * ```
             * @param title the name of the section
             * @param copyright a copyright string
             * @param license_type the type of license
             * @param license custom license information
             */
            add_legal_section(
                title: string,
                copyright: string | null,
                license_type: Gtk.License | null,
                license?: string | null,
            ): void;
            /**
             * Adds an extra link to the Details page.
             *
             * Extra links are displayed under the comment and website.
             *
             * Underlines in `title` will be interpreted as indicating a mnemonic.
             *
             * See [property`AboutDialog:`website].
             * @param title the link title
             * @param url the link URL
             */
            add_link(title: string, url: string): void;
            /**
             * Adds another application to `self`.
             *
             * The application will be displayed at the bottom of the main page, in a
             * separate section. Each added application will be presented as a row with
             * `title` and `summary,` as well as an icon with the name `appid`. Clicking the
             * row will show `appid` in the software center app.
             *
             * This can be used to link to your other applications if you have multiple.
             *
             * Example:
             *
             * ```c
             * adw_about_dialog_add_other_app (ADW_ABOUT_DIALOG (about),
             *                                 "org.gnome.Boxes",
             *                                 _("Boxes"),
             *                                 _("Virtualization made simple"));
             * ```
             * @param appid the application ID
             * @param name the application name
             * @param summary the application summary
             */
            add_other_app(appid: string, name: string, summary: string): void;
            /**
             * Gets the name of the application icon for `self`.
             * @returns the application icon name
             */
            get_application_icon(): string;
            /**
             * Gets the application name for `self`.
             * @returns the application name
             */
            get_application_name(): string;
            /**
             * Gets the list of artists of the application.
             * @returns The list of artists
             */
            get_artists(): string[] | null;
            /**
             * Gets the comments about the application.
             * @returns the comments
             */
            get_comments(): string;
            /**
             * Gets the copyright information for `self`.
             * @returns the copyright information
             */
            get_copyright(): string;
            /**
             * Gets the debug information for `self`.
             * @returns the debug information
             */
            get_debug_info(): string;
            /**
             * Gets the debug information filename for `self`.
             * @returns the debug information filename
             */
            get_debug_info_filename(): string;
            /**
             * Gets the list of designers of the application.
             * @returns The list of designers
             */
            get_designers(): string[] | null;
            /**
             * Gets the developer name for `self`.
             * @returns the developer_name
             */
            get_developer_name(): string;
            /**
             * Gets the list of developers of the application.
             * @returns The list of developers
             */
            get_developers(): string[] | null;
            /**
             * Gets the list of documenters of the application.
             * @returns The list of documenters
             */
            get_documenters(): string[] | null;
            /**
             * Gets the issue tracker URL for `self`.
             * @returns the issue tracker URL
             */
            get_issue_url(): string;
            /**
             * Gets the license for `self`.
             * @returns the license
             */
            get_license(): string;
            /**
             * Gets the license type for `self`.
             * @returns the license type
             */
            get_license_type(): Gtk.License;
            /**
             * Gets the release notes for `self`.
             * @returns the release notes
             */
            get_release_notes(): string;
            /**
             * Gets the version described by the application's release notes.
             * @returns the release notes version
             */
            get_release_notes_version(): string;
            /**
             * Gets the URL of the support page for `self`.
             * @returns the support page URL
             */
            get_support_url(): string;
            /**
             * Gets the translator credits string.
             * @returns The translator credits string
             */
            get_translator_credits(): string;
            /**
             * Gets the version for `self`.
             * @returns the version
             */
            get_version(): string;
            /**
             * Gets the application website URL for `self`.
             * @returns the website URL
             */
            get_website(): string;
            /**
             * Sets the name of the application icon for `self`.
             *
             * The icon is displayed at the top of the main page.
             * @param application_icon the application icon name
             */
            set_application_icon(application_icon: string): void;
            /**
             * Sets the application name for `self`.
             *
             * The name is displayed at the top of the main page.
             * @param application_name the application name
             */
            set_application_name(application_name: string): void;
            /**
             * Sets the list of artists of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`documenters]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             * @param artists the list of artists
             */
            set_artists(artists?: string[] | null): void;
            /**
             * Sets the comments about the application.
             *
             * Comments will be shown on the Details page, above links.
             *
             * Unlike [property`Gtk`.AboutDialog:comments], this string can be long and
             * detailed. It can also contain links and Pango markup.
             * @param comments the comments
             */
            set_comments(comments: string): void;
            /**
             * Sets the copyright information for `self`.
             *
             * This should be a short string of one or two lines, for example:
             * `© 2022 Example`.
             *
             * The copyright information will be displayed on the Legal page, before the
             * application license.
             *
             * [method`AboutDialog`.add_legal_section] can be used to add copyright
             * information for the application dependencies or other components.
             * @param copyright the copyright information
             */
            set_copyright(copyright: string): void;
            /**
             * Sets the debug information for `self`.
             *
             * Debug information will be shown on the Troubleshooting page. It's intended
             * to be attached to issue reports when reporting issues against the
             * application.
             *
             * `AdwAboutDialog` provides a quick way to save debug information to a file.
             * When saving, [property`AboutDialog:`debug-info-filename] would be used as
             * the suggested filename.
             *
             * Debug information cannot contain markup or links.
             * @param debug_info the debug information
             */
            set_debug_info(debug_info: string): void;
            /**
             * Sets the debug information filename for `self`.
             *
             * It will be used as the suggested filename when saving debug information to a
             * file.
             *
             * See [property`AboutDialog:`debug-info].
             * @param filename the debug info filename
             */
            set_debug_info_filename(filename: string): void;
            /**
             * Sets the list of designers of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             * @param designers the list of designers
             */
            set_designers(designers?: string[] | null): void;
            /**
             * Sets the developer name for `self`.
             *
             * The developer name is displayed on the main page, under the application name.
             *
             * If the application is developed by multiple people, the developer name can be
             * set to values like "AppName team", "AppName developers" or
             * "The AppName project", and the individual contributors can be listed on the
             * Credits page, with [property`AboutDialog:`developers] and related properties.
             * @param developer_name the developer name
             */
            set_developer_name(developer_name: string): void;
            /**
             * Sets the list of developers of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             * @param developers the list of developers
             */
            set_developers(developers?: string[] | null): void;
            /**
             * Sets the list of documenters of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`translator-credits]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             * @param documenters the list of documenters
             */
            set_documenters(documenters?: string[] | null): void;
            /**
             * Sets the issue tracker URL for `self`.
             *
             * The issue tracker link is displayed on the main page.
             * @param issue_url the issue tracker URL
             */
            set_issue_url(issue_url: string): void;
            /**
             * Sets the license for `self`.
             *
             * This can be used to set a custom text for the license if it can't be set via
             * [property`AboutDialog:`license-type].
             *
             * When set, [property`AboutDialog:`license-type] will be set to
             * `GTK_LICENSE_CUSTOM`.
             *
             * The license text will be displayed on the Legal page, below the copyright
             * information.
             *
             * License text can contain Pango markup and links.
             *
             * [method`AboutDialog`.add_legal_section] can be used to add license information
             * for the application dependencies or other components.
             * @param license the license
             */
            set_license(license: string): void;
            /**
             * Sets the license for `self` from a list of known licenses.
             *
             * If the application's license is not in the list,
             * [property`AboutDialog:`license] can be used instead. The license type will be
             * automatically set to `GTK_LICENSE_CUSTOM` in that case.
             *
             * If `license_type` is `GTK_LICENSE_UNKNOWN`, no information will be displayed.
             *
             * If `license_type` is different from `GTK_LICENSE_CUSTOM`.
             * [property`AboutDialog:`license] will be cleared out.
             *
             * The license description will be displayed on the Legal page, below the
             * copyright information.
             *
             * [method`AboutDialog`.add_legal_section] can be used to add license information
             * for the application dependencies or other components.
             * @param license_type the license type
             */
            set_license_type(license_type: Gtk.License | null): void;
            /**
             * Sets the release notes for `self`.
             *
             * Release notes are displayed on the the What's New page.
             *
             * Release notes are formatted the same way as
             * [AppStream descriptions](https://freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-description).
             *
             * The supported formatting options are:
             *
             * * Paragraph (`<p>`)
             * * Ordered list (`<ol>`), with list items (`<li>`)
             * * Unordered list (`<ul>`), with list items (`<li>`)
             *
             * Within paragraphs and list items, emphasis (`<em>`) and inline code
             * (`<code>`) text styles are supported. The emphasis is rendered in italic,
             * while inline code is shown in a monospaced font.
             *
             * Any text outside paragraphs or list items is ignored.
             *
             * Nested lists are not supported.
             *
             * `AdwAboutDialog` displays the version above the release notes. If set, the
             * [property`AboutDialog:`release-notes-version] of the property will be used
             * as the version; otherwise, [property`AboutDialog:`version] is used.
             * @param release_notes the release notes
             */
            set_release_notes(release_notes: string): void;
            /**
             * Sets the version described by the application's release notes.
             *
             * The release notes version is displayed on the What's New page, above the
             * release notes.
             *
             * If not set, [property`AboutDialog:`version] will be used instead.
             *
             * For example, an application with the current version 2.0.2 might want to
             * keep the release notes from 2.0.0, and set the release notes version
             * accordingly.
             *
             * See [property`AboutDialog:`release-notes].
             * @param version the release notes version
             */
            set_release_notes_version(version: string): void;
            /**
             * Sets the URL of the support page for `self`.
             *
             * The support page link is displayed on the main page.
             * @param support_url the support page URL
             */
            set_support_url(support_url: string): void;
            /**
             * Sets the translator credits string.
             *
             * It will be displayed on the Credits page.
             *
             * This string should be `"translator-credits"` or `"translator_credits"` and
             * should be marked as translatable.
             *
             * The string may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutDialog:`developers]
             * * [property`AboutDialog:`designers]
             * * [property`AboutDialog:`artists]
             * * [property`AboutDialog:`documenters]
             * * [method`AboutDialog`.add_credit_section]
             * * [method`AboutDialog`.add_acknowledgement_section]
             * @param translator_credits the translator credits
             */
            set_translator_credits(translator_credits: string): void;
            /**
             * Sets the version for `self`.
             *
             * The version is displayed on the main page.
             *
             * If [property`AboutDialog:`release-notes-version] is not set, the version will
             * also be displayed above the release notes on the What's New page.
             * @param version the version
             */
            set_version(version: string): void;
            /**
             * Sets the application website URL for `self`.
             *
             * Website is displayed on the Details page, below comments, or on the main page
             * if the Details page doesn't have any other content.
             *
             * Applications can add other links below, see [method`AboutDialog`.add_link].
             * @param website the website URL
             */
            set_website(website: string): void;

            // Inherited methods
            /**
             * Add a `GtkShortcutController` to be managed.
             * @param controller
             */
            vfunc_add_controller(controller: Gtk.ShortcutController): void;
            /**
             * Remove a `GtkShortcutController` that had previously
             *   been added
             * @param controller
             */
            vfunc_remove_controller(controller: Gtk.ShortcutController): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace AboutWindow {
            // Signal callback interfaces

            interface ActivateLink {
                (uri: string): boolean;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Window.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps,
                    Gtk.Native.ConstructorProps,
                    Gtk.Root.ConstructorProps,
                    Gtk.ShortcutManager.ConstructorProps {
                application_icon: string;
                applicationIcon: string;
                application_name: string;
                applicationName: string;
                artists: string[];
                comments: string;
                copyright: string;
                debug_info: string;
                debugInfo: string;
                debug_info_filename: string;
                debugInfoFilename: string;
                designers: string[];
                developer_name: string;
                developerName: string;
                developers: string[];
                documenters: string[];
                issue_url: string;
                issueUrl: string;
                license: string;
                license_type: Gtk.License;
                licenseType: Gtk.License;
                release_notes: string;
                releaseNotes: string;
                release_notes_version: string;
                releaseNotesVersion: string;
                support_url: string;
                supportUrl: string;
                translator_credits: string;
                translatorCredits: string;
                version: string;
                website: string;
            }
        }

        /**
         * A window showing information about the application.
         *
         * <picture>
         *   <source srcset="about-window-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="about-window.png" alt="about-window">
         * </picture>
         *
         * An about window is typically opened when the user activates the `About …`
         * item in the application's primary menu. All parts of the window are optional.
         *
         * ## Main page
         *
         * `AdwAboutWindow` prominently displays the application's icon, name, developer
         * name and version. They can be set with the [property`AboutWindow:`application-icon],
         * [property`AboutWindow:`application-name],
         * [property`AboutWindow:`developer-name] and [property`AboutWindow:`version]
         * respectively.
         *
         * ## What's New
         *
         * `AdwAboutWindow` provides a way for applications to display their release
         * notes, set with the [property`AboutWindow:`release-notes] property.
         *
         * Release notes are formatted the same way as
         * [AppStream descriptions](https://freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-description).
         *
         * The supported formatting options are:
         *
         * * Paragraph (`<p>`)
         * * Ordered list (`<ol>`), with list items (`<li>`)
         * * Unordered list (`<ul>`), with list items (`<li>`)
         *
         * Within paragraphs and list items, emphasis (`<em>`) and inline code
         * (`<code>`) text styles are supported. The emphasis is rendered in italic,
         * while inline code is shown in a monospaced font.
         *
         * Any text outside paragraphs or list items is ignored.
         *
         * Nested lists are not supported.
         *
         * Only one version can be shown at a time. By default, the displayed version
         * number matches [property`AboutWindow:`version]. Use
         * [property`AboutWindow:`release-notes-version] to override it.
         *
         * ## Details
         *
         * The Details page displays the application comments and links.
         *
         * The comments can be set with the [property`AboutWindow:`comments] property.
         * Unlike [property`Gtk`.AboutDialog:comments], this string can be long and
         * detailed. It can also contain links and Pango markup.
         *
         * To set the application website, use [property`AboutWindow:`website].
         * To add extra links below the website, use [method`AboutWindow`.add_link].
         *
         * If the Details page doesn't have any other content besides website, the
         * website will be displayed on the main page instead.
         *
         * ## Troubleshooting
         *
         * `AdwAboutWindow` displays the following two links on the main page:
         *
         * * Support Questions, set with the [property`AboutWindow:`support-url] property,
         * * Report an Issue, set with the [property`AboutWindow:`issue-url] property.
         *
         * Additionally, applications can provide debugging information. It will be
         * shown separately on the Troubleshooting page. Use the
         * [property`AboutWindow:`debug-info] property to specify it.
         *
         * It's intended to be attached to issue reports when reporting issues against
         * the application. As such, it cannot contain markup or links.
         *
         * `AdwAboutWindow` provides a quick way to save debug information to a file.
         * When saving, [property`AboutWindow:`debug-info-filename] would be used as
         * the suggested filename.
         *
         * ## Credits and Acknowledgements
         *
         * The Credits page has the following default sections:
         *
         * * Developers, set with the [property`AboutWindow:`developers] property,
         * * Designers, set with the [property`AboutWindow:`designers] property,
         * * Artists, set with the [property`AboutWindow:`artists] property,
         * * Documenters, set with the [property`AboutWindow:`documenters] property,
         * * Translators, set with the [property`AboutWindow:`translator-credits] property.
         *
         * When setting translator credits, use the strings `"translator-credits"` or
         * `"translator_credits"` and mark them as translatable.
         *
         * The default sections that don't contain any names won't be displayed.
         *
         * The Credits page can also contain an arbitrary number of extra sections below
         * the default ones. Use [method`AboutWindow`.add_credit_section] to add them.
         *
         * The Acknowledgements page can be used to acknowledge additional people and
         * organizations for their non-development contributions. Use
         * [method`AboutWindow`.add_acknowledgement_section] to add sections to it. For
         * example, it can be used to list backers in a crowdfunded project or to give
         * special thanks.
         *
         * Each of the people or organizations can have an email address or a website
         * specified. To add a email address, use a string like
         * `Edgar Allan Poe <edgar`poe`.com>`. To specify a website with a title, use a
         * string like `The GNOME Project https://www.gnome.org`:
         *
         * <picture>
         *   <source srcset="about-window-credits-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="about-window-credits.png" alt="about-window-credits">
         * </picture>
         *
         * ## Legal
         *
         * The Legal page displays the copyright and licensing information for the
         * application and other modules.
         *
         * The copyright string is set with the [property`AboutWindow:`copyright]
         * property and should be a short string of one or two lines, for example:
         * `© 2022 Example`.
         *
         * Licensing information can be quickly set from a list of known licenses with
         * the [property`AboutWindow:`license-type] property. If the application's
         * license is not in the list, [property`AboutWindow:`license] can be used
         * instead.
         *
         * To add information about other modules, such as application dependencies or
         * data, use [method`AboutWindow`.add_legal_section].
         *
         * ## Constructing
         *
         * To make constructing an `AdwAboutWindow` as convenient as possible, you can
         * use the function [func`show_about_window]` which constructs and shows a
         * window.
         *
         * ```c
         * static void
         * show_about (GtkApplication *app)
         * {
         *   const char *developers[] = {
         *     "Angela Avery",
         *     NULL
         *   };
         *
         *   const char *designers[] = {
         *     "GNOME Design Team",
         *     NULL
         *   };
         *
         *   adw_show_about_window (gtk_application_get_active_window (app),
         *                          "application-name", _("Example"),
         *                          "application-icon", "org.example.App",
         *                          "version", "1.2.3",
         *                          "copyright", "© 2022 Angela Avery",
         *                          "issue-url", "https://gitlab.gnome.org/example/example/-/issues/",
         *                          "license-type", GTK_LICENSE_GPL_3_0,
         *                          "developers", developers,
         *                          "designers", designers,
         *                          "translator-credits", _("translator-credits"),
         *                          NULL);
         * }
         * ```
         *
         * ## CSS nodes
         *
         * `AdwAboutWindow` has a main CSS node with the name `window` and the
         * style class `.about`.
         */
        class AboutWindow
            extends Window
            implements Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.Native, Gtk.Root, Gtk.ShortcutManager
        {
            static $gtype: GObject.GType<AboutWindow>;

            // Properties

            /**
             * The name of the application icon.
             *
             * The icon is displayed at the top of the main page.
             */
            get application_icon(): string;
            set application_icon(val: string);
            /**
             * The name of the application icon.
             *
             * The icon is displayed at the top of the main page.
             */
            get applicationIcon(): string;
            set applicationIcon(val: string);
            /**
             * The name of the application.
             *
             * The name is displayed at the top of the main page.
             */
            get application_name(): string;
            set application_name(val: string);
            /**
             * The name of the application.
             *
             * The name is displayed at the top of the main page.
             */
            get applicationName(): string;
            set applicationName(val: string);
            /**
             * The list of artists of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`documenters]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             */
            get artists(): string[];
            set artists(val: string[]);
            /**
             * The comments about the application.
             *
             * Comments will be shown on the Details page, above links.
             *
             * Unlike [property`Gtk`.AboutDialog:comments], this string can be long and
             * detailed. It can also contain links and Pango markup.
             */
            get comments(): string;
            set comments(val: string);
            /**
             * The copyright information.
             *
             * This should be a short string of one or two lines, for example:
             * `© 2022 Example`.
             *
             * The copyright information will be displayed on the Legal page, above the
             * application license.
             *
             * [method`AboutWindow`.add_legal_section] can be used to add copyright
             * information for the application dependencies or other components.
             */
            get copyright(): string;
            set copyright(val: string);
            /**
             * The debug information.
             *
             * Debug information will be shown on the Troubleshooting page. It's intended
             * to be attached to issue reports when reporting issues against the
             * application.
             *
             * `AdwAboutWindow` provides a quick way to save debug information to a file.
             * When saving, [property`AboutWindow:`debug-info-filename] would be used as
             * the suggested filename.
             *
             * Debug information cannot contain markup or links.
             */
            get debug_info(): string;
            set debug_info(val: string);
            /**
             * The debug information.
             *
             * Debug information will be shown on the Troubleshooting page. It's intended
             * to be attached to issue reports when reporting issues against the
             * application.
             *
             * `AdwAboutWindow` provides a quick way to save debug information to a file.
             * When saving, [property`AboutWindow:`debug-info-filename] would be used as
             * the suggested filename.
             *
             * Debug information cannot contain markup or links.
             */
            get debugInfo(): string;
            set debugInfo(val: string);
            /**
             * The debug information filename.
             *
             * It will be used as the suggested filename when saving debug information to
             * a file.
             *
             * See [property`AboutWindow:`debug-info].
             */
            get debug_info_filename(): string;
            set debug_info_filename(val: string);
            /**
             * The debug information filename.
             *
             * It will be used as the suggested filename when saving debug information to
             * a file.
             *
             * See [property`AboutWindow:`debug-info].
             */
            get debugInfoFilename(): string;
            set debugInfoFilename(val: string);
            /**
             * The list of designers of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             */
            get designers(): string[];
            set designers(val: string[]);
            /**
             * The developer name.
             *
             * The developer name is displayed on the main page, under the application
             * name.
             *
             * If the application is developed by multiple people, the developer name can
             * be set to values like "AppName team", "AppName developers" or
             * "The AppName project", and the individual contributors can be listed on the
             * Credits page, with [property`AboutWindow:`developers] and related
             * properties.
             */
            get developer_name(): string;
            set developer_name(val: string);
            /**
             * The developer name.
             *
             * The developer name is displayed on the main page, under the application
             * name.
             *
             * If the application is developed by multiple people, the developer name can
             * be set to values like "AppName team", "AppName developers" or
             * "The AppName project", and the individual contributors can be listed on the
             * Credits page, with [property`AboutWindow:`developers] and related
             * properties.
             */
            get developerName(): string;
            set developerName(val: string);
            /**
             * The list of developers of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             */
            get developers(): string[];
            set developers(val: string[]);
            /**
             * The list of documenters of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             */
            get documenters(): string[];
            set documenters(val: string[]);
            /**
             * The URL for the application's issue tracker.
             *
             * The issue tracker link is displayed on the main page.
             */
            get issue_url(): string;
            set issue_url(val: string);
            /**
             * The URL for the application's issue tracker.
             *
             * The issue tracker link is displayed on the main page.
             */
            get issueUrl(): string;
            set issueUrl(val: string);
            /**
             * The license text.
             *
             * This can be used to set a custom text for the license if it can't be set
             * via [property`AboutWindow:`license-type].
             *
             * When set, [property`AboutWindow:`license-type] will be set to
             * `GTK_LICENSE_CUSTOM`.
             *
             * The license text will be displayed on the Legal page, below the copyright
             * information.
             *
             * License text can contain Pango markup and links.
             *
             * [method`AboutWindow`.add_legal_section] can be used to add license
             * information for the application dependencies or other components.
             */
            get license(): string;
            set license(val: string);
            /**
             * The license type.
             *
             * Allows to set the application's license froma list of known licenses.
             *
             * If the application's license is not in the list,
             * [property`AboutWindow:`license] can be used instead. The license type will
             * be automatically set to `GTK_LICENSE_CUSTOM` in that case.
             *
             * If set to `GTK_LICENSE_UNKNOWN`, no information will be displayed.
             *
             * If the license type is different from `GTK_LICENSE_CUSTOM`.
             * [property`AboutWindow:`license] will be cleared out.
             *
             * The license description will be displayed on the Legal page, below the
             * copyright information.
             *
             * [method`AboutWindow`.add_legal_section] can be used to add license
             * information for the application dependencies or other components.
             */
            get license_type(): Gtk.License;
            set license_type(val: Gtk.License);
            /**
             * The license type.
             *
             * Allows to set the application's license froma list of known licenses.
             *
             * If the application's license is not in the list,
             * [property`AboutWindow:`license] can be used instead. The license type will
             * be automatically set to `GTK_LICENSE_CUSTOM` in that case.
             *
             * If set to `GTK_LICENSE_UNKNOWN`, no information will be displayed.
             *
             * If the license type is different from `GTK_LICENSE_CUSTOM`.
             * [property`AboutWindow:`license] will be cleared out.
             *
             * The license description will be displayed on the Legal page, below the
             * copyright information.
             *
             * [method`AboutWindow`.add_legal_section] can be used to add license
             * information for the application dependencies or other components.
             */
            get licenseType(): Gtk.License;
            set licenseType(val: Gtk.License);
            /**
             * The release notes of the application.
             *
             * Release notes are displayed on the the What's New page.
             *
             * Release notes are formatted the same way as
             * [AppStream descriptions](https://freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-description).
             *
             * The supported formatting options are:
             *
             * * Paragraph (`<p>`)
             * * Ordered list (`<ol>`), with list items (`<li>`)
             * * Unordered list (`<ul>`), with list items (`<li>`)
             *
             * Within paragraphs and list items, emphasis (`<em>`) and inline code
             * (`<code>`) text styles are supported. The emphasis is rendered in italic,
             * while inline code is shown in a monospaced font.
             *
             * Any text outside paragraphs or list items is ignored.
             *
             * Nested lists are not supported.
             *
             * `AdwAboutWindow` displays the version above the release notes. If set, the
             * [property`AboutWindow:`release-notes-version] of the property will be used
             * as the version; otherwise, [property`AboutWindow:`version] is used.
             */
            get release_notes(): string;
            set release_notes(val: string);
            /**
             * The release notes of the application.
             *
             * Release notes are displayed on the the What's New page.
             *
             * Release notes are formatted the same way as
             * [AppStream descriptions](https://freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-description).
             *
             * The supported formatting options are:
             *
             * * Paragraph (`<p>`)
             * * Ordered list (`<ol>`), with list items (`<li>`)
             * * Unordered list (`<ul>`), with list items (`<li>`)
             *
             * Within paragraphs and list items, emphasis (`<em>`) and inline code
             * (`<code>`) text styles are supported. The emphasis is rendered in italic,
             * while inline code is shown in a monospaced font.
             *
             * Any text outside paragraphs or list items is ignored.
             *
             * Nested lists are not supported.
             *
             * `AdwAboutWindow` displays the version above the release notes. If set, the
             * [property`AboutWindow:`release-notes-version] of the property will be used
             * as the version; otherwise, [property`AboutWindow:`version] is used.
             */
            get releaseNotes(): string;
            set releaseNotes(val: string);
            /**
             * The version described by the application's release notes.
             *
             * The release notes version is displayed on the What's New page, above the
             * release notes.
             *
             * If not set, [property`AboutWindow:`version] will be used instead.
             *
             * For example, an application with the current version 2.0.2 might want to
             * keep the release notes from 2.0.0, and set the release notes version
             * accordingly.
             *
             * See [property`AboutWindow:`release-notes].
             */
            get release_notes_version(): string;
            set release_notes_version(val: string);
            /**
             * The version described by the application's release notes.
             *
             * The release notes version is displayed on the What's New page, above the
             * release notes.
             *
             * If not set, [property`AboutWindow:`version] will be used instead.
             *
             * For example, an application with the current version 2.0.2 might want to
             * keep the release notes from 2.0.0, and set the release notes version
             * accordingly.
             *
             * See [property`AboutWindow:`release-notes].
             */
            get releaseNotesVersion(): string;
            set releaseNotesVersion(val: string);
            /**
             * The URL of the application's support page.
             *
             * The support page link is displayed on the main page.
             */
            get support_url(): string;
            set support_url(val: string);
            /**
             * The URL of the application's support page.
             *
             * The support page link is displayed on the main page.
             */
            get supportUrl(): string;
            set supportUrl(val: string);
            /**
             * The translator credits string.
             *
             * It will be displayed on the Credits page.
             *
             * This string should be `"translator-credits"` or `"translator_credits"` and
             * should be marked as translatable.
             *
             * The string may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             */
            get translator_credits(): string;
            set translator_credits(val: string);
            /**
             * The translator credits string.
             *
             * It will be displayed on the Credits page.
             *
             * This string should be `"translator-credits"` or `"translator_credits"` and
             * should be marked as translatable.
             *
             * The string may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             */
            get translatorCredits(): string;
            set translatorCredits(val: string);
            /**
             * The version of the application.
             *
             * The version is displayed on the main page.
             *
             * If [property`AboutWindow:`release-notes-version] is not set, the version
             * will also be displayed above the release notes on the What's New page.
             */
            get version(): string;
            set version(val: string);
            /**
             * The URL of the application's website.
             *
             * Website is displayed on the Details page, below comments, or on the main
             * page if the Details page doesn't have any other content.
             *
             * Applications can add other links below, see [method`AboutWindow`.add_link].
             */
            get website(): string;
            set website(val: string);

            // Constructors

            constructor(properties?: Partial<AboutWindow.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): AboutWindow;

            static new_from_appdata(resource_path: string, release_notes_version?: string | null): AboutWindow;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'activate-link', callback: (_source: this, uri: string) => boolean): number;
            connect_after(signal: 'activate-link', callback: (_source: this, uri: string) => boolean): number;
            emit(signal: 'activate-link', uri: string): void;

            // Methods

            /**
             * Adds a section to the Acknowledgements page.
             *
             * This can be used to acknowledge additional people and organizations for their
             * non-development contributions - for example, backers in a crowdfunded
             * project.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * @param name the section name
             * @param people the list of names
             */
            add_acknowledgement_section(name: string | null, people: string[]): void;
            /**
             * Adds an extra section to the Credits page.
             *
             * Extra sections are displayed below the standard categories.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_acknowledgement_section]
             * @param name the section name
             * @param people the list of names
             */
            add_credit_section(name: string | null, people: string[]): void;
            /**
             * Adds an extra section to the Legal page.
             *
             * Extra sections will be displayed below the application's own information.
             *
             * The parameters `copyright,` `license_type` and `license` will be used to present
             * the it the same way as [property`AboutWindow:`copyright],
             * [property`AboutWindow:`license-type] and [property`AboutWindow:`license] are
             * for the application's own information.
             *
             * See those properties for more details.
             *
             * This can be useful to attribute the application dependencies or data.
             *
             * Examples:
             *
             * ```c
             * adw_about_window_add_legal_section (ADW_ABOUT_WINDOW (about),
             *                                     _("Copyright and a known license"),
             *                                     "© 2022 Example",
             *                                     GTK_LICENSE_LGPL_2_1,
             *                                     NULL);
             *
             * adw_about_window_add_legal_section (ADW_ABOUT_WINDOW (about),
             *                                     _("Copyright and custom license"),
             *                                     "© 2022 Example",
             *                                     GTK_LICENSE_CUSTOM,
             *                                     "Custom license text");
             *
             * adw_about_window_add_legal_section (ADW_ABOUT_WINDOW (about),
             *                                     _("Copyright only"),
             *                                     "© 2022 Example",
             *                                     GTK_LICENSE_UNKNOWN,
             *                                     NULL);
             *
             * adw_about_window_add_legal_section (ADW_ABOUT_WINDOW (about),
             *                                     _("Custom license only"),
             *                                     NULL,
             *                                     GTK_LICENSE_CUSTOM,
             *                                     "Something completely custom here.");
             * ```
             * @param title the name of the section
             * @param copyright a copyright string
             * @param license_type the type of license
             * @param license custom license information
             */
            add_legal_section(
                title: string,
                copyright: string | null,
                license_type: Gtk.License | null,
                license?: string | null,
            ): void;
            /**
             * Adds an extra link to the Details page.
             *
             * Extra links are displayed under the comment and website.
             *
             * Underlines in `title` will be interpreted as indicating a mnemonic.
             *
             * See [property`AboutWindow:`website].
             * @param title the link title
             * @param url the link URL
             */
            add_link(title: string, url: string): void;
            /**
             * Gets the name of the application icon for `self`.
             * @returns the application icon name
             */
            get_application_icon(): string;
            /**
             * Gets the application name for `self`.
             * @returns the application name
             */
            get_application_name(): string;
            /**
             * Gets the list of artists of the application.
             * @returns The list of artists
             */
            get_artists(): string[] | null;
            /**
             * Gets the comments about the application.
             * @returns the comments
             */
            get_comments(): string;
            /**
             * Gets the copyright information for `self`.
             * @returns the copyright information
             */
            get_copyright(): string;
            /**
             * Gets the debug information for `self`.
             * @returns the debug information
             */
            get_debug_info(): string;
            /**
             * Gets the debug information filename for `self`.
             * @returns the debug information filename
             */
            get_debug_info_filename(): string;
            /**
             * Gets the list of designers of the application.
             * @returns The list of designers
             */
            get_designers(): string[] | null;
            /**
             * Gets the developer name for `self`.
             * @returns the developer_name
             */
            get_developer_name(): string;
            /**
             * Gets the list of developers of the application.
             * @returns The list of developers
             */
            get_developers(): string[] | null;
            /**
             * Gets the list of documenters of the application.
             * @returns The list of documenters
             */
            get_documenters(): string[] | null;
            /**
             * Gets the issue tracker URL for `self`.
             * @returns the issue tracker URL
             */
            get_issue_url(): string;
            /**
             * Gets the license for `self`.
             * @returns the license
             */
            get_license(): string;
            /**
             * Gets the license type for `self`.
             * @returns the license type
             */
            get_license_type(): Gtk.License;
            /**
             * Gets the release notes for `self`.
             * @returns the release notes
             */
            get_release_notes(): string;
            /**
             * Gets the version described by the application's release notes.
             * @returns the release notes version
             */
            get_release_notes_version(): string;
            /**
             * Gets the URL of the support page for `self`.
             * @returns the support page URL
             */
            get_support_url(): string;
            /**
             * Gets the translator credits string.
             * @returns The translator credits string
             */
            get_translator_credits(): string;
            /**
             * Gets the version for `self`.
             * @returns the version
             */
            get_version(): string;
            /**
             * Gets the application website URL for `self`.
             * @returns the website URL
             */
            get_website(): string;
            /**
             * Sets the name of the application icon for `self`.
             *
             * The icon is displayed at the top of the main page.
             * @param application_icon the application icon name
             */
            set_application_icon(application_icon: string): void;
            /**
             * Sets the application name for `self`.
             *
             * The name is displayed at the top of the main page.
             * @param application_name the application name
             */
            set_application_name(application_name: string): void;
            /**
             * Sets the list of artists of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`documenters]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             * @param artists the list of artists
             */
            set_artists(artists?: string[] | null): void;
            /**
             * Sets the comments about the application.
             *
             * Comments will be shown on the Details page, above links.
             *
             * Unlike [property`Gtk`.AboutDialog:comments], this string can be long and
             * detailed. It can also contain links and Pango markup.
             * @param comments the comments
             */
            set_comments(comments: string): void;
            /**
             * Sets the copyright information for `self`.
             *
             * This should be a short string of one or two lines, for example:
             * `© 2022 Example`.
             *
             * The copyright information will be displayed on the Legal page, before the
             * application license.
             *
             * [method`AboutWindow`.add_legal_section] can be used to add copyright
             * information for the application dependencies or other components.
             * @param copyright the copyright information
             */
            set_copyright(copyright: string): void;
            /**
             * Sets the debug information for `self`.
             *
             * Debug information will be shown on the Troubleshooting page. It's intended
             * to be attached to issue reports when reporting issues against the
             * application.
             *
             * `AdwAboutWindow` provides a quick way to save debug information to a file.
             * When saving, [property`AboutWindow:`debug-info-filename] would be used as
             * the suggested filename.
             *
             * Debug information cannot contain markup or links.
             * @param debug_info the debug information
             */
            set_debug_info(debug_info: string): void;
            /**
             * Sets the debug information filename for `self`.
             *
             * It will be used as the suggested filename when saving debug information to a
             * file.
             *
             * See [property`AboutWindow:`debug-info].
             * @param filename the debug info filename
             */
            set_debug_info_filename(filename: string): void;
            /**
             * Sets the list of designers of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             * @param designers the list of designers
             */
            set_designers(designers?: string[] | null): void;
            /**
             * Sets the developer name for `self`.
             *
             * The developer name is displayed on the main page, under the application name.
             *
             * If the application is developed by multiple people, the developer name can be
             * set to values like "AppName team", "AppName developers" or
             * "The AppName project", and the individual contributors can be listed on the
             * Credits page, with [property`AboutWindow:`developers] and related properties.
             * @param developer_name the developer name
             */
            set_developer_name(developer_name: string): void;
            /**
             * Sets the list of developers of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             * @param developers the list of developers
             */
            set_developers(developers?: string[] | null): void;
            /**
             * Sets the list of documenters of the application.
             *
             * It will be displayed on the Credits page.
             *
             * Each name may contain email addresses and URLs, see the introduction for more
             * details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`translator-credits]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             * @param documenters the list of documenters
             */
            set_documenters(documenters?: string[] | null): void;
            /**
             * Sets the issue tracker URL for `self`.
             *
             * The issue tracker link is displayed on the main page.
             * @param issue_url the issue tracker URL
             */
            set_issue_url(issue_url: string): void;
            /**
             * Sets the license for `self`.
             *
             * This can be used to set a custom text for the license if it can't be set via
             * [property`AboutWindow:`license-type].
             *
             * When set, [property`AboutWindow:`license-type] will be set to
             * `GTK_LICENSE_CUSTOM`.
             *
             * The license text will be displayed on the Legal page, below the copyright
             * information.
             *
             * License text can contain Pango markup and links.
             *
             * [method`AboutWindow`.add_legal_section] can be used to add license information
             * for the application dependencies or other components.
             * @param license the license
             */
            set_license(license: string): void;
            /**
             * Sets the license for `self` from a list of known licenses.
             *
             * If the application's license is not in the list,
             * [property`AboutWindow:`license] can be used instead. The license type will be
             * automatically set to `GTK_LICENSE_CUSTOM` in that case.
             *
             * If `license_type` is `GTK_LICENSE_UNKNOWN`, no information will be displayed.
             *
             * If `license_type` is different from `GTK_LICENSE_CUSTOM`.
             * [property`AboutWindow:`license] will be cleared out.
             *
             * The license description will be displayed on the Legal page, below the
             * copyright information.
             *
             * [method`AboutWindow`.add_legal_section] can be used to add license information
             * for the application dependencies or other components.
             * @param license_type the license type
             */
            set_license_type(license_type: Gtk.License | null): void;
            /**
             * Sets the release notes for `self`.
             *
             * Release notes are displayed on the the What's New page.
             *
             * Release notes are formatted the same way as
             * [AppStream descriptions](https://freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-description).
             *
             * The supported formatting options are:
             *
             * * Paragraph (`<p>`)
             * * Ordered list (`<ol>`), with list items (`<li>`)
             * * Unordered list (`<ul>`), with list items (`<li>`)
             *
             * Within paragraphs and list items, emphasis (`<em>`) and inline code
             * (`<code>`) text styles are supported. The emphasis is rendered in italic,
             * while inline code is shown in a monospaced font.
             *
             * Any text outside paragraphs or list items is ignored.
             *
             * Nested lists are not supported.
             *
             * `AdwAboutWindow` displays the version above the release notes. If set, the
             * [property`AboutWindow:`release-notes-version] of the property will be used
             * as the version; otherwise, [property`AboutWindow:`version] is used.
             * @param release_notes the release notes
             */
            set_release_notes(release_notes: string): void;
            /**
             * Sets the version described by the application's release notes.
             *
             * The release notes version is displayed on the What's New page, above the
             * release notes.
             *
             * If not set, [property`AboutWindow:`version] will be used instead.
             *
             * For example, an application with the current version 2.0.2 might want to
             * keep the release notes from 2.0.0, and set the release notes version
             * accordingly.
             *
             * See [property`AboutWindow:`release-notes].
             * @param version the release notes version
             */
            set_release_notes_version(version: string): void;
            /**
             * Sets the URL of the support page for `self`.
             *
             * The support page link is displayed on the main page.
             * @param support_url the support page URL
             */
            set_support_url(support_url: string): void;
            /**
             * Sets the translator credits string.
             *
             * It will be displayed on the Credits page.
             *
             * This string should be `"translator-credits"` or `"translator_credits"` and
             * should be marked as translatable.
             *
             * The string may contain email addresses and URLs, see the introduction for
             * more details.
             *
             * See also:
             *
             * * [property`AboutWindow:`developers]
             * * [property`AboutWindow:`designers]
             * * [property`AboutWindow:`artists]
             * * [property`AboutWindow:`documenters]
             * * [method`AboutWindow`.add_credit_section]
             * * [method`AboutWindow`.add_acknowledgement_section]
             * @param translator_credits the translator credits
             */
            set_translator_credits(translator_credits: string): void;
            /**
             * Sets the version for `self`.
             *
             * The version is displayed on the main page.
             *
             * If [property`AboutWindow:`release-notes-version] is not set, the version will
             * also be displayed above the release notes on the What's New page.
             * @param version the version
             */
            set_version(version: string): void;
            /**
             * Sets the application website URL for `self`.
             *
             * Website is displayed on the Details page, below comments, or on the main page
             * if the Details page doesn't have any other content.
             *
             * Applications can add other links below, see [method`AboutWindow`.add_link].
             * @param website the website URL
             */
            set_website(website: string): void;

            // Inherited properties
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get can_focus(): boolean;
            set can_focus(val: boolean);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get canFocus(): boolean;
            set canFocus(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get can_target(): boolean;
            set can_target(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get canTarget(): boolean;
            set canTarget(val: boolean);
            /**
             * A list of css classes applied to this widget.
             */
            get css_classes(): string[];
            set css_classes(val: string[]);
            /**
             * A list of css classes applied to this widget.
             */
            get cssClasses(): string[];
            set cssClasses(val: string[]);
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get css_name(): string;
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get cssName(): string;
            /**
             * The cursor used by `widget`.
             */
            get cursor(): Gdk.Cursor;
            set cursor(val: Gdk.Cursor);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * Whether this widget itself will accept the input focus.
             */
            get focusable(): boolean;
            set focusable(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space.
             */
            get halign(): Gtk.Align;
            set halign(val: Gtk.Align);
            /**
             * Whether the widget is the default widget.
             */
            get has_default(): boolean;
            /**
             * Whether the widget is the default widget.
             */
            get hasDefault(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get has_focus(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get hasFocus(): boolean;
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get height_request(): number;
            set height_request(val: number);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally.
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layout_manager(): Gtk.LayoutManager;
            set layout_manager(val: Gtk.LayoutManager);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layoutManager(): Gtk.LayoutManager;
            set layoutManager(val: Gtk.LayoutManager);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limit_events(): boolean;
            set limit_events(val: boolean);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limitEvents(): boolean;
            set limitEvents(val: boolean);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            /**
             * The name of the widget.
             */
            get name(): string;
            set name(val: string);
            /**
             * The requested opacity of the widget.
             */
            get opacity(): number;
            set opacity(val: number);
            /**
             * How content outside the widget's content area is treated.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get overflow(): Gtk.Overflow;
            set overflow(val: Gtk.Overflow);
            /**
             * The parent widget of this widget.
             */
            get parent(): Gtk.Widget;
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receives_default(): boolean;
            set receives_default(val: boolean);
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The `GtkRoot` widget of the widget tree containing this widget.
             *
             * This will be `NULL` if the widget is not contained in a root widget.
             */
            get root(): Gtk.Root;
            /**
             * The scale factor of the widget.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget.
             */
            get scaleFactor(): number;
            /**
             * Whether the widget responds to input.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space.
             */
            get valign(): Gtk.Align;
            set valign(val: Gtk.Align);
            /**
             * Whether to expand vertically.
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            /**
             * Whether the widget is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get width_request(): number;
            set width_request(val: number);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get widthRequest(): number;
            set widthRequest(val: number);

            // Inherited methods
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * Enables or disables an action installed with
             * [method`Gtk`.WidgetClass.install_action].
             * @param action_name action name, such as "clipboard.paste"
             * @param enabled whether the action is now enabled
             */
            action_set_enabled(action_name: string, enabled: boolean): void;
            /**
             * Activates the widget.
             *
             * The activation will emit the signal set using
             * [method`Gtk`.WidgetClass.set_activate_signal]
             * during class initialization.
             *
             * Activation is what happens when you press <kbd>Enter</kbd>
             * on a widget.
             *
             * If you wish to handle the activation keybinding yourself,
             * it is recommended to use [method`Gtk`.WidgetClass.add_shortcut]
             * with an action created with [ctor`Gtk`.SignalAction.new].
             *
             * If `widget` is not activatable, the function returns false.
             * @returns true if the widget was activated
             */
            activate(): boolean;
            /**
             * Activates an action for the widget.
             *
             * The action is looked up in the action groups associated with
             * `widget` and its ancestors.
             *
             * If the action is in an action group added with
             * [method`Gtk`.Widget.insert_action_group], the `name` is expected
             * to be prefixed with the prefix that was used when the group was
             * inserted.
             *
             * The arguments must match the actions expected parameter type,
             * as returned by [method`Gio`.Action.get_parameter_type].
             * @param name the name of the action to activate
             * @param args parameters to use
             * @returns true if the action was activated
             */
            activate_action(name: string, args?: GLib.Variant | null): boolean;
            /**
             * Activates the `default.activate` action for the widget.
             *
             * The action is looked up in the same was as for
             * [method`Gtk`.Widget.activate_action].
             */
            activate_default(): void;
            /**
             * Adds an event controller to the widget.
             *
             * The event controllers of a widget handle the events that are
             * propagated to the widget.
             *
             * You will usually want to call this function right after
             * creating any kind of [class`Gtk`.EventController].
             * @param controller an event controller that hasn't been   added to a widget yet
             */
            add_controller(controller: Gtk.EventController): void;
            /**
             * Adds a style class to the widget.
             *
             * After calling this function, the widget’s style will match
             * for `css_class,` according to CSS matching rules.
             *
             * Use [method`Gtk`.Widget.remove_css_class] to remove the
             * style again.
             * @param css_class style class to add to @widget, without the leading period
             */
            add_css_class(css_class: string): void;
            /**
             * Adds a widget to the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * Note that the list of mnemonic labels for the widget is cleared
             * when the widget is destroyed, so the caller must make sure
             * to update its internal state at this point as well.
             * @param label a widget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Gtk.Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame.
             *
             * Until the tick callback is removed, it will be called frequently
             * (usually at the frame rate of the output device or as quickly as
             * the application can be repainted, whichever is slower). For this
             * reason, is most suitable for handling graphics that change every
             * frame or every few frames.
             *
             * The tick callback does not automatically imply a relayout or repaint.
             * If you want a repaint or relayout, and aren’t changing widget properties
             * that would trigger that (for example, changing the text of a label),
             * then you will have to call [method`Gtk`.Widget.queue_resize] or
             * [method`Gtk`.Widget.queue_draw] yourself.
             *
             * [method`Gdk`.FrameClock.get_frame_time] should generally be used
             * for timing continuous animations and
             * [method`Gdk`.FrameTimings.get_predicted_presentation_time] should be
             * used if you are trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * [signal`Gdk`.FrameClock::update] signal of the frame clock, since you
             * don't have to worry about when a frame clock is assigned to a widget.
             *
             * To remove a tick callback, pass the ID that is returned by this function
             * to [method`Gtk`.Widget.remove_tick_callback].
             * @param callback function   to call for updating animations
             * @returns an ID for this callback
             */
            add_tick_callback(callback: Gtk.TickCallback): number;
            /**
             * Assigns size, position, (optionally) a baseline and transform
             * to a child widget.
             *
             * In this function, the allocation and baseline may be adjusted.
             * The given allocation will be forced to be bigger than the
             * widget's minimum size, as well as at least 0×0 in size.
             *
             * This function is only used by widget implementations.
             *
             * For a version that does not take a transform, see
             * [method`Gtk`.Widget.size_allocate].
             * @param width new width
             * @param height new height
             * @param baseline new baseline, or -1
             * @param transform transformation to be applied
             */
            allocate(width: number, height: number, baseline: number, transform?: Gsk.Transform | null): void;
            /**
             * Called by widgets as the user moves around the window using
             * keyboard shortcuts.
             *
             * The `direction` argument indicates what kind of motion is taking
             * place (up, down, left, right, tab forward, tab backward).
             *
             * This function calls the [vfunc`Gtk`.Widget.focus] virtual function;
             * widgets can override the virtual function in order to implement
             * appropriate focus behavior.
             *
             * The default `focus()` virtual function for a widget should return
             * true if moving in `direction` left the focus on a focusable location
             * inside that widget, and false if moving in `direction` moved the focus
             * outside the widget. When returning true, widgets normally call
             * [method`Gtk`.Widget.grab_focus] to place the focus accordingly;
             * when returning false, they don’t modify the current focus location.
             *
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use [method`Gtk`.Widget.grab_focus] to move
             * the focus to a particular widget.
             * @param direction direction of focus movement
             * @returns true if focus ended up inside @widget
             */
            child_focus(direction: Gtk.DirectionType | null): boolean;
            /**
             * Computes the bounds for `widget` in the coordinate space of `target`.
             *
             * The bounds of widget are (the bounding box of) the region that it is
             * expected to draw in. See the [coordinate system](coordinates.html)
             * overview to learn more.
             *
             * If the operation is successful, true is returned. If `widget` has no
             * bounds or the bounds cannot be expressed in `target'`s coordinate space
             * (for example if both widgets are in different windows), false is
             * returned and `bounds` is set to the zero rectangle.
             *
             * It is valid for `widget` and `target` to be the same widget.
             * @param target the target widget
             * @returns true if the bounds could be computed
             */
            compute_bounds(target: Gtk.Widget): [boolean, Graphene.Rect];
            /**
             * Computes whether a parent widget should give this widget
             * extra space when possible.
             *
             * Widgets with children should check this, rather than looking at
             * [method`Gtk`.Widget.get_hexpand] or [method`Gtk`.Widget.get_vexpand].
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Gtk.Orientation | null): boolean;
            /**
             * Translates the given `point` in `widget'`s coordinates to coordinates
             * in `target’`s coordinate system.
             *
             * In order to perform this operation, both widgets must share a
             * a common ancestor. If that is not the case, `out_point` is set
             * to (0, 0) and false is returned.
             * @param target the widget to transform into
             * @param point a point in @widget's coordinate system
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            compute_point(target: Gtk.Widget, point: Graphene.Point): [boolean, Graphene.Point];
            /**
             * Computes a matrix suitable to describe a transformation from
             * `widget'`s coordinate system into `target'`s coordinate system.
             *
             * The transform can not be computed in certain cases, for example
             * when `widget` and `target` do not share a common ancestor. In that
             * case `out_transform` gets set to the identity matrix.
             *
             * To learn more about widget coordinate systems, see the coordinate
             * system [overview](coordinates.html).
             * @param target the target widget that the matrix will transform to
             * @returns true if the transform could be computed
             */
            compute_transform(target: Gtk.Widget): [boolean, Graphene.Matrix];
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             * @returns true if @widget contains the point (x, y)
             */
            contains(x: number, y: number): boolean;
            /**
             * Creates a new `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map,
             * font options, font description, and base direction set.
             *
             * See also [method`Gtk`.Widget.get_pango_context].
             * @returns the new `PangoContext`
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new `PangoLayout` that is configured for the widget.
             *
             * The `PangoLayout` will have the appropriate font map,
             * font description, and base direction set.
             *
             * If you keep a `PangoLayout` created in this way around,
             * you need to re-create it when the widgets `PangoContext`
             * is replaced. This can be tracked by listening to changes
             * of the [property`Gtk`.Widget:root] property on the widget.
             * @param text text to set on the layout
             * @returns the new `PangoLayout`
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Clears the template children for the widget.
             *
             * This function is the opposite of [method`Gtk`.Widget.init_template],
             * and it is used to clear all the template children from a widget
             * instance. If you bound a template child to a field in the instance
             * structure, or in the instance private data structure, the field will
             * be set to `NULL` after this function returns.
             *
             * You should call this function inside the `GObjectClass.dispose()`
             * implementation of any widget that called [method`Gtk`.Widget.init_template].
             * Typically, you will want to call this function last, right before
             * chaining up to the parent type's dispose implementation, e.g.
             *
             * ```c
             * static void
             * some_widget_dispose (GObject *gobject)
             * {
             *   SomeWidget *self = SOME_WIDGET (gobject);
             *
             *   // Clear the template data for SomeWidget
             *   gtk_widget_dispose_template (GTK_WIDGET (self), SOME_TYPE_WIDGET);
             *
             *   G_OBJECT_CLASS (some_widget_parent_class)->dispose (gobject);
             * }
             * ```
             * @param widget_type the type of the widget to finalize the template for
             */
            dispose_template(widget_type: GObject.GType): void;
            /**
             * Checks to see if a drag movement has passed the GTK drag threshold.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns true if the drag threshold has been passed
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Notifies the user about an input-related error on the widget.
             *
             * If the [property`Gtk`.Settings:gtk-error-bell] setting is true,
             * it calls [method`Gdk`.Surface.beep], otherwise it does nothing.
             *
             * Note that the effect of [method`Gdk`.Surface.beep] can be configured
             * in many ways, depending on the windowing backend and the desktop
             * environment or window manager that is used.
             */
            error_bell(): void;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidget`Class.snapshot() function, and when allocating
             * child widgets in `GtkWidget`Class.size_allocate().
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Returns the width that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a layout widget: a widget’s allocation
             * will be its “adjusted” allocation, that is, the widget’s parent
             * typically calls [method`Gtk`.Widget.size_allocate] with an allocation,
             * and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * [method`Gtk`.Widget.get_allocation] returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * [method`Gtk`.Widget.size_allocate] allocation, however.
             *
             * So a layout widget is guaranteed that its children stay inside
             * the assigned bounds, but not that they have exactly the bounds the
             * widget assigned.
             */
            get_allocation(): Gtk.Allocation;
            /**
             * Gets the first ancestor of the widget with type `widget_type`.
             *
             * For example, `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)`
             * gets the first `GtkBox` that’s an ancestor of `widget`. No
             * reference will be added to the returned widget; it should
             * not be unreferenced.
             *
             * Note that unlike [method`Gtk`.Widget.is_ancestor], this function
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget
             */
            get_ancestor(widget_type: GObject.GType): Gtk.Widget | null;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidgetClass.snapshot()` function, and when allocating
             * child widgets in `GtkWidgetClass.size_allocate()`.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_baseline(): number;
            /**
             * Determines whether the input focus can enter the widget or any
             * of its children.
             *
             * See [method`Gtk`.Widget.set_can_focus].
             * @returns true if the input focus can enter @widget
             */
            get_can_focus(): boolean;
            /**
             * Queries whether the widget can be the target of pointer events.
             * @returns true if @widget can receive pointer events
             */
            get_can_target(): boolean;
            /**
             * Gets the value set with [method`Gtk`.Widget.set_child_visible].
             *
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @returns true if the widget is mapped with the parent
             */
            get_child_visible(): boolean;
            /**
             * Gets the clipboard object for the widget.
             *
             * This is a utility function to get the clipboard object for the
             * display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_clipboard(): Gdk.Clipboard;
            /**
             * Gets the current foreground color for the widget’s style.
             *
             * This function should only be used in snapshot
             * implementations that need to do custom drawing
             * with the foreground color.
             */
            get_color(): Gdk.RGBA;
            /**
             * Returns the list of style classes applied to the widget.
             * @returns a `NULL`-terminated list of   css classes currently applied to @widget
             */
            get_css_classes(): string[];
            /**
             * Returns the CSS name of the widget.
             * @returns the CSS name
             */
            get_css_name(): string;
            /**
             * Gets the cursor set on the widget.
             *
             * See [method`Gtk`.Widget.set_cursor] for details.
             * @returns the cursor   that is set on @widget
             */
            get_cursor(): Gdk.Cursor | null;
            /**
             * Gets the reading direction for the widget.
             *
             * See [method`Gtk`.Widget.set_direction].
             * @returns the reading direction for the widget
             */
            get_direction(): Gtk.TextDirection;
            /**
             * Get the display for the window that the widget belongs to.
             *
             * This function can only be called after the widget has been
             * added to a widget hierarchy with a `GtkRoot` at the top.
             *
             * In general, you should only create display-specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the display for this widget
             */
            get_display(): Gdk.Display;
            /**
             * Returns the widget’s first child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's first child
             */
            get_first_child(): Gtk.Widget | null;
            /**
             * Returns the focus child of the widget.
             * @returns the current focus   child of @widget
             */
            get_focus_child(): Gtk.Widget | null;
            /**
             * Returns whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * See [method`Gtk`.Widget.set_focus_on_click].
             * @returns true if the widget should grab focus when it is   clicked with the mouse
             */
            get_focus_on_click(): boolean;
            /**
             * Determines whether the widget can own the input focus.
             *
             * See [method`Gtk`.Widget.set_focusable].
             * @returns true if @widget can own the input focus
             */
            get_focusable(): boolean;
            /**
             * Gets the font map of the widget.
             *
             * See [method`Gtk`.Widget.set_font_map].
             * @returns the font map of @widget
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the `cairo_font_options_t` of the widget.
             *
             * Seee [method`Gtk`.Widget.set_font_options].
             * @returns the `cairo_font_options_t` of widget
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget.
             *
             * The frame clock is a global “ticker” that can be used to drive
             * animations and repaints. The most common reason to get the frame
             * clock is to call [method`Gdk`.FrameClock.get_frame_time], in order
             * to get a time to use for animating. For example you might record
             * the start of the animation with an initial value from
             * [method`Gdk`.FrameClock.get_frame_time], and then update the animation
             * by calling [method`Gdk`.FrameClock.get_frame_time] again during each repaint.
             *
             * [method`Gdk`.FrameClock.request_phase] will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a widget,
             * you have to use [method`Gtk`.Widget.queue_draw] which invalidates the
             * widget (thus scheduling it to receive a draw on the next frame).
             * [method`Gtk`.Widget.queue_draw] will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is mapped.
             * Reparenting a widget (which implies a temporary unmap) can change
             * the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns the frame clock
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the horizontal alignment of the widget.
             *
             * For backwards compatibility reasons this method will never return
             * one of the baseline alignments, but instead it will convert it to
             * [enum`Gtk`.Align.fill] or [enum`Gtk`.Align.center].
             *
             * Baselines are not supported for horizontal alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Gtk.Align;
            /**
             * Returns the current value of the `has-tooltip` property.
             * @returns current value of `has-tooltip` on @widget
             */
            get_has_tooltip(): boolean;
            /**
             * Returns the content height of the widget.
             *
             * This function returns the height passed to its
             * size-allocate implementation, which is the height you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The height of @widget
             */
            get_height(): number;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Widgets with children should use [method`Gtk`.Widget.compute_expand]
             * rather than this function, to see whether any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether the `hexpand` flag has been explicitly set.
             *
             * If [property`Gtk`.Widget:hexpand] property is set, then it
             * overrides any computed expand value based on child widgets.
             * If `hexpand` is not set, then the expand value depends on
             * whether any children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Returns the widget’s last child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's last child
             */
            get_last_child(): Gtk.Widget | null;
            /**
             * Retrieves the layout manager of the widget.
             *
             * See [method`Gtk`.Widget.set_layout_manager].
             * @returns the layout manager of @widget
             */
            get_layout_manager(): Gtk.LayoutManager | null;
            /**
             * Gets the value of the [property`Gtk`.Widget:limit-events] property.
             */
            get_limit_events(): boolean;
            /**
             * Returns whether the widget is mapped.
             * @returns true if the widget is mapped
             */
            get_mapped(): boolean;
            /**
             * Gets the bottom margin of the widget.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the end margin of the widget.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the start margin of the widget.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the top margin of the widget.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Retrieves the name of a widget.
             *
             * See [method`Gtk`.Widget.set_name] for the significance of widget names.
             * @returns name of the widget
             */
            get_name(): string;
            /**
             * Returns the nearest `GtkNative` ancestor of the widget.
             *
             * This function will return `NULL` if the widget is not
             * contained inside a widget tree with a native ancestor.
             *
             * `GtkNative` widgets will return themselves here.
             * @returns the `GtkNative` ancestor of @widget
             */
            get_native(): Gtk.Native | null;
            /**
             * Returns the widget’s next sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's next sibling
             */
            get_next_sibling(): Gtk.Widget | null;
            /**
             * Fetches the requested opacity for the widget.
             *
             * See [method`Gtk`.Widget.set_opacity].
             * @returns the requested opacity for this widget
             */
            get_opacity(): number;
            /**
             * Returns the widget’s overflow value.
             * @returns The widget's overflow value
             */
            get_overflow(): Gtk.Overflow;
            /**
             * Gets a `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map, font description,
             * and base direction set.
             *
             * Unlike the context returned by [method`Gtk`.Widget.create_pango_context],
             * this context is owned by the widget (it can be used until the screen
             * for the widget changes or the widget is removed from its toplevel),
             * and will be updated to match any changes to the widget’s attributes.
             * This can be tracked by listening to changes of the
             * [property`Gtk`.Widget:root] property on the widget.
             * @returns the `PangoContext` for the widget
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent widget of the widget.
             * @returns the parent widget of @widget
             */
            get_parent(): Gtk.Widget | null;
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as `GtkFixed`.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since
             * the required height for the natural width is generally smaller than the
             * required height for the minimum width.
             *
             * Use [method`Gtk`.Widget.measure] if you want to support baseline alignment.
             */
            get_preferred_size(): [Gtk.Requisition | null, Gtk.Requisition | null];
            /**
             * Returns the widget’s previous sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's previous sibling
             */
            get_prev_sibling(): Gtk.Widget | null;
            /**
             * Gets the primary clipboard of the widget.
             *
             * This is a utility function to get the primary clipboard object
             * for the display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_primary_clipboard(): Gdk.Clipboard;
            /**
             * Determines whether the widget is realized.
             * @returns true if @widget is realized
             */
            get_realized(): boolean;
            /**
             * Determines whether the widget is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See [method`Gtk`.Widget.set_receives_default].
             * @returns true if @widget acts as the default widget when focused
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             * @returns The `GtkSizeRequestMode` preferred by @widget.
             */
            get_request_mode(): Gtk.SizeRequestMode;
            /**
             * Returns the `GtkRoot` widget of the widget.
             *
             * This function will return `NULL` if the widget is not contained
             * inside a widget tree with a root widget.
             *
             * `GtkRoot` widgets will return themselves here.
             * @returns the root widget of @widget
             */
            get_root(): Gtk.Root | null;
            /**
             * Retrieves the internal scale factor that maps from window
             * coordinates to the actual device pixels.
             *
             * On traditional systems this is 1, on high density outputs,
             * it can be a higher value (typically 2).
             *
             * See [method`Gdk`.Surface.get_scale_factor].
             *
             * Note that modern systems may support *fractional* scaling,
             * where the scale factor is not an integer. On such systems,
             * this function will return the next higher integer value,
             * but you probably want to use [method`Gdk`.Surface.get_scale]
             * to get the fractional scale value.
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Returns the widget’s sensitivity.
             *
             * This function returns the value that has been set using
             * [method`Gtk`.Widget.set_sensitive]).
             *
             * The effective sensitivity of a widget is however determined
             * by both its own and its parent widget’s sensitivity.
             * See [method`Gtk`.Widget.is_sensitive].
             * @returns true if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for the widget.
             *
             * Note that this function can only be called when the `GtkWidget`
             * is attached to a toplevel, since the settings object is specific
             * to a particular display. If you want to monitor the widget for
             * changes in its settings, connect to the `notify::display` signal.
             * @returns the relevant settings object
             */
            get_settings(): Gtk.Settings;
            /**
             * Returns the content width or height of the widget.
             *
             * Which dimension is returned depends on `orientation`.
             *
             * This is equivalent to calling [method`Gtk`.Widget.get_width]
             * for [enum`Gtk`.Orientation.horizontal] or [method`Gtk`.Widget.get_height]
             * for [enum`Gtk`.Orientation.vertical], but can be used when
             * writing orientation-independent code, such as when
             * implementing [iface`Gtk`.Orientable] widgets.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @param orientation the orientation to query
             * @returns the size of @widget in @orientation
             */
            get_size(orientation: Gtk.Orientation | null): number;
            /**
             * Gets the size request that was explicitly set for the widget.
             *
             * A value of -1 stored in `width` or `height` indicates that that
             * dimension has not been set explicitly and the natural requisition
             * of the widget will be used instead.
             *
             * See [method`Gtk`.Widget.set_size_request].
             *
             * To get the size a widget will actually request, call
             * [method`Gtk`.Widget.measure] instead of this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget state as a flag set.
             *
             * It is worth mentioning that the effective [flags`Gtk`.StateFlags.insensitive]
             * state will be returned, that is, also based on parent insensitivity,
             * even if `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * [flags`Gtk`.StateFlags] to pass to a [class`Gtk`.StyleContext]
             * method, you should look at [method`Gtk`.StyleContext.get_state].
             * @returns the state flags of widget
             */
            get_state_flags(): Gtk.StateFlags;
            /**
             * Returns the style context associated to the widget.
             *
             * The returned object is guaranteed to be the same
             * for the lifetime of `widget`.
             * @returns the widgets style context
             */
            get_style_context(): Gtk.StyleContext;
            /**
             * Fetches an object build from the template XML for `widget_type` in
             * the widget.
             *
             * This will only report children which were previously declared
             * with [method`Gtk`.WidgetClass.bind_template_child_full] or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private
             * to the `widget_type` which declared the child and is meant for language
             * bindings which cannot easily make use of the GObject structure offsets.
             * @param widget_type The `GType` to get a template child for
             * @param name ID of the child defined in the template XML
             * @returns the object built in the template XML with   the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the tooltip has not been set using
             * [method`Gtk`.Widget.set_tooltip_markup], this
             * function returns `NULL`.
             * @returns the tooltip text
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the `widget'`s tooltip was set using
             * [method`Gtk`.Widget.set_tooltip_markup],
             * this function will return the escaped text.
             * @returns the tooltip text
             */
            get_tooltip_text(): string | null;
            /**
             * Gets the vertical alignment of the widget.
             * @returns the vertical alignment of @widget
             */
            get_valign(): Gtk.Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.get_hexpand] for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether the `vexpand` flag has been explicitly set.
             *
             * See [method`Gtk`.Widget.get_hexpand_set] for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible.
             *
             * If you want to take into account whether the widget’s
             * parent is also marked as visible, use
             * [method`Gtk`.Widget.is_visible] instead.
             *
             * This function does not check if the widget is
             * obscured in any way.
             *
             * See [method`Gtk`.Widget.set_visible].
             * @returns true if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Returns the content width of the widget.
             *
             * This function returns the width passed to its
             * size-allocate implementation, which is the width you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The width of @widget
             */
            get_width(): number;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             * @returns true if focus is now inside @widget
             */
            grab_focus(): boolean;
            /**
             * Returns whether a style class is currently applied to the widget.
             * @param css_class style class, without the leading period
             * @returns true if @css_class is currently applied to @widget
             */
            has_css_class(css_class: string): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus.
             *
             * This is a convenience function that takes into account whether
             * focus indication should currently be shown in the toplevel window
             * of `widget`. See [method`Gtk`.Window.get_focus_visible] for more
             * information about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * [method`Gtk`.Widget.has_focus].
             * @returns true if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Returns whether the widget is currently being destroyed.
             *
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns true if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates.
             *
             * This function must be called in the instance initializer
             * for any class which assigned itself a template using
             * [method`Gtk`.WidgetClass.set_template].
             *
             * It is important to call this function in the instance initializer
             * of a widget subclass and not in `GObject.constructed()` or
             * `GObject.constructor()` for two reasons:
             *
             *  - derived widgets will assume that the composite widgets
             *    defined by its parent classes have been created in their
             *    relative instance initializers
             *  - when calling `g_object_new()` on a widget with composite templates,
             *    it’s important to build the composite widgets before the construct
             *    properties are set. Properties passed to `g_object_new()` should
             *    take precedence over properties set in the private template XML
             *
             * A good rule of thumb is to call this function as the first thing in
             * an instance initialization function.
             */
            init_template(): void;
            /**
             * Inserts an action group into the widget's actions.
             *
             * Children of `widget` that implement [iface`Gtk`.Actionable] can
             * then be associated with actions in `group` by setting their
             * “action-name” to `prefix`.`action-name`.
             *
             * Note that inheritance is defined for individual actions. I.e.
             * even if you insert a group with prefix `prefix,` actions with
             * the same prefix will still be inherited from the parent, unless
             * the group contains an action with the same name.
             *
             * If `group` is `NULL`, a previously inserted group for `name` is
             * removed from `widget`.
             * @param name the prefix for actions in @group
             * @param group an action group
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed after `previous_sibling,` or at the beginning if
             * `previous_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_prev_sibling (widget)`
             * will return `previous_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this
             * function can also be used to reorder `widget` in the child widget
             * list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param previous_sibling the new previous sibling of @widget
             */
            insert_after(parent: Gtk.Widget, previous_sibling?: Gtk.Widget | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed before `next_sibling,` or at the end if
             * `next_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_next_sibling (widget)`
             * will return `next_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this function
             * can also be used to reorder `widget` in the child widget list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param next_sibling the new next sibling of @widget
             */
            insert_before(parent: Gtk.Widget, next_sibling?: Gtk.Widget | null): void;
            /**
             * Determines whether the widget is a descendent of `ancestor`.
             * @param ancestor another `GtkWidget`
             * @returns true if @ancestor contains @widget as a child,   grandchild, great grandchild, etc
             */
            is_ancestor(ancestor: Gtk.Widget): boolean;
            /**
             * Determines whether the widget can be drawn to.
             *
             * A widget can be drawn if it is mapped and visible.
             * @returns true if @widget is drawable
             */
            is_drawable(): boolean;
            /**
             * Determines if the widget is the focus widget within its
             * toplevel.
             *
             * This does not mean that the [property`Gtk`.Widget:has-focus]
             * property is necessarily set; [property`Gtk`.Widget:has-focus]
             * will only be set if the toplevel widget additionally has the
             * global input focus.
             * @returns true if the widget is the focus widget
             */
            is_focus(): boolean;
            /**
             * Returns the widget’s effective sensitivity.
             *
             * This means it is sensitive itself and also its
             * parent widget is sensitive.
             * @returns true if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also [method`Gtk`.Widget.get_visible] and
             * [method`Gtk`.Widget.set_visible].
             * @returns true if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             * @returns true if stopping keyboard navigation is fine, false   if the emitting widget should try to handle the keyboard   navigation attempt in its parent widget
             */
            keynav_failed(direction: Gtk.DirectionType | null): boolean;
            /**
             * Returns the widgets for which this widget is the target of a
             * mnemonic.
             *
             * Typically, these widgets will be labels. See, for example,
             * [method`Gtk`.Label.set_mnemonic_widget].
             *
             * The widgets in the list are not individually referenced.
             * If you want to iterate through the list and perform actions
             * involving callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result, (GFunc)g_object_ref, NULL)`
             * first, and then unref all the widgets afterwards.
             * @returns the list   of mnemonic labels
             */
            list_mnemonic_labels(): Gtk.Widget[];
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            measure(orientation: Gtk.Orientation | null, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             * @returns true if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Returns a list model to track the children of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track children and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's children
             */
            observe_children(): Gio.ListModel;
            /**
             * Returns a list model to track the event controllers of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track controllers and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's controllers
             */
            observe_controllers(): Gio.ListModel;
            /**
             * Finds the descendant of the widget closest to a point.
             *
             * The point (x, y) must be given in widget coordinates, so (0, 0)
             * is assumed to be the top left of `widget'`s content area.
             *
             * Usually widgets will return `NULL` if the given coordinate is not
             * contained in `widget` checked via [method`Gtk`.Widget.contains].
             * Otherwise they will recursively try to find a child that does
             * not return `NULL`. Widgets are however free to customize their
             * picking algorithm.
             *
             * This function is used on the toplevel to determine the widget
             * below the mouse cursor for purposes of hover highlighting and
             * delivering events.
             * @param x x coordinate to test, relative to @widget's origin
             * @param y y coordinate to test, relative to @widget's origin
             * @param flags flags to influence what is picked
             * @returns the widget's descendant at (x, y)
             */
            pick(x: number, y: number, flags: Gtk.PickFlags | null): Gtk.Widget | null;
            /**
             * Flags the widget for a rerun of the [vfunc`Gtk`.Widget.size_allocate]
             * function.
             *
             * Use this function instead of [method`Gtk`.Widget.queue_resize]
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is [method`Gtk`.Widget.set_halign].
             *
             * This function is only for use in widget implementations.
             */
            queue_allocate(): void;
            /**
             * Schedules this widget to be redrawn.
             *
             * The redraw will happen in the paint phase
             * of the current or the next frame.
             *
             * This means `widget'`s [vfunc`Gtk`.Widget.snapshot]
             * implementation will be called.
             */
            queue_draw(): void;
            /**
             * Flags a widget to have its size renegotiated.
             *
             * This should be called when a widget for some reason has a new
             * size request. For example, when you change the text in a
             * [class`Gtk`.Label], the label queues a resize to ensure there’s
             * enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the [vfunc`Gtk`.Widget.size_allocate]
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * [vfunc`Gtk`.Widget.size_allocate] will be silently ignored.
             *
             * This function is only for use in widget implementations.
             */
            queue_resize(): void;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            realize(): void;
            /**
             * Removes an event controller from the widget.
             *
             * The removed event controller will not receive any more events,
             * and should not be used again.
             *
             * Widgets will remove all event controllers automatically when they
             * are destroyed, there is normally no need to call this function.
             * @param controller an event controller
             */
            remove_controller(controller: Gtk.EventController): void;
            /**
             * Removes a style from the widget.
             *
             * After this, the style of `widget` will stop matching for `css_class`.
             * @param css_class style class to remove from @widget, without the leading period
             */
            remove_css_class(css_class: string): void;
            /**
             * Removes a widget from the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * The widget must have previously been added to the list with
             * [method`Gtk`.Widget.add_mnemonic_label].
             * @param label a widget that is a mnemonic label for @widget
             */
            remove_mnemonic_label(label: Gtk.Widget): void;
            /**
             * Removes a tick callback previously registered with
             * [method`Gtk`.Widget.add_tick_callback].
             * @param id an ID returned by [method@Gtk.Widget.add_tick_callback]
             */
            remove_tick_callback(id: number): void;
            /**
             * Sets whether the input focus can enter the widget or
             * any of its children.
             *
             * Applications should set `can_focus` to false to mark a
             * widget as for pointer/touch use only.
             *
             * Note that having `can_focus` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and focusable and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param can_focus whether the input focus can enter   the widget or any of its children
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether the widget can be the target of pointer events.
             * @param can_target whether this widget should be able to   receive pointer events
             */
            set_can_target(can_target: boolean): void;
            /**
             * Sets whether the widget should be mapped along with its parent.
             *
             * The child visibility can be set for widget before it is added
             * to a container with [method`Gtk`.Widget.set_parent], to avoid
             * mapping children unnecessary before immediately unmapping them.
             * However it will be reset to its default state of true when the
             * widget is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @param child_visible whether @widget should be mapped along   with its parent
             */
            set_child_visible(child_visible: boolean): void;
            /**
             * Replaces the current style classes of the widget with `classes`.
             * @param classes `NULL`-terminated list of style classes
             */
            set_css_classes(classes: string[]): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * If the `cursor` is `NULL`, `widget` will use the cursor
             * inherited from its parent.
             * @param cursor the new cursor
             */
            set_cursor(cursor?: Gdk.Cursor | null): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * This is a utility function that creates a cursor via
             * [ctor`Gdk`.Cursor.new_from_name] and then sets it on `widget`
             * with [method`Gtk`.Widget.set_cursor]. See those functions for
             * details.
             *
             * On top of that, this function allows `name` to be `NULL`, which
             * will do the same as calling [method`Gtk`.Widget.set_cursor]
             * with a `NULL` cursor.
             * @param name the name of the cursor
             */
            set_cursor_from_name(name?: string | null): void;
            /**
             * Sets the reading direction on the widget.
             *
             * This direction controls the primary direction for widgets
             * containing text, and also the direction in which the children
             * of a container are packed. The ability to set the direction is
             * present in order so that correct localization into languages with
             * right-to-left reading directions can be done.
             *
             * Generally, applications will let the default reading direction
             * prevail, except for widgets where the children are arranged in
             * an order that is explicitly visual rather than logical (such as
             * buttons for text justification).
             *
             * If the direction is set to [enum`Gtk`.TextDirection.none], then
             * the value set by [func`Gtk`.Widget.set_default_direction] will be used.
             * @param dir the new direction
             */
            set_direction(dir: Gtk.TextDirection | null): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            set_focus_child(child?: Gtk.Widget | null): void;
            /**
             * Sets whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * Making mouse clicks not grab focus is useful in places like
             * toolbars where you don’t want the keyboard focus removed from
             * the main area of the application.
             * @param focus_on_click whether the widget should grab focus when clicked   with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets whether the widget can own the input focus.
             *
             * Widget implementations should set `focusable` to true in
             * their init() function if they want to receive keyboard input.
             *
             * Note that having `focusable` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and can-focus and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param focusable whether or not @widget can own the input focus
             */
            set_focusable(focusable: boolean): void;
            /**
             * Sets the font map to use for text rendering in the widget.
             *
             * The font map is the object that is used to look up fonts.
             * Setting a custom font map can be useful in special situations,
             * e.g. when you need to add application-specific fonts to the set
             * of available fonts.
             *
             * When not set, the widget will inherit the font map from its parent.
             * @param font_map a `PangoFontMap`
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the `cairo_font_options_t` used for text rendering
             * in the widget.
             *
             * When not set, the default font options for the `GdkDisplay`
             * will be used.
             * @param options a `cairo_font_options_t` struct   to unset any previously set default font options
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of the widget.
             * @param align the horizontal alignment
             */
            set_halign(align: Gtk.Align | null): void;
            /**
             * Sets the `has-tooltip` property on the widget.
             * @param has_tooltip whether or not @widget has a tooltip
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call [method`Gtk`.Widget.compute_expand].
             * A widget can decide how the expandability of children affects its
             * own expansion by overriding the `compute_expand` virtual method on
             * `GtkWidget`.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children. The override occurs because
             * [method`Gtk`.Widget.set_hexpand] sets the hexpand-set property (see
             * [method`Gtk`.Widget.set_hexpand_set]) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag will be used.
             *
             * The [property`Gtk`.Widget:hexpand-set] property will be set
             * automatically when you call [method`Gtk`.Widget.set_hexpand]
             * to set hexpand, so the most likely reason to use this function
             * would be to unset an explicit expand flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Sets the layout manager to use for measuring and allocating children
             * of the widget.
             * @param layout_manager a layout manager
             */
            set_layout_manager(layout_manager?: Gtk.LayoutManager | null): void;
            /**
             * Sets whether the widget acts like a modal dialog,
             * with respect to event delivery.
             * @param limit_events whether to limit events
             */
            set_limit_events(limit_events: boolean): void;
            /**
             * Sets the bottom margin of the widget.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of the widget.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the start margin of the widget.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of the widget.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Sets a widgets name.
             *
             * Setting a name allows you to refer to the widget from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for [class`Gtk`.StyleContext].
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Requests the widget to be rendered partially transparent.
             *
             * An opacity of 0 is fully transparent and an opacity of 1
             * is fully opaque.
             *
             * Opacity works on both toplevel widgets and child widgets, although
             * there are some limitations: For toplevel widgets, applying opacity
             * depends on the capabilities of the windowing system. On X11, this
             * has any effect only on X displays with a compositing manager, see
             * [method`Gdk`.Display.is_composited]. On Windows and Wayland it will
             * always work, although setting a window’s opacity after the window
             * has been shown may cause some flicker.
             *
             * Note that the opacity is inherited through inclusion — if you set
             * a toplevel to be partially translucent, all of its content will
             * appear translucent, since it is ultimatively rendered on that
             * toplevel. The opacity value itself is not inherited by child
             * widgets (since that would make widgets deeper in the hierarchy
             * progressively more translucent). As a consequence, [class`Gtk`.Popover]
             * instances and other [iface`Gtk`.Native] widgets with their own surface
             * will use their own opacity value, and thus by default appear
             * non-translucent, even if they are attached to a toplevel that
             * is translucent.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * Sets how the widget treats content that is drawn outside the
             * it's content area.
             *
             * See the definition of [enum`Gtk`.Overflow] for details.
             *
             * This setting is provided for widget implementations and
             * should not be used by application code.
             *
             * The default value is [enum`Gtk`.Overflow.visible].
             * @param overflow desired overflow value
             */
            set_overflow(overflow: Gtk.Overflow | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * This takes care of details such as updating the state and style
             * of the child to reflect its new location and resizing the parent.
             * The opposite function is [method`Gtk`.Widget.unparent].
             *
             * This function is useful only when implementing subclasses of
             * `GtkWidget`.
             * @param parent parent widget
             */
            set_parent(parent: Gtk.Widget): void;
            /**
             * Sets whether the widget will be treated as the default
             * widget within its toplevel when it has the focus, even if
             * another widget is the default.
             * @param receives_default whether or not @widget can be a default widget
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets the sensitivity of the widget.
             *
             * A widget is sensitive if the user can interact with it.
             * Insensitive widgets are “grayed out” and the user can’t
             * interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive true to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of the widget.
             *
             * That is, the widget’s size request will be at least `width`
             * by `height`. You can use this function to force a widget to
             * be larger than it normally would be.
             *
             * In most cases, [method`Gtk`.Window.set_default_size] is a better
             * choice for toplevel windows than this function; setting the default
             * size will still allow users to shrink the window. Setting the size
             * request will force them to leave the window at least as large as
             * the size request.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it is
             * basically impossible to hardcode a size that will always work.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * properties
             * [property`Gtk`.Widget:margin-start],
             * [property`Gtk`.Widget:margin-end],
             * [property`Gtk`.Widget:margin-top], and
             * [property`Gtk`.Widget:margin-bottom], but it does include pretty
             * much all other padding or border properties set by any subclass
             * of `GtkWidget`.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * Turns on flag values in the current widget state.
             *
             * Typical widget states are insensitive, prelighted, etc.
             *
             * This function accepts the values [flags`Gtk`.StateFlags.dir-ltr] and
             * [flags`Gtk`.StateFlags.dir-rtl] but ignores them. If you want to set
             * the widget's direction, use [method`Gtk`.Widget.set_direction].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn on
             * @param clear whether to clear state before turning on @flags
             */
            set_state_flags(flags: Gtk.StateFlags | null, clear: boolean): void;
            /**
             * Sets the contents of the tooltip for widget.
             *
             * `markup` must contain Pango markup.
             *
             * This function will take care of setting the
             * [property`Gtk`.Widget:has-tooltip] as a side effect, and of the
             * default handler for the [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_markup].
             * @param markup the contents of the tooltip for @widget
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets the contents of the tooltip for the widget.
             *
             * If `text` contains any markup, it will be escaped.
             *
             * This function will take care of setting
             * [property`Gtk`.Widget:has-tooltip] as a side effect,
             * and of the default handler for the
             * [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_text].
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Sets the vertical alignment of the widget.
             * @param align the vertical alignment
             */
            set_valign(align: Gtk.Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.set_hexpand] for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag will be used.
             *
             * See [method`Gtk`.Widget.set_hexpand_set] for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`.
             *
             * Note that setting this to true doesn’t mean the widget is
             * actually viewable, see [method`Gtk`.Widget.get_visible].
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Returns whether the widget should contribute to
             * the measuring and allocation of its parent.
             *
             * This is false for invisible children, but also
             * for children that have their own surface, such
             * as [class`Gtk`.Popover] instances.
             * @returns true if child should be included in   measuring and allocating
             */
            should_layout(): boolean;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            show(): void;
            /**
             * Allocates widget with a transformation that translates
             * the origin to the position in `allocation`.
             *
             * This is a simple form of [method`Gtk`.Widget.allocate].
             * @param allocation position and size to be allocated to @widget
             * @param baseline the baseline of the child, or -1
             */
            size_allocate(allocation: Gtk.Allocation, baseline: number): void;
            /**
             * Snapshots a child of the widget.
             *
             * When a widget receives a call to the snapshot function,
             * it must send synthetic [vfunc`Gtk`.Widget.snapshot] calls
             * to all children. This function provides a convenient way
             * of doing this. A widget, when it receives a call to its
             * [vfunc`Gtk`.Widget.snapshot] function, calls
             * gtk_widget_snapshot_child() once for each child, passing in
             * the `snapshot` the widget received.
             *
             * This function takes care of translating the origin of `snapshot,`
             * and deciding whether the child needs to be snapshot.
             *
             * It does nothing for children that implement `GtkNative`.
             * @param child a child of @widget
             * @param snapshot snapshot as passed to the widget. In particular, no   calls to [method@Gtk.Snapshot.translate] or other transform calls   should have been made
             */
            snapshot_child(child: Gtk.Widget, snapshot: Gtk.Snapshot): void;
            /**
             * Translates coordinates relative to `src_widget’`s allocation
             * to coordinates relative to `dest_widget’`s allocations.
             *
             * In order to perform this operation, both widget must share
             * a common ancestor. If that is not the case, `dest_x` and `dest_y`
             * are set to 0 and false is returned.
             * @param dest_widget another widget
             * @param src_x X position in widget coordinates of @src_widget
             * @param src_y Y position in widget coordinates of @src_widget
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            translate_coordinates(dest_widget: Gtk.Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display of the widget.
             */
            trigger_tooltip_query(): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            unmap(): void;
            /**
             * Removes `widget` from its parent.
             *
             * This function is only for use in widget implementations,
             * typically in dispose.
             */
            unparent(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            unrealize(): void;
            /**
             * Turns off flag values for the current widget state.
             *
             * See [method`Gtk`.Widget.set_state_flags].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn off
             */
            unset_state_flags(flags: Gtk.StateFlags | null): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             */
            vfunc_contains(x: number, y: number): boolean;
            /**
             * Vfunc called when the CSS used by widget was changed. Widgets
             *   should then discard their caches that depend on CSS and queue resizes or
             *   redraws accordingly. The default implementation will take care of this for
             *   all the default CSS properties, so implementations must chain up.
             * @param change
             */
            vfunc_css_changed(change: Gtk.CssStyleChange): void;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: Gtk.TextDirection): void;
            /**
             * Vfunc for gtk_widget_child_focus()
             * @param direction
             */
            vfunc_focus(direction: Gtk.DirectionType): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             */
            vfunc_get_request_mode(): Gtk.SizeRequestMode;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             */
            vfunc_grab_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: Gtk.DirectionType): boolean;
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            vfunc_measure(orientation: Gtk.Orientation, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: Gtk.DirectionType): void;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Gtk.Tooltip): boolean;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            vfunc_realize(): void;
            /**
             * Called when the widget gets added to a `GtkRoot` widget. Must
             *   chain up
             */
            vfunc_root(): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            vfunc_set_focus_child(child?: Gtk.Widget | null): void;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Called to set the allocation, if the widget does
             *   not have a layout manager.
             * @param width
             * @param height
             * @param baseline
             */
            vfunc_size_allocate(width: number, height: number, baseline: number): void;
            /**
             * Vfunc called when a new snapshot of the widget has to be taken.
             * @param snapshot
             */
            vfunc_snapshot(snapshot: Gtk.Snapshot): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: Gtk.StateFlags): void;
            /**
             * Emitted when a system setting was changed. Must chain up.
             * @param settings
             */
            vfunc_system_setting_changed(settings: Gtk.SystemSetting): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_unmap(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            vfunc_unrealize(): void;
            /**
             * Called when the widget is about to be removed from its
             *   `GtkRoot` widget. Must chain up
             */
            vfunc_unroot(): void;
        }

        namespace ActionRow {
            // Signal callback interfaces

            interface Activated {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends PreferencesRow.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Actionable.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps {
                activatable_widget: Gtk.Widget;
                activatableWidget: Gtk.Widget;
                icon_name: string;
                iconName: string;
                subtitle: string;
                subtitle_lines: number;
                subtitleLines: number;
                subtitle_selectable: boolean;
                subtitleSelectable: boolean;
                title_lines: number;
                titleLines: number;
            }
        }

        /**
         * A [class`Gtk`.ListBoxRow] used to present actions.
         *
         * <picture>
         *   <source srcset="action-row-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="action-row.png" alt="action-row">
         * </picture>
         *
         * The `AdwActionRow` widget can have a title, a subtitle and an icon. The row
         * can receive additional widgets at its end, or prefix widgets at its start.
         *
         * It is convenient to present a preference and its related actions.
         *
         * `AdwActionRow` is unactivatable by default, giving it an activatable widget
         * will automatically make it activatable, but unsetting it won't change the
         * row's activatability.
         *
         * ## AdwActionRow as GtkBuildable
         *
         * The `AdwActionRow` implementation of the [iface`Gtk`.Buildable] interface
         * supports adding a child at its end by specifying “suffix” or omitting the
         * “type” attribute of a <child> element.
         *
         * It also supports adding a child as a prefix widget by specifying “prefix” as
         * the “type” attribute of a <child> element.
         *
         * ## CSS nodes
         *
         * `AdwActionRow` has a main CSS node with name `row`.
         *
         * It contains the subnode `box.header` for its main horizontal box, and
         * `box.title` for the vertical box containing the title and subtitle labels.
         *
         * It contains subnodes `label.title` and `label.subtitle` representing
         * respectively the title label and subtitle label.
         *
         * ## Style classes
         *
         * `AdwActionRow` can use the [`.property`](style-classes.html#property-rows)
         * style class to emphasize the row subtitle instead of the row title, which is
         * useful for displaying read-only properties.
         *
         * <picture>
         *   <source srcset="property-row-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="property-row.png" alt="property-row">
         * </picture>
         *
         * When used together with the `.monospace` style class, only the subtitle
         * becomes monospace, not the title or any extra widgets.
         */
        class ActionRow
            extends PreferencesRow
            implements Gtk.Accessible, Gtk.Actionable, Gtk.Buildable, Gtk.ConstraintTarget
        {
            static $gtype: GObject.GType<ActionRow>;

            // Properties

            /**
             * The widget to activate when the row is activated.
             *
             * The row can be activated either by clicking on it, calling
             * [method`ActionRow`.activate], or via mnemonics in the title.
             * See the [property`PreferencesRow:`use-underline] property to enable
             * mnemonics.
             *
             * The target widget will be activated by emitting the
             * [signal`Gtk`.Widget::mnemonic-activate] signal on it.
             */
            get activatable_widget(): Gtk.Widget;
            set activatable_widget(val: Gtk.Widget);
            /**
             * The widget to activate when the row is activated.
             *
             * The row can be activated either by clicking on it, calling
             * [method`ActionRow`.activate], or via mnemonics in the title.
             * See the [property`PreferencesRow:`use-underline] property to enable
             * mnemonics.
             *
             * The target widget will be activated by emitting the
             * [signal`Gtk`.Widget::mnemonic-activate] signal on it.
             */
            get activatableWidget(): Gtk.Widget;
            set activatableWidget(val: Gtk.Widget);
            /**
             * The icon name for this row.
             */
            get icon_name(): string;
            set icon_name(val: string);
            /**
             * The icon name for this row.
             */
            get iconName(): string;
            set iconName(val: string);
            /**
             * The subtitle for this row.
             *
             * The subtitle is interpreted as Pango markup unless
             * [property`PreferencesRow:`use-markup] is set to `FALSE`.
             */
            get subtitle(): string;
            set subtitle(val: string);
            /**
             * The number of lines at the end of which the subtitle label will be
             * ellipsized.
             *
             * If the value is 0, the number of lines won't be limited.
             */
            get subtitle_lines(): number;
            set subtitle_lines(val: number);
            /**
             * The number of lines at the end of which the subtitle label will be
             * ellipsized.
             *
             * If the value is 0, the number of lines won't be limited.
             */
            get subtitleLines(): number;
            set subtitleLines(val: number);
            /**
             * Whether the user can copy the subtitle from the label.
             *
             * See also [property`Gtk`.Label:selectable].
             */
            get subtitle_selectable(): boolean;
            set subtitle_selectable(val: boolean);
            /**
             * Whether the user can copy the subtitle from the label.
             *
             * See also [property`Gtk`.Label:selectable].
             */
            get subtitleSelectable(): boolean;
            set subtitleSelectable(val: boolean);
            /**
             * The number of lines at the end of which the title label will be ellipsized.
             *
             * If the value is 0, the number of lines won't be limited.
             */
            get title_lines(): number;
            set title_lines(val: number);
            /**
             * The number of lines at the end of which the title label will be ellipsized.
             *
             * If the value is 0, the number of lines won't be limited.
             */
            get titleLines(): number;
            set titleLines(val: number);

            // Constructors

            constructor(properties?: Partial<ActionRow.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): ActionRow;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'activated', callback: (_source: this) => void): number;
            connect_after(signal: 'activated', callback: (_source: this) => void): number;
            emit(signal: 'activated'): void;

            // Virtual methods

            /**
             * Activates `self`.
             */
            vfunc_activate(): void;

            // Methods

            /**
             * Activates `self`.
             */
            activate(): void;
            // Conflicted with Gtk.Widget.activate
            activate(...args: never[]): any;
            /**
             * Adds a prefix widget to `self`.
             * @param widget a widget
             */
            add_prefix(widget: Gtk.Widget): void;
            /**
             * Adds a suffix widget to `self`.
             * @param widget a widget
             */
            add_suffix(widget: Gtk.Widget): void;
            /**
             * Gets the widget activated when `self` is activated.
             * @returns the activatable widget for @self
             */
            get_activatable_widget(): Gtk.Widget | null;
            /**
             * Gets the icon name for `self`.
             * @returns the icon name for @self
             */
            get_icon_name(): string | null;
            /**
             * Gets the subtitle for `self`.
             * @returns the subtitle for @self
             */
            get_subtitle(): string | null;
            /**
             * Gets the number of lines at the end of which the subtitle label will be
             * ellipsized.
             * @returns the number of lines at the end of which the subtitle label will be   ellipsized
             */
            get_subtitle_lines(): number;
            /**
             * Gets whether the user can copy the subtitle from the label
             * @returns whether the user can copy the subtitle from the label
             */
            get_subtitle_selectable(): boolean;
            /**
             * Gets the number of lines at the end of which the title label will be
             * ellipsized.
             * @returns the number of lines at the end of which the title label will be   ellipsized
             */
            get_title_lines(): number;
            /**
             * Removes a child from `self`.
             * @param widget the child to be removed
             */
            remove(widget: Gtk.Widget): void;
            /**
             * Sets the widget to activate when `self` is activated.
             *
             * The row can be activated either by clicking on it, calling
             * [method`ActionRow`.activate], or via mnemonics in the title.
             * See the [property`PreferencesRow:`use-underline] property to enable mnemonics.
             *
             * The target widget will be activated by emitting the
             * [signal`Gtk`.Widget::mnemonic-activate] signal on it.
             * @param widget the target widget
             */
            set_activatable_widget(widget?: Gtk.Widget | null): void;
            /**
             * Sets the icon name for `self`.
             * @param icon_name the icon name
             */
            set_icon_name(icon_name?: string | null): void;
            /**
             * Sets the subtitle for `self`.
             *
             * The subtitle is interpreted as Pango markup unless
             * [property`PreferencesRow:`use-markup] is set to `FALSE`.
             * @param subtitle the subtitle
             */
            set_subtitle(subtitle: string): void;
            /**
             * Sets the number of lines at the end of which the subtitle label will be
             * ellipsized.
             *
             * If the value is 0, the number of lines won't be limited.
             * @param subtitle_lines the number of lines at the end of which the subtitle label will be ellipsized
             */
            set_subtitle_lines(subtitle_lines: number): void;
            /**
             * Sets whether the user can copy the subtitle from the label
             *
             * See also [property`Gtk`.Label:selectable].
             * @param subtitle_selectable `TRUE` if the user can copy the subtitle from the label
             */
            set_subtitle_selectable(subtitle_selectable: boolean): void;
            /**
             * Sets the number of lines at the end of which the title label will be
             * ellipsized.
             *
             * If the value is 0, the number of lines won't be limited.
             * @param title_lines the number of lines at the end of which the title label will be ellipsized
             */
            set_title_lines(title_lines: number): void;

            // Inherited properties
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get can_focus(): boolean;
            set can_focus(val: boolean);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get canFocus(): boolean;
            set canFocus(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get can_target(): boolean;
            set can_target(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get canTarget(): boolean;
            set canTarget(val: boolean);
            /**
             * A list of css classes applied to this widget.
             */
            get css_classes(): string[];
            set css_classes(val: string[]);
            /**
             * A list of css classes applied to this widget.
             */
            get cssClasses(): string[];
            set cssClasses(val: string[]);
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get css_name(): string;
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get cssName(): string;
            /**
             * The cursor used by `widget`.
             */
            get cursor(): Gdk.Cursor;
            set cursor(val: Gdk.Cursor);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * Whether this widget itself will accept the input focus.
             */
            get focusable(): boolean;
            set focusable(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space.
             */
            get halign(): Gtk.Align;
            set halign(val: Gtk.Align);
            /**
             * Whether the widget is the default widget.
             */
            get has_default(): boolean;
            /**
             * Whether the widget is the default widget.
             */
            get hasDefault(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get has_focus(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get hasFocus(): boolean;
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get height_request(): number;
            set height_request(val: number);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally.
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layout_manager(): Gtk.LayoutManager;
            set layout_manager(val: Gtk.LayoutManager);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layoutManager(): Gtk.LayoutManager;
            set layoutManager(val: Gtk.LayoutManager);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limit_events(): boolean;
            set limit_events(val: boolean);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limitEvents(): boolean;
            set limitEvents(val: boolean);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            /**
             * The name of the widget.
             */
            get name(): string;
            set name(val: string);
            /**
             * The requested opacity of the widget.
             */
            get opacity(): number;
            set opacity(val: number);
            /**
             * How content outside the widget's content area is treated.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get overflow(): Gtk.Overflow;
            set overflow(val: Gtk.Overflow);
            /**
             * The parent widget of this widget.
             */
            get parent(): Gtk.Widget;
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receives_default(): boolean;
            set receives_default(val: boolean);
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The `GtkRoot` widget of the widget tree containing this widget.
             *
             * This will be `NULL` if the widget is not contained in a root widget.
             */
            get root(): Gtk.Root;
            /**
             * The scale factor of the widget.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget.
             */
            get scaleFactor(): number;
            /**
             * Whether the widget responds to input.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space.
             */
            get valign(): Gtk.Align;
            set valign(val: Gtk.Align);
            /**
             * Whether to expand vertically.
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            /**
             * Whether the widget is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get width_request(): number;
            set width_request(val: number);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get widthRequest(): number;
            set widthRequest(val: number);

            // Inherited methods
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * Enables or disables an action installed with
             * [method`Gtk`.WidgetClass.install_action].
             * @param action_name action name, such as "clipboard.paste"
             * @param enabled whether the action is now enabled
             */
            action_set_enabled(action_name: string, enabled: boolean): void;
            /**
             * Activates an action for the widget.
             *
             * The action is looked up in the action groups associated with
             * `widget` and its ancestors.
             *
             * If the action is in an action group added with
             * [method`Gtk`.Widget.insert_action_group], the `name` is expected
             * to be prefixed with the prefix that was used when the group was
             * inserted.
             *
             * The arguments must match the actions expected parameter type,
             * as returned by [method`Gio`.Action.get_parameter_type].
             * @param name the name of the action to activate
             * @param args parameters to use
             * @returns true if the action was activated
             */
            activate_action(name: string, args?: GLib.Variant | null): boolean;
            /**
             * Activates the `default.activate` action for the widget.
             *
             * The action is looked up in the same was as for
             * [method`Gtk`.Widget.activate_action].
             */
            activate_default(): void;
            /**
             * Adds an event controller to the widget.
             *
             * The event controllers of a widget handle the events that are
             * propagated to the widget.
             *
             * You will usually want to call this function right after
             * creating any kind of [class`Gtk`.EventController].
             * @param controller an event controller that hasn't been   added to a widget yet
             */
            add_controller(controller: Gtk.EventController): void;
            /**
             * Adds a style class to the widget.
             *
             * After calling this function, the widget’s style will match
             * for `css_class,` according to CSS matching rules.
             *
             * Use [method`Gtk`.Widget.remove_css_class] to remove the
             * style again.
             * @param css_class style class to add to @widget, without the leading period
             */
            add_css_class(css_class: string): void;
            /**
             * Adds a widget to the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * Note that the list of mnemonic labels for the widget is cleared
             * when the widget is destroyed, so the caller must make sure
             * to update its internal state at this point as well.
             * @param label a widget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Gtk.Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame.
             *
             * Until the tick callback is removed, it will be called frequently
             * (usually at the frame rate of the output device or as quickly as
             * the application can be repainted, whichever is slower). For this
             * reason, is most suitable for handling graphics that change every
             * frame or every few frames.
             *
             * The tick callback does not automatically imply a relayout or repaint.
             * If you want a repaint or relayout, and aren’t changing widget properties
             * that would trigger that (for example, changing the text of a label),
             * then you will have to call [method`Gtk`.Widget.queue_resize] or
             * [method`Gtk`.Widget.queue_draw] yourself.
             *
             * [method`Gdk`.FrameClock.get_frame_time] should generally be used
             * for timing continuous animations and
             * [method`Gdk`.FrameTimings.get_predicted_presentation_time] should be
             * used if you are trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * [signal`Gdk`.FrameClock::update] signal of the frame clock, since you
             * don't have to worry about when a frame clock is assigned to a widget.
             *
             * To remove a tick callback, pass the ID that is returned by this function
             * to [method`Gtk`.Widget.remove_tick_callback].
             * @param callback function   to call for updating animations
             * @returns an ID for this callback
             */
            add_tick_callback(callback: Gtk.TickCallback): number;
            /**
             * Assigns size, position, (optionally) a baseline and transform
             * to a child widget.
             *
             * In this function, the allocation and baseline may be adjusted.
             * The given allocation will be forced to be bigger than the
             * widget's minimum size, as well as at least 0×0 in size.
             *
             * This function is only used by widget implementations.
             *
             * For a version that does not take a transform, see
             * [method`Gtk`.Widget.size_allocate].
             * @param width new width
             * @param height new height
             * @param baseline new baseline, or -1
             * @param transform transformation to be applied
             */
            allocate(width: number, height: number, baseline: number, transform?: Gsk.Transform | null): void;
            /**
             * Called by widgets as the user moves around the window using
             * keyboard shortcuts.
             *
             * The `direction` argument indicates what kind of motion is taking
             * place (up, down, left, right, tab forward, tab backward).
             *
             * This function calls the [vfunc`Gtk`.Widget.focus] virtual function;
             * widgets can override the virtual function in order to implement
             * appropriate focus behavior.
             *
             * The default `focus()` virtual function for a widget should return
             * true if moving in `direction` left the focus on a focusable location
             * inside that widget, and false if moving in `direction` moved the focus
             * outside the widget. When returning true, widgets normally call
             * [method`Gtk`.Widget.grab_focus] to place the focus accordingly;
             * when returning false, they don’t modify the current focus location.
             *
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use [method`Gtk`.Widget.grab_focus] to move
             * the focus to a particular widget.
             * @param direction direction of focus movement
             * @returns true if focus ended up inside @widget
             */
            child_focus(direction: Gtk.DirectionType | null): boolean;
            /**
             * Computes the bounds for `widget` in the coordinate space of `target`.
             *
             * The bounds of widget are (the bounding box of) the region that it is
             * expected to draw in. See the [coordinate system](coordinates.html)
             * overview to learn more.
             *
             * If the operation is successful, true is returned. If `widget` has no
             * bounds or the bounds cannot be expressed in `target'`s coordinate space
             * (for example if both widgets are in different windows), false is
             * returned and `bounds` is set to the zero rectangle.
             *
             * It is valid for `widget` and `target` to be the same widget.
             * @param target the target widget
             * @returns true if the bounds could be computed
             */
            compute_bounds(target: Gtk.Widget): [boolean, Graphene.Rect];
            /**
             * Computes whether a parent widget should give this widget
             * extra space when possible.
             *
             * Widgets with children should check this, rather than looking at
             * [method`Gtk`.Widget.get_hexpand] or [method`Gtk`.Widget.get_vexpand].
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Gtk.Orientation | null): boolean;
            /**
             * Translates the given `point` in `widget'`s coordinates to coordinates
             * in `target’`s coordinate system.
             *
             * In order to perform this operation, both widgets must share a
             * a common ancestor. If that is not the case, `out_point` is set
             * to (0, 0) and false is returned.
             * @param target the widget to transform into
             * @param point a point in @widget's coordinate system
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            compute_point(target: Gtk.Widget, point: Graphene.Point): [boolean, Graphene.Point];
            /**
             * Computes a matrix suitable to describe a transformation from
             * `widget'`s coordinate system into `target'`s coordinate system.
             *
             * The transform can not be computed in certain cases, for example
             * when `widget` and `target` do not share a common ancestor. In that
             * case `out_transform` gets set to the identity matrix.
             *
             * To learn more about widget coordinate systems, see the coordinate
             * system [overview](coordinates.html).
             * @param target the target widget that the matrix will transform to
             * @returns true if the transform could be computed
             */
            compute_transform(target: Gtk.Widget): [boolean, Graphene.Matrix];
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             * @returns true if @widget contains the point (x, y)
             */
            contains(x: number, y: number): boolean;
            /**
             * Creates a new `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map,
             * font options, font description, and base direction set.
             *
             * See also [method`Gtk`.Widget.get_pango_context].
             * @returns the new `PangoContext`
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new `PangoLayout` that is configured for the widget.
             *
             * The `PangoLayout` will have the appropriate font map,
             * font description, and base direction set.
             *
             * If you keep a `PangoLayout` created in this way around,
             * you need to re-create it when the widgets `PangoContext`
             * is replaced. This can be tracked by listening to changes
             * of the [property`Gtk`.Widget:root] property on the widget.
             * @param text text to set on the layout
             * @returns the new `PangoLayout`
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Clears the template children for the widget.
             *
             * This function is the opposite of [method`Gtk`.Widget.init_template],
             * and it is used to clear all the template children from a widget
             * instance. If you bound a template child to a field in the instance
             * structure, or in the instance private data structure, the field will
             * be set to `NULL` after this function returns.
             *
             * You should call this function inside the `GObjectClass.dispose()`
             * implementation of any widget that called [method`Gtk`.Widget.init_template].
             * Typically, you will want to call this function last, right before
             * chaining up to the parent type's dispose implementation, e.g.
             *
             * ```c
             * static void
             * some_widget_dispose (GObject *gobject)
             * {
             *   SomeWidget *self = SOME_WIDGET (gobject);
             *
             *   // Clear the template data for SomeWidget
             *   gtk_widget_dispose_template (GTK_WIDGET (self), SOME_TYPE_WIDGET);
             *
             *   G_OBJECT_CLASS (some_widget_parent_class)->dispose (gobject);
             * }
             * ```
             * @param widget_type the type of the widget to finalize the template for
             */
            dispose_template(widget_type: GObject.GType): void;
            /**
             * Checks to see if a drag movement has passed the GTK drag threshold.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns true if the drag threshold has been passed
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Notifies the user about an input-related error on the widget.
             *
             * If the [property`Gtk`.Settings:gtk-error-bell] setting is true,
             * it calls [method`Gdk`.Surface.beep], otherwise it does nothing.
             *
             * Note that the effect of [method`Gdk`.Surface.beep] can be configured
             * in many ways, depending on the windowing backend and the desktop
             * environment or window manager that is used.
             */
            error_bell(): void;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidget`Class.snapshot() function, and when allocating
             * child widgets in `GtkWidget`Class.size_allocate().
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Returns the width that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a layout widget: a widget’s allocation
             * will be its “adjusted” allocation, that is, the widget’s parent
             * typically calls [method`Gtk`.Widget.size_allocate] with an allocation,
             * and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * [method`Gtk`.Widget.get_allocation] returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * [method`Gtk`.Widget.size_allocate] allocation, however.
             *
             * So a layout widget is guaranteed that its children stay inside
             * the assigned bounds, but not that they have exactly the bounds the
             * widget assigned.
             */
            get_allocation(): Gtk.Allocation;
            /**
             * Gets the first ancestor of the widget with type `widget_type`.
             *
             * For example, `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)`
             * gets the first `GtkBox` that’s an ancestor of `widget`. No
             * reference will be added to the returned widget; it should
             * not be unreferenced.
             *
             * Note that unlike [method`Gtk`.Widget.is_ancestor], this function
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget
             */
            get_ancestor(widget_type: GObject.GType): Gtk.Widget | null;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidgetClass.snapshot()` function, and when allocating
             * child widgets in `GtkWidgetClass.size_allocate()`.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_baseline(): number;
            /**
             * Determines whether the input focus can enter the widget or any
             * of its children.
             *
             * See [method`Gtk`.Widget.set_can_focus].
             * @returns true if the input focus can enter @widget
             */
            get_can_focus(): boolean;
            /**
             * Queries whether the widget can be the target of pointer events.
             * @returns true if @widget can receive pointer events
             */
            get_can_target(): boolean;
            /**
             * Gets the value set with [method`Gtk`.Widget.set_child_visible].
             *
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @returns true if the widget is mapped with the parent
             */
            get_child_visible(): boolean;
            /**
             * Gets the clipboard object for the widget.
             *
             * This is a utility function to get the clipboard object for the
             * display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_clipboard(): Gdk.Clipboard;
            /**
             * Gets the current foreground color for the widget’s style.
             *
             * This function should only be used in snapshot
             * implementations that need to do custom drawing
             * with the foreground color.
             */
            get_color(): Gdk.RGBA;
            /**
             * Returns the list of style classes applied to the widget.
             * @returns a `NULL`-terminated list of   css classes currently applied to @widget
             */
            get_css_classes(): string[];
            /**
             * Returns the CSS name of the widget.
             * @returns the CSS name
             */
            get_css_name(): string;
            /**
             * Gets the cursor set on the widget.
             *
             * See [method`Gtk`.Widget.set_cursor] for details.
             * @returns the cursor   that is set on @widget
             */
            get_cursor(): Gdk.Cursor | null;
            /**
             * Gets the reading direction for the widget.
             *
             * See [method`Gtk`.Widget.set_direction].
             * @returns the reading direction for the widget
             */
            get_direction(): Gtk.TextDirection;
            /**
             * Get the display for the window that the widget belongs to.
             *
             * This function can only be called after the widget has been
             * added to a widget hierarchy with a `GtkRoot` at the top.
             *
             * In general, you should only create display-specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the display for this widget
             */
            get_display(): Gdk.Display;
            /**
             * Returns the widget’s first child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's first child
             */
            get_first_child(): Gtk.Widget | null;
            /**
             * Returns the focus child of the widget.
             * @returns the current focus   child of @widget
             */
            get_focus_child(): Gtk.Widget | null;
            /**
             * Returns whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * See [method`Gtk`.Widget.set_focus_on_click].
             * @returns true if the widget should grab focus when it is   clicked with the mouse
             */
            get_focus_on_click(): boolean;
            /**
             * Determines whether the widget can own the input focus.
             *
             * See [method`Gtk`.Widget.set_focusable].
             * @returns true if @widget can own the input focus
             */
            get_focusable(): boolean;
            /**
             * Gets the font map of the widget.
             *
             * See [method`Gtk`.Widget.set_font_map].
             * @returns the font map of @widget
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the `cairo_font_options_t` of the widget.
             *
             * Seee [method`Gtk`.Widget.set_font_options].
             * @returns the `cairo_font_options_t` of widget
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget.
             *
             * The frame clock is a global “ticker” that can be used to drive
             * animations and repaints. The most common reason to get the frame
             * clock is to call [method`Gdk`.FrameClock.get_frame_time], in order
             * to get a time to use for animating. For example you might record
             * the start of the animation with an initial value from
             * [method`Gdk`.FrameClock.get_frame_time], and then update the animation
             * by calling [method`Gdk`.FrameClock.get_frame_time] again during each repaint.
             *
             * [method`Gdk`.FrameClock.request_phase] will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a widget,
             * you have to use [method`Gtk`.Widget.queue_draw] which invalidates the
             * widget (thus scheduling it to receive a draw on the next frame).
             * [method`Gtk`.Widget.queue_draw] will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is mapped.
             * Reparenting a widget (which implies a temporary unmap) can change
             * the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns the frame clock
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the horizontal alignment of the widget.
             *
             * For backwards compatibility reasons this method will never return
             * one of the baseline alignments, but instead it will convert it to
             * [enum`Gtk`.Align.fill] or [enum`Gtk`.Align.center].
             *
             * Baselines are not supported for horizontal alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Gtk.Align;
            /**
             * Returns the current value of the `has-tooltip` property.
             * @returns current value of `has-tooltip` on @widget
             */
            get_has_tooltip(): boolean;
            /**
             * Returns the content height of the widget.
             *
             * This function returns the height passed to its
             * size-allocate implementation, which is the height you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The height of @widget
             */
            get_height(): number;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Widgets with children should use [method`Gtk`.Widget.compute_expand]
             * rather than this function, to see whether any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether the `hexpand` flag has been explicitly set.
             *
             * If [property`Gtk`.Widget:hexpand] property is set, then it
             * overrides any computed expand value based on child widgets.
             * If `hexpand` is not set, then the expand value depends on
             * whether any children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Returns the widget’s last child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's last child
             */
            get_last_child(): Gtk.Widget | null;
            /**
             * Retrieves the layout manager of the widget.
             *
             * See [method`Gtk`.Widget.set_layout_manager].
             * @returns the layout manager of @widget
             */
            get_layout_manager(): Gtk.LayoutManager | null;
            /**
             * Gets the value of the [property`Gtk`.Widget:limit-events] property.
             */
            get_limit_events(): boolean;
            /**
             * Returns whether the widget is mapped.
             * @returns true if the widget is mapped
             */
            get_mapped(): boolean;
            /**
             * Gets the bottom margin of the widget.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the end margin of the widget.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the start margin of the widget.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the top margin of the widget.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Retrieves the name of a widget.
             *
             * See [method`Gtk`.Widget.set_name] for the significance of widget names.
             * @returns name of the widget
             */
            get_name(): string;
            /**
             * Returns the nearest `GtkNative` ancestor of the widget.
             *
             * This function will return `NULL` if the widget is not
             * contained inside a widget tree with a native ancestor.
             *
             * `GtkNative` widgets will return themselves here.
             * @returns the `GtkNative` ancestor of @widget
             */
            get_native(): Gtk.Native | null;
            /**
             * Returns the widget’s next sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's next sibling
             */
            get_next_sibling(): Gtk.Widget | null;
            /**
             * Fetches the requested opacity for the widget.
             *
             * See [method`Gtk`.Widget.set_opacity].
             * @returns the requested opacity for this widget
             */
            get_opacity(): number;
            /**
             * Returns the widget’s overflow value.
             * @returns The widget's overflow value
             */
            get_overflow(): Gtk.Overflow;
            /**
             * Gets a `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map, font description,
             * and base direction set.
             *
             * Unlike the context returned by [method`Gtk`.Widget.create_pango_context],
             * this context is owned by the widget (it can be used until the screen
             * for the widget changes or the widget is removed from its toplevel),
             * and will be updated to match any changes to the widget’s attributes.
             * This can be tracked by listening to changes of the
             * [property`Gtk`.Widget:root] property on the widget.
             * @returns the `PangoContext` for the widget
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent widget of the widget.
             * @returns the parent widget of @widget
             */
            get_parent(): Gtk.Widget | null;
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as `GtkFixed`.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since
             * the required height for the natural width is generally smaller than the
             * required height for the minimum width.
             *
             * Use [method`Gtk`.Widget.measure] if you want to support baseline alignment.
             */
            get_preferred_size(): [Gtk.Requisition | null, Gtk.Requisition | null];
            /**
             * Returns the widget’s previous sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's previous sibling
             */
            get_prev_sibling(): Gtk.Widget | null;
            /**
             * Gets the primary clipboard of the widget.
             *
             * This is a utility function to get the primary clipboard object
             * for the display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_primary_clipboard(): Gdk.Clipboard;
            /**
             * Determines whether the widget is realized.
             * @returns true if @widget is realized
             */
            get_realized(): boolean;
            /**
             * Determines whether the widget is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See [method`Gtk`.Widget.set_receives_default].
             * @returns true if @widget acts as the default widget when focused
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             * @returns The `GtkSizeRequestMode` preferred by @widget.
             */
            get_request_mode(): Gtk.SizeRequestMode;
            /**
             * Returns the `GtkRoot` widget of the widget.
             *
             * This function will return `NULL` if the widget is not contained
             * inside a widget tree with a root widget.
             *
             * `GtkRoot` widgets will return themselves here.
             * @returns the root widget of @widget
             */
            get_root(): Gtk.Root | null;
            /**
             * Retrieves the internal scale factor that maps from window
             * coordinates to the actual device pixels.
             *
             * On traditional systems this is 1, on high density outputs,
             * it can be a higher value (typically 2).
             *
             * See [method`Gdk`.Surface.get_scale_factor].
             *
             * Note that modern systems may support *fractional* scaling,
             * where the scale factor is not an integer. On such systems,
             * this function will return the next higher integer value,
             * but you probably want to use [method`Gdk`.Surface.get_scale]
             * to get the fractional scale value.
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Returns the widget’s sensitivity.
             *
             * This function returns the value that has been set using
             * [method`Gtk`.Widget.set_sensitive]).
             *
             * The effective sensitivity of a widget is however determined
             * by both its own and its parent widget’s sensitivity.
             * See [method`Gtk`.Widget.is_sensitive].
             * @returns true if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for the widget.
             *
             * Note that this function can only be called when the `GtkWidget`
             * is attached to a toplevel, since the settings object is specific
             * to a particular display. If you want to monitor the widget for
             * changes in its settings, connect to the `notify::display` signal.
             * @returns the relevant settings object
             */
            get_settings(): Gtk.Settings;
            /**
             * Returns the content width or height of the widget.
             *
             * Which dimension is returned depends on `orientation`.
             *
             * This is equivalent to calling [method`Gtk`.Widget.get_width]
             * for [enum`Gtk`.Orientation.horizontal] or [method`Gtk`.Widget.get_height]
             * for [enum`Gtk`.Orientation.vertical], but can be used when
             * writing orientation-independent code, such as when
             * implementing [iface`Gtk`.Orientable] widgets.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @param orientation the orientation to query
             * @returns the size of @widget in @orientation
             */
            get_size(orientation: Gtk.Orientation | null): number;
            /**
             * Gets the size request that was explicitly set for the widget.
             *
             * A value of -1 stored in `width` or `height` indicates that that
             * dimension has not been set explicitly and the natural requisition
             * of the widget will be used instead.
             *
             * See [method`Gtk`.Widget.set_size_request].
             *
             * To get the size a widget will actually request, call
             * [method`Gtk`.Widget.measure] instead of this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget state as a flag set.
             *
             * It is worth mentioning that the effective [flags`Gtk`.StateFlags.insensitive]
             * state will be returned, that is, also based on parent insensitivity,
             * even if `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * [flags`Gtk`.StateFlags] to pass to a [class`Gtk`.StyleContext]
             * method, you should look at [method`Gtk`.StyleContext.get_state].
             * @returns the state flags of widget
             */
            get_state_flags(): Gtk.StateFlags;
            /**
             * Returns the style context associated to the widget.
             *
             * The returned object is guaranteed to be the same
             * for the lifetime of `widget`.
             * @returns the widgets style context
             */
            get_style_context(): Gtk.StyleContext;
            /**
             * Fetches an object build from the template XML for `widget_type` in
             * the widget.
             *
             * This will only report children which were previously declared
             * with [method`Gtk`.WidgetClass.bind_template_child_full] or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private
             * to the `widget_type` which declared the child and is meant for language
             * bindings which cannot easily make use of the GObject structure offsets.
             * @param widget_type The `GType` to get a template child for
             * @param name ID of the child defined in the template XML
             * @returns the object built in the template XML with   the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the tooltip has not been set using
             * [method`Gtk`.Widget.set_tooltip_markup], this
             * function returns `NULL`.
             * @returns the tooltip text
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the `widget'`s tooltip was set using
             * [method`Gtk`.Widget.set_tooltip_markup],
             * this function will return the escaped text.
             * @returns the tooltip text
             */
            get_tooltip_text(): string | null;
            /**
             * Gets the vertical alignment of the widget.
             * @returns the vertical alignment of @widget
             */
            get_valign(): Gtk.Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.get_hexpand] for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether the `vexpand` flag has been explicitly set.
             *
             * See [method`Gtk`.Widget.get_hexpand_set] for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible.
             *
             * If you want to take into account whether the widget’s
             * parent is also marked as visible, use
             * [method`Gtk`.Widget.is_visible] instead.
             *
             * This function does not check if the widget is
             * obscured in any way.
             *
             * See [method`Gtk`.Widget.set_visible].
             * @returns true if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Returns the content width of the widget.
             *
             * This function returns the width passed to its
             * size-allocate implementation, which is the width you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The width of @widget
             */
            get_width(): number;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             * @returns true if focus is now inside @widget
             */
            grab_focus(): boolean;
            /**
             * Returns whether a style class is currently applied to the widget.
             * @param css_class style class, without the leading period
             * @returns true if @css_class is currently applied to @widget
             */
            has_css_class(css_class: string): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus.
             *
             * This is a convenience function that takes into account whether
             * focus indication should currently be shown in the toplevel window
             * of `widget`. See [method`Gtk`.Window.get_focus_visible] for more
             * information about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * [method`Gtk`.Widget.has_focus].
             * @returns true if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Returns whether the widget is currently being destroyed.
             *
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns true if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates.
             *
             * This function must be called in the instance initializer
             * for any class which assigned itself a template using
             * [method`Gtk`.WidgetClass.set_template].
             *
             * It is important to call this function in the instance initializer
             * of a widget subclass and not in `GObject.constructed()` or
             * `GObject.constructor()` for two reasons:
             *
             *  - derived widgets will assume that the composite widgets
             *    defined by its parent classes have been created in their
             *    relative instance initializers
             *  - when calling `g_object_new()` on a widget with composite templates,
             *    it’s important to build the composite widgets before the construct
             *    properties are set. Properties passed to `g_object_new()` should
             *    take precedence over properties set in the private template XML
             *
             * A good rule of thumb is to call this function as the first thing in
             * an instance initialization function.
             */
            init_template(): void;
            /**
             * Inserts an action group into the widget's actions.
             *
             * Children of `widget` that implement [iface`Gtk`.Actionable] can
             * then be associated with actions in `group` by setting their
             * “action-name” to `prefix`.`action-name`.
             *
             * Note that inheritance is defined for individual actions. I.e.
             * even if you insert a group with prefix `prefix,` actions with
             * the same prefix will still be inherited from the parent, unless
             * the group contains an action with the same name.
             *
             * If `group` is `NULL`, a previously inserted group for `name` is
             * removed from `widget`.
             * @param name the prefix for actions in @group
             * @param group an action group
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed after `previous_sibling,` or at the beginning if
             * `previous_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_prev_sibling (widget)`
             * will return `previous_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this
             * function can also be used to reorder `widget` in the child widget
             * list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param previous_sibling the new previous sibling of @widget
             */
            insert_after(parent: Gtk.Widget, previous_sibling?: Gtk.Widget | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed before `next_sibling,` or at the end if
             * `next_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_next_sibling (widget)`
             * will return `next_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this function
             * can also be used to reorder `widget` in the child widget list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param next_sibling the new next sibling of @widget
             */
            insert_before(parent: Gtk.Widget, next_sibling?: Gtk.Widget | null): void;
            /**
             * Determines whether the widget is a descendent of `ancestor`.
             * @param ancestor another `GtkWidget`
             * @returns true if @ancestor contains @widget as a child,   grandchild, great grandchild, etc
             */
            is_ancestor(ancestor: Gtk.Widget): boolean;
            /**
             * Determines whether the widget can be drawn to.
             *
             * A widget can be drawn if it is mapped and visible.
             * @returns true if @widget is drawable
             */
            is_drawable(): boolean;
            /**
             * Determines if the widget is the focus widget within its
             * toplevel.
             *
             * This does not mean that the [property`Gtk`.Widget:has-focus]
             * property is necessarily set; [property`Gtk`.Widget:has-focus]
             * will only be set if the toplevel widget additionally has the
             * global input focus.
             * @returns true if the widget is the focus widget
             */
            is_focus(): boolean;
            /**
             * Returns the widget’s effective sensitivity.
             *
             * This means it is sensitive itself and also its
             * parent widget is sensitive.
             * @returns true if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also [method`Gtk`.Widget.get_visible] and
             * [method`Gtk`.Widget.set_visible].
             * @returns true if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             * @returns true if stopping keyboard navigation is fine, false   if the emitting widget should try to handle the keyboard   navigation attempt in its parent widget
             */
            keynav_failed(direction: Gtk.DirectionType | null): boolean;
            /**
             * Returns the widgets for which this widget is the target of a
             * mnemonic.
             *
             * Typically, these widgets will be labels. See, for example,
             * [method`Gtk`.Label.set_mnemonic_widget].
             *
             * The widgets in the list are not individually referenced.
             * If you want to iterate through the list and perform actions
             * involving callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result, (GFunc)g_object_ref, NULL)`
             * first, and then unref all the widgets afterwards.
             * @returns the list   of mnemonic labels
             */
            list_mnemonic_labels(): Gtk.Widget[];
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            measure(orientation: Gtk.Orientation | null, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             * @returns true if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Returns a list model to track the children of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track children and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's children
             */
            observe_children(): Gio.ListModel;
            /**
             * Returns a list model to track the event controllers of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track controllers and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's controllers
             */
            observe_controllers(): Gio.ListModel;
            /**
             * Finds the descendant of the widget closest to a point.
             *
             * The point (x, y) must be given in widget coordinates, so (0, 0)
             * is assumed to be the top left of `widget'`s content area.
             *
             * Usually widgets will return `NULL` if the given coordinate is not
             * contained in `widget` checked via [method`Gtk`.Widget.contains].
             * Otherwise they will recursively try to find a child that does
             * not return `NULL`. Widgets are however free to customize their
             * picking algorithm.
             *
             * This function is used on the toplevel to determine the widget
             * below the mouse cursor for purposes of hover highlighting and
             * delivering events.
             * @param x x coordinate to test, relative to @widget's origin
             * @param y y coordinate to test, relative to @widget's origin
             * @param flags flags to influence what is picked
             * @returns the widget's descendant at (x, y)
             */
            pick(x: number, y: number, flags: Gtk.PickFlags | null): Gtk.Widget | null;
            /**
             * Flags the widget for a rerun of the [vfunc`Gtk`.Widget.size_allocate]
             * function.
             *
             * Use this function instead of [method`Gtk`.Widget.queue_resize]
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is [method`Gtk`.Widget.set_halign].
             *
             * This function is only for use in widget implementations.
             */
            queue_allocate(): void;
            /**
             * Schedules this widget to be redrawn.
             *
             * The redraw will happen in the paint phase
             * of the current or the next frame.
             *
             * This means `widget'`s [vfunc`Gtk`.Widget.snapshot]
             * implementation will be called.
             */
            queue_draw(): void;
            /**
             * Flags a widget to have its size renegotiated.
             *
             * This should be called when a widget for some reason has a new
             * size request. For example, when you change the text in a
             * [class`Gtk`.Label], the label queues a resize to ensure there’s
             * enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the [vfunc`Gtk`.Widget.size_allocate]
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * [vfunc`Gtk`.Widget.size_allocate] will be silently ignored.
             *
             * This function is only for use in widget implementations.
             */
            queue_resize(): void;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            realize(): void;
            /**
             * Removes an event controller from the widget.
             *
             * The removed event controller will not receive any more events,
             * and should not be used again.
             *
             * Widgets will remove all event controllers automatically when they
             * are destroyed, there is normally no need to call this function.
             * @param controller an event controller
             */
            remove_controller(controller: Gtk.EventController): void;
            /**
             * Removes a style from the widget.
             *
             * After this, the style of `widget` will stop matching for `css_class`.
             * @param css_class style class to remove from @widget, without the leading period
             */
            remove_css_class(css_class: string): void;
            /**
             * Removes a widget from the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * The widget must have previously been added to the list with
             * [method`Gtk`.Widget.add_mnemonic_label].
             * @param label a widget that is a mnemonic label for @widget
             */
            remove_mnemonic_label(label: Gtk.Widget): void;
            /**
             * Removes a tick callback previously registered with
             * [method`Gtk`.Widget.add_tick_callback].
             * @param id an ID returned by [method@Gtk.Widget.add_tick_callback]
             */
            remove_tick_callback(id: number): void;
            /**
             * Sets whether the input focus can enter the widget or
             * any of its children.
             *
             * Applications should set `can_focus` to false to mark a
             * widget as for pointer/touch use only.
             *
             * Note that having `can_focus` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and focusable and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param can_focus whether the input focus can enter   the widget or any of its children
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether the widget can be the target of pointer events.
             * @param can_target whether this widget should be able to   receive pointer events
             */
            set_can_target(can_target: boolean): void;
            /**
             * Sets whether the widget should be mapped along with its parent.
             *
             * The child visibility can be set for widget before it is added
             * to a container with [method`Gtk`.Widget.set_parent], to avoid
             * mapping children unnecessary before immediately unmapping them.
             * However it will be reset to its default state of true when the
             * widget is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @param child_visible whether @widget should be mapped along   with its parent
             */
            set_child_visible(child_visible: boolean): void;
            /**
             * Replaces the current style classes of the widget with `classes`.
             * @param classes `NULL`-terminated list of style classes
             */
            set_css_classes(classes: string[]): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * If the `cursor` is `NULL`, `widget` will use the cursor
             * inherited from its parent.
             * @param cursor the new cursor
             */
            set_cursor(cursor?: Gdk.Cursor | null): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * This is a utility function that creates a cursor via
             * [ctor`Gdk`.Cursor.new_from_name] and then sets it on `widget`
             * with [method`Gtk`.Widget.set_cursor]. See those functions for
             * details.
             *
             * On top of that, this function allows `name` to be `NULL`, which
             * will do the same as calling [method`Gtk`.Widget.set_cursor]
             * with a `NULL` cursor.
             * @param name the name of the cursor
             */
            set_cursor_from_name(name?: string | null): void;
            /**
             * Sets the reading direction on the widget.
             *
             * This direction controls the primary direction for widgets
             * containing text, and also the direction in which the children
             * of a container are packed. The ability to set the direction is
             * present in order so that correct localization into languages with
             * right-to-left reading directions can be done.
             *
             * Generally, applications will let the default reading direction
             * prevail, except for widgets where the children are arranged in
             * an order that is explicitly visual rather than logical (such as
             * buttons for text justification).
             *
             * If the direction is set to [enum`Gtk`.TextDirection.none], then
             * the value set by [func`Gtk`.Widget.set_default_direction] will be used.
             * @param dir the new direction
             */
            set_direction(dir: Gtk.TextDirection | null): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            set_focus_child(child?: Gtk.Widget | null): void;
            /**
             * Sets whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * Making mouse clicks not grab focus is useful in places like
             * toolbars where you don’t want the keyboard focus removed from
             * the main area of the application.
             * @param focus_on_click whether the widget should grab focus when clicked   with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets whether the widget can own the input focus.
             *
             * Widget implementations should set `focusable` to true in
             * their init() function if they want to receive keyboard input.
             *
             * Note that having `focusable` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and can-focus and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param focusable whether or not @widget can own the input focus
             */
            set_focusable(focusable: boolean): void;
            /**
             * Sets the font map to use for text rendering in the widget.
             *
             * The font map is the object that is used to look up fonts.
             * Setting a custom font map can be useful in special situations,
             * e.g. when you need to add application-specific fonts to the set
             * of available fonts.
             *
             * When not set, the widget will inherit the font map from its parent.
             * @param font_map a `PangoFontMap`
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the `cairo_font_options_t` used for text rendering
             * in the widget.
             *
             * When not set, the default font options for the `GdkDisplay`
             * will be used.
             * @param options a `cairo_font_options_t` struct   to unset any previously set default font options
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of the widget.
             * @param align the horizontal alignment
             */
            set_halign(align: Gtk.Align | null): void;
            /**
             * Sets the `has-tooltip` property on the widget.
             * @param has_tooltip whether or not @widget has a tooltip
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call [method`Gtk`.Widget.compute_expand].
             * A widget can decide how the expandability of children affects its
             * own expansion by overriding the `compute_expand` virtual method on
             * `GtkWidget`.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children. The override occurs because
             * [method`Gtk`.Widget.set_hexpand] sets the hexpand-set property (see
             * [method`Gtk`.Widget.set_hexpand_set]) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag will be used.
             *
             * The [property`Gtk`.Widget:hexpand-set] property will be set
             * automatically when you call [method`Gtk`.Widget.set_hexpand]
             * to set hexpand, so the most likely reason to use this function
             * would be to unset an explicit expand flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Sets the layout manager to use for measuring and allocating children
             * of the widget.
             * @param layout_manager a layout manager
             */
            set_layout_manager(layout_manager?: Gtk.LayoutManager | null): void;
            /**
             * Sets whether the widget acts like a modal dialog,
             * with respect to event delivery.
             * @param limit_events whether to limit events
             */
            set_limit_events(limit_events: boolean): void;
            /**
             * Sets the bottom margin of the widget.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of the widget.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the start margin of the widget.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of the widget.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Sets a widgets name.
             *
             * Setting a name allows you to refer to the widget from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for [class`Gtk`.StyleContext].
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Requests the widget to be rendered partially transparent.
             *
             * An opacity of 0 is fully transparent and an opacity of 1
             * is fully opaque.
             *
             * Opacity works on both toplevel widgets and child widgets, although
             * there are some limitations: For toplevel widgets, applying opacity
             * depends on the capabilities of the windowing system. On X11, this
             * has any effect only on X displays with a compositing manager, see
             * [method`Gdk`.Display.is_composited]. On Windows and Wayland it will
             * always work, although setting a window’s opacity after the window
             * has been shown may cause some flicker.
             *
             * Note that the opacity is inherited through inclusion — if you set
             * a toplevel to be partially translucent, all of its content will
             * appear translucent, since it is ultimatively rendered on that
             * toplevel. The opacity value itself is not inherited by child
             * widgets (since that would make widgets deeper in the hierarchy
             * progressively more translucent). As a consequence, [class`Gtk`.Popover]
             * instances and other [iface`Gtk`.Native] widgets with their own surface
             * will use their own opacity value, and thus by default appear
             * non-translucent, even if they are attached to a toplevel that
             * is translucent.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * Sets how the widget treats content that is drawn outside the
             * it's content area.
             *
             * See the definition of [enum`Gtk`.Overflow] for details.
             *
             * This setting is provided for widget implementations and
             * should not be used by application code.
             *
             * The default value is [enum`Gtk`.Overflow.visible].
             * @param overflow desired overflow value
             */
            set_overflow(overflow: Gtk.Overflow | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * This takes care of details such as updating the state and style
             * of the child to reflect its new location and resizing the parent.
             * The opposite function is [method`Gtk`.Widget.unparent].
             *
             * This function is useful only when implementing subclasses of
             * `GtkWidget`.
             * @param parent parent widget
             */
            set_parent(parent: Gtk.Widget): void;
            /**
             * Sets whether the widget will be treated as the default
             * widget within its toplevel when it has the focus, even if
             * another widget is the default.
             * @param receives_default whether or not @widget can be a default widget
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets the sensitivity of the widget.
             *
             * A widget is sensitive if the user can interact with it.
             * Insensitive widgets are “grayed out” and the user can’t
             * interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive true to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of the widget.
             *
             * That is, the widget’s size request will be at least `width`
             * by `height`. You can use this function to force a widget to
             * be larger than it normally would be.
             *
             * In most cases, [method`Gtk`.Window.set_default_size] is a better
             * choice for toplevel windows than this function; setting the default
             * size will still allow users to shrink the window. Setting the size
             * request will force them to leave the window at least as large as
             * the size request.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it is
             * basically impossible to hardcode a size that will always work.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * properties
             * [property`Gtk`.Widget:margin-start],
             * [property`Gtk`.Widget:margin-end],
             * [property`Gtk`.Widget:margin-top], and
             * [property`Gtk`.Widget:margin-bottom], but it does include pretty
             * much all other padding or border properties set by any subclass
             * of `GtkWidget`.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * Turns on flag values in the current widget state.
             *
             * Typical widget states are insensitive, prelighted, etc.
             *
             * This function accepts the values [flags`Gtk`.StateFlags.dir-ltr] and
             * [flags`Gtk`.StateFlags.dir-rtl] but ignores them. If you want to set
             * the widget's direction, use [method`Gtk`.Widget.set_direction].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn on
             * @param clear whether to clear state before turning on @flags
             */
            set_state_flags(flags: Gtk.StateFlags | null, clear: boolean): void;
            /**
             * Sets the contents of the tooltip for widget.
             *
             * `markup` must contain Pango markup.
             *
             * This function will take care of setting the
             * [property`Gtk`.Widget:has-tooltip] as a side effect, and of the
             * default handler for the [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_markup].
             * @param markup the contents of the tooltip for @widget
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets the contents of the tooltip for the widget.
             *
             * If `text` contains any markup, it will be escaped.
             *
             * This function will take care of setting
             * [property`Gtk`.Widget:has-tooltip] as a side effect,
             * and of the default handler for the
             * [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_text].
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Sets the vertical alignment of the widget.
             * @param align the vertical alignment
             */
            set_valign(align: Gtk.Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.set_hexpand] for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag will be used.
             *
             * See [method`Gtk`.Widget.set_hexpand_set] for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`.
             *
             * Note that setting this to true doesn’t mean the widget is
             * actually viewable, see [method`Gtk`.Widget.get_visible].
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Returns whether the widget should contribute to
             * the measuring and allocation of its parent.
             *
             * This is false for invisible children, but also
             * for children that have their own surface, such
             * as [class`Gtk`.Popover] instances.
             * @returns true if child should be included in   measuring and allocating
             */
            should_layout(): boolean;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            show(): void;
            /**
             * Allocates widget with a transformation that translates
             * the origin to the position in `allocation`.
             *
             * This is a simple form of [method`Gtk`.Widget.allocate].
             * @param allocation position and size to be allocated to @widget
             * @param baseline the baseline of the child, or -1
             */
            size_allocate(allocation: Gtk.Allocation, baseline: number): void;
            /**
             * Snapshots a child of the widget.
             *
             * When a widget receives a call to the snapshot function,
             * it must send synthetic [vfunc`Gtk`.Widget.snapshot] calls
             * to all children. This function provides a convenient way
             * of doing this. A widget, when it receives a call to its
             * [vfunc`Gtk`.Widget.snapshot] function, calls
             * gtk_widget_snapshot_child() once for each child, passing in
             * the `snapshot` the widget received.
             *
             * This function takes care of translating the origin of `snapshot,`
             * and deciding whether the child needs to be snapshot.
             *
             * It does nothing for children that implement `GtkNative`.
             * @param child a child of @widget
             * @param snapshot snapshot as passed to the widget. In particular, no   calls to [method@Gtk.Snapshot.translate] or other transform calls   should have been made
             */
            snapshot_child(child: Gtk.Widget, snapshot: Gtk.Snapshot): void;
            /**
             * Translates coordinates relative to `src_widget’`s allocation
             * to coordinates relative to `dest_widget’`s allocations.
             *
             * In order to perform this operation, both widget must share
             * a common ancestor. If that is not the case, `dest_x` and `dest_y`
             * are set to 0 and false is returned.
             * @param dest_widget another widget
             * @param src_x X position in widget coordinates of @src_widget
             * @param src_y Y position in widget coordinates of @src_widget
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            translate_coordinates(dest_widget: Gtk.Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display of the widget.
             */
            trigger_tooltip_query(): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            unmap(): void;
            /**
             * Removes `widget` from its parent.
             *
             * This function is only for use in widget implementations,
             * typically in dispose.
             */
            unparent(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            unrealize(): void;
            /**
             * Turns off flag values for the current widget state.
             *
             * See [method`Gtk`.Widget.set_state_flags].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn off
             */
            unset_state_flags(flags: Gtk.StateFlags | null): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             */
            vfunc_contains(x: number, y: number): boolean;
            /**
             * Vfunc called when the CSS used by widget was changed. Widgets
             *   should then discard their caches that depend on CSS and queue resizes or
             *   redraws accordingly. The default implementation will take care of this for
             *   all the default CSS properties, so implementations must chain up.
             * @param change
             */
            vfunc_css_changed(change: Gtk.CssStyleChange): void;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: Gtk.TextDirection): void;
            /**
             * Vfunc for gtk_widget_child_focus()
             * @param direction
             */
            vfunc_focus(direction: Gtk.DirectionType): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             */
            vfunc_get_request_mode(): Gtk.SizeRequestMode;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             */
            vfunc_grab_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: Gtk.DirectionType): boolean;
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            vfunc_measure(orientation: Gtk.Orientation, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: Gtk.DirectionType): void;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Gtk.Tooltip): boolean;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            vfunc_realize(): void;
            /**
             * Called when the widget gets added to a `GtkRoot` widget. Must
             *   chain up
             */
            vfunc_root(): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            vfunc_set_focus_child(child?: Gtk.Widget | null): void;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Called to set the allocation, if the widget does
             *   not have a layout manager.
             * @param width
             * @param height
             * @param baseline
             */
            vfunc_size_allocate(width: number, height: number, baseline: number): void;
            /**
             * Vfunc called when a new snapshot of the widget has to be taken.
             * @param snapshot
             */
            vfunc_snapshot(snapshot: Gtk.Snapshot): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: Gtk.StateFlags): void;
            /**
             * Emitted when a system setting was changed. Must chain up.
             * @param settings
             */
            vfunc_system_setting_changed(settings: Gtk.SystemSetting): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_unmap(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            vfunc_unrealize(): void;
            /**
             * Called when the widget is about to be removed from its
             *   `GtkRoot` widget. Must chain up
             */
            vfunc_unroot(): void;
        }

        namespace AlertDialog {
            // Signal callback interfaces

            interface Response {
                (response: string): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Dialog.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps,
                    Gtk.ShortcutManager.ConstructorProps {
                body: string;
                body_use_markup: boolean;
                bodyUseMarkup: boolean;
                close_response: string;
                closeResponse: string;
                default_response: string;
                defaultResponse: string;
                extra_child: Gtk.Widget;
                extraChild: Gtk.Widget;
                heading: string;
                heading_use_markup: boolean;
                headingUseMarkup: boolean;
                prefer_wide_layout: boolean;
                preferWideLayout: boolean;
            }
        }

        /**
         * A dialog presenting a message or a question.
         *
         * <picture>
         *   <source srcset="alert-dialog-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="alert-dialog.png" alt="alert-dialog">
         * </picture>
         *
         * Alert dialogs have a heading, a body, an optional child widget, and one or
         * multiple responses, each presented as a button.
         *
         * Each response has a unique string ID, and a button label. Additionally, each
         * response can be enabled or disabled, and can have a suggested or destructive
         * appearance.
         *
         * When one of the responses is activated, or the dialog is closed, the
         * [signal`AlertDialog:`:response] signal will be emitted. This signal is
         * detailed, and the detail, as well as the `response` parameter will be set to
         * the ID of the activated response, or to the value of the
         * [property`AlertDialog:`close-response] property if the dialog had been closed
         * without activating any of the responses.
         *
         * Response buttons can be presented horizontally or vertically depending on
         * available space.
         *
         * When a response is activated, `AdwAlertDialog` is closed automatically.
         *
         * An example of using an alert dialog:
         *
         * ```c
         * AdwDialog *dialog;
         *
         * dialog = adw_alert_dialog_new (_("Replace File?"), NULL);
         *
         * adw_alert_dialog_format_body (ADW_ALERT_DIALOG (dialog),
         *                               _("A file named “%s” already exists. Do you want to replace it?"),
         *                               filename);
         *
         * adw_alert_dialog_add_responses (ADW_ALERT_DIALOG (dialog),
         *                                 "cancel",  _("_Cancel"),
         *                                 "replace", _("_Replace"),
         *                                 NULL);
         *
         * adw_alert_dialog_set_response_appearance (ADW_ALERT_DIALOG (dialog),
         *                                           "replace",
         *                                           ADW_RESPONSE_DESTRUCTIVE);
         *
         * adw_alert_dialog_set_default_response (ADW_ALERT_DIALOG (dialog), "cancel");
         * adw_alert_dialog_set_close_response (ADW_ALERT_DIALOG (dialog), "cancel");
         *
         * g_signal_connect (dialog, "response", G_CALLBACK (response_cb), self);
         *
         * adw_dialog_present (dialog, parent);
         * ```
         *
         * ## Async API
         *
         * `AdwAlertDialog` can also be used via the [method`AlertDialog`.choose] method.
         * This API follows the GIO async pattern, for example:
         *
         * ```c
         * static void
         * dialog_cb (AdwAlertDialog *dialog,
         *            GAsyncResult   *result,
         *            MyWindow       *self)
         * {
         *   const char *response = adw_alert_dialog_choose_finish (dialog, result);
         *
         *   // ...
         * }
         *
         * static void
         * show_dialog (MyWindow *self)
         * {
         *   AdwDialog *dialog;
         *
         *   dialog = adw_alert_dialog_new (_("Replace File?"), NULL);
         *
         *   adw_alert_dialog_format_body (ADW_ALERT_DIALOG (dialog),
         *                                 _("A file named “%s” already exists. Do you want to replace it?"),
         *                                 filename);
         *
         *   adw_alert_dialog_add_responses (ADW_ALERT_DIALOG (dialog),
         *                                   "cancel",  _("_Cancel"),
         *                                   "replace", _("_Replace"),
         *                                   NULL);
         *
         *   adw_alert_dialog_set_response_appearance (ADW_ALERT_DIALOG (dialog),
         *                                             "replace",
         *                                             ADW_RESPONSE_DESTRUCTIVE);
         *
         *   adw_alert_dialog_set_default_response (ADW_ALERT_DIALOG (dialog), "cancel");
         *   adw_alert_dialog_set_close_response (ADW_ALERT_DIALOG (dialog), "cancel");
         *
         *   adw_alert_dialog_choose (ADW_ALERT_DIALOG (dialog), GTK_WIDGET (self),
         *                            NULL, (GAsyncReadyCallback) dialog_cb, self);
         * }
         * ```
         *
         * ## AdwAlertDialog as GtkBuildable
         *
         * `AdwAlertDialog` supports adding responses in UI definitions by via the
         * `<responses>` element that may contain multiple `<response>` elements, each
         * representing a response.
         *
         * Each of the `<response>` elements must have the `id` attribute specifying the
         * response ID. The contents of the element are used as the response label.
         *
         * Response labels can be translated with the usual `translatable`, `context`
         * and `comments` attributes.
         *
         * The `<response>` elements can also have `enabled` and/or `appearance`
         * attributes. See [method`AlertDialog`.set_response_enabled] and
         * [method`AlertDialog`.set_response_appearance] for details.
         *
         * Example of an `AdwAlertDialog` UI definition:
         *
         * ```xml
         * <object class="AdwAlertDialog" id="dialog">
         *   <property name="heading" translatable="yes">Save Changes?</property>
         *   <property name="body" translatable="yes">Open documents contain unsaved changes. Changes which are not saved will be permanently lost.</property>
         *   <property name="default-response">save</property>
         *   <property name="close-response">cancel</property>
         *   <signal name="response" handler="response_cb"/>
         *   <responses>
         *     <response id="cancel" translatable="yes">_Cancel</response>
         *     <response id="discard" translatable="yes" appearance="destructive">_Discard</response>
         *     <response id="save" translatable="yes" appearance="suggested" enabled="false">_Save</response>
         *   </responses>
         * </object>
         * ```
         */
        class AlertDialog
            extends Dialog
            implements Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.ShortcutManager
        {
            static $gtype: GObject.GType<AlertDialog>;

            // Properties

            /**
             * The body text of the dialog.
             */
            get body(): string;
            set body(val: string);
            /**
             * Whether the body text includes Pango markup.
             *
             * See [func`Pango`.parse_markup].
             */
            get body_use_markup(): boolean;
            set body_use_markup(val: boolean);
            /**
             * Whether the body text includes Pango markup.
             *
             * See [func`Pango`.parse_markup].
             */
            get bodyUseMarkup(): boolean;
            set bodyUseMarkup(val: boolean);
            /**
             * The ID of the close response.
             *
             * It will be passed to [signal`AlertDialog:`:response] if the dialog is
             * closed by pressing <kbd>Escape</kbd> or with a system action.
             *
             * It doesn't have to correspond to any of the responses in the dialog.
             *
             * The default close response is `close`.
             */
            get close_response(): string;
            set close_response(val: string);
            /**
             * The ID of the close response.
             *
             * It will be passed to [signal`AlertDialog:`:response] if the dialog is
             * closed by pressing <kbd>Escape</kbd> or with a system action.
             *
             * It doesn't have to correspond to any of the responses in the dialog.
             *
             * The default close response is `close`.
             */
            get closeResponse(): string;
            set closeResponse(val: string);
            /**
             * The response ID of the default response.
             *
             * If set, pressing <kbd>Enter</kbd> will activate the corresponding button.
             *
             * If set to `NULL` or a non-existent response ID, pressing <kbd>Enter</kbd>
             * will do nothing.
             */
            get default_response(): string;
            set default_response(val: string);
            /**
             * The response ID of the default response.
             *
             * If set, pressing <kbd>Enter</kbd> will activate the corresponding button.
             *
             * If set to `NULL` or a non-existent response ID, pressing <kbd>Enter</kbd>
             * will do nothing.
             */
            get defaultResponse(): string;
            set defaultResponse(val: string);
            /**
             * The child widget.
             *
             * Displayed below the heading and body.
             */
            get extra_child(): Gtk.Widget;
            set extra_child(val: Gtk.Widget);
            /**
             * The child widget.
             *
             * Displayed below the heading and body.
             */
            get extraChild(): Gtk.Widget;
            set extraChild(val: Gtk.Widget);
            /**
             * The heading of the dialog.
             */
            get heading(): string;
            set heading(val: string);
            /**
             * Whether the heading includes Pango markup.
             *
             * See [func`Pango`.parse_markup].
             */
            get heading_use_markup(): boolean;
            set heading_use_markup(val: boolean);
            /**
             * Whether the heading includes Pango markup.
             *
             * See [func`Pango`.parse_markup].
             */
            get headingUseMarkup(): boolean;
            set headingUseMarkup(val: boolean);
            /**
             * Whether to prefer wide layout.
             *
             * Prefer horizontal button layout when possible, and wider dialog width
             * otherwise.
             */
            get prefer_wide_layout(): boolean;
            set prefer_wide_layout(val: boolean);
            /**
             * Whether to prefer wide layout.
             *
             * Prefer horizontal button layout when possible, and wider dialog width
             * otherwise.
             */
            get preferWideLayout(): boolean;
            set preferWideLayout(val: boolean);

            // Constructors

            constructor(properties?: Partial<AlertDialog.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](heading?: string | null, body?: string | null): AlertDialog;
            // Conflicted with Adw.Dialog.new

            static ['new'](...args: never[]): any;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'response', callback: (_source: this, response: string) => void): number;
            connect_after(signal: 'response', callback: (_source: this, response: string) => void): number;
            emit(signal: 'response', response: string): void;

            // Virtual methods

            vfunc_response(response: string): void;

            // Methods

            /**
             * Adds a response with `id` and `label` to `self`.
             *
             * Responses are represented as buttons in the dialog.
             *
             * Response ID must be unique. It will be used in [signal`AlertDialog:`:response]
             * to tell which response had been activated, as well as to inspect and modify
             * the response later.
             *
             * An embedded underline in `label` indicates a mnemonic.
             *
             * [method`AlertDialog`.set_response_label] can be used to change the response
             * label after it had been added.
             *
             * [method`AlertDialog`.set_response_enabled] and
             * [method`AlertDialog`.set_response_appearance] can be used to customize the
             * responses further.
             * @param id the response ID
             * @param label the response label
             */
            add_response(id: string, label: string): void;
            /**
             * This function shows `self` to the user.
             *
             * If the window is an [class`Window]` or [class`ApplicationWindow]`, the dialog
             * will be shown within it. Otherwise, it will be a separate window.
             * @param parent the parent widget
             * @param cancellable a `GCancellable` to cancel the operation
             */
            choose(parent?: Gtk.Widget | null, cancellable?: Gio.Cancellable | null): Promise<string>;
            /**
             * This function shows `self` to the user.
             *
             * If the window is an [class`Window]` or [class`ApplicationWindow]`, the dialog
             * will be shown within it. Otherwise, it will be a separate window.
             * @param parent the parent widget
             * @param cancellable a `GCancellable` to cancel the operation
             * @param callback a callback to call when the operation is complete
             */
            choose(
                parent: Gtk.Widget | null,
                cancellable: Gio.Cancellable | null,
                callback: Gio.AsyncReadyCallback<this> | null,
            ): void;
            /**
             * This function shows `self` to the user.
             *
             * If the window is an [class`Window]` or [class`ApplicationWindow]`, the dialog
             * will be shown within it. Otherwise, it will be a separate window.
             * @param parent the parent widget
             * @param cancellable a `GCancellable` to cancel the operation
             * @param callback a callback to call when the operation is complete
             */
            choose(
                parent?: Gtk.Widget | null,
                cancellable?: Gio.Cancellable | null,
                callback?: Gio.AsyncReadyCallback<this> | null,
            ): Promise<string> | void;
            /**
             * Finishes the [method`AlertDialog`.choose] call and returns the response ID.
             * @param result a `GAsyncResult`
             * @returns the ID of the response that was selected, or   [property@AlertDialog:close-response] if the call was cancelled.
             */
            choose_finish(result: Gio.AsyncResult): string;
            /**
             * Gets the body text of `self`.
             * @returns the body of @self.
             */
            get_body(): string;
            /**
             * Gets whether the body text of `self` includes Pango markup.
             * @returns whether @self uses markup for body text
             */
            get_body_use_markup(): boolean;
            /**
             * Gets the ID of the close response of `self`.
             * @returns the close response ID
             */
            get_close_response(): string;
            /**
             * Gets the ID of the default response of `self`.
             * @returns the default response ID
             */
            get_default_response(): string | null;
            /**
             * Gets the child widget of `self`.
             * @returns the child widget of @self.
             */
            get_extra_child(): Gtk.Widget | null;
            /**
             * Gets the heading of `self`.
             * @returns the heading of @self.
             */
            get_heading(): string | null;
            /**
             * Gets whether the heading of `self` includes Pango markup.
             * @returns whether @self uses markup for heading
             */
            get_heading_use_markup(): boolean;
            /**
             * Gets whether `self` prefers wide layout.
             * @returns whether to prefer wide layout
             */
            get_prefer_wide_layout(): boolean;
            /**
             * Gets the appearance of `response`.
             *
             * See [method`AlertDialog`.set_response_appearance].
             * @param response a response ID
             * @returns the appearance of @response
             */
            get_response_appearance(response: string): ResponseAppearance;
            /**
             * Gets whether `response` is enabled.
             *
             * See [method`AlertDialog`.set_response_enabled].
             * @param response a response ID
             * @returns whether @response is enabled
             */
            get_response_enabled(response: string): boolean;
            /**
             * Gets the label of `response`.
             *
             * See [method`AlertDialog`.set_response_label].
             * @param response a response ID
             * @returns the label of @response
             */
            get_response_label(response: string): string;
            /**
             * Gets whether `self` has a response with the ID `response`.
             * @param response response ID
             * @returns whether @self has a response with the ID @response.
             */
            has_response(response: string): boolean;
            /**
             * Removes a response from `self`.
             * @param id the response ID
             */
            remove_response(id: string): void;
            /**
             * Sets the body text of `self`.
             * @param body the body of @self
             */
            set_body(body: string): void;
            /**
             * Sets whether the body text of `self` includes Pango markup.
             *
             * See [func`Pango`.parse_markup].
             * @param use_markup whether to use markup for body text
             */
            set_body_use_markup(use_markup: boolean): void;
            /**
             * Sets the ID of the close response of `self`.
             *
             * It will be passed to [signal`AlertDialog:`:response] if the dialog is closed
             * by pressing <kbd>Escape</kbd> or with a system action.
             *
             * It doesn't have to correspond to any of the responses in the dialog.
             *
             * The default close response is `close`.
             * @param response the close response ID
             */
            set_close_response(response: string): void;
            /**
             * Sets the ID of the default response of `self`.
             *
             * If set, pressing <kbd>Enter</kbd> will activate the corresponding button.
             *
             * If set to `NULL` or to a non-existent response ID, pressing <kbd>Enter</kbd>
             * will do nothing.
             * @param response the default response ID
             */
            set_default_response(response?: string | null): void;
            /**
             * Sets the child widget of `self`.
             *
             * The child widget is displayed below the heading and body.
             * @param child the child widget
             */
            set_extra_child(child?: Gtk.Widget | null): void;
            /**
             * Sets the heading of `self`.
             * @param heading the heading of @self
             */
            set_heading(heading?: string | null): void;
            /**
             * Sets whether the heading of `self` includes Pango markup.
             *
             * See [func`Pango`.parse_markup].
             * @param use_markup whether to use markup for heading
             */
            set_heading_use_markup(use_markup: boolean): void;
            /**
             * Sets whether `self` prefers wide layout.
             *
             * Prefer horizontal button layout when possible, and wider dialog width
             * otherwise.
             * @param prefer_wide_layout whether to prefer wide layout
             */
            set_prefer_wide_layout(prefer_wide_layout: boolean): void;
            /**
             * Sets the appearance for `response`.
             *
             * <picture>
             *   <source srcset="alert-dialog-appearance-dark.png" media="(prefers-color-scheme: dark)">
             *   <img src="alert-dialog-appearance.png" alt="alert-dialog-appearance">
             * </picture>
             *
             * Use `ADW_RESPONSE_SUGGESTED` to mark important responses such as the
             * affirmative action, like the Save button in the example.
             *
             * Use `ADW_RESPONSE_DESTRUCTIVE` to draw attention to the potentially damaging
             * consequences of using `response`. This appearance acts as a warning to the
             * user. The Discard button in the example is using this appearance.
             *
             * The default appearance is `ADW_RESPONSE_DEFAULT`.
             *
             * Negative responses like Cancel or Close should use the default appearance.
             * @param response a response ID
             * @param appearance appearance for @response
             */
            set_response_appearance(response: string, appearance: ResponseAppearance | null): void;
            /**
             * Sets whether `response` is enabled.
             *
             * If `response` is not enabled, the corresponding button will have
             * [property`Gtk`.Widget:sensitive] set to `FALSE` and it can't be activated as
             * a default response.
             *
             * `response` can still be used as [property`AlertDialog:`close-response] while
             * it's not enabled.
             *
             * Responses are enabled by default.
             * @param response a response ID
             * @param enabled whether to enable @response
             */
            set_response_enabled(response: string, enabled: boolean): void;
            /**
             * Sets the label of `response` to `label`.
             *
             * Labels are displayed on the dialog buttons. An embedded underline in `label`
             * indicates a mnemonic.
             * @param response a response ID
             * @param label the label of @response
             */
            set_response_label(response: string, label: string): void;

            // Inherited methods
            /**
             * Add a `GtkShortcutController` to be managed.
             * @param controller
             */
            vfunc_add_controller(controller: Gtk.ShortcutController): void;
            /**
             * Remove a `GtkShortcutController` that had previously
             *   been added
             * @param controller
             */
            vfunc_remove_controller(controller: Gtk.ShortcutController): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace Animation {
            // Signal callback interfaces

            interface Done {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {
                follow_enable_animations_setting: boolean;
                followEnableAnimationsSetting: boolean;
                state: AnimationState;
                target: AnimationTarget;
                value: number;
                widget: Gtk.Widget;
            }
        }

        /**
         * A base class for animations.
         *
         * `AdwAnimation` represents an animation on a widget. It has a target that
         * provides a value to animate, and a state indicating whether the
         * animation hasn't been started yet, is playing, paused or finished.
         *
         * Currently there are two concrete animation types:
         * [class`TimedAnimation]` and [class`SpringAnimation]`.
         *
         * `AdwAnimation` will automatically skip the animation if
         * [property`Animation:`widget] is unmapped, or if
         * [property`Gtk`.Settings:gtk-enable-animations] is `FALSE`.
         *
         * The [signal`Animation:`:done] signal can be used to perform an action after
         * the animation ends, for example hiding a widget after animating its
         * [property`Gtk`.Widget:opacity] to 0.
         *
         * `AdwAnimation` will be kept alive while the animation is playing. As such,
         * it's safe to create an animation, start it and immediately unref it:
         * A fire-and-forget animation:
         *
         * ```c
         * static void
         * animation_cb (double    value,
         *               MyObject *self)
         * {
         *   // Do something with `value`
         * }
         *
         * static void
         * my_object_animate (MyObject *self)
         * {
         *   AdwAnimationTarget *target =
         *     adw_callback_animation_target_new ((AdwAnimationTargetFunc) animation_cb,
         *                                        self, NULL);
         *   g_autoptr (AdwAnimation) animation =
         *     adw_timed_animation_new (widget, 0, 1, 250, target);
         *
         *   adw_animation_play (animation);
         * }
         * ```
         *
         * If there's a chance the previous animation for the same target hasn't yet
         * finished, the previous animation should be stopped first, or the existing
         * `AdwAnimation` object can be reused.
         */
        abstract class Animation extends GObject.Object {
            static $gtype: GObject.GType<Animation>;

            // Properties

            /**
             * Whether to skip the animation when animations are globally disabled.
             *
             * The default behavior is to skip the animation. Set to `FALSE` to disable
             * this behavior.
             *
             * This can be useful for cases where animation is essential, like spinners,
             * or in demo applications. Most other animations should keep it enabled.
             *
             * See [property`Gtk`.Settings:gtk-enable-animations].
             */
            get follow_enable_animations_setting(): boolean;
            set follow_enable_animations_setting(val: boolean);
            /**
             * Whether to skip the animation when animations are globally disabled.
             *
             * The default behavior is to skip the animation. Set to `FALSE` to disable
             * this behavior.
             *
             * This can be useful for cases where animation is essential, like spinners,
             * or in demo applications. Most other animations should keep it enabled.
             *
             * See [property`Gtk`.Settings:gtk-enable-animations].
             */
            get followEnableAnimationsSetting(): boolean;
            set followEnableAnimationsSetting(val: boolean);
            /**
             * The animation state.
             *
             * The state indicates whether the animation is currently playing, paused,
             * finished or hasn't been started yet.
             */
            get state(): AnimationState;
            /**
             * The target to animate.
             */
            get target(): AnimationTarget;
            set target(val: AnimationTarget);
            /**
             * The current value of the animation.
             */
            get value(): number;
            /**
             * The animation widget.
             *
             * It provides the frame clock for the animation. It's not strictly necessary
             * for this widget to be same as the one being animated.
             *
             * The widget must be mapped in order for the animation to work. If it's not
             * mapped, or if it gets unmapped during an ongoing animation, the animation
             * will be automatically skipped.
             */
            get widget(): Gtk.Widget;

            // Constructors

            constructor(properties?: Partial<Animation.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'done', callback: (_source: this) => void): number;
            connect_after(signal: 'done', callback: (_source: this) => void): number;
            emit(signal: 'done'): void;

            // Methods

            /**
             * Gets whether `self` should be skipped when animations are globally disabled.
             * @returns whether to follow the global setting
             */
            get_follow_enable_animations_setting(): boolean;
            /**
             * Gets the current value of `self`.
             *
             * The state indicates whether `self` is currently playing, paused, finished or
             * hasn't been started yet.
             * @returns the animation value
             */
            get_state(): AnimationState;
            /**
             * Gets the target `self` animates.
             * @returns the animation target
             */
            get_target(): AnimationTarget;
            /**
             * Gets the current value of `self`.
             * @returns the current value
             */
            get_value(): number;
            /**
             * Gets the widget `self` was created for.
             *
             * It provides the frame clock for the animation. It's not strictly necessary
             * for this widget to be same as the one being animated.
             *
             * The widget must be mapped in order for the animation to work. If it's not
             * mapped, or if it gets unmapped during an ongoing animation, the animation
             * will be automatically skipped.
             * @returns the animation widget
             */
            get_widget(): Gtk.Widget;
            /**
             * Pauses a playing animation for `self`.
             *
             * Does nothing if the current state of `self` isn't `ADW_ANIMATION_PLAYING`.
             *
             * Sets [property`Animation:`state] to `ADW_ANIMATION_PAUSED`.
             */
            pause(): void;
            /**
             * Starts the animation for `self`.
             *
             * If the animation is playing, paused or has been completed, restarts it from
             * the beginning. This allows to easily play an animation regardless of whether
             * it's already playing or not.
             *
             * Sets [property`Animation:`state] to `ADW_ANIMATION_PLAYING`.
             *
             * The animation will be automatically skipped if [property`Animation:`widget] is
             * unmapped, or if [property`Gtk`.Settings:gtk-enable-animations] is `FALSE`.
             *
             * As such, it's not guaranteed that the animation will actually run. For
             * example, when using [func`GLib`.idle_add] and starting an animation
             * immediately afterwards, it's entirely possible that the idle callback will
             * run after the animation has already finished, and not while it's playing.
             */
            play(): void;
            /**
             * Resets the animation for `self`.
             *
             * Sets [property`Animation:`state] to `ADW_ANIMATION_IDLE`.
             */
            reset(): void;
            /**
             * Resumes a paused animation for `self`.
             *
             * This function must only be used if the animation has been paused with
             * [method`Animation`.pause].
             *
             * Sets [property`Animation:`state] to `ADW_ANIMATION_PLAYING`.
             */
            resume(): void;
            /**
             * Sets whether to skip `self` when animations are globally disabled.
             *
             * The default behavior is to skip the animation. Set to `FALSE` to disable this
             * behavior.
             *
             * This can be useful for cases where animation is essential, like spinners, or
             * in demo applications. Most other animations should keep it enabled.
             *
             * See [property`Gtk`.Settings:gtk-enable-animations].
             * @param setting whether to follow the global setting
             */
            set_follow_enable_animations_setting(setting: boolean): void;
            /**
             * Sets the target `self` animates to `target`.
             * @param target an animation target
             */
            set_target(target: AnimationTarget): void;
            /**
             * Skips the animation for `self`.
             *
             * If the animation hasn't been started yet, is playing, or is paused, instantly
             * skips the animation to the end and causes [signal`Animation:`:done] to be
             * emitted.
             *
             * Sets [property`Animation:`state] to `ADW_ANIMATION_FINISHED`.
             */
            skip(): void;
        }

        namespace AnimationTarget {
            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {}
        }

        /**
         * Represents a value [class`Animation]` can animate.
         */
        abstract class AnimationTarget extends GObject.Object {
            static $gtype: GObject.GType<AnimationTarget>;

            // Constructors

            constructor(properties?: Partial<AnimationTarget.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;
        }

        namespace Application {
            // Constructor properties interface

            interface ConstructorProps
                extends Gtk.Application.ConstructorProps,
                    Gio.ActionGroup.ConstructorProps,
                    Gio.ActionMap.ConstructorProps {
                style_manager: StyleManager;
                styleManager: StyleManager;
            }
        }

        /**
         * A base class for Adwaita applications.
         *
         * `AdwApplication` handles library initialization by calling [func`init]` in the
         * default [signal`Gio`.Application::startup] signal handler, in turn chaining up
         * as required by [class`Gtk`.Application]. Therefore, any subclass of
         * `AdwApplication` should always chain up its `startup` handler before using
         * any Adwaita or GTK API.
         *
         * ## Automatic Resources
         *
         * `AdwApplication` will automatically load stylesheets located in the
         * application's resource base path (see
         * [method`Gio`.Application.set_resource_base_path], if they're present.
         *
         * They can be used to add custom styles to the application, as follows:
         *
         * - `style.css` contains styles that are always present.
         *
         * - `style-dark.css` contains styles only used when
         * [property`StyleManager:`dark] is `TRUE`.
         *
         * - `style-hc.css` contains styles used when the system high contrast
         *   preference is enabled.
         *
         * - `style-hc-dark.css` contains styles used when the system high contrast
         *   preference is enabled and [property`StyleManager:`dark] is `TRUE`.
         */
        class Application extends Gtk.Application implements Gio.ActionGroup, Gio.ActionMap {
            static $gtype: GObject.GType<Application>;

            // Properties

            /**
             * The style manager for this application.
             *
             * This is a convenience property allowing to access `AdwStyleManager` through
             * property bindings or expressions.
             */
            get style_manager(): StyleManager;
            /**
             * The style manager for this application.
             *
             * This is a convenience property allowing to access `AdwStyleManager` through
             * property bindings or expressions.
             */
            get styleManager(): StyleManager;

            // Constructors

            constructor(properties?: Partial<Application.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](application_id: string | null, flags: Gio.ApplicationFlags): Application;

            // Methods

            /**
             * Gets the style manager for `self`.
             *
             * This is a convenience property allowing to access `AdwStyleManager` through
             * property bindings or expressions.
             * @returns the style manager
             */
            get_style_manager(): StyleManager;

            // Inherited methods
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace ApplicationWindow {
            // Constructor properties interface

            interface ConstructorProps
                extends Gtk.ApplicationWindow.ConstructorProps,
                    Gio.ActionGroup.ConstructorProps,
                    Gio.ActionMap.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps,
                    Gtk.Native.ConstructorProps,
                    Gtk.Root.ConstructorProps,
                    Gtk.ShortcutManager.ConstructorProps {
                adaptive_preview: boolean;
                adaptivePreview: boolean;
                content: Gtk.Widget;
                current_breakpoint: Breakpoint;
                currentBreakpoint: Breakpoint;
                dialogs: Gio.ListModel;
                visible_dialog: Dialog;
                visibleDialog: Dialog;
            }
        }

        /**
         * A freeform application window.
         *
         * <picture>
         *   <source srcset="application-window-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="application-window.png" alt="application-window">
         * </picture>
         *
         * `AdwApplicationWindow` is a [class`Gtk`.ApplicationWindow] subclass providing
         * the same features as [class`Window]`.
         *
         * See [class`Window]` for details.
         *
         * Example of an `AdwApplicationWindow` UI definition:
         *
         * ```xml
         * <object class="AdwApplicationWindow">
         *   <property name="content">
         *     <object class="AdwToolbarView">
         *       <child type="top">
         *         <object class="AdwHeaderBar"/>
         *       </child>
         *       <property name="content">
         *         <!-- ... -->
         *       </property>
         *     </object>
         *   </property>
         * </object>
         * ```
         *
         * Using [property`Gtk`.Application:menubar] is not supported and may result in
         * visual glitches.
         */
        class ApplicationWindow
            extends Gtk.ApplicationWindow
            implements
                Gio.ActionGroup,
                Gio.ActionMap,
                Gtk.Accessible,
                Gtk.Buildable,
                Gtk.ConstraintTarget,
                Gtk.Native,
                Gtk.Root,
                Gtk.ShortcutManager
        {
            static $gtype: GObject.GType<ApplicationWindow>;

            // Properties

            /**
             * Whether adaptive preview is currently open.
             *
             * Adaptive preview is a debugging tool used for testing the window
             * contents at specific screen sizes, simulating mobile environment.
             *
             * Adaptive preview can always be accessed from inspector. This function
             * allows applications to open it manually.
             *
             * Most applications should not use this property.
             */
            get adaptive_preview(): boolean;
            set adaptive_preview(val: boolean);
            /**
             * Whether adaptive preview is currently open.
             *
             * Adaptive preview is a debugging tool used for testing the window
             * contents at specific screen sizes, simulating mobile environment.
             *
             * Adaptive preview can always be accessed from inspector. This function
             * allows applications to open it manually.
             *
             * Most applications should not use this property.
             */
            get adaptivePreview(): boolean;
            set adaptivePreview(val: boolean);
            /**
             * The content widget.
             *
             * This property should always be used instead of [property`Gtk`.Window:child].
             */
            get content(): Gtk.Widget;
            set content(val: Gtk.Widget);
            /**
             * The current breakpoint.
             */
            get current_breakpoint(): Breakpoint;
            /**
             * The current breakpoint.
             */
            get currentBreakpoint(): Breakpoint;
            /**
             * The open dialogs.
             */
            get dialogs(): Gio.ListModel;
            /**
             * The currently visible dialog
             */
            get visible_dialog(): Dialog;
            /**
             * The currently visible dialog
             */
            get visibleDialog(): Dialog;

            // Constructors

            constructor(properties?: Partial<ApplicationWindow.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](app: Gtk.Application): ApplicationWindow;
            // Conflicted with Gtk.Window.new

            static ['new'](...args: never[]): any;

            // Methods

            /**
             * Adds `breakpoint` to `self`.
             * @param breakpoint the breakpoint to add
             */
            add_breakpoint(breakpoint: Breakpoint): void;
            /**
             * Gets whether adaptive preview for `self` is currently open.
             * @returns whether adaptive preview is open.
             */
            get_adaptive_preview(): boolean;
            /**
             * Gets the content widget of `self`.
             *
             * This method should always be used instead of [method`Gtk`.Window.get_child].
             * @returns the content widget of @self
             */
            get_content(): Gtk.Widget | null;
            /**
             * Gets the current breakpoint.
             * @returns the current breakpoint
             */
            get_current_breakpoint(): Breakpoint | null;
            /**
             * Returns a [iface`Gio`.ListModel] that contains the open dialogs of `self`.
             *
             * This can be used to keep an up-to-date view.
             * @returns a list model for the dialogs of @self
             */
            get_dialogs(): Gio.ListModel;
            /**
             * Returns the currently visible dialog in `self,` if there's one.
             * @returns the visible dialog
             */
            get_visible_dialog(): Dialog | null;
            /**
             * Sets whether adaptive preview for `self` is currently open.
             *
             * Adaptive preview is a debugging tool used for testing the window
             * contents at specific screen sizes, simulating mobile environment.
             *
             * Adaptive preview can always be accessed from inspector. This function
             * allows applications to open it manually.
             *
             * Most applications should not use this function.
             * @param adaptive_preview whether to open adaptive preview
             */
            set_adaptive_preview(adaptive_preview: boolean): void;
            /**
             * Sets the content widget of `self`.
             *
             * This method should always be used instead of [method`Gtk`.Window.set_child].
             * @param content the content widget
             */
            set_content(content?: Gtk.Widget | null): void;

            // Inherited properties
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get can_focus(): boolean;
            set can_focus(val: boolean);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get canFocus(): boolean;
            set canFocus(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get can_target(): boolean;
            set can_target(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get canTarget(): boolean;
            set canTarget(val: boolean);
            /**
             * A list of css classes applied to this widget.
             */
            get css_classes(): string[];
            set css_classes(val: string[]);
            /**
             * A list of css classes applied to this widget.
             */
            get cssClasses(): string[];
            set cssClasses(val: string[]);
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get css_name(): string;
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get cssName(): string;
            /**
             * The cursor used by `widget`.
             */
            get cursor(): Gdk.Cursor;
            set cursor(val: Gdk.Cursor);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * Whether this widget itself will accept the input focus.
             */
            get focusable(): boolean;
            set focusable(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space.
             */
            get halign(): Gtk.Align;
            set halign(val: Gtk.Align);
            /**
             * Whether the widget is the default widget.
             */
            get has_default(): boolean;
            /**
             * Whether the widget is the default widget.
             */
            get hasDefault(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get has_focus(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get hasFocus(): boolean;
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get height_request(): number;
            set height_request(val: number);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally.
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layout_manager(): Gtk.LayoutManager;
            set layout_manager(val: Gtk.LayoutManager);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layoutManager(): Gtk.LayoutManager;
            set layoutManager(val: Gtk.LayoutManager);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limit_events(): boolean;
            set limit_events(val: boolean);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limitEvents(): boolean;
            set limitEvents(val: boolean);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            /**
             * The name of the widget.
             */
            get name(): string;
            set name(val: string);
            /**
             * The requested opacity of the widget.
             */
            get opacity(): number;
            set opacity(val: number);
            /**
             * How content outside the widget's content area is treated.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get overflow(): Gtk.Overflow;
            set overflow(val: Gtk.Overflow);
            /**
             * The parent widget of this widget.
             */
            get parent(): Gtk.Widget;
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receives_default(): boolean;
            set receives_default(val: boolean);
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The `GtkRoot` widget of the widget tree containing this widget.
             *
             * This will be `NULL` if the widget is not contained in a root widget.
             */
            get root(): Gtk.Root;
            /**
             * The scale factor of the widget.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget.
             */
            get scaleFactor(): number;
            /**
             * Whether the widget responds to input.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space.
             */
            get valign(): Gtk.Align;
            set valign(val: Gtk.Align);
            /**
             * Whether to expand vertically.
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            /**
             * Whether the widget is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get width_request(): number;
            set width_request(val: number);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get widthRequest(): number;
            set widthRequest(val: number);

            // Inherited methods
            /**
             * Emits the [signal`Gio`.ActionGroup::action-added] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            action_added(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-enabled-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param enabled whether the action is now enabled
             */
            action_enabled_changed(action_name: string, enabled: boolean): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-removed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            action_removed(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-state-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param state the new state of the named action
             */
            action_state_changed(action_name: string, state: GLib.Variant): void;
            /**
             * Activate the named action within `action_group`.
             *
             * If the action is expecting a parameter, then the correct type of
             * parameter must be given as `parameter`.  If the action is expecting no
             * parameters then `parameter` must be `NULL`.  See
             * [method`Gio`.ActionGroup.get_action_parameter_type].
             *
             * If the [type`Gio`.ActionGroup] implementation supports asynchronous remote
             * activation over D-Bus, this call may return before the relevant
             * D-Bus traffic has been sent, or any replies have been received. In
             * order to block on such asynchronous activation calls,
             * [method`Gio`.DBusConnection.flush] should be called prior to the code, which
             * depends on the result of the action activation. Without flushing
             * the D-Bus connection, there is no guarantee that the action would
             * have been activated.
             *
             * The following code which runs in a remote app instance, shows an
             * example of a ‘quit’ action being activated on the primary app
             * instance over D-Bus. Here [method`Gio`.DBusConnection.flush] is called
             * before `exit()`. Without `g_dbus_connection_flush()`, the ‘quit’ action
             * may fail to be activated on the primary instance.
             *
             * ```c
             * // call ‘quit’ action on primary instance
             * g_action_group_activate_action (G_ACTION_GROUP (app), "quit", NULL);
             *
             * // make sure the action is activated now
             * g_dbus_connection_flush (…);
             *
             * g_debug ("Application has been terminated. Exiting.");
             *
             * exit (0);
             * ```
             * @param action_name the name of the action to activate
             * @param parameter parameters to the activation
             */
            activate_action(action_name: string, parameter?: GLib.Variant | null): void;
            // Conflicted with Gtk.Widget.activate_action
            activate_action(...args: never[]): any;
            /**
             * Request for the state of the named action within `action_group` to be
             * changed to `value`.
             *
             * The action must be stateful and `value` must be of the correct type.
             * See [method`Gio`.ActionGroup.get_action_state_type].
             *
             * This call merely requests a change.  The action may refuse to change
             * its state or may change its state to something other than `value`.
             * See [method`Gio`.ActionGroup.get_action_state_hint].
             *
             * If the `value` GVariant is floating, it is consumed.
             * @param action_name the name of the action to request the change on
             * @param value the new state
             */
            change_action_state(action_name: string, value: GLib.Variant): void;
            /**
             * Checks if the named action within `action_group` is currently enabled.
             *
             * An action must be enabled in order to be activated or in order to
             * have its state changed from outside callers.
             * @param action_name the name of the action to query
             * @returns whether the action is currently enabled
             */
            get_action_enabled(action_name: string): boolean;
            /**
             * Queries the type of the parameter that must be given when activating
             * the named action within `action_group`.
             *
             * When activating the action using [method`Gio`.ActionGroup.activate_action],
             * the [type`GLib`.Variant] given to that function must be of the type returned
             * by this function.
             *
             * In the case that this function returns `NULL`, you must not give any
             * [type`GLib`.Variant], but `NULL` instead.
             *
             * The parameter type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different parameter type.
             * @param action_name the name of the action to query
             * @returns the parameter type
             */
            get_action_parameter_type(action_name: string): GLib.VariantType | null;
            /**
             * Queries the current state of the named action within `action_group`.
             *
             * If the action is not stateful then `NULL` will be returned.  If the
             * action is stateful then the type of the return value is the type
             * given by [method`Gio`.ActionGroup.get_action_state_type].
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             * @returns the current state of the action
             */
            get_action_state(action_name: string): GLib.Variant | null;
            /**
             * Requests a hint about the valid range of values for the state of the
             * named action within `action_group`.
             *
             * If `NULL` is returned it either means that the action is not stateful
             * or that there is no hint about the valid range of values for the
             * state of the action.
             *
             * If a [type`GLib`.Variant] array is returned then each item in the array is a
             * possible value for the state.  If a [type`GLib`.Variant] pair (ie: two-tuple) is
             * returned then the tuple specifies the inclusive lower and upper bound
             * of valid values for the state.
             *
             * In any case, the information is merely a hint.  It may be possible to
             * have a state value outside of the hinted range and setting a value
             * within the range may fail.
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             * @returns the state range hint
             */
            get_action_state_hint(action_name: string): GLib.Variant | null;
            /**
             * Queries the type of the state of the named action within
             * `action_group`.
             *
             * If the action is stateful then this function returns the
             * [type`GLib`.VariantType] of the state.  All calls to
             * [method`Gio`.ActionGroup.change_action_state] must give a [type`GLib`.Variant] of this
             * type and [method`Gio`.ActionGroup.get_action_state] will return a [type`GLib`.Variant]
             * of the same type.
             *
             * If the action is not stateful then this function will return `NULL`.
             * In that case, [method`Gio`.ActionGroup.get_action_state] will return `NULL`
             * and you must not call [method`Gio`.ActionGroup.change_action_state].
             *
             * The state type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different state type.
             * @param action_name the name of the action to query
             * @returns the state type, if the action is stateful
             */
            get_action_state_type(action_name: string): GLib.VariantType | null;
            /**
             * Checks if the named action exists within `action_group`.
             * @param action_name the name of the action to check for
             * @returns whether the named action exists
             */
            has_action(action_name: string): boolean;
            /**
             * Lists the actions contained within `action_group`.
             *
             * The caller is responsible for freeing the list with [func`GLib`.strfreev] when
             * it is no longer required.
             * @returns a `NULL`-terminated array   of the names of the actions in the group
             */
            list_actions(): string[];
            /**
             * Queries all aspects of the named action within an `action_group`.
             *
             * This function acquires the information available from
             * [method`Gio`.ActionGroup.has_action], [method`Gio`.ActionGroup.get_action_enabled],
             * [method`Gio`.ActionGroup.get_action_parameter_type],
             * [method`Gio`.ActionGroup.get_action_state_type],
             * [method`Gio`.ActionGroup.get_action_state_hint] and
             * [method`Gio`.ActionGroup.get_action_state] with a single function call.
             *
             * This provides two main benefits.
             *
             * The first is the improvement in efficiency that comes with not having
             * to perform repeated lookups of the action in order to discover
             * different things about it.  The second is that implementing
             * [type`Gio`.ActionGroup] can now be done by only overriding this one virtual
             * function.
             *
             * The interface provides a default implementation of this function that
             * calls the individual functions, as required, to fetch the
             * information.  The interface also provides default implementations of
             * those functions that call this function.  All implementations,
             * therefore, must override either this function or all of the others.
             *
             * If the action exists, `TRUE` is returned and any of the requested
             * fields (as indicated by having a non-`NULL` reference passed in) are
             * filled.  If the action doesn’t exist, `FALSE` is returned and the
             * fields may or may not have been modified.
             * @param action_name the name of an action in the group
             * @returns `TRUE` if the action exists, else `FALSE`
             */
            query_action(
                action_name: string,
            ): [
                boolean,
                boolean,
                GLib.VariantType | null,
                GLib.VariantType | null,
                GLib.Variant | null,
                GLib.Variant | null,
            ];
            /**
             * Emits the [signal`Gio`.ActionGroup::action-added] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            vfunc_action_added(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-enabled-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param enabled whether the action is now enabled
             */
            vfunc_action_enabled_changed(action_name: string, enabled: boolean): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-removed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            vfunc_action_removed(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-state-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param state the new state of the named action
             */
            vfunc_action_state_changed(action_name: string, state: GLib.Variant): void;
            /**
             * Activate the named action within `action_group`.
             *
             * If the action is expecting a parameter, then the correct type of
             * parameter must be given as `parameter`.  If the action is expecting no
             * parameters then `parameter` must be `NULL`.  See
             * [method`Gio`.ActionGroup.get_action_parameter_type].
             *
             * If the [type`Gio`.ActionGroup] implementation supports asynchronous remote
             * activation over D-Bus, this call may return before the relevant
             * D-Bus traffic has been sent, or any replies have been received. In
             * order to block on such asynchronous activation calls,
             * [method`Gio`.DBusConnection.flush] should be called prior to the code, which
             * depends on the result of the action activation. Without flushing
             * the D-Bus connection, there is no guarantee that the action would
             * have been activated.
             *
             * The following code which runs in a remote app instance, shows an
             * example of a ‘quit’ action being activated on the primary app
             * instance over D-Bus. Here [method`Gio`.DBusConnection.flush] is called
             * before `exit()`. Without `g_dbus_connection_flush()`, the ‘quit’ action
             * may fail to be activated on the primary instance.
             *
             * ```c
             * // call ‘quit’ action on primary instance
             * g_action_group_activate_action (G_ACTION_GROUP (app), "quit", NULL);
             *
             * // make sure the action is activated now
             * g_dbus_connection_flush (…);
             *
             * g_debug ("Application has been terminated. Exiting.");
             *
             * exit (0);
             * ```
             * @param action_name the name of the action to activate
             * @param parameter parameters to the activation
             */
            vfunc_activate_action(action_name: string, parameter?: GLib.Variant | null): void;
            /**
             * Request for the state of the named action within `action_group` to be
             * changed to `value`.
             *
             * The action must be stateful and `value` must be of the correct type.
             * See [method`Gio`.ActionGroup.get_action_state_type].
             *
             * This call merely requests a change.  The action may refuse to change
             * its state or may change its state to something other than `value`.
             * See [method`Gio`.ActionGroup.get_action_state_hint].
             *
             * If the `value` GVariant is floating, it is consumed.
             * @param action_name the name of the action to request the change on
             * @param value the new state
             */
            vfunc_change_action_state(action_name: string, value: GLib.Variant): void;
            /**
             * Checks if the named action within `action_group` is currently enabled.
             *
             * An action must be enabled in order to be activated or in order to
             * have its state changed from outside callers.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_enabled(action_name: string): boolean;
            /**
             * Queries the type of the parameter that must be given when activating
             * the named action within `action_group`.
             *
             * When activating the action using [method`Gio`.ActionGroup.activate_action],
             * the [type`GLib`.Variant] given to that function must be of the type returned
             * by this function.
             *
             * In the case that this function returns `NULL`, you must not give any
             * [type`GLib`.Variant], but `NULL` instead.
             *
             * The parameter type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different parameter type.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_parameter_type(action_name: string): GLib.VariantType | null;
            /**
             * Queries the current state of the named action within `action_group`.
             *
             * If the action is not stateful then `NULL` will be returned.  If the
             * action is stateful then the type of the return value is the type
             * given by [method`Gio`.ActionGroup.get_action_state_type].
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state(action_name: string): GLib.Variant | null;
            /**
             * Requests a hint about the valid range of values for the state of the
             * named action within `action_group`.
             *
             * If `NULL` is returned it either means that the action is not stateful
             * or that there is no hint about the valid range of values for the
             * state of the action.
             *
             * If a [type`GLib`.Variant] array is returned then each item in the array is a
             * possible value for the state.  If a [type`GLib`.Variant] pair (ie: two-tuple) is
             * returned then the tuple specifies the inclusive lower and upper bound
             * of valid values for the state.
             *
             * In any case, the information is merely a hint.  It may be possible to
             * have a state value outside of the hinted range and setting a value
             * within the range may fail.
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state_hint(action_name: string): GLib.Variant | null;
            /**
             * Queries the type of the state of the named action within
             * `action_group`.
             *
             * If the action is stateful then this function returns the
             * [type`GLib`.VariantType] of the state.  All calls to
             * [method`Gio`.ActionGroup.change_action_state] must give a [type`GLib`.Variant] of this
             * type and [method`Gio`.ActionGroup.get_action_state] will return a [type`GLib`.Variant]
             * of the same type.
             *
             * If the action is not stateful then this function will return `NULL`.
             * In that case, [method`Gio`.ActionGroup.get_action_state] will return `NULL`
             * and you must not call [method`Gio`.ActionGroup.change_action_state].
             *
             * The state type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different state type.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state_type(action_name: string): GLib.VariantType | null;
            /**
             * Checks if the named action exists within `action_group`.
             * @param action_name the name of the action to check for
             */
            vfunc_has_action(action_name: string): boolean;
            /**
             * Lists the actions contained within `action_group`.
             *
             * The caller is responsible for freeing the list with [func`GLib`.strfreev] when
             * it is no longer required.
             */
            vfunc_list_actions(): string[];
            /**
             * Queries all aspects of the named action within an `action_group`.
             *
             * This function acquires the information available from
             * [method`Gio`.ActionGroup.has_action], [method`Gio`.ActionGroup.get_action_enabled],
             * [method`Gio`.ActionGroup.get_action_parameter_type],
             * [method`Gio`.ActionGroup.get_action_state_type],
             * [method`Gio`.ActionGroup.get_action_state_hint] and
             * [method`Gio`.ActionGroup.get_action_state] with a single function call.
             *
             * This provides two main benefits.
             *
             * The first is the improvement in efficiency that comes with not having
             * to perform repeated lookups of the action in order to discover
             * different things about it.  The second is that implementing
             * [type`Gio`.ActionGroup] can now be done by only overriding this one virtual
             * function.
             *
             * The interface provides a default implementation of this function that
             * calls the individual functions, as required, to fetch the
             * information.  The interface also provides default implementations of
             * those functions that call this function.  All implementations,
             * therefore, must override either this function or all of the others.
             *
             * If the action exists, `TRUE` is returned and any of the requested
             * fields (as indicated by having a non-`NULL` reference passed in) are
             * filled.  If the action doesn’t exist, `FALSE` is returned and the
             * fields may or may not have been modified.
             * @param action_name the name of an action in the group
             */
            vfunc_query_action(
                action_name: string,
            ): [
                boolean,
                boolean,
                GLib.VariantType | null,
                GLib.VariantType | null,
                GLib.Variant | null,
                GLib.Variant | null,
            ];
            /**
             * Adds an action to the `action_map`.
             *
             * If the action map already contains an action with the same name
             * as `action` then the old action is dropped from the action map.
             *
             * The action map takes its own reference on `action`.
             * @param action a [iface@Gio.Action]
             */
            add_action(action: Gio.Action): void;
            /**
             * A convenience function for creating multiple simple actions.
             * See Gio.ActionEntryObj for the structure of the action entry.
             * @param entries Array of action entries to add
             */
            add_action_entries(entries: Gio.ActionEntryObj[]): void;
            /**
             * Looks up the action with the name `action_name` in `action_map`.
             *
             * If no such action exists, returns `NULL`.
             * @param action_name the name of an action
             * @returns a [iface@Gio.Action]
             */
            lookup_action(action_name: string): Gio.Action | null;
            /**
             * Removes the named action from the action map.
             *
             * If no action of this name is in the map then nothing happens.
             * @param action_name the name of the action
             */
            remove_action(action_name: string): void;
            /**
             * Remove actions from a [iface`Gio`.ActionMap]. This is meant as the reverse of
             * [method`Gio`.ActionMap.add_action_entries].
             *
             *
             * ```c
             * static const GActionEntry entries[] = {
             *     { "quit",         activate_quit              },
             *     { "print-string", activate_print_string, "s" }
             * };
             *
             * void
             * add_actions (GActionMap *map)
             * {
             *   g_action_map_add_action_entries (map, entries, G_N_ELEMENTS (entries), NULL);
             * }
             *
             * void
             * remove_actions (GActionMap *map)
             * {
             *   g_action_map_remove_action_entries (map, entries, G_N_ELEMENTS (entries));
             * }
             * ```
             * @param entries a pointer to   the first item in an array of [struct@Gio.ActionEntry] structs
             */
            remove_action_entries(entries: Gio.ActionEntry[]): void;
            /**
             * Adds an action to the `action_map`.
             *
             * If the action map already contains an action with the same name
             * as `action` then the old action is dropped from the action map.
             *
             * The action map takes its own reference on `action`.
             * @param action a [iface@Gio.Action]
             */
            vfunc_add_action(action: Gio.Action): void;
            /**
             * Looks up the action with the name `action_name` in `action_map`.
             *
             * If no such action exists, returns `NULL`.
             * @param action_name the name of an action
             */
            vfunc_lookup_action(action_name: string): Gio.Action | null;
            /**
             * Removes the named action from the action map.
             *
             * If no action of this name is in the map then nothing happens.
             * @param action_name the name of the action
             */
            vfunc_remove_action(action_name: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * Enables or disables an action installed with
             * [method`Gtk`.WidgetClass.install_action].
             * @param action_name action name, such as "clipboard.paste"
             * @param enabled whether the action is now enabled
             */
            action_set_enabled(action_name: string, enabled: boolean): void;
            /**
             * Activates the widget.
             *
             * The activation will emit the signal set using
             * [method`Gtk`.WidgetClass.set_activate_signal]
             * during class initialization.
             *
             * Activation is what happens when you press <kbd>Enter</kbd>
             * on a widget.
             *
             * If you wish to handle the activation keybinding yourself,
             * it is recommended to use [method`Gtk`.WidgetClass.add_shortcut]
             * with an action created with [ctor`Gtk`.SignalAction.new].
             *
             * If `widget` is not activatable, the function returns false.
             * @returns true if the widget was activated
             */
            activate(): boolean;
            /**
             * Activates the `default.activate` action for the widget.
             *
             * The action is looked up in the same was as for
             * [method`Gtk`.Widget.activate_action].
             */
            activate_default(): void;
            /**
             * Adds an event controller to the widget.
             *
             * The event controllers of a widget handle the events that are
             * propagated to the widget.
             *
             * You will usually want to call this function right after
             * creating any kind of [class`Gtk`.EventController].
             * @param controller an event controller that hasn't been   added to a widget yet
             */
            add_controller(controller: Gtk.EventController): void;
            /**
             * Adds a style class to the widget.
             *
             * After calling this function, the widget’s style will match
             * for `css_class,` according to CSS matching rules.
             *
             * Use [method`Gtk`.Widget.remove_css_class] to remove the
             * style again.
             * @param css_class style class to add to @widget, without the leading period
             */
            add_css_class(css_class: string): void;
            /**
             * Adds a widget to the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * Note that the list of mnemonic labels for the widget is cleared
             * when the widget is destroyed, so the caller must make sure
             * to update its internal state at this point as well.
             * @param label a widget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Gtk.Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame.
             *
             * Until the tick callback is removed, it will be called frequently
             * (usually at the frame rate of the output device or as quickly as
             * the application can be repainted, whichever is slower). For this
             * reason, is most suitable for handling graphics that change every
             * frame or every few frames.
             *
             * The tick callback does not automatically imply a relayout or repaint.
             * If you want a repaint or relayout, and aren’t changing widget properties
             * that would trigger that (for example, changing the text of a label),
             * then you will have to call [method`Gtk`.Widget.queue_resize] or
             * [method`Gtk`.Widget.queue_draw] yourself.
             *
             * [method`Gdk`.FrameClock.get_frame_time] should generally be used
             * for timing continuous animations and
             * [method`Gdk`.FrameTimings.get_predicted_presentation_time] should be
             * used if you are trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * [signal`Gdk`.FrameClock::update] signal of the frame clock, since you
             * don't have to worry about when a frame clock is assigned to a widget.
             *
             * To remove a tick callback, pass the ID that is returned by this function
             * to [method`Gtk`.Widget.remove_tick_callback].
             * @param callback function   to call for updating animations
             * @returns an ID for this callback
             */
            add_tick_callback(callback: Gtk.TickCallback): number;
            /**
             * Assigns size, position, (optionally) a baseline and transform
             * to a child widget.
             *
             * In this function, the allocation and baseline may be adjusted.
             * The given allocation will be forced to be bigger than the
             * widget's minimum size, as well as at least 0×0 in size.
             *
             * This function is only used by widget implementations.
             *
             * For a version that does not take a transform, see
             * [method`Gtk`.Widget.size_allocate].
             * @param width new width
             * @param height new height
             * @param baseline new baseline, or -1
             * @param transform transformation to be applied
             */
            allocate(width: number, height: number, baseline: number, transform?: Gsk.Transform | null): void;
            /**
             * Called by widgets as the user moves around the window using
             * keyboard shortcuts.
             *
             * The `direction` argument indicates what kind of motion is taking
             * place (up, down, left, right, tab forward, tab backward).
             *
             * This function calls the [vfunc`Gtk`.Widget.focus] virtual function;
             * widgets can override the virtual function in order to implement
             * appropriate focus behavior.
             *
             * The default `focus()` virtual function for a widget should return
             * true if moving in `direction` left the focus on a focusable location
             * inside that widget, and false if moving in `direction` moved the focus
             * outside the widget. When returning true, widgets normally call
             * [method`Gtk`.Widget.grab_focus] to place the focus accordingly;
             * when returning false, they don’t modify the current focus location.
             *
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use [method`Gtk`.Widget.grab_focus] to move
             * the focus to a particular widget.
             * @param direction direction of focus movement
             * @returns true if focus ended up inside @widget
             */
            child_focus(direction: Gtk.DirectionType | null): boolean;
            /**
             * Computes the bounds for `widget` in the coordinate space of `target`.
             *
             * The bounds of widget are (the bounding box of) the region that it is
             * expected to draw in. See the [coordinate system](coordinates.html)
             * overview to learn more.
             *
             * If the operation is successful, true is returned. If `widget` has no
             * bounds or the bounds cannot be expressed in `target'`s coordinate space
             * (for example if both widgets are in different windows), false is
             * returned and `bounds` is set to the zero rectangle.
             *
             * It is valid for `widget` and `target` to be the same widget.
             * @param target the target widget
             * @returns true if the bounds could be computed
             */
            compute_bounds(target: Gtk.Widget): [boolean, Graphene.Rect];
            /**
             * Computes whether a parent widget should give this widget
             * extra space when possible.
             *
             * Widgets with children should check this, rather than looking at
             * [method`Gtk`.Widget.get_hexpand] or [method`Gtk`.Widget.get_vexpand].
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Gtk.Orientation | null): boolean;
            /**
             * Translates the given `point` in `widget'`s coordinates to coordinates
             * in `target’`s coordinate system.
             *
             * In order to perform this operation, both widgets must share a
             * a common ancestor. If that is not the case, `out_point` is set
             * to (0, 0) and false is returned.
             * @param target the widget to transform into
             * @param point a point in @widget's coordinate system
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            compute_point(target: Gtk.Widget, point: Graphene.Point): [boolean, Graphene.Point];
            /**
             * Computes a matrix suitable to describe a transformation from
             * `widget'`s coordinate system into `target'`s coordinate system.
             *
             * The transform can not be computed in certain cases, for example
             * when `widget` and `target` do not share a common ancestor. In that
             * case `out_transform` gets set to the identity matrix.
             *
             * To learn more about widget coordinate systems, see the coordinate
             * system [overview](coordinates.html).
             * @param target the target widget that the matrix will transform to
             * @returns true if the transform could be computed
             */
            compute_transform(target: Gtk.Widget): [boolean, Graphene.Matrix];
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             * @returns true if @widget contains the point (x, y)
             */
            contains(x: number, y: number): boolean;
            /**
             * Creates a new `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map,
             * font options, font description, and base direction set.
             *
             * See also [method`Gtk`.Widget.get_pango_context].
             * @returns the new `PangoContext`
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new `PangoLayout` that is configured for the widget.
             *
             * The `PangoLayout` will have the appropriate font map,
             * font description, and base direction set.
             *
             * If you keep a `PangoLayout` created in this way around,
             * you need to re-create it when the widgets `PangoContext`
             * is replaced. This can be tracked by listening to changes
             * of the [property`Gtk`.Widget:root] property on the widget.
             * @param text text to set on the layout
             * @returns the new `PangoLayout`
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Clears the template children for the widget.
             *
             * This function is the opposite of [method`Gtk`.Widget.init_template],
             * and it is used to clear all the template children from a widget
             * instance. If you bound a template child to a field in the instance
             * structure, or in the instance private data structure, the field will
             * be set to `NULL` after this function returns.
             *
             * You should call this function inside the `GObjectClass.dispose()`
             * implementation of any widget that called [method`Gtk`.Widget.init_template].
             * Typically, you will want to call this function last, right before
             * chaining up to the parent type's dispose implementation, e.g.
             *
             * ```c
             * static void
             * some_widget_dispose (GObject *gobject)
             * {
             *   SomeWidget *self = SOME_WIDGET (gobject);
             *
             *   // Clear the template data for SomeWidget
             *   gtk_widget_dispose_template (GTK_WIDGET (self), SOME_TYPE_WIDGET);
             *
             *   G_OBJECT_CLASS (some_widget_parent_class)->dispose (gobject);
             * }
             * ```
             * @param widget_type the type of the widget to finalize the template for
             */
            dispose_template(widget_type: GObject.GType): void;
            /**
             * Checks to see if a drag movement has passed the GTK drag threshold.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns true if the drag threshold has been passed
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Notifies the user about an input-related error on the widget.
             *
             * If the [property`Gtk`.Settings:gtk-error-bell] setting is true,
             * it calls [method`Gdk`.Surface.beep], otherwise it does nothing.
             *
             * Note that the effect of [method`Gdk`.Surface.beep] can be configured
             * in many ways, depending on the windowing backend and the desktop
             * environment or window manager that is used.
             */
            error_bell(): void;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidget`Class.snapshot() function, and when allocating
             * child widgets in `GtkWidget`Class.size_allocate().
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Returns the width that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a layout widget: a widget’s allocation
             * will be its “adjusted” allocation, that is, the widget’s parent
             * typically calls [method`Gtk`.Widget.size_allocate] with an allocation,
             * and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * [method`Gtk`.Widget.get_allocation] returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * [method`Gtk`.Widget.size_allocate] allocation, however.
             *
             * So a layout widget is guaranteed that its children stay inside
             * the assigned bounds, but not that they have exactly the bounds the
             * widget assigned.
             */
            get_allocation(): Gtk.Allocation;
            /**
             * Gets the first ancestor of the widget with type `widget_type`.
             *
             * For example, `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)`
             * gets the first `GtkBox` that’s an ancestor of `widget`. No
             * reference will be added to the returned widget; it should
             * not be unreferenced.
             *
             * Note that unlike [method`Gtk`.Widget.is_ancestor], this function
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget
             */
            get_ancestor(widget_type: GObject.GType): Gtk.Widget | null;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidgetClass.snapshot()` function, and when allocating
             * child widgets in `GtkWidgetClass.size_allocate()`.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_baseline(): number;
            /**
             * Determines whether the input focus can enter the widget or any
             * of its children.
             *
             * See [method`Gtk`.Widget.set_can_focus].
             * @returns true if the input focus can enter @widget
             */
            get_can_focus(): boolean;
            /**
             * Queries whether the widget can be the target of pointer events.
             * @returns true if @widget can receive pointer events
             */
            get_can_target(): boolean;
            /**
             * Gets the value set with [method`Gtk`.Widget.set_child_visible].
             *
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @returns true if the widget is mapped with the parent
             */
            get_child_visible(): boolean;
            /**
             * Gets the clipboard object for the widget.
             *
             * This is a utility function to get the clipboard object for the
             * display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_clipboard(): Gdk.Clipboard;
            /**
             * Gets the current foreground color for the widget’s style.
             *
             * This function should only be used in snapshot
             * implementations that need to do custom drawing
             * with the foreground color.
             */
            get_color(): Gdk.RGBA;
            /**
             * Returns the list of style classes applied to the widget.
             * @returns a `NULL`-terminated list of   css classes currently applied to @widget
             */
            get_css_classes(): string[];
            /**
             * Returns the CSS name of the widget.
             * @returns the CSS name
             */
            get_css_name(): string;
            /**
             * Gets the cursor set on the widget.
             *
             * See [method`Gtk`.Widget.set_cursor] for details.
             * @returns the cursor   that is set on @widget
             */
            get_cursor(): Gdk.Cursor | null;
            /**
             * Gets the reading direction for the widget.
             *
             * See [method`Gtk`.Widget.set_direction].
             * @returns the reading direction for the widget
             */
            get_direction(): Gtk.TextDirection;
            /**
             * Get the display for the window that the widget belongs to.
             *
             * This function can only be called after the widget has been
             * added to a widget hierarchy with a `GtkRoot` at the top.
             *
             * In general, you should only create display-specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the display for this widget
             */
            get_display(): Gdk.Display;
            /**
             * Returns the widget’s first child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's first child
             */
            get_first_child(): Gtk.Widget | null;
            /**
             * Returns the focus child of the widget.
             * @returns the current focus   child of @widget
             */
            get_focus_child(): Gtk.Widget | null;
            /**
             * Returns whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * See [method`Gtk`.Widget.set_focus_on_click].
             * @returns true if the widget should grab focus when it is   clicked with the mouse
             */
            get_focus_on_click(): boolean;
            /**
             * Determines whether the widget can own the input focus.
             *
             * See [method`Gtk`.Widget.set_focusable].
             * @returns true if @widget can own the input focus
             */
            get_focusable(): boolean;
            /**
             * Gets the font map of the widget.
             *
             * See [method`Gtk`.Widget.set_font_map].
             * @returns the font map of @widget
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the `cairo_font_options_t` of the widget.
             *
             * Seee [method`Gtk`.Widget.set_font_options].
             * @returns the `cairo_font_options_t` of widget
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget.
             *
             * The frame clock is a global “ticker” that can be used to drive
             * animations and repaints. The most common reason to get the frame
             * clock is to call [method`Gdk`.FrameClock.get_frame_time], in order
             * to get a time to use for animating. For example you might record
             * the start of the animation with an initial value from
             * [method`Gdk`.FrameClock.get_frame_time], and then update the animation
             * by calling [method`Gdk`.FrameClock.get_frame_time] again during each repaint.
             *
             * [method`Gdk`.FrameClock.request_phase] will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a widget,
             * you have to use [method`Gtk`.Widget.queue_draw] which invalidates the
             * widget (thus scheduling it to receive a draw on the next frame).
             * [method`Gtk`.Widget.queue_draw] will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is mapped.
             * Reparenting a widget (which implies a temporary unmap) can change
             * the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns the frame clock
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the horizontal alignment of the widget.
             *
             * For backwards compatibility reasons this method will never return
             * one of the baseline alignments, but instead it will convert it to
             * [enum`Gtk`.Align.fill] or [enum`Gtk`.Align.center].
             *
             * Baselines are not supported for horizontal alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Gtk.Align;
            /**
             * Returns the current value of the `has-tooltip` property.
             * @returns current value of `has-tooltip` on @widget
             */
            get_has_tooltip(): boolean;
            /**
             * Returns the content height of the widget.
             *
             * This function returns the height passed to its
             * size-allocate implementation, which is the height you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The height of @widget
             */
            get_height(): number;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Widgets with children should use [method`Gtk`.Widget.compute_expand]
             * rather than this function, to see whether any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether the `hexpand` flag has been explicitly set.
             *
             * If [property`Gtk`.Widget:hexpand] property is set, then it
             * overrides any computed expand value based on child widgets.
             * If `hexpand` is not set, then the expand value depends on
             * whether any children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Returns the widget’s last child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's last child
             */
            get_last_child(): Gtk.Widget | null;
            /**
             * Retrieves the layout manager of the widget.
             *
             * See [method`Gtk`.Widget.set_layout_manager].
             * @returns the layout manager of @widget
             */
            get_layout_manager(): Gtk.LayoutManager | null;
            /**
             * Gets the value of the [property`Gtk`.Widget:limit-events] property.
             */
            get_limit_events(): boolean;
            /**
             * Returns whether the widget is mapped.
             * @returns true if the widget is mapped
             */
            get_mapped(): boolean;
            /**
             * Gets the bottom margin of the widget.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the end margin of the widget.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the start margin of the widget.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the top margin of the widget.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Retrieves the name of a widget.
             *
             * See [method`Gtk`.Widget.set_name] for the significance of widget names.
             * @returns name of the widget
             */
            get_name(): string;
            /**
             * Returns the nearest `GtkNative` ancestor of the widget.
             *
             * This function will return `NULL` if the widget is not
             * contained inside a widget tree with a native ancestor.
             *
             * `GtkNative` widgets will return themselves here.
             * @returns the `GtkNative` ancestor of @widget
             */
            get_native(): Gtk.Native | null;
            /**
             * Returns the widget’s next sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's next sibling
             */
            get_next_sibling(): Gtk.Widget | null;
            /**
             * Fetches the requested opacity for the widget.
             *
             * See [method`Gtk`.Widget.set_opacity].
             * @returns the requested opacity for this widget
             */
            get_opacity(): number;
            /**
             * Returns the widget’s overflow value.
             * @returns The widget's overflow value
             */
            get_overflow(): Gtk.Overflow;
            /**
             * Gets a `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map, font description,
             * and base direction set.
             *
             * Unlike the context returned by [method`Gtk`.Widget.create_pango_context],
             * this context is owned by the widget (it can be used until the screen
             * for the widget changes or the widget is removed from its toplevel),
             * and will be updated to match any changes to the widget’s attributes.
             * This can be tracked by listening to changes of the
             * [property`Gtk`.Widget:root] property on the widget.
             * @returns the `PangoContext` for the widget
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent widget of the widget.
             * @returns the parent widget of @widget
             */
            get_parent(): Gtk.Widget | null;
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as `GtkFixed`.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since
             * the required height for the natural width is generally smaller than the
             * required height for the minimum width.
             *
             * Use [method`Gtk`.Widget.measure] if you want to support baseline alignment.
             */
            get_preferred_size(): [Gtk.Requisition | null, Gtk.Requisition | null];
            /**
             * Returns the widget’s previous sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's previous sibling
             */
            get_prev_sibling(): Gtk.Widget | null;
            /**
             * Gets the primary clipboard of the widget.
             *
             * This is a utility function to get the primary clipboard object
             * for the display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_primary_clipboard(): Gdk.Clipboard;
            /**
             * Determines whether the widget is realized.
             * @returns true if @widget is realized
             */
            get_realized(): boolean;
            /**
             * Determines whether the widget is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See [method`Gtk`.Widget.set_receives_default].
             * @returns true if @widget acts as the default widget when focused
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             * @returns The `GtkSizeRequestMode` preferred by @widget.
             */
            get_request_mode(): Gtk.SizeRequestMode;
            /**
             * Returns the `GtkRoot` widget of the widget.
             *
             * This function will return `NULL` if the widget is not contained
             * inside a widget tree with a root widget.
             *
             * `GtkRoot` widgets will return themselves here.
             * @returns the root widget of @widget
             */
            get_root(): Gtk.Root | null;
            /**
             * Retrieves the internal scale factor that maps from window
             * coordinates to the actual device pixels.
             *
             * On traditional systems this is 1, on high density outputs,
             * it can be a higher value (typically 2).
             *
             * See [method`Gdk`.Surface.get_scale_factor].
             *
             * Note that modern systems may support *fractional* scaling,
             * where the scale factor is not an integer. On such systems,
             * this function will return the next higher integer value,
             * but you probably want to use [method`Gdk`.Surface.get_scale]
             * to get the fractional scale value.
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Returns the widget’s sensitivity.
             *
             * This function returns the value that has been set using
             * [method`Gtk`.Widget.set_sensitive]).
             *
             * The effective sensitivity of a widget is however determined
             * by both its own and its parent widget’s sensitivity.
             * See [method`Gtk`.Widget.is_sensitive].
             * @returns true if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for the widget.
             *
             * Note that this function can only be called when the `GtkWidget`
             * is attached to a toplevel, since the settings object is specific
             * to a particular display. If you want to monitor the widget for
             * changes in its settings, connect to the `notify::display` signal.
             * @returns the relevant settings object
             */
            get_settings(): Gtk.Settings;
            /**
             * Returns the content width or height of the widget.
             *
             * Which dimension is returned depends on `orientation`.
             *
             * This is equivalent to calling [method`Gtk`.Widget.get_width]
             * for [enum`Gtk`.Orientation.horizontal] or [method`Gtk`.Widget.get_height]
             * for [enum`Gtk`.Orientation.vertical], but can be used when
             * writing orientation-independent code, such as when
             * implementing [iface`Gtk`.Orientable] widgets.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @param orientation the orientation to query
             * @returns the size of @widget in @orientation
             */
            get_size(orientation: Gtk.Orientation | null): number;
            /**
             * Gets the size request that was explicitly set for the widget.
             *
             * A value of -1 stored in `width` or `height` indicates that that
             * dimension has not been set explicitly and the natural requisition
             * of the widget will be used instead.
             *
             * See [method`Gtk`.Widget.set_size_request].
             *
             * To get the size a widget will actually request, call
             * [method`Gtk`.Widget.measure] instead of this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget state as a flag set.
             *
             * It is worth mentioning that the effective [flags`Gtk`.StateFlags.insensitive]
             * state will be returned, that is, also based on parent insensitivity,
             * even if `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * [flags`Gtk`.StateFlags] to pass to a [class`Gtk`.StyleContext]
             * method, you should look at [method`Gtk`.StyleContext.get_state].
             * @returns the state flags of widget
             */
            get_state_flags(): Gtk.StateFlags;
            /**
             * Returns the style context associated to the widget.
             *
             * The returned object is guaranteed to be the same
             * for the lifetime of `widget`.
             * @returns the widgets style context
             */
            get_style_context(): Gtk.StyleContext;
            /**
             * Fetches an object build from the template XML for `widget_type` in
             * the widget.
             *
             * This will only report children which were previously declared
             * with [method`Gtk`.WidgetClass.bind_template_child_full] or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private
             * to the `widget_type` which declared the child and is meant for language
             * bindings which cannot easily make use of the GObject structure offsets.
             * @param widget_type The `GType` to get a template child for
             * @param name ID of the child defined in the template XML
             * @returns the object built in the template XML with   the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the tooltip has not been set using
             * [method`Gtk`.Widget.set_tooltip_markup], this
             * function returns `NULL`.
             * @returns the tooltip text
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the `widget'`s tooltip was set using
             * [method`Gtk`.Widget.set_tooltip_markup],
             * this function will return the escaped text.
             * @returns the tooltip text
             */
            get_tooltip_text(): string | null;
            /**
             * Gets the vertical alignment of the widget.
             * @returns the vertical alignment of @widget
             */
            get_valign(): Gtk.Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.get_hexpand] for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether the `vexpand` flag has been explicitly set.
             *
             * See [method`Gtk`.Widget.get_hexpand_set] for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible.
             *
             * If you want to take into account whether the widget’s
             * parent is also marked as visible, use
             * [method`Gtk`.Widget.is_visible] instead.
             *
             * This function does not check if the widget is
             * obscured in any way.
             *
             * See [method`Gtk`.Widget.set_visible].
             * @returns true if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Returns the content width of the widget.
             *
             * This function returns the width passed to its
             * size-allocate implementation, which is the width you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The width of @widget
             */
            get_width(): number;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             * @returns true if focus is now inside @widget
             */
            grab_focus(): boolean;
            /**
             * Returns whether a style class is currently applied to the widget.
             * @param css_class style class, without the leading period
             * @returns true if @css_class is currently applied to @widget
             */
            has_css_class(css_class: string): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus.
             *
             * This is a convenience function that takes into account whether
             * focus indication should currently be shown in the toplevel window
             * of `widget`. See [method`Gtk`.Window.get_focus_visible] for more
             * information about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * [method`Gtk`.Widget.has_focus].
             * @returns true if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Returns whether the widget is currently being destroyed.
             *
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns true if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates.
             *
             * This function must be called in the instance initializer
             * for any class which assigned itself a template using
             * [method`Gtk`.WidgetClass.set_template].
             *
             * It is important to call this function in the instance initializer
             * of a widget subclass and not in `GObject.constructed()` or
             * `GObject.constructor()` for two reasons:
             *
             *  - derived widgets will assume that the composite widgets
             *    defined by its parent classes have been created in their
             *    relative instance initializers
             *  - when calling `g_object_new()` on a widget with composite templates,
             *    it’s important to build the composite widgets before the construct
             *    properties are set. Properties passed to `g_object_new()` should
             *    take precedence over properties set in the private template XML
             *
             * A good rule of thumb is to call this function as the first thing in
             * an instance initialization function.
             */
            init_template(): void;
            /**
             * Inserts an action group into the widget's actions.
             *
             * Children of `widget` that implement [iface`Gtk`.Actionable] can
             * then be associated with actions in `group` by setting their
             * “action-name” to `prefix`.`action-name`.
             *
             * Note that inheritance is defined for individual actions. I.e.
             * even if you insert a group with prefix `prefix,` actions with
             * the same prefix will still be inherited from the parent, unless
             * the group contains an action with the same name.
             *
             * If `group` is `NULL`, a previously inserted group for `name` is
             * removed from `widget`.
             * @param name the prefix for actions in @group
             * @param group an action group
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed after `previous_sibling,` or at the beginning if
             * `previous_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_prev_sibling (widget)`
             * will return `previous_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this
             * function can also be used to reorder `widget` in the child widget
             * list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param previous_sibling the new previous sibling of @widget
             */
            insert_after(parent: Gtk.Widget, previous_sibling?: Gtk.Widget | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed before `next_sibling,` or at the end if
             * `next_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_next_sibling (widget)`
             * will return `next_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this function
             * can also be used to reorder `widget` in the child widget list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param next_sibling the new next sibling of @widget
             */
            insert_before(parent: Gtk.Widget, next_sibling?: Gtk.Widget | null): void;
            /**
             * Determines whether the widget is a descendent of `ancestor`.
             * @param ancestor another `GtkWidget`
             * @returns true if @ancestor contains @widget as a child,   grandchild, great grandchild, etc
             */
            is_ancestor(ancestor: Gtk.Widget): boolean;
            /**
             * Determines whether the widget can be drawn to.
             *
             * A widget can be drawn if it is mapped and visible.
             * @returns true if @widget is drawable
             */
            is_drawable(): boolean;
            /**
             * Determines if the widget is the focus widget within its
             * toplevel.
             *
             * This does not mean that the [property`Gtk`.Widget:has-focus]
             * property is necessarily set; [property`Gtk`.Widget:has-focus]
             * will only be set if the toplevel widget additionally has the
             * global input focus.
             * @returns true if the widget is the focus widget
             */
            is_focus(): boolean;
            /**
             * Returns the widget’s effective sensitivity.
             *
             * This means it is sensitive itself and also its
             * parent widget is sensitive.
             * @returns true if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also [method`Gtk`.Widget.get_visible] and
             * [method`Gtk`.Widget.set_visible].
             * @returns true if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             * @returns true if stopping keyboard navigation is fine, false   if the emitting widget should try to handle the keyboard   navigation attempt in its parent widget
             */
            keynav_failed(direction: Gtk.DirectionType | null): boolean;
            /**
             * Returns the widgets for which this widget is the target of a
             * mnemonic.
             *
             * Typically, these widgets will be labels. See, for example,
             * [method`Gtk`.Label.set_mnemonic_widget].
             *
             * The widgets in the list are not individually referenced.
             * If you want to iterate through the list and perform actions
             * involving callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result, (GFunc)g_object_ref, NULL)`
             * first, and then unref all the widgets afterwards.
             * @returns the list   of mnemonic labels
             */
            list_mnemonic_labels(): Gtk.Widget[];
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            measure(orientation: Gtk.Orientation | null, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             * @returns true if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Returns a list model to track the children of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track children and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's children
             */
            observe_children(): Gio.ListModel;
            /**
             * Returns a list model to track the event controllers of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track controllers and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's controllers
             */
            observe_controllers(): Gio.ListModel;
            /**
             * Finds the descendant of the widget closest to a point.
             *
             * The point (x, y) must be given in widget coordinates, so (0, 0)
             * is assumed to be the top left of `widget'`s content area.
             *
             * Usually widgets will return `NULL` if the given coordinate is not
             * contained in `widget` checked via [method`Gtk`.Widget.contains].
             * Otherwise they will recursively try to find a child that does
             * not return `NULL`. Widgets are however free to customize their
             * picking algorithm.
             *
             * This function is used on the toplevel to determine the widget
             * below the mouse cursor for purposes of hover highlighting and
             * delivering events.
             * @param x x coordinate to test, relative to @widget's origin
             * @param y y coordinate to test, relative to @widget's origin
             * @param flags flags to influence what is picked
             * @returns the widget's descendant at (x, y)
             */
            pick(x: number, y: number, flags: Gtk.PickFlags | null): Gtk.Widget | null;
            /**
             * Flags the widget for a rerun of the [vfunc`Gtk`.Widget.size_allocate]
             * function.
             *
             * Use this function instead of [method`Gtk`.Widget.queue_resize]
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is [method`Gtk`.Widget.set_halign].
             *
             * This function is only for use in widget implementations.
             */
            queue_allocate(): void;
            /**
             * Schedules this widget to be redrawn.
             *
             * The redraw will happen in the paint phase
             * of the current or the next frame.
             *
             * This means `widget'`s [vfunc`Gtk`.Widget.snapshot]
             * implementation will be called.
             */
            queue_draw(): void;
            /**
             * Flags a widget to have its size renegotiated.
             *
             * This should be called when a widget for some reason has a new
             * size request. For example, when you change the text in a
             * [class`Gtk`.Label], the label queues a resize to ensure there’s
             * enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the [vfunc`Gtk`.Widget.size_allocate]
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * [vfunc`Gtk`.Widget.size_allocate] will be silently ignored.
             *
             * This function is only for use in widget implementations.
             */
            queue_resize(): void;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            realize(): void;
            /**
             * Removes an event controller from the widget.
             *
             * The removed event controller will not receive any more events,
             * and should not be used again.
             *
             * Widgets will remove all event controllers automatically when they
             * are destroyed, there is normally no need to call this function.
             * @param controller an event controller
             */
            remove_controller(controller: Gtk.EventController): void;
            /**
             * Removes a style from the widget.
             *
             * After this, the style of `widget` will stop matching for `css_class`.
             * @param css_class style class to remove from @widget, without the leading period
             */
            remove_css_class(css_class: string): void;
            /**
             * Removes a widget from the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * The widget must have previously been added to the list with
             * [method`Gtk`.Widget.add_mnemonic_label].
             * @param label a widget that is a mnemonic label for @widget
             */
            remove_mnemonic_label(label: Gtk.Widget): void;
            /**
             * Removes a tick callback previously registered with
             * [method`Gtk`.Widget.add_tick_callback].
             * @param id an ID returned by [method@Gtk.Widget.add_tick_callback]
             */
            remove_tick_callback(id: number): void;
            /**
             * Sets whether the input focus can enter the widget or
             * any of its children.
             *
             * Applications should set `can_focus` to false to mark a
             * widget as for pointer/touch use only.
             *
             * Note that having `can_focus` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and focusable and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param can_focus whether the input focus can enter   the widget or any of its children
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether the widget can be the target of pointer events.
             * @param can_target whether this widget should be able to   receive pointer events
             */
            set_can_target(can_target: boolean): void;
            /**
             * Sets whether the widget should be mapped along with its parent.
             *
             * The child visibility can be set for widget before it is added
             * to a container with [method`Gtk`.Widget.set_parent], to avoid
             * mapping children unnecessary before immediately unmapping them.
             * However it will be reset to its default state of true when the
             * widget is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @param child_visible whether @widget should be mapped along   with its parent
             */
            set_child_visible(child_visible: boolean): void;
            /**
             * Replaces the current style classes of the widget with `classes`.
             * @param classes `NULL`-terminated list of style classes
             */
            set_css_classes(classes: string[]): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * If the `cursor` is `NULL`, `widget` will use the cursor
             * inherited from its parent.
             * @param cursor the new cursor
             */
            set_cursor(cursor?: Gdk.Cursor | null): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * This is a utility function that creates a cursor via
             * [ctor`Gdk`.Cursor.new_from_name] and then sets it on `widget`
             * with [method`Gtk`.Widget.set_cursor]. See those functions for
             * details.
             *
             * On top of that, this function allows `name` to be `NULL`, which
             * will do the same as calling [method`Gtk`.Widget.set_cursor]
             * with a `NULL` cursor.
             * @param name the name of the cursor
             */
            set_cursor_from_name(name?: string | null): void;
            /**
             * Sets the reading direction on the widget.
             *
             * This direction controls the primary direction for widgets
             * containing text, and also the direction in which the children
             * of a container are packed. The ability to set the direction is
             * present in order so that correct localization into languages with
             * right-to-left reading directions can be done.
             *
             * Generally, applications will let the default reading direction
             * prevail, except for widgets where the children are arranged in
             * an order that is explicitly visual rather than logical (such as
             * buttons for text justification).
             *
             * If the direction is set to [enum`Gtk`.TextDirection.none], then
             * the value set by [func`Gtk`.Widget.set_default_direction] will be used.
             * @param dir the new direction
             */
            set_direction(dir: Gtk.TextDirection | null): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            set_focus_child(child?: Gtk.Widget | null): void;
            /**
             * Sets whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * Making mouse clicks not grab focus is useful in places like
             * toolbars where you don’t want the keyboard focus removed from
             * the main area of the application.
             * @param focus_on_click whether the widget should grab focus when clicked   with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets whether the widget can own the input focus.
             *
             * Widget implementations should set `focusable` to true in
             * their init() function if they want to receive keyboard input.
             *
             * Note that having `focusable` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and can-focus and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param focusable whether or not @widget can own the input focus
             */
            set_focusable(focusable: boolean): void;
            /**
             * Sets the font map to use for text rendering in the widget.
             *
             * The font map is the object that is used to look up fonts.
             * Setting a custom font map can be useful in special situations,
             * e.g. when you need to add application-specific fonts to the set
             * of available fonts.
             *
             * When not set, the widget will inherit the font map from its parent.
             * @param font_map a `PangoFontMap`
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the `cairo_font_options_t` used for text rendering
             * in the widget.
             *
             * When not set, the default font options for the `GdkDisplay`
             * will be used.
             * @param options a `cairo_font_options_t` struct   to unset any previously set default font options
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of the widget.
             * @param align the horizontal alignment
             */
            set_halign(align: Gtk.Align | null): void;
            /**
             * Sets the `has-tooltip` property on the widget.
             * @param has_tooltip whether or not @widget has a tooltip
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call [method`Gtk`.Widget.compute_expand].
             * A widget can decide how the expandability of children affects its
             * own expansion by overriding the `compute_expand` virtual method on
             * `GtkWidget`.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children. The override occurs because
             * [method`Gtk`.Widget.set_hexpand] sets the hexpand-set property (see
             * [method`Gtk`.Widget.set_hexpand_set]) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag will be used.
             *
             * The [property`Gtk`.Widget:hexpand-set] property will be set
             * automatically when you call [method`Gtk`.Widget.set_hexpand]
             * to set hexpand, so the most likely reason to use this function
             * would be to unset an explicit expand flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Sets the layout manager to use for measuring and allocating children
             * of the widget.
             * @param layout_manager a layout manager
             */
            set_layout_manager(layout_manager?: Gtk.LayoutManager | null): void;
            /**
             * Sets whether the widget acts like a modal dialog,
             * with respect to event delivery.
             * @param limit_events whether to limit events
             */
            set_limit_events(limit_events: boolean): void;
            /**
             * Sets the bottom margin of the widget.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of the widget.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the start margin of the widget.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of the widget.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Sets a widgets name.
             *
             * Setting a name allows you to refer to the widget from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for [class`Gtk`.StyleContext].
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Requests the widget to be rendered partially transparent.
             *
             * An opacity of 0 is fully transparent and an opacity of 1
             * is fully opaque.
             *
             * Opacity works on both toplevel widgets and child widgets, although
             * there are some limitations: For toplevel widgets, applying opacity
             * depends on the capabilities of the windowing system. On X11, this
             * has any effect only on X displays with a compositing manager, see
             * [method`Gdk`.Display.is_composited]. On Windows and Wayland it will
             * always work, although setting a window’s opacity after the window
             * has been shown may cause some flicker.
             *
             * Note that the opacity is inherited through inclusion — if you set
             * a toplevel to be partially translucent, all of its content will
             * appear translucent, since it is ultimatively rendered on that
             * toplevel. The opacity value itself is not inherited by child
             * widgets (since that would make widgets deeper in the hierarchy
             * progressively more translucent). As a consequence, [class`Gtk`.Popover]
             * instances and other [iface`Gtk`.Native] widgets with their own surface
             * will use their own opacity value, and thus by default appear
             * non-translucent, even if they are attached to a toplevel that
             * is translucent.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * Sets how the widget treats content that is drawn outside the
             * it's content area.
             *
             * See the definition of [enum`Gtk`.Overflow] for details.
             *
             * This setting is provided for widget implementations and
             * should not be used by application code.
             *
             * The default value is [enum`Gtk`.Overflow.visible].
             * @param overflow desired overflow value
             */
            set_overflow(overflow: Gtk.Overflow | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * This takes care of details such as updating the state and style
             * of the child to reflect its new location and resizing the parent.
             * The opposite function is [method`Gtk`.Widget.unparent].
             *
             * This function is useful only when implementing subclasses of
             * `GtkWidget`.
             * @param parent parent widget
             */
            set_parent(parent: Gtk.Widget): void;
            /**
             * Sets whether the widget will be treated as the default
             * widget within its toplevel when it has the focus, even if
             * another widget is the default.
             * @param receives_default whether or not @widget can be a default widget
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets the sensitivity of the widget.
             *
             * A widget is sensitive if the user can interact with it.
             * Insensitive widgets are “grayed out” and the user can’t
             * interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive true to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of the widget.
             *
             * That is, the widget’s size request will be at least `width`
             * by `height`. You can use this function to force a widget to
             * be larger than it normally would be.
             *
             * In most cases, [method`Gtk`.Window.set_default_size] is a better
             * choice for toplevel windows than this function; setting the default
             * size will still allow users to shrink the window. Setting the size
             * request will force them to leave the window at least as large as
             * the size request.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it is
             * basically impossible to hardcode a size that will always work.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * properties
             * [property`Gtk`.Widget:margin-start],
             * [property`Gtk`.Widget:margin-end],
             * [property`Gtk`.Widget:margin-top], and
             * [property`Gtk`.Widget:margin-bottom], but it does include pretty
             * much all other padding or border properties set by any subclass
             * of `GtkWidget`.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * Turns on flag values in the current widget state.
             *
             * Typical widget states are insensitive, prelighted, etc.
             *
             * This function accepts the values [flags`Gtk`.StateFlags.dir-ltr] and
             * [flags`Gtk`.StateFlags.dir-rtl] but ignores them. If you want to set
             * the widget's direction, use [method`Gtk`.Widget.set_direction].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn on
             * @param clear whether to clear state before turning on @flags
             */
            set_state_flags(flags: Gtk.StateFlags | null, clear: boolean): void;
            /**
             * Sets the contents of the tooltip for widget.
             *
             * `markup` must contain Pango markup.
             *
             * This function will take care of setting the
             * [property`Gtk`.Widget:has-tooltip] as a side effect, and of the
             * default handler for the [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_markup].
             * @param markup the contents of the tooltip for @widget
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets the contents of the tooltip for the widget.
             *
             * If `text` contains any markup, it will be escaped.
             *
             * This function will take care of setting
             * [property`Gtk`.Widget:has-tooltip] as a side effect,
             * and of the default handler for the
             * [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_text].
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Sets the vertical alignment of the widget.
             * @param align the vertical alignment
             */
            set_valign(align: Gtk.Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.set_hexpand] for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag will be used.
             *
             * See [method`Gtk`.Widget.set_hexpand_set] for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`.
             *
             * Note that setting this to true doesn’t mean the widget is
             * actually viewable, see [method`Gtk`.Widget.get_visible].
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Returns whether the widget should contribute to
             * the measuring and allocation of its parent.
             *
             * This is false for invisible children, but also
             * for children that have their own surface, such
             * as [class`Gtk`.Popover] instances.
             * @returns true if child should be included in   measuring and allocating
             */
            should_layout(): boolean;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            show(): void;
            /**
             * Allocates widget with a transformation that translates
             * the origin to the position in `allocation`.
             *
             * This is a simple form of [method`Gtk`.Widget.allocate].
             * @param allocation position and size to be allocated to @widget
             * @param baseline the baseline of the child, or -1
             */
            size_allocate(allocation: Gtk.Allocation, baseline: number): void;
            /**
             * Snapshots a child of the widget.
             *
             * When a widget receives a call to the snapshot function,
             * it must send synthetic [vfunc`Gtk`.Widget.snapshot] calls
             * to all children. This function provides a convenient way
             * of doing this. A widget, when it receives a call to its
             * [vfunc`Gtk`.Widget.snapshot] function, calls
             * gtk_widget_snapshot_child() once for each child, passing in
             * the `snapshot` the widget received.
             *
             * This function takes care of translating the origin of `snapshot,`
             * and deciding whether the child needs to be snapshot.
             *
             * It does nothing for children that implement `GtkNative`.
             * @param child a child of @widget
             * @param snapshot snapshot as passed to the widget. In particular, no   calls to [method@Gtk.Snapshot.translate] or other transform calls   should have been made
             */
            snapshot_child(child: Gtk.Widget, snapshot: Gtk.Snapshot): void;
            /**
             * Translates coordinates relative to `src_widget’`s allocation
             * to coordinates relative to `dest_widget’`s allocations.
             *
             * In order to perform this operation, both widget must share
             * a common ancestor. If that is not the case, `dest_x` and `dest_y`
             * are set to 0 and false is returned.
             * @param dest_widget another widget
             * @param src_x X position in widget coordinates of @src_widget
             * @param src_y Y position in widget coordinates of @src_widget
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            translate_coordinates(dest_widget: Gtk.Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display of the widget.
             */
            trigger_tooltip_query(): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            unmap(): void;
            /**
             * Removes `widget` from its parent.
             *
             * This function is only for use in widget implementations,
             * typically in dispose.
             */
            unparent(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            unrealize(): void;
            /**
             * Turns off flag values for the current widget state.
             *
             * See [method`Gtk`.Widget.set_state_flags].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn off
             */
            unset_state_flags(flags: Gtk.StateFlags | null): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             */
            vfunc_contains(x: number, y: number): boolean;
            /**
             * Vfunc called when the CSS used by widget was changed. Widgets
             *   should then discard their caches that depend on CSS and queue resizes or
             *   redraws accordingly. The default implementation will take care of this for
             *   all the default CSS properties, so implementations must chain up.
             * @param change
             */
            vfunc_css_changed(change: Gtk.CssStyleChange): void;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: Gtk.TextDirection): void;
            /**
             * Vfunc for gtk_widget_child_focus()
             * @param direction
             */
            vfunc_focus(direction: Gtk.DirectionType): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             */
            vfunc_get_request_mode(): Gtk.SizeRequestMode;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             */
            vfunc_grab_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: Gtk.DirectionType): boolean;
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            vfunc_measure(orientation: Gtk.Orientation, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: Gtk.DirectionType): void;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Gtk.Tooltip): boolean;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            vfunc_realize(): void;
            /**
             * Called when the widget gets added to a `GtkRoot` widget. Must
             *   chain up
             */
            vfunc_root(): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            vfunc_set_focus_child(child?: Gtk.Widget | null): void;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Called to set the allocation, if the widget does
             *   not have a layout manager.
             * @param width
             * @param height
             * @param baseline
             */
            vfunc_size_allocate(width: number, height: number, baseline: number): void;
            /**
             * Vfunc called when a new snapshot of the widget has to be taken.
             * @param snapshot
             */
            vfunc_snapshot(snapshot: Gtk.Snapshot): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: Gtk.StateFlags): void;
            /**
             * Emitted when a system setting was changed. Must chain up.
             * @param settings
             */
            vfunc_system_setting_changed(settings: Gtk.SystemSetting): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_unmap(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            vfunc_unrealize(): void;
            /**
             * Called when the widget is about to be removed from its
             *   `GtkRoot` widget. Must chain up
             */
            vfunc_unroot(): void;
        }

        namespace Avatar {
            // Constructor properties interface

            interface ConstructorProps
                extends Gtk.Widget.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps {
                custom_image: Gdk.Paintable;
                customImage: Gdk.Paintable;
                icon_name: string;
                iconName: string;
                show_initials: boolean;
                showInitials: boolean;
                size: number;
                text: string;
            }
        }

        /**
         * A widget displaying an image, with a generated fallback.
         *
         * <picture>
         *   <source srcset="avatar-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="avatar.png" alt="avatar">
         * </picture>
         *
         * `AdwAvatar` is a widget that shows a round avatar.
         *
         * `AdwAvatar` generates an avatar with the initials of  the
         * [property`Avatar:`text] on top of a colored background.
         *
         * The color is picked based on the hash of the [property`Avatar:`text].
         *
         * If [property`Avatar:`show-initials] is set to `FALSE`,
         * [property`Avatar:`icon-name] or `avatar-default-symbolic` is shown instead of
         * the initials.
         *
         * Use [property`Avatar:`custom-image] to set a custom image.
         *
         * ## CSS nodes
         *
         * `AdwAvatar` has a single CSS node with name `avatar`.
         *
         * ## Accessibility
         *
         * `AdwAvatar` uses the `GTK_ACCESSIBLE_ROLE_IMG` role.
         */
        class Avatar extends Gtk.Widget implements Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
            static $gtype: GObject.GType<Avatar>;

            // Properties

            /**
             * A custom image paintable.
             *
             * Custom image is displayed instead of initials or icon.
             */
            get custom_image(): Gdk.Paintable;
            set custom_image(val: Gdk.Paintable);
            /**
             * A custom image paintable.
             *
             * Custom image is displayed instead of initials or icon.
             */
            get customImage(): Gdk.Paintable;
            set customImage(val: Gdk.Paintable);
            /**
             * The name of an icon to use as a fallback.
             *
             * If no name is set, `avatar-default-symbolic` will be used.
             */
            get icon_name(): string;
            set icon_name(val: string);
            /**
             * The name of an icon to use as a fallback.
             *
             * If no name is set, `avatar-default-symbolic` will be used.
             */
            get iconName(): string;
            set iconName(val: string);
            /**
             * Whether initials are used instead of an icon on the fallback avatar.
             *
             * See [property`Avatar:`icon-name] for how to change the fallback icon.
             */
            get show_initials(): boolean;
            set show_initials(val: boolean);
            /**
             * Whether initials are used instead of an icon on the fallback avatar.
             *
             * See [property`Avatar:`icon-name] for how to change the fallback icon.
             */
            get showInitials(): boolean;
            set showInitials(val: boolean);
            /**
             * The size of the avatar.
             */
            get size(): number;
            set size(val: number);
            /**
             * Sets the text used to generate the fallback initials and color.
             *
             * It's only used to generate the color if [property`Avatar:`show-initials] is
             * `FALSE`.
             */
            get text(): string;
            set text(val: string);

            // Constructors

            constructor(properties?: Partial<Avatar.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](size: number, text: string | null, show_initials: boolean): Avatar;

            // Methods

            /**
             * Renders `self` into a [class`Gdk`.Texture] at `scale_factor`.
             *
             * This can be used to export the fallback avatar.
             * @param scale_factor The scale factor
             * @returns the texture
             */
            draw_to_texture(scale_factor: number): Gdk.Texture;
            /**
             * Gets the custom image paintable.
             * @returns the custom image
             */
            get_custom_image(): Gdk.Paintable | null;
            /**
             * Gets the name of an icon to use as a fallback.
             * @returns the icon name
             */
            get_icon_name(): string | null;
            /**
             * Gets whether initials are used instead of an icon on the fallback avatar.
             * @returns whether initials are used instead of an icon as fallback
             */
            get_show_initials(): boolean;
            /**
             * Gets the size of the avatar.
             * @returns the size of the avatar
             */
            get_size(): number;
            /**
             * Gets the text used to generate the fallback initials and color.
             * @returns the text used to generate the fallback initials and   color
             */
            get_text(): string | null;
            /**
             * Sets the custom image paintable.
             *
             * Custom image is displayed instead of initials or icon.
             * @param custom_image a custom image
             */
            set_custom_image(custom_image?: Gdk.Paintable | null): void;
            /**
             * Sets the name of an icon to use as a fallback.
             *
             * If no name is set, `avatar-default-symbolic` will be used.
             * @param icon_name the icon name
             */
            set_icon_name(icon_name?: string | null): void;
            /**
             * Sets whether to use initials instead of an icon on the fallback avatar.
             *
             * See [property`Avatar:`icon-name] for how to change the fallback icon.
             * @param show_initials whether to use initials instead of an icon as fallback
             */
            set_show_initials(show_initials: boolean): void;
            /**
             * Sets the size of the avatar.
             * @param size The size of the avatar
             */
            set_size(size: number): void;
            /**
             * Sets the text used to generate the fallback initials and color.
             *
             * It's only used to generate the color if [property`Avatar:`show-initials] is
             * `FALSE`.
             * @param text the text used to get the initials and color
             */
            set_text(text?: string | null): void;

            // Inherited properties
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessible_role(): Gtk.AccessibleRole;
            set accessible_role(val: Gtk.AccessibleRole);
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessibleRole(): Gtk.AccessibleRole;
            set accessibleRole(val: Gtk.AccessibleRole);

            // Inherited methods
            /**
             * Requests the user's screen reader to announce the given message.
             *
             * This kind of notification is useful for messages that
             * either have only a visual representation or that are not
             * exposed visually at all, e.g. a notification about a
             * successful operation.
             *
             * Also, by using this API, you can ensure that the message
             * does not interrupts the user's current screen reader output.
             * @param message the string to announce
             * @param priority the priority of the announcement
             */
            announce(message: string, priority: Gtk.AccessibleAnnouncementPriority | null): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             * @returns the accessible parent
             */
            get_accessible_parent(): Gtk.Accessible | null;
            /**
             * Retrieves the accessible role of an accessible object.
             * @returns the accessible role
             */
            get_accessible_role(): Gtk.AccessibleRole;
            /**
             * Retrieves the implementation for the given accessible object.
             * @returns the accessible implementation object
             */
            get_at_context(): Gtk.ATContext;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             * @returns true if the bounds are valid, and false otherwise
             */
            get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             * @returns the first accessible child
             */
            get_first_accessible_child(): Gtk.Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             * @returns the next accessible sibling
             */
            get_next_accessible_sibling(): Gtk.Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             * @returns the value of state for the accessible
             */
            get_platform_state(state: Gtk.AccessiblePlatformState | null): boolean;
            /**
             * Resets the accessible property to its default value.
             * @param property the accessible property
             */
            reset_property(property: Gtk.AccessibleProperty | null): void;
            /**
             * Resets the accessible relation to its default value.
             * @param relation the accessible relation
             */
            reset_relation(relation: Gtk.AccessibleRelation | null): void;
            /**
             * Resets the accessible state to its default value.
             * @param state the accessible state
             */
            reset_state(state: Gtk.AccessibleState | null): void;
            /**
             * Sets the parent and sibling of an accessible object.
             *
             * This function is meant to be used by accessible implementations that are
             * not part of the widget hierarchy, and but act as a logical bridge between
             * widgets. For instance, if a widget creates an object that holds metadata
             * for each child, and you want that object to implement the `GtkAccessible`
             * interface, you will use this function to ensure that the parent of each
             * child widget is the metadata object, and the parent of each metadata
             * object is the container widget.
             * @param parent the parent accessible object
             * @param next_sibling the sibling accessible object
             */
            set_accessible_parent(parent?: Gtk.Accessible | null, next_sibling?: Gtk.Accessible | null): void;
            /**
             * Updates the next accessible sibling.
             *
             * That might be useful when a new child of a custom accessible
             * is created, and it needs to be linked to a previous child.
             * @param new_sibling the new next accessible sibling to set
             */
            update_next_accessible_sibling(new_sibling?: Gtk.Accessible | null): void;
            /**
             * Informs ATs that the platform state has changed.
             *
             * This function should be used by `GtkAccessible` implementations that
             * have a platform state but are not widgets. Widgets handle platform
             * states automatically.
             * @param state the platform state to update
             */
            update_platform_state(state: Gtk.AccessiblePlatformState | null): void;
            /**
             * Updates an array of accessible properties.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * property change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param properties an array of accessible properties
             * @param values an array of `GValues`, one for each property
             */
            update_property(properties: Gtk.AccessibleProperty[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible relations.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * relation change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param relations an array of accessible relations
             * @param values an array of `GValues`, one for each relation
             */
            update_relation(relations: Gtk.AccessibleRelation[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible states.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * state change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param states an array of accessible states
             * @param values an array of `GValues`, one for each state
             */
            update_state(states: Gtk.AccessibleState[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             */
            vfunc_get_accessible_parent(): Gtk.Accessible | null;
            /**
             * Retrieves the implementation for the given accessible object.
             */
            vfunc_get_at_context(): Gtk.ATContext | null;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             */
            vfunc_get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             */
            vfunc_get_first_accessible_child(): Gtk.Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             */
            vfunc_get_next_accessible_sibling(): Gtk.Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             */
            vfunc_get_platform_state(state: Gtk.AccessiblePlatformState): boolean;
            /**
             * Gets the ID of the `buildable` object.
             *
             * `GtkBuilder` sets the name based on the ID attribute
             * of the `<object>` tag used to construct the `buildable`.
             * @returns the ID of the buildable object
             */
            get_buildable_id(): string | null;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a `GtkBuilder`
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Gtk.Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a `GtkBuilder`
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called at the end of each custom element handled by
             * the buildable.
             * @param builder `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called for each unknown element under `<child>`.
             * @param builder a `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, Gtk.BuildableParser, any];
            /**
             * The getter corresponding to `set_id`. Implement this
             *   if you implement `set_id`.
             */
            vfunc_get_id(): string;
            /**
             * Retrieves the internal child called `childname` of the `buildable` object.
             * @param builder a `GtkBuilder`
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Gtk.Builder, childname: string): T;
            /**
             * Called when a builder finishes the parsing
             *  of a UI definition. It is normally not necessary to implement this,
             *  unless you need to perform special cleanup actions. `GtkWindow` sets
             *  the `GtkWidget:visible` property here.
             * @param builder
             */
            vfunc_parser_finished(builder: Gtk.Builder): void;
            /**
             * Sets a property of a buildable object.
             *  It is normally not necessary to implement this, g_object_set_property()
             *  is used by default. `GtkWindow` implements this to delay showing itself
             *  (i.e. setting the [property`Gtk`.Widget:visible] property) until the whole
             *  interface is created.
             * @param builder
             * @param name
             * @param value
             */
            vfunc_set_buildable_property(builder: Gtk.Builder, name: string, value: GObject.Value | any): void;
            /**
             * Stores the id attribute given in the `GtkBuilder` UI definition.
             *   `GtkWidget` stores the name as object data. Implement this method if your
             *   object has some notion of “ID” and it makes sense to map the XML id
             *   attribute to it.
             * @param id
             */
            vfunc_set_id(id: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace Banner {
            // Signal callback interfaces

            interface ButtonClicked {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Gtk.Widget.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Actionable.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps {
                button_label: string;
                buttonLabel: string;
                button_style: BannerButtonStyle;
                buttonStyle: BannerButtonStyle;
                revealed: boolean;
                title: string;
                use_markup: boolean;
                useMarkup: boolean;
            }
        }

        /**
         * A bar with contextual information.
         *
         * <picture>
         *   <source srcset="banner-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="banner.png" alt="banner">
         * </picture>
         *
         * Banners are hidden by default, use [property`Banner:`revealed] to show them.
         *
         * Banners have a title, set with [property`Banner:`title]. Titles can be marked
         * up with Pango markup, use [property`Banner:`use-markup] to enable it.
         *
         * The title will be shown centered or left-aligned depending on available
         * space.
         *
         * Banners can optionally have a button with text on it, set through
         * [property`Banner:`button-label]. The button can be used with a `GAction`,
         * or with the [signal`Banner:`:button-clicked] signal. The button can have
         * different styles, a gray style and a suggested style.
         *
         * <picture>
         *   <source srcset="banner-suggested-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="banner-suggested.png" alt="banner with suggested button style">
         * </picture>
         *
         * ## CSS nodes
         *
         * `AdwBanner` has a main CSS node with the name `banner`.
         */
        class Banner extends Gtk.Widget implements Gtk.Accessible, Gtk.Actionable, Gtk.Buildable, Gtk.ConstraintTarget {
            static $gtype: GObject.GType<Banner>;

            // Properties

            /**
             * The label to show on the button.
             *
             * If set to `""` or `NULL`, the button won't be shown.
             *
             * The button can be used with a `GAction`, or with the
             * [signal`Banner:`:button-clicked] signal.
             */
            get button_label(): string;
            set button_label(val: string);
            /**
             * The label to show on the button.
             *
             * If set to `""` or `NULL`, the button won't be shown.
             *
             * The button can be used with a `GAction`, or with the
             * [signal`Banner:`:button-clicked] signal.
             */
            get buttonLabel(): string;
            set buttonLabel(val: string);
            /**
             * The style class to use for the banner button.
             *
             * When set to `ADW_BANNER_BUTTON_DEFAULT`, the button stays grey.
             * When set to `ADW_BANNER_BUTTON_SUGGESTED`, the button follows the [`.suggested-action`](style-classes.html#suggested-action) style
             *
             * <picture>
             *   <source srcset="banner-suggested-dark.png" media="(prefers-color-scheme: dark)">
             *   <img src="banner-suggested.png" alt="banner with suggested button style">
             * </picture>
             */
            get button_style(): BannerButtonStyle;
            set button_style(val: BannerButtonStyle);
            /**
             * The style class to use for the banner button.
             *
             * When set to `ADW_BANNER_BUTTON_DEFAULT`, the button stays grey.
             * When set to `ADW_BANNER_BUTTON_SUGGESTED`, the button follows the [`.suggested-action`](style-classes.html#suggested-action) style
             *
             * <picture>
             *   <source srcset="banner-suggested-dark.png" media="(prefers-color-scheme: dark)">
             *   <img src="banner-suggested.png" alt="banner with suggested button style">
             * </picture>
             */
            get buttonStyle(): BannerButtonStyle;
            set buttonStyle(val: BannerButtonStyle);
            /**
             * Whether the banner is currently revealed.
             */
            get revealed(): boolean;
            set revealed(val: boolean);
            /**
             * The title for this banner.
             *
             * See also: [property`Banner:`use-markup].
             */
            get title(): string;
            set title(val: string);
            /**
             * Whether to use Pango markup for the banner title.
             *
             * See also [func`Pango`.parse_markup].
             */
            get use_markup(): boolean;
            set use_markup(val: boolean);
            /**
             * Whether to use Pango markup for the banner title.
             *
             * See also [func`Pango`.parse_markup].
             */
            get useMarkup(): boolean;
            set useMarkup(val: boolean);

            // Constructors

            constructor(properties?: Partial<Banner.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](title: string): Banner;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'button-clicked', callback: (_source: this) => void): number;
            connect_after(signal: 'button-clicked', callback: (_source: this) => void): number;
            emit(signal: 'button-clicked'): void;

            // Methods

            /**
             * Gets the button label for `self`.
             * @returns the button label for @self
             */
            get_button_label(): string | null;
            /**
             * Gets the style class in use for the banner button.
             * @returns the current button style
             */
            get_button_style(): BannerButtonStyle;
            /**
             * Gets if a banner is revealed
             * @returns Whether a banner is revealed
             */
            get_revealed(): boolean;
            /**
             * Gets the title for `self`.
             * @returns the title for @self
             */
            get_title(): string;
            /**
             * Gets whether to use Pango markup for the banner title.
             * @returns whether to use markup
             */
            get_use_markup(): boolean;
            /**
             * Sets the button label for `self`.
             *
             * If set to `""` or `NULL`, the button won't be shown.
             *
             * The button can be used with a `GAction`, or with the
             * [signal`Banner:`:button-clicked] signal.
             * @param label the label
             */
            set_button_label(label?: string | null): void;
            /**
             * Sets the style class to use for the banner button.
             *
             * When set to `ADW_BANNER_BUTTON_DEFAULT`, the button stays grey.
             * When set to `ADW_BANNER_BUTTON_SUGGESTED`, the button follows the [`.suggested-action`](style-classes.html#suggested-action) style
             *
             * <picture>
             *   <source srcset="banner-suggested-dark.png" media="(prefers-color-scheme: dark)">
             *   <img src="banner-suggested.png" alt="banner with suggested button style">
             * </picture>
             * @param style a button style
             */
            set_button_style(style: BannerButtonStyle | null): void;
            /**
             * Sets whether a banner should be revealed
             * @param revealed whether a banner should be revealed
             */
            set_revealed(revealed: boolean): void;
            /**
             * Sets the title for this banner.
             *
             * See also: [property`Banner:`use-markup].
             * @param title the title
             */
            set_title(title: string): void;
            /**
             * Sets whether to use Pango markup for the banner title.
             *
             * See also [func`Pango`.parse_markup].
             * @param use_markup whether to use markup
             */
            set_use_markup(use_markup: boolean): void;

            // Inherited properties
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessible_role(): Gtk.AccessibleRole;
            set accessible_role(val: Gtk.AccessibleRole);
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessibleRole(): Gtk.AccessibleRole;
            set accessibleRole(val: Gtk.AccessibleRole);
            /**
             * The name of the action with which this widget should be associated.
             */
            get action_name(): string;
            set action_name(val: string);
            /**
             * The name of the action with which this widget should be associated.
             */
            get actionName(): string;
            set actionName(val: string);
            /**
             * The target value of the actionable widget's action.
             */
            get action_target(): GLib.Variant;
            set action_target(val: GLib.Variant);
            /**
             * The target value of the actionable widget's action.
             */
            get actionTarget(): GLib.Variant;
            set actionTarget(val: GLib.Variant);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get can_focus(): boolean;
            set can_focus(val: boolean);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get canFocus(): boolean;
            set canFocus(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get can_target(): boolean;
            set can_target(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get canTarget(): boolean;
            set canTarget(val: boolean);
            /**
             * A list of css classes applied to this widget.
             */
            get css_classes(): string[];
            set css_classes(val: string[]);
            /**
             * A list of css classes applied to this widget.
             */
            get cssClasses(): string[];
            set cssClasses(val: string[]);
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get css_name(): string;
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get cssName(): string;
            /**
             * The cursor used by `widget`.
             */
            get cursor(): Gdk.Cursor;
            set cursor(val: Gdk.Cursor);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * Whether this widget itself will accept the input focus.
             */
            get focusable(): boolean;
            set focusable(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space.
             */
            get halign(): Gtk.Align;
            set halign(val: Gtk.Align);
            /**
             * Whether the widget is the default widget.
             */
            get has_default(): boolean;
            /**
             * Whether the widget is the default widget.
             */
            get hasDefault(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get has_focus(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get hasFocus(): boolean;
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get height_request(): number;
            set height_request(val: number);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally.
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layout_manager(): Gtk.LayoutManager;
            set layout_manager(val: Gtk.LayoutManager);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layoutManager(): Gtk.LayoutManager;
            set layoutManager(val: Gtk.LayoutManager);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limit_events(): boolean;
            set limit_events(val: boolean);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limitEvents(): boolean;
            set limitEvents(val: boolean);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            /**
             * The name of the widget.
             */
            get name(): string;
            set name(val: string);
            /**
             * The requested opacity of the widget.
             */
            get opacity(): number;
            set opacity(val: number);
            /**
             * How content outside the widget's content area is treated.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get overflow(): Gtk.Overflow;
            set overflow(val: Gtk.Overflow);
            /**
             * The parent widget of this widget.
             */
            get parent(): Gtk.Widget;
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receives_default(): boolean;
            set receives_default(val: boolean);
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The `GtkRoot` widget of the widget tree containing this widget.
             *
             * This will be `NULL` if the widget is not contained in a root widget.
             */
            get root(): Gtk.Root;
            /**
             * The scale factor of the widget.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget.
             */
            get scaleFactor(): number;
            /**
             * Whether the widget responds to input.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space.
             */
            get valign(): Gtk.Align;
            set valign(val: Gtk.Align);
            /**
             * Whether to expand vertically.
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            /**
             * Whether the widget is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get width_request(): number;
            set width_request(val: number);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get widthRequest(): number;
            set widthRequest(val: number);

            // Inherited methods
            /**
             * Requests the user's screen reader to announce the given message.
             *
             * This kind of notification is useful for messages that
             * either have only a visual representation or that are not
             * exposed visually at all, e.g. a notification about a
             * successful operation.
             *
             * Also, by using this API, you can ensure that the message
             * does not interrupts the user's current screen reader output.
             * @param message the string to announce
             * @param priority the priority of the announcement
             */
            announce(message: string, priority: Gtk.AccessibleAnnouncementPriority | null): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             * @returns the accessible parent
             */
            get_accessible_parent(): Gtk.Accessible | null;
            /**
             * Retrieves the accessible role of an accessible object.
             * @returns the accessible role
             */
            get_accessible_role(): Gtk.AccessibleRole;
            /**
             * Retrieves the implementation for the given accessible object.
             * @returns the accessible implementation object
             */
            get_at_context(): Gtk.ATContext;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             * @returns true if the bounds are valid, and false otherwise
             */
            get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             * @returns the first accessible child
             */
            get_first_accessible_child(): Gtk.Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             * @returns the next accessible sibling
             */
            get_next_accessible_sibling(): Gtk.Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             * @returns the value of state for the accessible
             */
            get_platform_state(state: Gtk.AccessiblePlatformState | null): boolean;
            /**
             * Resets the accessible property to its default value.
             * @param property the accessible property
             */
            reset_property(property: Gtk.AccessibleProperty | null): void;
            /**
             * Resets the accessible relation to its default value.
             * @param relation the accessible relation
             */
            reset_relation(relation: Gtk.AccessibleRelation | null): void;
            /**
             * Resets the accessible state to its default value.
             * @param state the accessible state
             */
            reset_state(state: Gtk.AccessibleState | null): void;
            /**
             * Sets the parent and sibling of an accessible object.
             *
             * This function is meant to be used by accessible implementations that are
             * not part of the widget hierarchy, and but act as a logical bridge between
             * widgets. For instance, if a widget creates an object that holds metadata
             * for each child, and you want that object to implement the `GtkAccessible`
             * interface, you will use this function to ensure that the parent of each
             * child widget is the metadata object, and the parent of each metadata
             * object is the container widget.
             * @param parent the parent accessible object
             * @param next_sibling the sibling accessible object
             */
            set_accessible_parent(parent?: Gtk.Accessible | null, next_sibling?: Gtk.Accessible | null): void;
            /**
             * Updates the next accessible sibling.
             *
             * That might be useful when a new child of a custom accessible
             * is created, and it needs to be linked to a previous child.
             * @param new_sibling the new next accessible sibling to set
             */
            update_next_accessible_sibling(new_sibling?: Gtk.Accessible | null): void;
            /**
             * Informs ATs that the platform state has changed.
             *
             * This function should be used by `GtkAccessible` implementations that
             * have a platform state but are not widgets. Widgets handle platform
             * states automatically.
             * @param state the platform state to update
             */
            update_platform_state(state: Gtk.AccessiblePlatformState | null): void;
            /**
             * Updates an array of accessible properties.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * property change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param properties an array of accessible properties
             * @param values an array of `GValues`, one for each property
             */
            update_property(properties: Gtk.AccessibleProperty[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible relations.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * relation change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param relations an array of accessible relations
             * @param values an array of `GValues`, one for each relation
             */
            update_relation(relations: Gtk.AccessibleRelation[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible states.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * state change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param states an array of accessible states
             * @param values an array of `GValues`, one for each state
             */
            update_state(states: Gtk.AccessibleState[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             */
            vfunc_get_accessible_parent(): Gtk.Accessible | null;
            /**
             * Retrieves the implementation for the given accessible object.
             */
            vfunc_get_at_context(): Gtk.ATContext | null;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             */
            vfunc_get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             */
            vfunc_get_first_accessible_child(): Gtk.Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             */
            vfunc_get_next_accessible_sibling(): Gtk.Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             */
            vfunc_get_platform_state(state: Gtk.AccessiblePlatformState): boolean;
            /**
             * Gets the action name for `actionable`.
             * @returns the action name
             */
            get_action_name(): string | null;
            /**
             * Gets the current target value of `actionable`.
             * @returns the current target value
             */
            get_action_target_value(): GLib.Variant | null;
            /**
             * Specifies the name of the action with which this widget should be
             * associated.
             *
             * If `action_name` is %NULL then the widget will be unassociated from
             * any previous action.
             *
             * Usually this function is used when the widget is located (or will be
             * located) within the hierarchy of a `GtkApplicationWindow`.
             *
             * Names are of the form “win.save” or “app.quit” for actions on the
             * containing [class`ApplicationWindow]` or its associated [class`Application]`,
             * respectively. This is the same form used for actions in the [class`Gio`.Menu]
             * associated with the window.
             * @param action_name an action name
             */
            set_action_name(action_name?: string | null): void;
            /**
             * Sets the target value of an actionable widget.
             *
             * If `target_value` is %NULL then the target value is unset.
             *
             * The target value has two purposes. First, it is used as the parameter
             * to activation of the action associated with the `GtkActionable` widget.
             * Second, it is used to determine if the widget should be rendered as
             * “active” — the widget is active if the state is equal to the given target.
             *
             * Consider the example of associating a set of buttons with a [iface`Gio`.Action]
             * with string state in a typical “radio button” situation. Each button
             * will be associated with the same action, but with a different target
             * value for that action. Clicking on a particular button will activate
             * the action with the target of that button, which will typically cause
             * the action’s state to change to that value. Since the action’s state
             * is now equal to the target value of the button, the button will now
             * be rendered as active (and the other buttons, with different targets,
             * rendered inactive).
             * @param target_value a [struct@GLib.Variant] to set as the target value
             */
            set_action_target_value(target_value?: GLib.Variant | null): void;
            /**
             * Sets the action-name and associated string target value of an
             * actionable widget.
             *
             * `detailed_action_name` is a string in the format accepted by
             * [func`Gio`.Action.parse_detailed_name].
             * @param detailed_action_name the detailed action name
             */
            set_detailed_action_name(detailed_action_name: string): void;
            /**
             * Gets the action name for `actionable`.
             */
            vfunc_get_action_name(): string | null;
            /**
             * Gets the current target value of `actionable`.
             */
            vfunc_get_action_target_value(): GLib.Variant | null;
            /**
             * Specifies the name of the action with which this widget should be
             * associated.
             *
             * If `action_name` is %NULL then the widget will be unassociated from
             * any previous action.
             *
             * Usually this function is used when the widget is located (or will be
             * located) within the hierarchy of a `GtkApplicationWindow`.
             *
             * Names are of the form “win.save” or “app.quit” for actions on the
             * containing [class`ApplicationWindow]` or its associated [class`Application]`,
             * respectively. This is the same form used for actions in the [class`Gio`.Menu]
             * associated with the window.
             * @param action_name an action name
             */
            vfunc_set_action_name(action_name?: string | null): void;
            /**
             * Sets the target value of an actionable widget.
             *
             * If `target_value` is %NULL then the target value is unset.
             *
             * The target value has two purposes. First, it is used as the parameter
             * to activation of the action associated with the `GtkActionable` widget.
             * Second, it is used to determine if the widget should be rendered as
             * “active” — the widget is active if the state is equal to the given target.
             *
             * Consider the example of associating a set of buttons with a [iface`Gio`.Action]
             * with string state in a typical “radio button” situation. Each button
             * will be associated with the same action, but with a different target
             * value for that action. Clicking on a particular button will activate
             * the action with the target of that button, which will typically cause
             * the action’s state to change to that value. Since the action’s state
             * is now equal to the target value of the button, the button will now
             * be rendered as active (and the other buttons, with different targets,
             * rendered inactive).
             * @param target_value a [struct@GLib.Variant] to set as the target value
             */
            vfunc_set_action_target_value(target_value?: GLib.Variant | null): void;
            /**
             * Gets the ID of the `buildable` object.
             *
             * `GtkBuilder` sets the name based on the ID attribute
             * of the `<object>` tag used to construct the `buildable`.
             * @returns the ID of the buildable object
             */
            get_buildable_id(): string | null;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a `GtkBuilder`
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Gtk.Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a `GtkBuilder`
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called at the end of each custom element handled by
             * the buildable.
             * @param builder `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called for each unknown element under `<child>`.
             * @param builder a `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, Gtk.BuildableParser, any];
            /**
             * The getter corresponding to `set_id`. Implement this
             *   if you implement `set_id`.
             */
            vfunc_get_id(): string;
            /**
             * Retrieves the internal child called `childname` of the `buildable` object.
             * @param builder a `GtkBuilder`
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Gtk.Builder, childname: string): T;
            /**
             * Called when a builder finishes the parsing
             *  of a UI definition. It is normally not necessary to implement this,
             *  unless you need to perform special cleanup actions. `GtkWindow` sets
             *  the `GtkWidget:visible` property here.
             * @param builder
             */
            vfunc_parser_finished(builder: Gtk.Builder): void;
            /**
             * Sets a property of a buildable object.
             *  It is normally not necessary to implement this, g_object_set_property()
             *  is used by default. `GtkWindow` implements this to delay showing itself
             *  (i.e. setting the [property`Gtk`.Widget:visible] property) until the whole
             *  interface is created.
             * @param builder
             * @param name
             * @param value
             */
            vfunc_set_buildable_property(builder: Gtk.Builder, name: string, value: GObject.Value | any): void;
            /**
             * Stores the id attribute given in the `GtkBuilder` UI definition.
             *   `GtkWidget` stores the name as object data. Implement this method if your
             *   object has some notion of “ID” and it makes sense to map the XML id
             *   attribute to it.
             * @param id
             */
            vfunc_set_id(id: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * Enables or disables an action installed with
             * [method`Gtk`.WidgetClass.install_action].
             * @param action_name action name, such as "clipboard.paste"
             * @param enabled whether the action is now enabled
             */
            action_set_enabled(action_name: string, enabled: boolean): void;
            /**
             * Activates the widget.
             *
             * The activation will emit the signal set using
             * [method`Gtk`.WidgetClass.set_activate_signal]
             * during class initialization.
             *
             * Activation is what happens when you press <kbd>Enter</kbd>
             * on a widget.
             *
             * If you wish to handle the activation keybinding yourself,
             * it is recommended to use [method`Gtk`.WidgetClass.add_shortcut]
             * with an action created with [ctor`Gtk`.SignalAction.new].
             *
             * If `widget` is not activatable, the function returns false.
             * @returns true if the widget was activated
             */
            activate(): boolean;
            /**
             * Activates an action for the widget.
             *
             * The action is looked up in the action groups associated with
             * `widget` and its ancestors.
             *
             * If the action is in an action group added with
             * [method`Gtk`.Widget.insert_action_group], the `name` is expected
             * to be prefixed with the prefix that was used when the group was
             * inserted.
             *
             * The arguments must match the actions expected parameter type,
             * as returned by [method`Gio`.Action.get_parameter_type].
             * @param name the name of the action to activate
             * @param args parameters to use
             * @returns true if the action was activated
             */
            activate_action(name: string, args?: GLib.Variant | null): boolean;
            /**
             * Activates the `default.activate` action for the widget.
             *
             * The action is looked up in the same was as for
             * [method`Gtk`.Widget.activate_action].
             */
            activate_default(): void;
            /**
             * Adds an event controller to the widget.
             *
             * The event controllers of a widget handle the events that are
             * propagated to the widget.
             *
             * You will usually want to call this function right after
             * creating any kind of [class`Gtk`.EventController].
             * @param controller an event controller that hasn't been   added to a widget yet
             */
            add_controller(controller: Gtk.EventController): void;
            /**
             * Adds a style class to the widget.
             *
             * After calling this function, the widget’s style will match
             * for `css_class,` according to CSS matching rules.
             *
             * Use [method`Gtk`.Widget.remove_css_class] to remove the
             * style again.
             * @param css_class style class to add to @widget, without the leading period
             */
            add_css_class(css_class: string): void;
            /**
             * Adds a widget to the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * Note that the list of mnemonic labels for the widget is cleared
             * when the widget is destroyed, so the caller must make sure
             * to update its internal state at this point as well.
             * @param label a widget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Gtk.Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame.
             *
             * Until the tick callback is removed, it will be called frequently
             * (usually at the frame rate of the output device or as quickly as
             * the application can be repainted, whichever is slower). For this
             * reason, is most suitable for handling graphics that change every
             * frame or every few frames.
             *
             * The tick callback does not automatically imply a relayout or repaint.
             * If you want a repaint or relayout, and aren’t changing widget properties
             * that would trigger that (for example, changing the text of a label),
             * then you will have to call [method`Gtk`.Widget.queue_resize] or
             * [method`Gtk`.Widget.queue_draw] yourself.
             *
             * [method`Gdk`.FrameClock.get_frame_time] should generally be used
             * for timing continuous animations and
             * [method`Gdk`.FrameTimings.get_predicted_presentation_time] should be
             * used if you are trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * [signal`Gdk`.FrameClock::update] signal of the frame clock, since you
             * don't have to worry about when a frame clock is assigned to a widget.
             *
             * To remove a tick callback, pass the ID that is returned by this function
             * to [method`Gtk`.Widget.remove_tick_callback].
             * @param callback function   to call for updating animations
             * @returns an ID for this callback
             */
            add_tick_callback(callback: Gtk.TickCallback): number;
            /**
             * Assigns size, position, (optionally) a baseline and transform
             * to a child widget.
             *
             * In this function, the allocation and baseline may be adjusted.
             * The given allocation will be forced to be bigger than the
             * widget's minimum size, as well as at least 0×0 in size.
             *
             * This function is only used by widget implementations.
             *
             * For a version that does not take a transform, see
             * [method`Gtk`.Widget.size_allocate].
             * @param width new width
             * @param height new height
             * @param baseline new baseline, or -1
             * @param transform transformation to be applied
             */
            allocate(width: number, height: number, baseline: number, transform?: Gsk.Transform | null): void;
            /**
             * Called by widgets as the user moves around the window using
             * keyboard shortcuts.
             *
             * The `direction` argument indicates what kind of motion is taking
             * place (up, down, left, right, tab forward, tab backward).
             *
             * This function calls the [vfunc`Gtk`.Widget.focus] virtual function;
             * widgets can override the virtual function in order to implement
             * appropriate focus behavior.
             *
             * The default `focus()` virtual function for a widget should return
             * true if moving in `direction` left the focus on a focusable location
             * inside that widget, and false if moving in `direction` moved the focus
             * outside the widget. When returning true, widgets normally call
             * [method`Gtk`.Widget.grab_focus] to place the focus accordingly;
             * when returning false, they don’t modify the current focus location.
             *
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use [method`Gtk`.Widget.grab_focus] to move
             * the focus to a particular widget.
             * @param direction direction of focus movement
             * @returns true if focus ended up inside @widget
             */
            child_focus(direction: Gtk.DirectionType | null): boolean;
            /**
             * Computes the bounds for `widget` in the coordinate space of `target`.
             *
             * The bounds of widget are (the bounding box of) the region that it is
             * expected to draw in. See the [coordinate system](coordinates.html)
             * overview to learn more.
             *
             * If the operation is successful, true is returned. If `widget` has no
             * bounds or the bounds cannot be expressed in `target'`s coordinate space
             * (for example if both widgets are in different windows), false is
             * returned and `bounds` is set to the zero rectangle.
             *
             * It is valid for `widget` and `target` to be the same widget.
             * @param target the target widget
             * @returns true if the bounds could be computed
             */
            compute_bounds(target: Gtk.Widget): [boolean, Graphene.Rect];
            /**
             * Computes whether a parent widget should give this widget
             * extra space when possible.
             *
             * Widgets with children should check this, rather than looking at
             * [method`Gtk`.Widget.get_hexpand] or [method`Gtk`.Widget.get_vexpand].
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Gtk.Orientation | null): boolean;
            /**
             * Translates the given `point` in `widget'`s coordinates to coordinates
             * in `target’`s coordinate system.
             *
             * In order to perform this operation, both widgets must share a
             * a common ancestor. If that is not the case, `out_point` is set
             * to (0, 0) and false is returned.
             * @param target the widget to transform into
             * @param point a point in @widget's coordinate system
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            compute_point(target: Gtk.Widget, point: Graphene.Point): [boolean, Graphene.Point];
            /**
             * Computes a matrix suitable to describe a transformation from
             * `widget'`s coordinate system into `target'`s coordinate system.
             *
             * The transform can not be computed in certain cases, for example
             * when `widget` and `target` do not share a common ancestor. In that
             * case `out_transform` gets set to the identity matrix.
             *
             * To learn more about widget coordinate systems, see the coordinate
             * system [overview](coordinates.html).
             * @param target the target widget that the matrix will transform to
             * @returns true if the transform could be computed
             */
            compute_transform(target: Gtk.Widget): [boolean, Graphene.Matrix];
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             * @returns true if @widget contains the point (x, y)
             */
            contains(x: number, y: number): boolean;
            /**
             * Creates a new `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map,
             * font options, font description, and base direction set.
             *
             * See also [method`Gtk`.Widget.get_pango_context].
             * @returns the new `PangoContext`
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new `PangoLayout` that is configured for the widget.
             *
             * The `PangoLayout` will have the appropriate font map,
             * font description, and base direction set.
             *
             * If you keep a `PangoLayout` created in this way around,
             * you need to re-create it when the widgets `PangoContext`
             * is replaced. This can be tracked by listening to changes
             * of the [property`Gtk`.Widget:root] property on the widget.
             * @param text text to set on the layout
             * @returns the new `PangoLayout`
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Clears the template children for the widget.
             *
             * This function is the opposite of [method`Gtk`.Widget.init_template],
             * and it is used to clear all the template children from a widget
             * instance. If you bound a template child to a field in the instance
             * structure, or in the instance private data structure, the field will
             * be set to `NULL` after this function returns.
             *
             * You should call this function inside the `GObjectClass.dispose()`
             * implementation of any widget that called [method`Gtk`.Widget.init_template].
             * Typically, you will want to call this function last, right before
             * chaining up to the parent type's dispose implementation, e.g.
             *
             * ```c
             * static void
             * some_widget_dispose (GObject *gobject)
             * {
             *   SomeWidget *self = SOME_WIDGET (gobject);
             *
             *   // Clear the template data for SomeWidget
             *   gtk_widget_dispose_template (GTK_WIDGET (self), SOME_TYPE_WIDGET);
             *
             *   G_OBJECT_CLASS (some_widget_parent_class)->dispose (gobject);
             * }
             * ```
             * @param widget_type the type of the widget to finalize the template for
             */
            dispose_template(widget_type: GObject.GType): void;
            /**
             * Checks to see if a drag movement has passed the GTK drag threshold.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns true if the drag threshold has been passed
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Notifies the user about an input-related error on the widget.
             *
             * If the [property`Gtk`.Settings:gtk-error-bell] setting is true,
             * it calls [method`Gdk`.Surface.beep], otherwise it does nothing.
             *
             * Note that the effect of [method`Gdk`.Surface.beep] can be configured
             * in many ways, depending on the windowing backend and the desktop
             * environment or window manager that is used.
             */
            error_bell(): void;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidget`Class.snapshot() function, and when allocating
             * child widgets in `GtkWidget`Class.size_allocate().
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Returns the width that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a layout widget: a widget’s allocation
             * will be its “adjusted” allocation, that is, the widget’s parent
             * typically calls [method`Gtk`.Widget.size_allocate] with an allocation,
             * and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * [method`Gtk`.Widget.get_allocation] returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * [method`Gtk`.Widget.size_allocate] allocation, however.
             *
             * So a layout widget is guaranteed that its children stay inside
             * the assigned bounds, but not that they have exactly the bounds the
             * widget assigned.
             */
            get_allocation(): Gtk.Allocation;
            /**
             * Gets the first ancestor of the widget with type `widget_type`.
             *
             * For example, `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)`
             * gets the first `GtkBox` that’s an ancestor of `widget`. No
             * reference will be added to the returned widget; it should
             * not be unreferenced.
             *
             * Note that unlike [method`Gtk`.Widget.is_ancestor], this function
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget
             */
            get_ancestor(widget_type: GObject.GType): Gtk.Widget | null;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidgetClass.snapshot()` function, and when allocating
             * child widgets in `GtkWidgetClass.size_allocate()`.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_baseline(): number;
            /**
             * Determines whether the input focus can enter the widget or any
             * of its children.
             *
             * See [method`Gtk`.Widget.set_can_focus].
             * @returns true if the input focus can enter @widget
             */
            get_can_focus(): boolean;
            /**
             * Queries whether the widget can be the target of pointer events.
             * @returns true if @widget can receive pointer events
             */
            get_can_target(): boolean;
            /**
             * Gets the value set with [method`Gtk`.Widget.set_child_visible].
             *
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @returns true if the widget is mapped with the parent
             */
            get_child_visible(): boolean;
            /**
             * Gets the clipboard object for the widget.
             *
             * This is a utility function to get the clipboard object for the
             * display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_clipboard(): Gdk.Clipboard;
            /**
             * Gets the current foreground color for the widget’s style.
             *
             * This function should only be used in snapshot
             * implementations that need to do custom drawing
             * with the foreground color.
             */
            get_color(): Gdk.RGBA;
            /**
             * Returns the list of style classes applied to the widget.
             * @returns a `NULL`-terminated list of   css classes currently applied to @widget
             */
            get_css_classes(): string[];
            /**
             * Returns the CSS name of the widget.
             * @returns the CSS name
             */
            get_css_name(): string;
            /**
             * Gets the cursor set on the widget.
             *
             * See [method`Gtk`.Widget.set_cursor] for details.
             * @returns the cursor   that is set on @widget
             */
            get_cursor(): Gdk.Cursor | null;
            /**
             * Gets the reading direction for the widget.
             *
             * See [method`Gtk`.Widget.set_direction].
             * @returns the reading direction for the widget
             */
            get_direction(): Gtk.TextDirection;
            /**
             * Get the display for the window that the widget belongs to.
             *
             * This function can only be called after the widget has been
             * added to a widget hierarchy with a `GtkRoot` at the top.
             *
             * In general, you should only create display-specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the display for this widget
             */
            get_display(): Gdk.Display;
            /**
             * Returns the widget’s first child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's first child
             */
            get_first_child(): Gtk.Widget | null;
            /**
             * Returns the focus child of the widget.
             * @returns the current focus   child of @widget
             */
            get_focus_child(): Gtk.Widget | null;
            /**
             * Returns whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * See [method`Gtk`.Widget.set_focus_on_click].
             * @returns true if the widget should grab focus when it is   clicked with the mouse
             */
            get_focus_on_click(): boolean;
            /**
             * Determines whether the widget can own the input focus.
             *
             * See [method`Gtk`.Widget.set_focusable].
             * @returns true if @widget can own the input focus
             */
            get_focusable(): boolean;
            /**
             * Gets the font map of the widget.
             *
             * See [method`Gtk`.Widget.set_font_map].
             * @returns the font map of @widget
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the `cairo_font_options_t` of the widget.
             *
             * Seee [method`Gtk`.Widget.set_font_options].
             * @returns the `cairo_font_options_t` of widget
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget.
             *
             * The frame clock is a global “ticker” that can be used to drive
             * animations and repaints. The most common reason to get the frame
             * clock is to call [method`Gdk`.FrameClock.get_frame_time], in order
             * to get a time to use for animating. For example you might record
             * the start of the animation with an initial value from
             * [method`Gdk`.FrameClock.get_frame_time], and then update the animation
             * by calling [method`Gdk`.FrameClock.get_frame_time] again during each repaint.
             *
             * [method`Gdk`.FrameClock.request_phase] will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a widget,
             * you have to use [method`Gtk`.Widget.queue_draw] which invalidates the
             * widget (thus scheduling it to receive a draw on the next frame).
             * [method`Gtk`.Widget.queue_draw] will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is mapped.
             * Reparenting a widget (which implies a temporary unmap) can change
             * the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns the frame clock
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the horizontal alignment of the widget.
             *
             * For backwards compatibility reasons this method will never return
             * one of the baseline alignments, but instead it will convert it to
             * [enum`Gtk`.Align.fill] or [enum`Gtk`.Align.center].
             *
             * Baselines are not supported for horizontal alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Gtk.Align;
            /**
             * Returns the current value of the `has-tooltip` property.
             * @returns current value of `has-tooltip` on @widget
             */
            get_has_tooltip(): boolean;
            /**
             * Returns the content height of the widget.
             *
             * This function returns the height passed to its
             * size-allocate implementation, which is the height you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The height of @widget
             */
            get_height(): number;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Widgets with children should use [method`Gtk`.Widget.compute_expand]
             * rather than this function, to see whether any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether the `hexpand` flag has been explicitly set.
             *
             * If [property`Gtk`.Widget:hexpand] property is set, then it
             * overrides any computed expand value based on child widgets.
             * If `hexpand` is not set, then the expand value depends on
             * whether any children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Returns the widget’s last child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's last child
             */
            get_last_child(): Gtk.Widget | null;
            /**
             * Retrieves the layout manager of the widget.
             *
             * See [method`Gtk`.Widget.set_layout_manager].
             * @returns the layout manager of @widget
             */
            get_layout_manager(): Gtk.LayoutManager | null;
            /**
             * Gets the value of the [property`Gtk`.Widget:limit-events] property.
             */
            get_limit_events(): boolean;
            /**
             * Returns whether the widget is mapped.
             * @returns true if the widget is mapped
             */
            get_mapped(): boolean;
            /**
             * Gets the bottom margin of the widget.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the end margin of the widget.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the start margin of the widget.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the top margin of the widget.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Retrieves the name of a widget.
             *
             * See [method`Gtk`.Widget.set_name] for the significance of widget names.
             * @returns name of the widget
             */
            get_name(): string;
            /**
             * Returns the nearest `GtkNative` ancestor of the widget.
             *
             * This function will return `NULL` if the widget is not
             * contained inside a widget tree with a native ancestor.
             *
             * `GtkNative` widgets will return themselves here.
             * @returns the `GtkNative` ancestor of @widget
             */
            get_native(): Gtk.Native | null;
            /**
             * Returns the widget’s next sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's next sibling
             */
            get_next_sibling(): Gtk.Widget | null;
            /**
             * Fetches the requested opacity for the widget.
             *
             * See [method`Gtk`.Widget.set_opacity].
             * @returns the requested opacity for this widget
             */
            get_opacity(): number;
            /**
             * Returns the widget’s overflow value.
             * @returns The widget's overflow value
             */
            get_overflow(): Gtk.Overflow;
            /**
             * Gets a `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map, font description,
             * and base direction set.
             *
             * Unlike the context returned by [method`Gtk`.Widget.create_pango_context],
             * this context is owned by the widget (it can be used until the screen
             * for the widget changes or the widget is removed from its toplevel),
             * and will be updated to match any changes to the widget’s attributes.
             * This can be tracked by listening to changes of the
             * [property`Gtk`.Widget:root] property on the widget.
             * @returns the `PangoContext` for the widget
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent widget of the widget.
             * @returns the parent widget of @widget
             */
            get_parent(): Gtk.Widget | null;
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as `GtkFixed`.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since
             * the required height for the natural width is generally smaller than the
             * required height for the minimum width.
             *
             * Use [method`Gtk`.Widget.measure] if you want to support baseline alignment.
             */
            get_preferred_size(): [Gtk.Requisition | null, Gtk.Requisition | null];
            /**
             * Returns the widget’s previous sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's previous sibling
             */
            get_prev_sibling(): Gtk.Widget | null;
            /**
             * Gets the primary clipboard of the widget.
             *
             * This is a utility function to get the primary clipboard object
             * for the display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_primary_clipboard(): Gdk.Clipboard;
            /**
             * Determines whether the widget is realized.
             * @returns true if @widget is realized
             */
            get_realized(): boolean;
            /**
             * Determines whether the widget is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See [method`Gtk`.Widget.set_receives_default].
             * @returns true if @widget acts as the default widget when focused
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             * @returns The `GtkSizeRequestMode` preferred by @widget.
             */
            get_request_mode(): Gtk.SizeRequestMode;
            /**
             * Returns the `GtkRoot` widget of the widget.
             *
             * This function will return `NULL` if the widget is not contained
             * inside a widget tree with a root widget.
             *
             * `GtkRoot` widgets will return themselves here.
             * @returns the root widget of @widget
             */
            get_root(): Gtk.Root | null;
            /**
             * Retrieves the internal scale factor that maps from window
             * coordinates to the actual device pixels.
             *
             * On traditional systems this is 1, on high density outputs,
             * it can be a higher value (typically 2).
             *
             * See [method`Gdk`.Surface.get_scale_factor].
             *
             * Note that modern systems may support *fractional* scaling,
             * where the scale factor is not an integer. On such systems,
             * this function will return the next higher integer value,
             * but you probably want to use [method`Gdk`.Surface.get_scale]
             * to get the fractional scale value.
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Returns the widget’s sensitivity.
             *
             * This function returns the value that has been set using
             * [method`Gtk`.Widget.set_sensitive]).
             *
             * The effective sensitivity of a widget is however determined
             * by both its own and its parent widget’s sensitivity.
             * See [method`Gtk`.Widget.is_sensitive].
             * @returns true if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for the widget.
             *
             * Note that this function can only be called when the `GtkWidget`
             * is attached to a toplevel, since the settings object is specific
             * to a particular display. If you want to monitor the widget for
             * changes in its settings, connect to the `notify::display` signal.
             * @returns the relevant settings object
             */
            get_settings(): Gtk.Settings;
            /**
             * Returns the content width or height of the widget.
             *
             * Which dimension is returned depends on `orientation`.
             *
             * This is equivalent to calling [method`Gtk`.Widget.get_width]
             * for [enum`Gtk`.Orientation.horizontal] or [method`Gtk`.Widget.get_height]
             * for [enum`Gtk`.Orientation.vertical], but can be used when
             * writing orientation-independent code, such as when
             * implementing [iface`Gtk`.Orientable] widgets.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @param orientation the orientation to query
             * @returns the size of @widget in @orientation
             */
            get_size(orientation: Gtk.Orientation | null): number;
            /**
             * Gets the size request that was explicitly set for the widget.
             *
             * A value of -1 stored in `width` or `height` indicates that that
             * dimension has not been set explicitly and the natural requisition
             * of the widget will be used instead.
             *
             * See [method`Gtk`.Widget.set_size_request].
             *
             * To get the size a widget will actually request, call
             * [method`Gtk`.Widget.measure] instead of this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget state as a flag set.
             *
             * It is worth mentioning that the effective [flags`Gtk`.StateFlags.insensitive]
             * state will be returned, that is, also based on parent insensitivity,
             * even if `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * [flags`Gtk`.StateFlags] to pass to a [class`Gtk`.StyleContext]
             * method, you should look at [method`Gtk`.StyleContext.get_state].
             * @returns the state flags of widget
             */
            get_state_flags(): Gtk.StateFlags;
            /**
             * Returns the style context associated to the widget.
             *
             * The returned object is guaranteed to be the same
             * for the lifetime of `widget`.
             * @returns the widgets style context
             */
            get_style_context(): Gtk.StyleContext;
            /**
             * Fetches an object build from the template XML for `widget_type` in
             * the widget.
             *
             * This will only report children which were previously declared
             * with [method`Gtk`.WidgetClass.bind_template_child_full] or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private
             * to the `widget_type` which declared the child and is meant for language
             * bindings which cannot easily make use of the GObject structure offsets.
             * @param widget_type The `GType` to get a template child for
             * @param name ID of the child defined in the template XML
             * @returns the object built in the template XML with   the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the tooltip has not been set using
             * [method`Gtk`.Widget.set_tooltip_markup], this
             * function returns `NULL`.
             * @returns the tooltip text
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the `widget'`s tooltip was set using
             * [method`Gtk`.Widget.set_tooltip_markup],
             * this function will return the escaped text.
             * @returns the tooltip text
             */
            get_tooltip_text(): string | null;
            /**
             * Gets the vertical alignment of the widget.
             * @returns the vertical alignment of @widget
             */
            get_valign(): Gtk.Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.get_hexpand] for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether the `vexpand` flag has been explicitly set.
             *
             * See [method`Gtk`.Widget.get_hexpand_set] for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible.
             *
             * If you want to take into account whether the widget’s
             * parent is also marked as visible, use
             * [method`Gtk`.Widget.is_visible] instead.
             *
             * This function does not check if the widget is
             * obscured in any way.
             *
             * See [method`Gtk`.Widget.set_visible].
             * @returns true if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Returns the content width of the widget.
             *
             * This function returns the width passed to its
             * size-allocate implementation, which is the width you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The width of @widget
             */
            get_width(): number;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             * @returns true if focus is now inside @widget
             */
            grab_focus(): boolean;
            /**
             * Returns whether a style class is currently applied to the widget.
             * @param css_class style class, without the leading period
             * @returns true if @css_class is currently applied to @widget
             */
            has_css_class(css_class: string): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus.
             *
             * This is a convenience function that takes into account whether
             * focus indication should currently be shown in the toplevel window
             * of `widget`. See [method`Gtk`.Window.get_focus_visible] for more
             * information about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * [method`Gtk`.Widget.has_focus].
             * @returns true if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Returns whether the widget is currently being destroyed.
             *
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns true if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates.
             *
             * This function must be called in the instance initializer
             * for any class which assigned itself a template using
             * [method`Gtk`.WidgetClass.set_template].
             *
             * It is important to call this function in the instance initializer
             * of a widget subclass and not in `GObject.constructed()` or
             * `GObject.constructor()` for two reasons:
             *
             *  - derived widgets will assume that the composite widgets
             *    defined by its parent classes have been created in their
             *    relative instance initializers
             *  - when calling `g_object_new()` on a widget with composite templates,
             *    it’s important to build the composite widgets before the construct
             *    properties are set. Properties passed to `g_object_new()` should
             *    take precedence over properties set in the private template XML
             *
             * A good rule of thumb is to call this function as the first thing in
             * an instance initialization function.
             */
            init_template(): void;
            /**
             * Inserts an action group into the widget's actions.
             *
             * Children of `widget` that implement [iface`Gtk`.Actionable] can
             * then be associated with actions in `group` by setting their
             * “action-name” to `prefix`.`action-name`.
             *
             * Note that inheritance is defined for individual actions. I.e.
             * even if you insert a group with prefix `prefix,` actions with
             * the same prefix will still be inherited from the parent, unless
             * the group contains an action with the same name.
             *
             * If `group` is `NULL`, a previously inserted group for `name` is
             * removed from `widget`.
             * @param name the prefix for actions in @group
             * @param group an action group
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed after `previous_sibling,` or at the beginning if
             * `previous_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_prev_sibling (widget)`
             * will return `previous_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this
             * function can also be used to reorder `widget` in the child widget
             * list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param previous_sibling the new previous sibling of @widget
             */
            insert_after(parent: Gtk.Widget, previous_sibling?: Gtk.Widget | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed before `next_sibling,` or at the end if
             * `next_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_next_sibling (widget)`
             * will return `next_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this function
             * can also be used to reorder `widget` in the child widget list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param next_sibling the new next sibling of @widget
             */
            insert_before(parent: Gtk.Widget, next_sibling?: Gtk.Widget | null): void;
            /**
             * Determines whether the widget is a descendent of `ancestor`.
             * @param ancestor another `GtkWidget`
             * @returns true if @ancestor contains @widget as a child,   grandchild, great grandchild, etc
             */
            is_ancestor(ancestor: Gtk.Widget): boolean;
            /**
             * Determines whether the widget can be drawn to.
             *
             * A widget can be drawn if it is mapped and visible.
             * @returns true if @widget is drawable
             */
            is_drawable(): boolean;
            /**
             * Determines if the widget is the focus widget within its
             * toplevel.
             *
             * This does not mean that the [property`Gtk`.Widget:has-focus]
             * property is necessarily set; [property`Gtk`.Widget:has-focus]
             * will only be set if the toplevel widget additionally has the
             * global input focus.
             * @returns true if the widget is the focus widget
             */
            is_focus(): boolean;
            /**
             * Returns the widget’s effective sensitivity.
             *
             * This means it is sensitive itself and also its
             * parent widget is sensitive.
             * @returns true if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also [method`Gtk`.Widget.get_visible] and
             * [method`Gtk`.Widget.set_visible].
             * @returns true if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             * @returns true if stopping keyboard navigation is fine, false   if the emitting widget should try to handle the keyboard   navigation attempt in its parent widget
             */
            keynav_failed(direction: Gtk.DirectionType | null): boolean;
            /**
             * Returns the widgets for which this widget is the target of a
             * mnemonic.
             *
             * Typically, these widgets will be labels. See, for example,
             * [method`Gtk`.Label.set_mnemonic_widget].
             *
             * The widgets in the list are not individually referenced.
             * If you want to iterate through the list and perform actions
             * involving callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result, (GFunc)g_object_ref, NULL)`
             * first, and then unref all the widgets afterwards.
             * @returns the list   of mnemonic labels
             */
            list_mnemonic_labels(): Gtk.Widget[];
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            measure(orientation: Gtk.Orientation | null, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             * @returns true if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Returns a list model to track the children of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track children and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's children
             */
            observe_children(): Gio.ListModel;
            /**
             * Returns a list model to track the event controllers of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track controllers and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's controllers
             */
            observe_controllers(): Gio.ListModel;
            /**
             * Finds the descendant of the widget closest to a point.
             *
             * The point (x, y) must be given in widget coordinates, so (0, 0)
             * is assumed to be the top left of `widget'`s content area.
             *
             * Usually widgets will return `NULL` if the given coordinate is not
             * contained in `widget` checked via [method`Gtk`.Widget.contains].
             * Otherwise they will recursively try to find a child that does
             * not return `NULL`. Widgets are however free to customize their
             * picking algorithm.
             *
             * This function is used on the toplevel to determine the widget
             * below the mouse cursor for purposes of hover highlighting and
             * delivering events.
             * @param x x coordinate to test, relative to @widget's origin
             * @param y y coordinate to test, relative to @widget's origin
             * @param flags flags to influence what is picked
             * @returns the widget's descendant at (x, y)
             */
            pick(x: number, y: number, flags: Gtk.PickFlags | null): Gtk.Widget | null;
            /**
             * Flags the widget for a rerun of the [vfunc`Gtk`.Widget.size_allocate]
             * function.
             *
             * Use this function instead of [method`Gtk`.Widget.queue_resize]
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is [method`Gtk`.Widget.set_halign].
             *
             * This function is only for use in widget implementations.
             */
            queue_allocate(): void;
            /**
             * Schedules this widget to be redrawn.
             *
             * The redraw will happen in the paint phase
             * of the current or the next frame.
             *
             * This means `widget'`s [vfunc`Gtk`.Widget.snapshot]
             * implementation will be called.
             */
            queue_draw(): void;
            /**
             * Flags a widget to have its size renegotiated.
             *
             * This should be called when a widget for some reason has a new
             * size request. For example, when you change the text in a
             * [class`Gtk`.Label], the label queues a resize to ensure there’s
             * enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the [vfunc`Gtk`.Widget.size_allocate]
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * [vfunc`Gtk`.Widget.size_allocate] will be silently ignored.
             *
             * This function is only for use in widget implementations.
             */
            queue_resize(): void;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            realize(): void;
            /**
             * Removes an event controller from the widget.
             *
             * The removed event controller will not receive any more events,
             * and should not be used again.
             *
             * Widgets will remove all event controllers automatically when they
             * are destroyed, there is normally no need to call this function.
             * @param controller an event controller
             */
            remove_controller(controller: Gtk.EventController): void;
            /**
             * Removes a style from the widget.
             *
             * After this, the style of `widget` will stop matching for `css_class`.
             * @param css_class style class to remove from @widget, without the leading period
             */
            remove_css_class(css_class: string): void;
            /**
             * Removes a widget from the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * The widget must have previously been added to the list with
             * [method`Gtk`.Widget.add_mnemonic_label].
             * @param label a widget that is a mnemonic label for @widget
             */
            remove_mnemonic_label(label: Gtk.Widget): void;
            /**
             * Removes a tick callback previously registered with
             * [method`Gtk`.Widget.add_tick_callback].
             * @param id an ID returned by [method@Gtk.Widget.add_tick_callback]
             */
            remove_tick_callback(id: number): void;
            /**
             * Sets whether the input focus can enter the widget or
             * any of its children.
             *
             * Applications should set `can_focus` to false to mark a
             * widget as for pointer/touch use only.
             *
             * Note that having `can_focus` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and focusable and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param can_focus whether the input focus can enter   the widget or any of its children
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether the widget can be the target of pointer events.
             * @param can_target whether this widget should be able to   receive pointer events
             */
            set_can_target(can_target: boolean): void;
            /**
             * Sets whether the widget should be mapped along with its parent.
             *
             * The child visibility can be set for widget before it is added
             * to a container with [method`Gtk`.Widget.set_parent], to avoid
             * mapping children unnecessary before immediately unmapping them.
             * However it will be reset to its default state of true when the
             * widget is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @param child_visible whether @widget should be mapped along   with its parent
             */
            set_child_visible(child_visible: boolean): void;
            /**
             * Replaces the current style classes of the widget with `classes`.
             * @param classes `NULL`-terminated list of style classes
             */
            set_css_classes(classes: string[]): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * If the `cursor` is `NULL`, `widget` will use the cursor
             * inherited from its parent.
             * @param cursor the new cursor
             */
            set_cursor(cursor?: Gdk.Cursor | null): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * This is a utility function that creates a cursor via
             * [ctor`Gdk`.Cursor.new_from_name] and then sets it on `widget`
             * with [method`Gtk`.Widget.set_cursor]. See those functions for
             * details.
             *
             * On top of that, this function allows `name` to be `NULL`, which
             * will do the same as calling [method`Gtk`.Widget.set_cursor]
             * with a `NULL` cursor.
             * @param name the name of the cursor
             */
            set_cursor_from_name(name?: string | null): void;
            /**
             * Sets the reading direction on the widget.
             *
             * This direction controls the primary direction for widgets
             * containing text, and also the direction in which the children
             * of a container are packed. The ability to set the direction is
             * present in order so that correct localization into languages with
             * right-to-left reading directions can be done.
             *
             * Generally, applications will let the default reading direction
             * prevail, except for widgets where the children are arranged in
             * an order that is explicitly visual rather than logical (such as
             * buttons for text justification).
             *
             * If the direction is set to [enum`Gtk`.TextDirection.none], then
             * the value set by [func`Gtk`.Widget.set_default_direction] will be used.
             * @param dir the new direction
             */
            set_direction(dir: Gtk.TextDirection | null): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            set_focus_child(child?: Gtk.Widget | null): void;
            /**
             * Sets whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * Making mouse clicks not grab focus is useful in places like
             * toolbars where you don’t want the keyboard focus removed from
             * the main area of the application.
             * @param focus_on_click whether the widget should grab focus when clicked   with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets whether the widget can own the input focus.
             *
             * Widget implementations should set `focusable` to true in
             * their init() function if they want to receive keyboard input.
             *
             * Note that having `focusable` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and can-focus and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param focusable whether or not @widget can own the input focus
             */
            set_focusable(focusable: boolean): void;
            /**
             * Sets the font map to use for text rendering in the widget.
             *
             * The font map is the object that is used to look up fonts.
             * Setting a custom font map can be useful in special situations,
             * e.g. when you need to add application-specific fonts to the set
             * of available fonts.
             *
             * When not set, the widget will inherit the font map from its parent.
             * @param font_map a `PangoFontMap`
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the `cairo_font_options_t` used for text rendering
             * in the widget.
             *
             * When not set, the default font options for the `GdkDisplay`
             * will be used.
             * @param options a `cairo_font_options_t` struct   to unset any previously set default font options
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of the widget.
             * @param align the horizontal alignment
             */
            set_halign(align: Gtk.Align | null): void;
            /**
             * Sets the `has-tooltip` property on the widget.
             * @param has_tooltip whether or not @widget has a tooltip
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call [method`Gtk`.Widget.compute_expand].
             * A widget can decide how the expandability of children affects its
             * own expansion by overriding the `compute_expand` virtual method on
             * `GtkWidget`.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children. The override occurs because
             * [method`Gtk`.Widget.set_hexpand] sets the hexpand-set property (see
             * [method`Gtk`.Widget.set_hexpand_set]) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag will be used.
             *
             * The [property`Gtk`.Widget:hexpand-set] property will be set
             * automatically when you call [method`Gtk`.Widget.set_hexpand]
             * to set hexpand, so the most likely reason to use this function
             * would be to unset an explicit expand flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Sets the layout manager to use for measuring and allocating children
             * of the widget.
             * @param layout_manager a layout manager
             */
            set_layout_manager(layout_manager?: Gtk.LayoutManager | null): void;
            /**
             * Sets whether the widget acts like a modal dialog,
             * with respect to event delivery.
             * @param limit_events whether to limit events
             */
            set_limit_events(limit_events: boolean): void;
            /**
             * Sets the bottom margin of the widget.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of the widget.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the start margin of the widget.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of the widget.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Sets a widgets name.
             *
             * Setting a name allows you to refer to the widget from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for [class`Gtk`.StyleContext].
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Requests the widget to be rendered partially transparent.
             *
             * An opacity of 0 is fully transparent and an opacity of 1
             * is fully opaque.
             *
             * Opacity works on both toplevel widgets and child widgets, although
             * there are some limitations: For toplevel widgets, applying opacity
             * depends on the capabilities of the windowing system. On X11, this
             * has any effect only on X displays with a compositing manager, see
             * [method`Gdk`.Display.is_composited]. On Windows and Wayland it will
             * always work, although setting a window’s opacity after the window
             * has been shown may cause some flicker.
             *
             * Note that the opacity is inherited through inclusion — if you set
             * a toplevel to be partially translucent, all of its content will
             * appear translucent, since it is ultimatively rendered on that
             * toplevel. The opacity value itself is not inherited by child
             * widgets (since that would make widgets deeper in the hierarchy
             * progressively more translucent). As a consequence, [class`Gtk`.Popover]
             * instances and other [iface`Gtk`.Native] widgets with their own surface
             * will use their own opacity value, and thus by default appear
             * non-translucent, even if they are attached to a toplevel that
             * is translucent.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * Sets how the widget treats content that is drawn outside the
             * it's content area.
             *
             * See the definition of [enum`Gtk`.Overflow] for details.
             *
             * This setting is provided for widget implementations and
             * should not be used by application code.
             *
             * The default value is [enum`Gtk`.Overflow.visible].
             * @param overflow desired overflow value
             */
            set_overflow(overflow: Gtk.Overflow | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * This takes care of details such as updating the state and style
             * of the child to reflect its new location and resizing the parent.
             * The opposite function is [method`Gtk`.Widget.unparent].
             *
             * This function is useful only when implementing subclasses of
             * `GtkWidget`.
             * @param parent parent widget
             */
            set_parent(parent: Gtk.Widget): void;
            /**
             * Sets whether the widget will be treated as the default
             * widget within its toplevel when it has the focus, even if
             * another widget is the default.
             * @param receives_default whether or not @widget can be a default widget
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets the sensitivity of the widget.
             *
             * A widget is sensitive if the user can interact with it.
             * Insensitive widgets are “grayed out” and the user can’t
             * interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive true to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of the widget.
             *
             * That is, the widget’s size request will be at least `width`
             * by `height`. You can use this function to force a widget to
             * be larger than it normally would be.
             *
             * In most cases, [method`Gtk`.Window.set_default_size] is a better
             * choice for toplevel windows than this function; setting the default
             * size will still allow users to shrink the window. Setting the size
             * request will force them to leave the window at least as large as
             * the size request.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it is
             * basically impossible to hardcode a size that will always work.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * properties
             * [property`Gtk`.Widget:margin-start],
             * [property`Gtk`.Widget:margin-end],
             * [property`Gtk`.Widget:margin-top], and
             * [property`Gtk`.Widget:margin-bottom], but it does include pretty
             * much all other padding or border properties set by any subclass
             * of `GtkWidget`.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * Turns on flag values in the current widget state.
             *
             * Typical widget states are insensitive, prelighted, etc.
             *
             * This function accepts the values [flags`Gtk`.StateFlags.dir-ltr] and
             * [flags`Gtk`.StateFlags.dir-rtl] but ignores them. If you want to set
             * the widget's direction, use [method`Gtk`.Widget.set_direction].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn on
             * @param clear whether to clear state before turning on @flags
             */
            set_state_flags(flags: Gtk.StateFlags | null, clear: boolean): void;
            /**
             * Sets the contents of the tooltip for widget.
             *
             * `markup` must contain Pango markup.
             *
             * This function will take care of setting the
             * [property`Gtk`.Widget:has-tooltip] as a side effect, and of the
             * default handler for the [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_markup].
             * @param markup the contents of the tooltip for @widget
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets the contents of the tooltip for the widget.
             *
             * If `text` contains any markup, it will be escaped.
             *
             * This function will take care of setting
             * [property`Gtk`.Widget:has-tooltip] as a side effect,
             * and of the default handler for the
             * [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_text].
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Sets the vertical alignment of the widget.
             * @param align the vertical alignment
             */
            set_valign(align: Gtk.Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.set_hexpand] for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag will be used.
             *
             * See [method`Gtk`.Widget.set_hexpand_set] for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`.
             *
             * Note that setting this to true doesn’t mean the widget is
             * actually viewable, see [method`Gtk`.Widget.get_visible].
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Returns whether the widget should contribute to
             * the measuring and allocation of its parent.
             *
             * This is false for invisible children, but also
             * for children that have their own surface, such
             * as [class`Gtk`.Popover] instances.
             * @returns true if child should be included in   measuring and allocating
             */
            should_layout(): boolean;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            show(): void;
            /**
             * Allocates widget with a transformation that translates
             * the origin to the position in `allocation`.
             *
             * This is a simple form of [method`Gtk`.Widget.allocate].
             * @param allocation position and size to be allocated to @widget
             * @param baseline the baseline of the child, or -1
             */
            size_allocate(allocation: Gtk.Allocation, baseline: number): void;
            /**
             * Snapshots a child of the widget.
             *
             * When a widget receives a call to the snapshot function,
             * it must send synthetic [vfunc`Gtk`.Widget.snapshot] calls
             * to all children. This function provides a convenient way
             * of doing this. A widget, when it receives a call to its
             * [vfunc`Gtk`.Widget.snapshot] function, calls
             * gtk_widget_snapshot_child() once for each child, passing in
             * the `snapshot` the widget received.
             *
             * This function takes care of translating the origin of `snapshot,`
             * and deciding whether the child needs to be snapshot.
             *
             * It does nothing for children that implement `GtkNative`.
             * @param child a child of @widget
             * @param snapshot snapshot as passed to the widget. In particular, no   calls to [method@Gtk.Snapshot.translate] or other transform calls   should have been made
             */
            snapshot_child(child: Gtk.Widget, snapshot: Gtk.Snapshot): void;
            /**
             * Translates coordinates relative to `src_widget’`s allocation
             * to coordinates relative to `dest_widget’`s allocations.
             *
             * In order to perform this operation, both widget must share
             * a common ancestor. If that is not the case, `dest_x` and `dest_y`
             * are set to 0 and false is returned.
             * @param dest_widget another widget
             * @param src_x X position in widget coordinates of @src_widget
             * @param src_y Y position in widget coordinates of @src_widget
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            translate_coordinates(dest_widget: Gtk.Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display of the widget.
             */
            trigger_tooltip_query(): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            unmap(): void;
            /**
             * Removes `widget` from its parent.
             *
             * This function is only for use in widget implementations,
             * typically in dispose.
             */
            unparent(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            unrealize(): void;
            /**
             * Turns off flag values for the current widget state.
             *
             * See [method`Gtk`.Widget.set_state_flags].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn off
             */
            unset_state_flags(flags: Gtk.StateFlags | null): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             */
            vfunc_contains(x: number, y: number): boolean;
            /**
             * Vfunc called when the CSS used by widget was changed. Widgets
             *   should then discard their caches that depend on CSS and queue resizes or
             *   redraws accordingly. The default implementation will take care of this for
             *   all the default CSS properties, so implementations must chain up.
             * @param change
             */
            vfunc_css_changed(change: Gtk.CssStyleChange): void;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: Gtk.TextDirection): void;
            /**
             * Vfunc for gtk_widget_child_focus()
             * @param direction
             */
            vfunc_focus(direction: Gtk.DirectionType): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             */
            vfunc_get_request_mode(): Gtk.SizeRequestMode;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             */
            vfunc_grab_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: Gtk.DirectionType): boolean;
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            vfunc_measure(orientation: Gtk.Orientation, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: Gtk.DirectionType): void;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Gtk.Tooltip): boolean;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            vfunc_realize(): void;
            /**
             * Called when the widget gets added to a `GtkRoot` widget. Must
             *   chain up
             */
            vfunc_root(): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            vfunc_set_focus_child(child?: Gtk.Widget | null): void;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Called to set the allocation, if the widget does
             *   not have a layout manager.
             * @param width
             * @param height
             * @param baseline
             */
            vfunc_size_allocate(width: number, height: number, baseline: number): void;
            /**
             * Vfunc called when a new snapshot of the widget has to be taken.
             * @param snapshot
             */
            vfunc_snapshot(snapshot: Gtk.Snapshot): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: Gtk.StateFlags): void;
            /**
             * Emitted when a system setting was changed. Must chain up.
             * @param settings
             */
            vfunc_system_setting_changed(settings: Gtk.SystemSetting): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_unmap(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            vfunc_unrealize(): void;
            /**
             * Called when the widget is about to be removed from its
             *   `GtkRoot` widget. Must chain up
             */
            vfunc_unroot(): void;
        }

        namespace Bin {
            // Constructor properties interface

            interface ConstructorProps
                extends Gtk.Widget.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps {
                child: Gtk.Widget;
            }
        }

        /**
         * A widget with one child.
         *
         * <picture>
         *   <source srcset="bin-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="bin.png" alt="bin">
         * </picture>
         *
         * The `AdwBin` widget has only one child, set with the [property`Bin:`child]
         * property.
         *
         * It is useful for deriving subclasses, since it provides common code needed
         * for handling a single child widget.
         */
        class Bin extends Gtk.Widget implements Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
            static $gtype: GObject.GType<Bin>;

            // Properties

            /**
             * The child widget of the `AdwBin`.
             */
            get child(): Gtk.Widget;
            set child(val: Gtk.Widget);

            // Constructors

            constructor(properties?: Partial<Bin.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): Bin;

            // Methods

            /**
             * Gets the child widget of `self`.
             * @returns the child widget of @self
             */
            get_child(): Gtk.Widget | null;
            /**
             * Sets the child widget of `self`.
             * @param child the child widget
             */
            set_child(child?: Gtk.Widget | null): void;

            // Inherited properties
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessible_role(): Gtk.AccessibleRole;
            set accessible_role(val: Gtk.AccessibleRole);
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessibleRole(): Gtk.AccessibleRole;
            set accessibleRole(val: Gtk.AccessibleRole);

            // Inherited methods
            /**
             * Requests the user's screen reader to announce the given message.
             *
             * This kind of notification is useful for messages that
             * either have only a visual representation or that are not
             * exposed visually at all, e.g. a notification about a
             * successful operation.
             *
             * Also, by using this API, you can ensure that the message
             * does not interrupts the user's current screen reader output.
             * @param message the string to announce
             * @param priority the priority of the announcement
             */
            announce(message: string, priority: Gtk.AccessibleAnnouncementPriority | null): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             * @returns the accessible parent
             */
            get_accessible_parent(): Gtk.Accessible | null;
            /**
             * Retrieves the accessible role of an accessible object.
             * @returns the accessible role
             */
            get_accessible_role(): Gtk.AccessibleRole;
            /**
             * Retrieves the implementation for the given accessible object.
             * @returns the accessible implementation object
             */
            get_at_context(): Gtk.ATContext;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             * @returns true if the bounds are valid, and false otherwise
             */
            get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             * @returns the first accessible child
             */
            get_first_accessible_child(): Gtk.Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             * @returns the next accessible sibling
             */
            get_next_accessible_sibling(): Gtk.Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             * @returns the value of state for the accessible
             */
            get_platform_state(state: Gtk.AccessiblePlatformState | null): boolean;
            /**
             * Resets the accessible property to its default value.
             * @param property the accessible property
             */
            reset_property(property: Gtk.AccessibleProperty | null): void;
            /**
             * Resets the accessible relation to its default value.
             * @param relation the accessible relation
             */
            reset_relation(relation: Gtk.AccessibleRelation | null): void;
            /**
             * Resets the accessible state to its default value.
             * @param state the accessible state
             */
            reset_state(state: Gtk.AccessibleState | null): void;
            /**
             * Sets the parent and sibling of an accessible object.
             *
             * This function is meant to be used by accessible implementations that are
             * not part of the widget hierarchy, and but act as a logical bridge between
             * widgets. For instance, if a widget creates an object that holds metadata
             * for each child, and you want that object to implement the `GtkAccessible`
             * interface, you will use this function to ensure that the parent of each
             * child widget is the metadata object, and the parent of each metadata
             * object is the container widget.
             * @param parent the parent accessible object
             * @param next_sibling the sibling accessible object
             */
            set_accessible_parent(parent?: Gtk.Accessible | null, next_sibling?: Gtk.Accessible | null): void;
            /**
             * Updates the next accessible sibling.
             *
             * That might be useful when a new child of a custom accessible
             * is created, and it needs to be linked to a previous child.
             * @param new_sibling the new next accessible sibling to set
             */
            update_next_accessible_sibling(new_sibling?: Gtk.Accessible | null): void;
            /**
             * Informs ATs that the platform state has changed.
             *
             * This function should be used by `GtkAccessible` implementations that
             * have a platform state but are not widgets. Widgets handle platform
             * states automatically.
             * @param state the platform state to update
             */
            update_platform_state(state: Gtk.AccessiblePlatformState | null): void;
            /**
             * Updates an array of accessible properties.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * property change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param properties an array of accessible properties
             * @param values an array of `GValues`, one for each property
             */
            update_property(properties: Gtk.AccessibleProperty[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible relations.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * relation change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param relations an array of accessible relations
             * @param values an array of `GValues`, one for each relation
             */
            update_relation(relations: Gtk.AccessibleRelation[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible states.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * state change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param states an array of accessible states
             * @param values an array of `GValues`, one for each state
             */
            update_state(states: Gtk.AccessibleState[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             */
            vfunc_get_accessible_parent(): Gtk.Accessible | null;
            /**
             * Retrieves the implementation for the given accessible object.
             */
            vfunc_get_at_context(): Gtk.ATContext | null;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             */
            vfunc_get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             */
            vfunc_get_first_accessible_child(): Gtk.Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             */
            vfunc_get_next_accessible_sibling(): Gtk.Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             */
            vfunc_get_platform_state(state: Gtk.AccessiblePlatformState): boolean;
            /**
             * Gets the ID of the `buildable` object.
             *
             * `GtkBuilder` sets the name based on the ID attribute
             * of the `<object>` tag used to construct the `buildable`.
             * @returns the ID of the buildable object
             */
            get_buildable_id(): string | null;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a `GtkBuilder`
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Gtk.Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a `GtkBuilder`
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called at the end of each custom element handled by
             * the buildable.
             * @param builder `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called for each unknown element under `<child>`.
             * @param builder a `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Gtk.Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, Gtk.BuildableParser, any];
            /**
             * The getter corresponding to `set_id`. Implement this
             *   if you implement `set_id`.
             */
            vfunc_get_id(): string;
            /**
             * Retrieves the internal child called `childname` of the `buildable` object.
             * @param builder a `GtkBuilder`
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Gtk.Builder, childname: string): T;
            /**
             * Called when a builder finishes the parsing
             *  of a UI definition. It is normally not necessary to implement this,
             *  unless you need to perform special cleanup actions. `GtkWindow` sets
             *  the `GtkWidget:visible` property here.
             * @param builder
             */
            vfunc_parser_finished(builder: Gtk.Builder): void;
            /**
             * Sets a property of a buildable object.
             *  It is normally not necessary to implement this, g_object_set_property()
             *  is used by default. `GtkWindow` implements this to delay showing itself
             *  (i.e. setting the [property`Gtk`.Widget:visible] property) until the whole
             *  interface is created.
             * @param builder
             * @param name
             * @param value
             */
            vfunc_set_buildable_property(builder: Gtk.Builder, name: string, value: GObject.Value | any): void;
            /**
             * Stores the id attribute given in the `GtkBuilder` UI definition.
             *   `GtkWidget` stores the name as object data. Implement this method if your
             *   object has some notion of “ID” and it makes sense to map the XML id
             *   attribute to it.
             * @param id
             */
            vfunc_set_id(id: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace BottomSheet {
            // Signal callback interfaces

            interface CloseAttempt {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Gtk.Widget.ConstructorProps,
                    Swipeable.ConstructorProps,
                    Gtk.Accessible.ConstructorProps,
                    Gtk.Buildable.ConstructorProps,
                    Gtk.ConstraintTarget.ConstructorProps {
                align: number;
                bottom_bar: Gtk.Widget;
                bottomBar: Gtk.Widget;
                bottom_bar_height: number;
                bottomBarHeight: number;
                can_close: boolean;
                canClose: boolean;
                can_open: boolean;
                canOpen: boolean;
                content: Gtk.Widget;
                full_width: boolean;
                fullWidth: boolean;
                modal: boolean;
                open: boolean;
                reveal_bottom_bar: boolean;
                revealBottomBar: boolean;
                sheet: Gtk.Widget;
                sheet_height: number;
                sheetHeight: number;
                show_drag_handle: boolean;
                showDragHandle: boolean;
            }
        }

        /**
         * A bottom sheet with an optional bottom bar.
         *
         * <picture>
         *   <source srcset="bottom-sheet-dark.png" media="(prefers-color-scheme: dark)">
         *   <img src="bottom-sheet.png" alt="bottom-sheet">
         * </picture>
         *
         * `AdwBottomSheet` has three child widgets. [property`BottomSheet:`content] is
         * shown persistently. [property`BottomSheet:`sheet] is displayed above it when
         * it's open, and [property`BottomSheet:`bottom-bar] is displayed when it's not.
         *
         * Bottom sheet and bottom bar are attached to the bottom edge of the widget.
         * They take the full width by default, but can only take a portion of it if
         * [property`BottomSheet:`full-width] is set to `FALSE`. In this case,
         * [property`BottomSheet:`align] determines where along the bottom edge they are
         * placed.
         *
         * Bottom bar can be hidden using the [property`BottomSheet:`reveal-bottom-bar]
         * property.
         *
         * `AdwBottomSheet` can be useful for applications such as music players, that
         * want to have a persistent bottom bar that expands into a bottom sheet when
         * clicked. It's meant for cases where a bottom sheet is tightly integrated into
         * the UI. For more transient bottom sheets, see [class`Dialog]`.
         *
         * To open or close the bottom sheet, use the [property`BottomSheet:`open]
         * property.
         *
         * By default, the bottom sheet has an overlaid drag handle. It can be disabled
         * by setting [property`BottomSheet:`show-drag-handle] to `FALSE`. Note that the
         * handle also controls whether the sheet can be dragged using a pointer.
         *
         * Bottom sheets are modal by default, meaning that the content is dimmed and
         * cannot be accessed while the sheet is open. Set [property`BottomSheet:`modal]
         * to `FALSE` if this behavior is unwanted.
         *
         * To disable user interactions for opening or closing the bottom sheet (such as
         * swipes or clicking the bottom bar or close button), set
         * [property`BottomSheet:`can-open] or [property`BottomSheet:`can-close] to
         * `FALSE`.
         *
         * In some cases, particularly when using a full-width bottom bar, it may be
         * necessary to shift [property`BottomSheet:`content] upwards. Use the
         * [property`BottomSheet:`bottom-bar-height] and
         * [property`BottomSheet:`sheet-height] for that.
         *
         * `AdwBottomSheet` is not adaptive, and for larger window sizes applications
         * may want to replace it with another UI, such as a sidebar. This can be done
         * using [class`MultiLayoutView]`.
         *
         * ## Sizing
         *
         * Unlike [class`Dialog]` presented as a bottom sheet, `AdwBottomSheet` just
         * follows the content's natural size, and it's up to the applications to make
         * sure their content provides one. For example, when using
         * [class`Gtk`.ScrolledWindow], make sure to set
         * [property`Gtk`.ScrolledWindow:propagate-natural-height] to `TRUE`.
         *
         * ## Header Bar Integration
         *
         * When placed inside an `AdwBottomSheet`, [class`HeaderBar]` will not show the
         * title when [property`BottomSheet:`show-drag-handle] is `TRUE`, regardless of
         * [property`HeaderBar:`show-title]. This only applies to the default title,
         * titles set with [property`HeaderBar:`title-widget] will still be shown.
         *
         * ## `AdwBottomSheet` as `GtkBuildable`:
         *
         * The `AdwBottomSheet` implementation of the [iface`Gtk`.Buildable] interface
         * supports setting the sheet widget by specifying “sheet” as the “type”
         * attribute of a `<child>` element, and the bottom bar by specifying
         * “bottom-bar”. Specifying “content” or omitting the child type results in
         * setting the content child.
         */
        class BottomSheet extends Gtk.Widget implements Swipeable, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
            static $gtype: GObject.GType<BottomSheet>;

            // Properties

            /**
             * Horizontal alignment of the bottom sheet.
             *
             * 0 means the bottom sheet is flush with the start edge, 1 means it's flush
             * with the end edge. 0.5 means it's centered.
             *
             * Only used when [property`BottomSheet:`full-width] is set to `FALSE`.
             */
            get align(): number;
            set align(val: number);
            /**
             * The bottom bar widget.
             *
             * Shown when [property`BottomSheet:`open] is `FALSE`. When open, morphs into
             * the [property`BottomSheet:`sheet].
             *
             * Bottom bar can be temporarily hidden using the
             * [property`BottomSheet:`reveal-bottom-bar] property.
             */
            get bottom_bar(): Gtk.Widget;
            set bottom_bar(val: Gtk.Widget);
            /**
             * The bottom bar widget.
             *
             * Shown when [property`BottomSheet:`open] is `FALSE`. When open, morphs into
             * the [property`BottomSheet:`sheet].
             *
             * Bottom bar can be temporarily hidden using the
             * [property`BottomSheet:`reveal-bottom-bar] property.
             */
            get bottomBar(): Gtk.Widget;
            set bottomBar(val: Gtk.Widget);
            /**
             * The current bottom bar height.
             *
             * It can be used to shift the content upwards permanently to accommodate for
             * the bottom bar.
             */
            get bottom_bar_height(): number;
            /**
        