/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.ProvenanceEvent;
import com.intellij.code.provenance.core.events.ProvenanceEvents;
import com.intellij.code.provenance.core.events.detection.DocumentChangeKindDetector;
import com.intellij.code.provenance.core.events.listeners.ProvenanceDocumentListenerKt;
import com.intellij.code.provenance.core.events.mergeableEvents.DocumentChanges;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002#$B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceDocumentListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "provenanceEvents", "Lcom/intellij/code/provenance/core/events/ProvenanceEvents;", "getProvenanceEvents", "()Lcom/intellij/code/provenance/core/events/ProvenanceEvents;", "provenanceEvents$delegate", "Lkotlin/Lazy;", "dispose", "", "startBulk", "bulkUpdateStarting", "document", "Lcom/intellij/openapi/editor/Document;", "bulkUpdateFinished", "finishBulk", "beforeDocumentChange", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "BeforeDocumentChangeInfo", "BulkUpdateInfo", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nProvenanceDocumentListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceDocumentListener.kt\ncom/intellij/code/provenance/core/events/listeners/ProvenanceDocumentListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1740#2,3:146\n*S KotlinDebug\n*F\n+ 1 ProvenanceDocumentListener.kt\ncom/intellij/code/provenance/core/events/listeners/ProvenanceDocumentListener\n*L\n66#1:146,3\n*E\n"})
public final class ProvenanceDocumentListener
implements BulkAwareDocumentListener,
Disposable {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile virtualFile;
    @NotNull
    private final Lazy provenanceEvents$delegate;

    public ProvenanceDocumentListener(@NotNull EditorImpl editor, @NotNull Project project, @Nullable VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.editor = editor;
        this.project = project;
        this.virtualFile = virtualFile;
        this.provenanceEvents$delegate = LazyKt.lazy(() -> ProvenanceDocumentListener.provenanceEvents_delegate$lambda$0(this));
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    private final ProvenanceEvents getProvenanceEvents() {
        Lazy lazy = this.provenanceEvents$delegate;
        return (ProvenanceEvents)lazy.getValue();
    }

    public void dispose() {
        this.finishBulk();
    }

    private final void startBulk() {
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence content = charSequence;
        this.editor.putUserData(ProvenanceDocumentListenerKt.access$getEDITOR_BULK_UPDATE_INFO_KEY$p(), (Object)new BulkUpdateInfo(content, content, new ArrayList(), null, 0L, 0L, 56, null));
    }

    public void bulkUpdateStarting(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        this.startBulk();
    }

    public void bulkUpdateFinished(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        this.finishBulk();
    }

    private final void finishBulk() {
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        BulkUpdateInfo bulkUpdateInfo = (BulkUpdateInfo)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)this.editor), (Key)ProvenanceDocumentListenerKt.access$getEDITOR_BULK_UPDATE_INFO_KEY$p());
        if (bulkUpdateInfo == null) {
            return;
        }
        BulkUpdateInfo info = bulkUpdateInfo;
        CharSequence oldContent = info.component1();
        CharSequence newContent = info.component2();
        List<ProvenanceEntry.SingleDocumentChange> diffs = info.component3();
        if (UtilsKt.isTooBigContent(oldContent) || UtilsKt.isTooBigContent(newContent)) {
            return;
        }
        if (diffs.isEmpty()) {
            return;
        }
        ProvenanceEvent.Deferred event = new ProvenanceEvent.Deferred((Function0<? extends ProvenanceEntry>)((Function0)() -> ProvenanceDocumentListener.finishBulk$lambda$0(oldContent, newContent, diffs, this, info)));
        this.getProvenanceEvents().add(event);
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        if (event.getDocument().isInBulkUpdate()) {
            return;
        }
        Key key = ProvenanceDocumentListenerKt.access$getEDITOR_BEFORE_CHANGE_INFO_KEY$p();
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        this.editor.putUserData(key, (Object)new BeforeDocumentChangeInfo(charSequence, event));
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        if (this.editor.getDocument().isInBulkUpdate()) {
            BulkUpdateInfo bulkUpdateInfo = (BulkUpdateInfo)this.editor.getUserData(ProvenanceDocumentListenerKt.access$getEDITOR_BULK_UPDATE_INFO_KEY$p());
            if (bulkUpdateInfo != null) {
                BulkUpdateInfo $this$documentChanged_u24lambda_u240 = bulkUpdateInfo;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)event.getOldFragment(), (Object)event.getNewFragment())) {
                    List<ProvenanceEntry.SingleDocumentChange> list = $this$documentChanged_u24lambda_u240.getChanges();
                    int n = event.getOffset();
                    int n2 = event.getOldLength();
                    CharSequence charSequence = event.getNewFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                    list.add(new ProvenanceEntry.SingleDocumentChange(n, n2, charSequence));
                    if ($this$documentChanged_u24lambda_u240.getKind() == DocumentChangesKind.UNKNOWN || $this$documentChanged_u24lambda_u240.getKind() == DocumentChangesKind.EXTERNAL) {
                        $this$documentChanged_u24lambda_u240.setKind(DocumentChangeKindDetector.INSTANCE.detect(this.project, (Editor)this.editor, this.virtualFile, event));
                    }
                    CharSequence charSequence2 = event.getDocument().getImmutableCharSequence();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
                    $this$documentChanged_u24lambda_u240.setNewContent(charSequence2);
                    $this$documentChanged_u24lambda_u240.setTimestampEnd(System.currentTimeMillis());
                }
            }
            return;
        }
        BeforeDocumentChangeInfo beforeDocumentChangeInfo = (BeforeDocumentChangeInfo)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)this.editor), (Key)ProvenanceDocumentListenerKt.access$getEDITOR_BEFORE_CHANGE_INFO_KEY$p());
        if (beforeDocumentChangeInfo == null) {
            return;
        }
        BeforeDocumentChangeInfo beforeDocumentChangeInfo2 = beforeDocumentChangeInfo;
        CharSequence oldContent = beforeDocumentChangeInfo2.component1();
        DocumentEvent beforeEvent = beforeDocumentChangeInfo2.component2();
        if (!Intrinsics.areEqual((Object)beforeEvent, (Object)event)) {
            return;
        }
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence newContent = charSequence;
        if (UtilsKt.isTooBigContent(oldContent) || UtilsKt.isTooBigContent(newContent)) {
            return;
        }
        DocumentChangesKind kind = DocumentChangeKindDetector.INSTANCE.detect(this.project, (Editor)this.editor, this.virtualFile, event);
        if (kind == DocumentChangesKind.EXTERNAL) {
            return;
        }
        Object object = this.virtualFile;
        if (object == null || (object = object.getPath()) == null) {
            object = "Unknown";
        }
        Object filePath = object;
        int offset = event.getOffset();
        int oldLength = event.getOldLength();
        CharSequence charSequence3 = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getNewFragment(...)");
        CharSequence newFragment = charSequence3;
        boolean isAtomic = kind != DocumentChangesKind.TYPING || StringsKt.contains$default((CharSequence)newFragment, (char)'\n', (boolean)false, (int)2, null);
        long beforeHash = UtilsKt.contentHash(oldContent);
        long afterHash = UtilsKt.contentHash(newContent);
        if (beforeHash == afterHash) {
            return;
        }
        List changes = CollectionsKt.listOf((Object)new ProvenanceEntry.SingleDocumentChange(offset, oldLength, newFragment));
        this.getProvenanceEvents().add(new DocumentChanges(changes, beforeHash, afterHash, (String)filePath, 0L, kind, !isAtomic, 16, null));
    }

    private static final ProvenanceEvents provenanceEvents_delegate$lambda$0(ProvenanceDocumentListener this$0) {
        return ProvenanceEvents.Companion.getInstance(this$0.project);
    }

    private static final ProvenanceEntry finishBulk$lambda$0(CharSequence $oldContent, CharSequence $newContent, List $diffs, ProvenanceDocumentListener this$0, BulkUpdateInfo $info) {
        List<ProvenanceEntry.SingleDocumentChange> diffs;
        boolean bl;
        long afterHash;
        long beforeHash;
        block6: {
            beforeHash = UtilsKt.contentHash($oldContent);
            if (beforeHash == (afterHash = UtilsKt.contentHash($newContent))) {
                return ProvenanceEntry.None.INSTANCE;
            }
            Iterable $this$all$iv = CollectionsKt.zipWithNext((Iterable)$diffs);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    ProvenanceEntry.SingleDocumentChange prev = (ProvenanceEntry.SingleDocumentChange)pair.component1();
                    ProvenanceEntry.SingleDocumentChange next = (ProvenanceEntry.SingleDocumentChange)pair.component2();
                    if (next.getOffset() + next.getOldLength() < prev.getOffset()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        boolean properEvents = bl;
        List<ProvenanceEntry.SingleDocumentChange> list = diffs = properEvents ? CollectionsKt.reversed((Iterable)$diffs) : UtilsKt.computeDocumentChanges($oldContent, $newContent);
        if (diffs.isEmpty()) {
            return ProvenanceEntry.None.INSTANCE;
        }
        Object object = this$0.virtualFile;
        if (object == null || (object = object.getPath()) == null) {
            object = "Unknown";
        }
        Object filePath = object;
        return new ProvenanceEntry.DocumentChange((String)filePath, diffs, $info.getDuration(), $info.getTimestampStart(), $info.getKind(), beforeHash, afterHash);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceDocumentListener$BeforeDocumentChangeInfo;", "", "oldContent", "", "documentEvent", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/openapi/editor/event/DocumentEvent;)V", "getOldContent", "()Ljava/lang/CharSequence;", "getDocumentEvent", "()Lcom/intellij/openapi/editor/event/DocumentEvent;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.code.provenance.core"})
    public static final class BeforeDocumentChangeInfo {
        @NotNull
        private final CharSequence oldContent;
        @NotNull
        private final DocumentEvent documentEvent;

        public BeforeDocumentChangeInfo(@NotNull CharSequence oldContent, @NotNull DocumentEvent documentEvent) {
            Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
            Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"documentEvent");
            this.oldContent = oldContent;
            this.documentEvent = documentEvent;
        }

        @NotNull
        public final CharSequence getOldContent() {
            return this.oldContent;
        }

        @NotNull
        public final DocumentEvent getDocumentEvent() {
            return this.documentEvent;
        }

        @NotNull
        public final CharSequence component1() {
            return this.oldContent;
        }

        @NotNull
        public final DocumentEvent component2() {
            return this.documentEvent;
        }

        @NotNull
        public final BeforeDocumentChangeInfo copy(@NotNull CharSequence oldContent, @NotNull DocumentEvent documentEvent) {
            Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
            Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"documentEvent");
            return new BeforeDocumentChangeInfo(oldContent, documentEvent);
        }

        public static /* synthetic */ BeforeDocumentChangeInfo copy$default(BeforeDocumentChangeInfo beforeDocumentChangeInfo, CharSequence charSequence, DocumentEvent documentEvent, int n, Object object) {
            if ((n & 1) != 0) {
                charSequence = beforeDocumentChangeInfo.oldContent;
            }
            if ((n & 2) != 0) {
                documentEvent = beforeDocumentChangeInfo.documentEvent;
            }
            return beforeDocumentChangeInfo.copy(charSequence, documentEvent);
        }

        @NotNull
        public String toString() {
            return "BeforeDocumentChangeInfo(oldContent=" + this.oldContent + ", documentEvent=" + this.documentEvent + ")";
        }

        public int hashCode() {
            int result = this.oldContent.hashCode();
            result = result * 31 + this.documentEvent.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BeforeDocumentChangeInfo)) {
                return false;
            }
            BeforeDocumentChangeInfo beforeDocumentChangeInfo = (BeforeDocumentChangeInfo)other;
            if (!Intrinsics.areEqual((Object)this.oldContent, (Object)beforeDocumentChangeInfo.oldContent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.documentEvent, (Object)beforeDocumentChangeInfo.documentEvent);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\t\u0010%\u001a\u00020\u000bH\u00c6\u0003J\t\u0010&\u001a\u00020\u000bH\u00c6\u0003JK\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0010\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001b\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001b\u00a8\u0006/"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceDocumentListener$BulkUpdateInfo;", "", "oldContent", "", "newContent", "changes", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;", "kind", "Lcom/intellij/code/provenance/DocumentChangesKind;", "timestampStart", "", "timestampEnd", "<init>", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/util/List;Lcom/intellij/code/provenance/DocumentChangesKind;JJ)V", "getOldContent", "()Ljava/lang/CharSequence;", "getNewContent", "setNewContent", "(Ljava/lang/CharSequence;)V", "getChanges", "()Ljava/util/List;", "getKind", "()Lcom/intellij/code/provenance/DocumentChangesKind;", "setKind", "(Lcom/intellij/code/provenance/DocumentChangesKind;)V", "getTimestampStart", "()J", "getTimestampEnd", "setTimestampEnd", "(J)V", "duration", "getDuration", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.code.provenance.core"})
    public static final class BulkUpdateInfo {
        @NotNull
        private final CharSequence oldContent;
        @NotNull
        private CharSequence newContent;
        @NotNull
        private final List<ProvenanceEntry.SingleDocumentChange> changes;
        @NotNull
        private DocumentChangesKind kind;
        private final long timestampStart;
        private long timestampEnd;

        public BulkUpdateInfo(@NotNull CharSequence oldContent, @NotNull CharSequence newContent, @NotNull List<ProvenanceEntry.SingleDocumentChange> changes, @NotNull DocumentChangesKind kind, long timestampStart, long timestampEnd) {
            Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
            Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            this.oldContent = oldContent;
            this.newContent = newContent;
            this.changes = changes;
            this.kind = kind;
            this.timestampStart = timestampStart;
            this.timestampEnd = timestampEnd;
        }

        public /* synthetic */ BulkUpdateInfo(CharSequence charSequence, CharSequence charSequence2, List list, DocumentChangesKind documentChangesKind, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                documentChangesKind = DocumentChangesKind.UNKNOWN;
            }
            if ((n & 0x10) != 0) {
                l = System.currentTimeMillis();
            }
            if ((n & 0x20) != 0) {
                l2 = l;
            }
            this(charSequence, charSequence2, list, documentChangesKind, l, l2);
        }

        @NotNull
        public final CharSequence getOldContent() {
            return this.oldContent;
        }

        @NotNull
        public final CharSequence getNewContent() {
            return this.newContent;
        }

        public final void setNewContent(@NotNull CharSequence charSequence) {
            Intrinsics.checkNotNullParameter((Object)charSequence, (String)"<set-?>");
            this.newContent = charSequence;
        }

        @NotNull
        public final List<ProvenanceEntry.SingleDocumentChange> getChanges() {
            return this.changes;
        }

        @NotNull
        public final DocumentChangesKind getKind() {
            return this.kind;
        }

        public final void setKind(@NotNull DocumentChangesKind documentChangesKind) {
            Intrinsics.checkNotNullParameter((Object)documentChangesKind, (String)"<set-?>");
            this.kind = documentChangesKind;
        }

        public final long getTimestampStart() {
            return this.timestampStart;
        }

        public final long getTimestampEnd() {
            return this.timestampEnd;
        }

        public final void setTimestampEnd(long l) {
            this.timestampEnd = l;
        }

        public final long getDuration() {
            return this.timestampEnd - this.timestampStart;
        }

        @NotNull
        public final CharSequence component1() {
            return this.oldContent;
        }

        @NotNull
        public final CharSequence component2() {
            return this.newContent;
        }

        @NotNull
        public final List<ProvenanceEntry.SingleDocumentChange> component3() {
            return this.changes;
        }

        @NotNull
        public final DocumentChangesKind component4() {
            return this.kind;
        }

        public final long component5() {
            return this.timestampStart;
        }

        public final long component6() {
            return this.timestampEnd;
        }

        @NotNull
        public final BulkUpdateInfo copy(@NotNull CharSequence oldContent, @NotNull CharSequence newContent, @NotNull List<ProvenanceEntry.SingleDocumentChange> changes, @NotNull DocumentChangesKind kind, long timestampStart, long timestampEnd) {
            Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
            Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return new BulkUpdateInfo(oldContent, newContent, changes, kind, timestampStart, timestampEnd);
        }

        public static /* synthetic */ BulkUpdateInfo copy$default(BulkUpdateInfo bulkUpdateInfo, CharSequence charSequence, CharSequence charSequence2, List list, DocumentChangesKind documentChangesKind, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                charSequence = bulkUpdateInfo.oldContent;
            }
            if ((n & 2) != 0) {
                charSequence2 = bulkUpdateInfo.newContent;
            }
            if ((n & 4) != 0) {
                list = bulkUpdateInfo.changes;
            }
            if ((n & 8) != 0) {
                documentChangesKind = bulkUpdateInfo.kind;
            }
            if ((n & 0x10) != 0) {
                l = bulkUpdateInfo.timestampStart;
            }
            if ((n & 0x20) != 0) {
                l2 = bulkUpdateInfo.timestampEnd;
            }
            return bulkUpdateInfo.copy(charSequence, charSequence2, list, documentChangesKind, l, l2);
        }

        @NotNull
        public String toString() {
            return "BulkUpdateInfo(oldContent=" + this.oldContent + ", newContent=" + this.newContent + ", changes=" + this.changes + ", kind=" + this.kind + ", timestampStart=" + this.timestampStart + ", timestampEnd=" + this.timestampEnd + ")";
        }

        public int hashCode() {
            int result = this.oldContent.hashCode();
            result = result * 31 + this.newContent.hashCode();
            result = result * 31 + ((Object)this.changes).hashCode();
            result = result * 31 + this.kind.hashCode();
            result = result * 31 + Long.hashCode(this.timestampStart);
            result = result * 31 + Long.hashCode(this.timestampEnd);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BulkUpdateInfo)) {
                return false;
            }
            BulkUpdateInfo bulkUpdateInfo = (BulkUpdateInfo)other;
            if (!Intrinsics.areEqual((Object)this.oldContent, (Object)bulkUpdateInfo.oldContent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newContent, (Object)bulkUpdateInfo.newContent)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.changes, bulkUpdateInfo.changes)) {
                return false;
            }
            if (this.kind != bulkUpdateInfo.kind) {
                return false;
            }
            if (this.timestampStart != bulkUpdateInfo.timestampStart) {
                return false;
            }
            return this.timestampEnd == bulkUpdateInfo.timestampEnd;
        }
    }
}

