/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners.utils;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.storage.ProvenanceStorage;
import com.intellij.code.provenance.core.events.utils.Path_utilsKt;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a?\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000b\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001\u001aJ\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"createToolDocumentChange", "Lcom/intellij/code/provenance/core/ProvenanceEntry$MetadataEntryOfDocumentChange;", "kind", "Lcom/intellij/code/provenance/DocumentChangesKind;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "oldContentHash", "", "newContentHash", "ts", "duration", "(Lcom/intellij/code/provenance/DocumentChangesKind;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Long;Ljava/lang/Long;JJ)Lcom/intellij/code/provenance/core/ProvenanceEntry$MetadataEntryOfDocumentChange;", "saveToolChange", "", "project", "Lcom/intellij/openapi/project/Project;", "change", "processFileChange", "filePath", "", "beforeContent", "", "afterContent", "timestamp", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.code.provenance.core"})
public final class Listener_toolsKt {
    @NotNull
    public static final ProvenanceEntry.MetadataEntryOfDocumentChange createToolDocumentChange(@NotNull DocumentChangesKind kind, @NotNull VirtualFile file, @Nullable Long oldContentHash, @Nullable Long newContentHash, long ts, long duration) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = string;
        return new ProvenanceEntry.MetadataEntryOfDocumentChange(string2, ts, kind, oldContentHash, newContentHash, duration);
    }

    public static final void saveToolChange(@NotNull Project project, @NotNull ProvenanceEntry.MetadataEntryOfDocumentChange change) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ProvenanceStorage provenanceStorage = ProvenanceStorage.Companion.getInstance(project);
        provenanceStorage.addMetadata(change);
    }

    public static final void processFileChange(@NotNull Project project, @NotNull String filePath, @NotNull DocumentChangesKind kind, @NotNull CharSequence beforeContent, @NotNull CharSequence afterContent, long timestamp, long duration, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)beforeContent, (String)"beforeContent");
        Intrinsics.checkNotNullParameter((Object)afterContent, (String)"afterContent");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        VirtualFile virtualFile = Path_utilsKt.findVirtualFileByPath$default(project, filePath, false, 2, null);
        if (virtualFile == null && (virtualFile = Path_utilsKt.findVirtualFileByPath(project, filePath, true)) == null) {
            boolean bl = false;
            logger.debug("File not found or not a file: " + filePath);
            return;
        }
        VirtualFile file = virtualFile;
        try {
            long currentContentHash = UtilsKt.contentHash(afterContent);
            long oldContentHash = UtilsKt.contentHash(beforeContent);
            ProvenanceEntry.MetadataEntryOfDocumentChange change = Listener_toolsKt.createToolDocumentChange(kind, file, oldContentHash, currentContentHash, timestamp, duration);
            Listener_toolsKt.saveToolChange(project, change);
        }
        catch (Exception e) {
            logger.warn("Failed to process file change for: " + filePath, (Throwable)e);
        }
    }

    public static /* synthetic */ void processFileChange$default(Project project, String string, DocumentChangesKind documentChangesKind, CharSequence charSequence, CharSequence charSequence2, long l, long l2, Logger logger, int n, Object object) {
        if ((n & 0x20) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n & 0x40) != 0) {
            l2 = 0L;
        }
        Listener_toolsKt.processFileChange(project, string, documentChangesKind, charSequence, charSequence2, l, l2, logger);
    }
}

