/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.velocity.editorActions.EditorUtil;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.files.VtlFileViewProvider;

public class VelocityBackspaceHandler
extends BackspaceHandlerDelegate {
    private int pairedBraceOffset;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        this.pairedBraceOffset = -1;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        if (c != '{' && c != '(') {
            return;
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        if (!(file.getViewProvider() instanceof VtlFileViewProvider) || offset == 0) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if (EditorUtil.getElementType(parent) == VtlCompositeElementTypes.INTERPOLATION) {
            this.pairedBraceOffset = parent.getTextOffset() + parent.getTextLength() - 1;
        } else {
            String text = element.getText().trim();
            if ("${".startsWith(text) || "#{".startsWith(text) || "${}".startsWith(text) || "#{}".startsWith(text) || "()".startsWith(text)) {
                this.pairedBraceOffset = offset + 1;
            }
        }
        char pairChar = EditorUtil.getCharAt(document, this.pairedBraceOffset);
        if ('}' != pairChar && ')' != pairChar) {
            this.pairedBraceOffset = -1;
        }
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        if (this.pairedBraceOffset != -1) {
            int offset = editor.getCaretModel().getOffset();
            Document doc = editor.getDocument();
            if (this.pairedBraceOffset - offset == 1 && c == '{') {
                doc.deleteString(this.pairedBraceOffset - 2, this.pairedBraceOffset);
            } else {
                doc.deleteString(this.pairedBraceOffset - 1, this.pairedBraceOffset);
            }
            this.pairedBraceOffset = -1;
            return true;
        }
        return false;
    }
}

