/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VtlTypeSystem;
import com.intellij.velocity.psi.VtlCompositeElement;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlExpressionTypeCalculator;
import com.intellij.velocity.psi.VtlOperatorTokenType;
import com.intellij.velocity.psi.VtlVariableType;
import org.jetbrains.annotations.NotNull;

public class VtlOperatorExpression
extends VtlCompositeElement
implements VtlExpression {
    private final boolean myBinary;

    public VtlOperatorExpression(@NotNull ASTNode node, boolean binary) {
        if (node == null) {
            VtlOperatorExpression.$$$reportNull$$$0(0);
        }
        super(node);
        this.myBinary = binary;
    }

    @Override
    public VtlVariableType getPsiType() {
        VtlExpressionTypeCalculator typeCalculator = this.getOperationSign().getTypeCalculator();
        VtlExpression operand1 = this.getOperand1();
        if (operand1 == null) {
            return null;
        }
        if (!this.myBinary) {
            return typeCalculator.calculateUnary(operand1);
        }
        VtlExpression operand2 = this.getOperand2();
        if (operand2 == null) {
            return null;
        }
        return typeCalculator.calculateBinary(operand1, operand2);
    }

    @NotNull
    private VtlOperatorTokenType getOperationSign() {
        ASTNode operationNode = this.getNode().findChildByType(VtlElementTypes.OPERATIONS);
        assert (operationNode != null) : this.getText();
        IElementType tokenType = operationNode.getElementType();
        assert (tokenType instanceof VtlOperatorTokenType) : this.getText();
        VtlOperatorTokenType vtlOperatorTokenType = (VtlOperatorTokenType)tokenType;
        if (vtlOperatorTokenType == null) {
            VtlOperatorExpression.$$$reportNull$$$0(1);
        }
        return vtlOperatorTokenType;
    }

    private VtlExpression getOperand1() {
        return (VtlExpression)this.findChildByClass(VtlExpression.class);
    }

    private VtlExpression getOperand2() {
        PsiElement second;
        VtlExpression first = this.getOperand1();
        if (first == null) {
            return null;
        }
        for (second = first.getNextSibling(); second != null && !(second instanceof VtlExpression); second = second.getNextSibling()) {
        }
        return (VtlExpression)second;
    }

    @InspectionMessage
    public String getIndefiniteTypeMessage() {
        VtlVariableType opType2;
        VtlVariableType opType1;
        VtlExpression op1 = this.getOperand1();
        VtlVariableType vtlVariableType = opType1 = op1 == null ? null : op1.getPsiType();
        if (opType1 == null) {
            return null;
        }
        if (!this.myBinary) {
            return VelocityBundle.message("invalid.operand.type", VtlTypeSystem.getTypeSystem().getPresentableText(opType1));
        }
        VtlExpression op2 = this.getOperand2();
        VtlVariableType vtlVariableType2 = opType2 = op2 == null ? null : op2.getPsiType();
        if (opType2 == null) {
            return null;
        }
        return VelocityBundle.message("invalid.operands.type", VtlTypeSystem.getTypeSystem().getPresentableText(opType1), VtlTypeSystem.getTypeSystem().getPresentableText(opType2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/VtlOperatorExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/VtlOperatorExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

