/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.parsers;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.parsers.CompositeBodyParser;
import com.intellij.velocity.psi.parsers.VtlParser;
import org.jetbrains.annotations.Nullable;

public class InterpolationBodyParser
extends CompositeBodyParser {
    private final boolean myFormal;

    public InterpolationBodyParser(boolean formal) {
        this.myFormal = formal;
    }

    @Override
    public void parseBody(PsiBuilder builder, @Nullable PsiBuilder.Marker bodyMarker) {
        PsiBuilder.Marker referenceExpression = builder.mark();
        if (InterpolationBodyParser.assertToken(builder, VtlElementTypes.IDENTIFIER, VtlElementTypes.REFERENCE_EXPRESSION)) {
            while (true) {
                if (builder.getTokenType() == VtlElementTypes.JAVA_DOT) {
                    builder.advanceLexer();
                    if (!InterpolationBodyParser.assertToken(builder, VtlElementTypes.IDENTIFIER)) break;
                    referenceExpression.done((IElementType)VtlElementTypes.REFERENCE_EXPRESSION);
                    if (builder.getTokenType() == VtlElementTypes.LEFT_PAREN) {
                        referenceExpression = referenceExpression.precede();
                        InterpolationBodyParser.parseArgumentList(builder, true, true);
                        referenceExpression.done((IElementType)VtlElementTypes.METHOD_CALL_EXPRESSION);
                    }
                    referenceExpression = referenceExpression.precede();
                    continue;
                }
                if (builder.getTokenType() != VtlElementTypes.LEFT_BRACKET) break;
                builder.advanceLexer();
                VtlParser.parseOperand(builder, false);
                if (!InterpolationBodyParser.assertToken(builder, VtlElementTypes.RIGHT_BRACKET)) break;
                referenceExpression.done((IElementType)VtlElementTypes.INDEX_EXPRESSION);
                referenceExpression = referenceExpression.precede();
            }
        }
        referenceExpression.drop();
        if (this.myFormal) {
            InterpolationBodyParser.assertToken(builder, VtlElementTypes.RIGHT_BRACE);
        }
        if (bodyMarker != null) {
            bodyMarker.done((IElementType)VtlElementTypes.INTERPOLATION);
        }
    }
}

