/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler.singular;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularCollectionHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.PsiTypeUtil;
import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SingularGuavaCollectionHandler
extends SingularCollectionHandler {
    private final boolean sortedCollection;
    private final String typeCollectionQualifiedName;

    SingularGuavaCollectionHandler(String collectionQualifiedName, boolean sortedCollection) {
        super(collectionQualifiedName);
        this.sortedCollection = sortedCollection;
        this.typeCollectionQualifiedName = "com.google.common.collect.ImmutableCollection".equals(collectionQualifiedName) ? "com.google.common.collect.ImmutableList" : collectionQualifiedName;
    }

    @NotNull
    private static PsiType getCollectionType(@NotNull PsiType psiFieldType, PsiManager psiManager) {
        if (psiFieldType == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(0);
        }
        PsiType elementType = PsiTypeUtil.extractAllElementType(psiFieldType, psiManager);
        PsiType psiType = PsiTypeUtil.createCollectionType(psiManager, "java.lang.Iterable", elementType);
        if (psiType == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    @Override
    protected List<PsiType> getAllMethodParameterTypes(@NotNull BuilderInfo info) {
        if (info == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(2);
        }
        PsiType collectionType = SingularGuavaCollectionHandler.getCollectionType(info.getFieldType(), info.getManager());
        return List.of(collectionType);
    }

    @Override
    @NotNull
    protected PsiType getBuilderFieldType(@NotNull PsiType psiFieldType, @NotNull Project project) {
        if (psiFieldType == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(4);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiType elementType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager);
        PsiType psiType = PsiTypeUtil.createCollectionType(psiManager, this.typeCollectionQualifiedName + ".Builder", elementType);
        if (psiType == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    @Override
    protected void addAllMethodParameter(@NotNull LombokLightMethodBuilder methodBuilder, @NotNull PsiType psiFieldType, @NotNull String singularName) {
        if (methodBuilder == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(6);
        }
        if (psiFieldType == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(7);
        }
        if (singularName == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(8);
        }
        PsiManager psiManager = methodBuilder.getManager();
        PsiType collectionType = SingularGuavaCollectionHandler.getCollectionType(psiFieldType, psiManager);
        methodBuilder.withParameter(singularName, collectionType);
    }

    @Override
    protected String getClearMethodBody(@NotNull BuilderInfo info) {
        if (info == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(9);
        }
        String codeBlockFormat = "this.{0} = null;\nreturn {1};";
        return MessageFormat.format("this.{0} = null;\nreturn {1};", info.getFieldName(), info.getBuilderChainResult());
    }

    @Override
    protected String getOneMethodBody(@NotNull String singularName, @NotNull BuilderInfo info) {
        if (singularName == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(10);
        }
        if (info == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(11);
        }
        String codeBlockTemplate = "if (this.{0} == null) this.{0} = {2}.{3}; \nthis.{0}.add({1});\nreturn {4};";
        return MessageFormat.format("if (this.{0} == null) this.{0} = {2}.{3}; \nthis.{0}.add({1});\nreturn {4};", info.getFieldName(), singularName, this.typeCollectionQualifiedName, this.sortedCollection ? "naturalOrder()" : "builder()", info.getBuilderChainResult());
    }

    @Override
    protected String getAllMethodBody(@NotNull String singularName, @NotNull BuilderInfo info) {
        if (singularName == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(12);
        }
        if (info == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(13);
        }
        String codeBlockTemplate = "if({0}==null)'{'throw new NullPointerException(\"{0} cannot be null\");'}'\nif (this.{0} == null) this.{0} = {1}.{2}; \nthis.{0}.addAll({0});\nreturn {3};";
        return MessageFormat.format("if({0}==null)'{'throw new NullPointerException(\"{0} cannot be null\");'}'\nif (this.{0} == null) this.{0} = {1}.{2}; \nthis.{0}.addAll({0});\nreturn {3};", singularName, this.typeCollectionQualifiedName, this.sortedCollection ? "naturalOrder()" : "builder()", info.getBuilderChainResult());
    }

    @Override
    public String renderBuildCode(@NotNull PsiVariable psiVariable, @NotNull String fieldName, @NotNull String builderVariable) {
        if (psiVariable == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(14);
        }
        if (fieldName == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(15);
        }
        if (builderVariable == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(16);
        }
        PsiManager psiManager = psiVariable.getManager();
        PsiType psiFieldType = psiVariable.getType();
        PsiType elementType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager);
        return MessageFormat.format("{2}<{1}> {0} = {4}.{0} == null ? {3}.<{1}>of() : {4}.{0}.build();\n", fieldName, elementType.getCanonicalText(false), this.collectionQualifiedName, this.typeCollectionQualifiedName, builderVariable);
    }

    @Override
    protected String getEmptyCollectionCall(@NotNull BuilderInfo info) {
        if (info == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(17);
        }
        return this.typeCollectionQualifiedName + ".builder()";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFieldType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/singular/SingularGuavaCollectionHandler";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodBuilder";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singularName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/singular/SingularGuavaCollectionHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderFieldType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionType";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodParameterTypes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderFieldType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAllMethodParameter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClearMethodBody";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOneMethodBody";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodBody";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renderBuildCode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyCollectionCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

