/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.quickfix;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.LombokBundle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFieldQuickFix
extends PsiUpdateModCommandAction<PsiClass> {
    private final String myName;
    private final PsiType myType;
    private final String myInitializerText;
    private final Collection<String> myModifiers;

    public CreateFieldQuickFix(@NotNull PsiClass psiClass, @NotNull String name, @NotNull PsiType psiType, @Nullable String initializerText, String ... modifiers) {
        if (psiClass == null) {
            CreateFieldQuickFix.$$$reportNull$$$0(0);
        }
        if (name == null) {
            CreateFieldQuickFix.$$$reportNull$$$0(1);
        }
        if (psiType == null) {
            CreateFieldQuickFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)psiClass);
        this.myName = name;
        this.myType = psiType;
        this.myInitializerText = initializerText;
        this.myModifiers = Arrays.asList(modifiers);
    }

    @NotNull
    public String getFamilyName() {
        String string = LombokBundle.message("intention.name.create.new.field.s", this.myName);
        if (string == null) {
            CreateFieldQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiClass myClass, @NotNull ModPsiUpdater updater) {
        List generationInfos;
        PsiElement lBrace;
        if (context == null) {
            CreateFieldQuickFix.$$$reportNull$$$0(4);
        }
        if (myClass == null) {
            CreateFieldQuickFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            CreateFieldQuickFix.$$$reportNull$$$0(6);
        }
        if ((lBrace = myClass.getLBrace()) == null) {
            return;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)context.project());
        PsiField psiField = psiElementFactory.createField(this.myName, this.myType);
        PsiModifierList modifierList = psiField.getModifierList();
        if (modifierList != null) {
            for (String modifier : this.myModifiers) {
                modifierList.setModifierProperty(modifier, true);
            }
        }
        if (this.myInitializerText != null) {
            PsiExpression psiInitializer = psiElementFactory.createExpressionFromText(this.myInitializerText, (PsiElement)psiField);
            psiField.setInitializer(psiInitializer);
        }
        if (!(generationInfos = GenerateMembersUtil.insertMembersAtOffset((PsiFile)myClass.getContainingFile(), (int)lBrace.getTextRange().getEndOffset(), List.of(new PsiGenerationInfo((PsiMember)psiField)))).isEmpty()) {
            PsiField psiMember = Objects.requireNonNull((PsiField)((PsiGenerationInfo)generationInfos.iterator().next()).getPsiMember());
            updater.moveCaretTo(psiMember.getTextRange().getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/quickfix/CreateFieldQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/quickfix/CreateFieldQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

