/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.config.anno;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class CodeConfigurationPropertiesParser {
    private final PsiClass myClass;

    public CodeConfigurationPropertiesParser(PsiClass aClass) {
        this.myClass = aClass;
    }

    @Nullable
    public String getString(String methodName, boolean checkBases) {
        UExpression returnUEspression = (UExpression)ContainerUtil.getOnlyItem(this.getReturnedUExpression(methodName, checkBases));
        if (returnUEspression != null) {
            return UastUtils.evaluateString((UExpression)returnUEspression);
        }
        PsiMethod compiledMethod = this.getCompiledMethod(methodName, checkBases);
        if (compiledMethod == null) {
            return null;
        }
        return CodeConfigurationPropertiesParser.getStringCompiled(compiledMethod);
    }

    @Nullable
    private static String getStringCompiled(PsiMethod psiMethod) {
        VirtualFile file = psiMethod.getContainingFile().getVirtualFile();
        if (file == null) {
            return null;
        }
        StringConstantVisitor stringConstantVisitor = new StringConstantVisitor(psiMethod);
        try {
            new ClassReader(file.contentsToByteArray()).accept((ClassVisitor)stringConstantVisitor, 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringConstantVisitor.getResult();
    }

    public String @NotNull [] getStringArray(String methodName, boolean checkBases) {
        UExpression value = (UExpression)ContainerUtil.getOnlyItem(this.getReturnedUExpression(methodName, checkBases));
        if (value == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                CodeConfigurationPropertiesParser.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])StreamEx.of(CodeConfigurationPropertiesParser.getArrayInitializerExpression(value)).map(UastUtils::evaluateString).nonNull().toArray((Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            CodeConfigurationPropertiesParser.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public List<PsiClass> getPsiClasses(String methodName, boolean checkBases) {
        UExpression value = (UExpression)ContainerUtil.getOnlyItem(this.getReturnedUExpression(methodName, checkBases));
        if (value == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CodeConfigurationPropertiesParser.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = StreamEx.of(CodeConfigurationPropertiesParser.getArrayInitializerExpression(value)).map(CodeConfigurationPropertiesParser::evaluateToPsiClass).nonNull().toList();
        if (list == null) {
            CodeConfigurationPropertiesParser.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static PsiClass evaluateToPsiClass(UExpression expression) {
        if (expression instanceof UQualifiedReferenceExpression) {
            expression = ((UQualifiedReferenceExpression)expression).getReceiver();
        }
        if (expression instanceof UClassLiteralExpression) {
            return PsiTypesUtil.getPsiClass((PsiType)((UClassLiteralExpression)expression).getType());
        }
        return null;
    }

    @Nullable
    private PsiMethod getCompiledMethod(String methodName, boolean checkBases) {
        for (PsiMethod psiMethod : this.myClass.findMethodsByName(methodName, checkBases)) {
            if (!(psiMethod instanceof PsiCompiledElement)) continue;
            return psiMethod;
        }
        return null;
    }

    private List<UExpression> getReturnedUExpression(String methodName, boolean checkBases) {
        PsiMethod[] methodsByName;
        for (PsiMethod psiMethod : methodsByName = this.myClass.findMethodsByName(methodName, checkBases)) {
            List expressions = SpringCommonUtils.getReturnedUExpression((PsiMethod)psiMethod);
            if (expressions.isEmpty()) continue;
            return expressions;
        }
        return Collections.emptyList();
    }

    private static List<UExpression> getArrayInitializerExpression(@NotNull UExpression expression) {
        UElement referenceResolve;
        if (expression == null) {
            CodeConfigurationPropertiesParser.$$$reportNull$$$0(4);
        }
        if (expression instanceof UReferenceExpression && (referenceResolve = UastContextKt.toUElement((PsiElement)((UReferenceExpression)expression).resolve())) instanceof UField) {
            expression = ((UField)referenceResolve).getUastInitializer();
        }
        if (expression instanceof UCallExpression && (((UCallExpression)expression).getKind().equals(UastCallKind.NEW_ARRAY_WITH_INITIALIZER) || "arrayOf".equals(((UCallExpression)expression).getMethodName()))) {
            return ((UCallExpression)expression).getValueArguments();
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/config/anno/CodeConfigurationPropertiesParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringArray";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/config/anno/CodeConfigurationPropertiesParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArrayInitializerExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class StringConstantVisitor
    extends ClassVisitor {
        private final PsiMethod myPsiMethod;
        private String myResult;

        private StringConstantVisitor(PsiMethod psiMethod) {
            super(589824);
            this.myPsiMethod = psiMethod;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.myPsiMethod.getName().equals(name)) {
                return new MethodVisitor(589824){

                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof String) {
                            myResult = (String)cst;
                        }
                    }
                };
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        private String getResult() {
            return this.myResult;
        }
    }
}

