/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.restTestClient;

import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.jvm.cache.SourceTestLibSearcher;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import com.intellij.spring.mvc.webClient.restTestClient.RestTestClientModel;
import com.intellij.spring.mvc.webClient.restTestClient.RestTestClientUtils;
import com.intellij.uast.UastModificationTracker;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/intellij/spring/mvc/webClient/restTestClient/RestTestClientFramework;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "<init>", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "isValidEndpoint", "", "group", "endpoint", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getNavigationElement", "myHoldersSearcher", "Lcom/intellij/microservices/jvm/cache/SourceTestLibSearcher;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "intellij.spring.mvc.impl"})
public final class RestTestClientFramework
implements EndpointsProvider<WebClientHolder, WebClientUrl> {
    @NotNull
    private final SourceTestLibSearcher<WebClientHolder> myHoldersSearcher = new SourceTestLibSearcher("SPRING_TEST_REST_CLIENT", (Function2)new Function2<Module, GlobalSearchScope, Set<? extends WebClientHolder>>((Object)RestTestClientModel.INSTANCE){

        public final Set<WebClientHolder> invoke(Module p0, GlobalSearchScope p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return ((RestTestClientModel)this.receiver).findHolders(p0, p1);
        }
    });
    @NotNull
    private final FrameworkPresentation presentation;

    public RestTestClientFramework() {
        String string = SpringMvcBundle.message("spring.rest.test.client.endpoints.view.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.presentation = new FrameworkPresentation("Spring-RestTestClient", string, SpringApiIcons.SpringWeb);
    }

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_CLIENT_TYPE;
    }

    public boolean isValidEndpoint(@NotNull WebClientHolder group, @NotNull WebClientUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull WebClientHolder group, @NotNull WebClientUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return (ItemPresentation)new HttpMethodPresentation(endpoint.getUriPresentation(), endpoint.getHttpMethod(), group.getName(), SpringApiIcons.SpringWeb, null, 16, null);
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull WebClientHolder group, @NotNull WebClientUrl endpoint) {
        UElement parent;
        UElement uElement;
        UElement uElement2;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        UElement uElement3 = uElement2 = UastContextKt.toUElement((PsiElement)endpoint.getPsiElement());
        if (uElement3 != null) {
            Class[] classArray = new Class[]{UClass.class};
            uElement = UastUtils.getParentOfType((UElement)uElement3, (boolean)true, UMethod.class, (Class[])classArray);
        } else {
            uElement = null;
        }
        UElement uElement4 = parent = uElement;
        return uElement4 != null ? uElement4.getSourcePsi() : null;
    }

    @NotNull
    public PsiElement getNavigationElement(@NotNull WebClientHolder group, @NotNull WebClientUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getPsiElement();
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!RestTestClientUtils.isRestTestClientAvailable(project)) {
            return EndpointsProvider.Status.UNAVAILABLE;
        }
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public Iterable<WebClientHolder> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!RestTestClientUtils.isRestTestClientAvailable(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.myHoldersSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<WebClientUrl> getEndpoints(@NotNull WebClientHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return RestTestClientModel.INSTANCE.getEndpoints(group);
    }
}

