/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DiffRequestProcessorWithProducers;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.PresentableGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.platform.vcs.impl.shared.changes.DiffPreviewUpdateProcessor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeViewDiffRequestProcessor
extends CacheDiffRequestProcessor.Simple
implements DiffPreviewUpdateProcessor,
DiffRequestProcessorWithProducers {
    private static final int MANY_CHANGES_THRESHOLD = 10000;
    @Nullable
    private Wrapper myCurrentChange;

    public ChangeViewDiffRequestProcessor(@NotNull Project project, @NotNull String place) {
        if (project == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        super(project, place);
    }

    @Override
    public ListSelection<? extends DiffRequestProducer> collectDiffProducers(boolean selectedOnly) {
        Project project = this.getProject();
        Wrapper change = this.getCurrentChange();
        ArrayList changes = ContainerUtil.newArrayList(selectedOnly ? this.iterateSelectedChanges() : this.iterateAllChanges());
        return ListSelection.create((List)changes, (Object)change).withExplicitSelection(selectedOnly).map(wrapper2 -> wrapper2.createProducer(project));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.OverrideOnly
    @NotNull
    public Stream<? extends Wrapper> getSelectedChanges() {
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.OverrideOnly
    @NotNull
    public Stream<? extends Wrapper> getAllChanges() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Iterable<? extends Wrapper> iterateSelectedChanges() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getSelectedChanges().collect(Collectors.toList()));
        if (jBIterable == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<? extends Wrapper> iterateAllChanges() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getAllChanges().collect(Collectors.toList()));
        if (jBIterable == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    protected abstract void selectChange(@NotNull Wrapper var1);

    protected boolean showAllChangesForEmptySelection() {
        return true;
    }

    public boolean forceKeepCurrentFileWhileFocused() {
        return false;
    }

    protected DiffRequestProducer getCurrentRequestProvider() {
        return this.myCurrentChange != null ? this.myCurrentChange.createProducer(this.getProject()) : null;
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull DiffRequestProducer provider) {
        DiffRequest request;
        if (provider == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(4);
        }
        return ChangeViewDiffRequestProcessor.isRequestValid(request = super.loadRequestFast((Object)provider)) ? request : null;
    }

    private static boolean isRequestValid(@Nullable DiffRequest request) {
        if (request instanceof ContentDiffRequest) {
            for (DiffContent content : ((ContentDiffRequest)request).getContents()) {
                if (!(content instanceof FileContent) || ((FileContent)content).getFile().isValid()) continue;
                return false;
            }
        }
        return true;
    }

    public void updatePreview(boolean state, boolean fromModelRefresh) {
        if (state) {
            this.refresh(fromModelRefresh);
        } else {
            this.clear();
        }
    }

    @NotNull
    public Project getProject() {
        Project project = super.getProject();
        if (project == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(5);
        }
        return project;
    }

    public boolean isWindowFocused() {
        return DiffUtil.isFocusedComponent((Project)this.getProject(), (Component)this.getComponent());
    }

    @RequiresEdt
    public void clear() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myCurrentChange != null) {
            this.myCurrentChange = null;
            this.updateRequest();
        }
        this.dropCaches();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void refresh(boolean bl) {
        void fromModelRefresh;
        Wrapper selectedChange;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        ArrayList selectedChanges = ContainerUtil.newArrayList(this.iterateSelectedChanges());
        if (selectedChanges.isEmpty() && this.showAllChangesForEmptySelection()) {
            selectedChanges = ContainerUtil.newArrayList(this.iterateAllChanges());
        }
        Wrapper wrapper2 = selectedChange = this.myCurrentChange != null ? (Wrapper)ContainerUtil.find((Iterable)selectedChanges, (Object)this.myCurrentChange) : null;
        if (fromModelRefresh != false && selectedChange == null && this.myCurrentChange != null && this.forceKeepCurrentFileWhileFocused() && this.getContext().isWindowFocused() && this.getContext().isFocusedInWindow()) {
            if (selectedChanges.size() == 1 && ContainerUtil.exists(this.iterateAllChanges(), it -> this.myCurrentChange.equals(it))) {
                this.selectChange(this.myCurrentChange);
            }
            return;
        }
        if (selectedChanges.isEmpty()) {
            this.setCurrentChange(null);
            return;
        }
        if (selectedChange == null) {
            this.setCurrentChange((Wrapper)selectedChanges.get(0));
            return;
        }
        this.setCurrentChange(selectedChange);
    }

    @RequiresEdt
    @Nullable
    @Nls
    public String getCurrentChangeName() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myCurrentChange == null) {
            return null;
        }
        return this.myCurrentChange.getPresentableName();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setCurrentChange(@Nullable Wrapper wrapper2) {
        void change;
        ThreadingAssertions.assertEventDispatchThread();
        this.myCurrentChange = change;
        this.updateRequest();
    }

    @Nullable
    public Wrapper getCurrentChange() {
        return this.myCurrentChange;
    }

    @Nullable
    protected AnAction createGoToChangeAction() {
        return new MyGoToChangePopupAction();
    }

    protected boolean hasNextChange(boolean fromUpdate) {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy(fromUpdate);
        return strategy != null && strategy.canGoNext();
    }

    protected boolean hasPrevChange(boolean fromUpdate) {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy(fromUpdate);
        return strategy != null && strategy.canGoPrev();
    }

    protected void goToNextChange(boolean fromDifferences) {
        this.goToNextChangeImpl(fromDifferences, () -> Objects.requireNonNull(this.getSelectionStrategy(false)).goNext());
    }

    protected void goToPrevChange(boolean fromDifferences) {
        this.goToPrevChangeImpl(fromDifferences, () -> Objects.requireNonNull(this.getSelectionStrategy(false)).goPrev());
    }

    protected boolean isNavigationEnabled() {
        return true;
    }

    @Nullable
    private PrevNextDifferenceIterable getSelectionStrategy(boolean fromUpdate) {
        if (this.myCurrentChange == null) {
            return null;
        }
        List<? extends Wrapper> selectedChanges = ChangeViewDiffRequestProcessor.toListIfNotMany(this.iterateSelectedChanges(), fromUpdate);
        if (selectedChanges == null) {
            return DumbPrevNextDifferenceIterable.INSTANCE;
        }
        if (selectedChanges.size() > 1) {
            return new ChangesNavigatable(selectedChanges, selectedChanges.get(0), false);
        }
        if (selectedChanges.isEmpty() && !this.showAllChangesForEmptySelection()) {
            return null;
        }
        List<? extends Wrapper> allChanges = ChangeViewDiffRequestProcessor.toListIfNotMany(this.iterateAllChanges(), fromUpdate);
        if (allChanges == null) {
            return DumbPrevNextDifferenceIterable.INSTANCE;
        }
        if (allChanges.isEmpty()) {
            return null;
        }
        Wrapper selection = selectedChanges.isEmpty() ? allChanges.get(0) : selectedChanges.get(0);
        return new ChangesNavigatable(allChanges, selection, true);
    }

    @Nullable
    public static <T> List<? extends T> toListIfNotMany(@NotNull Iterable<? extends T> iterable, boolean fromUpdate) {
        if (iterable == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(6);
        }
        if (!fromUpdate) {
            return ContainerUtil.newArrayList(iterable);
        }
        List result2 = JBIterable.from(iterable).take(10001).toList();
        if (result2.size() > 10000) {
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateSelectedChanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateAllChanges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadRequestFast";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toListIfNotMany";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    public static abstract class Wrapper
    implements PresentableChange {
        @NotNull
        public abstract Object getUserObject();

        @Nullable
        @Nls
        public abstract String getPresentableName();

        @Nullable
        public abstract DiffRequestProducer createProducer(@Nullable Project var1);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Wrapper wrapper2 = (Wrapper)o;
            return Comparing.equal((Object)this.getUserObject(), (Object)wrapper2.getUserObject());
        }

        public int hashCode() {
            return this.getUserObject().hashCode();
        }
    }

    private class MyGoToChangePopupAction
    extends PresentableGoToChangePopupAction.Default<Wrapper> {
        private MyGoToChangePopupAction() {
        }

        @Override
        @NotNull
        protected ListSelection<? extends Wrapper> getChanges() {
            ArrayList allChanges = ContainerUtil.newArrayList(ChangeViewDiffRequestProcessor.this.iterateAllChanges());
            ListSelection listSelection = ListSelection.create((List)allChanges, (Object)ChangeViewDiffRequestProcessor.this.getCurrentChange());
            if (listSelection == null) {
                MyGoToChangePopupAction.$$$reportNull$$$0(0);
            }
            return listSelection;
        }

        @Override
        protected boolean canNavigate() {
            List<? extends Wrapper> allChanges = ChangeViewDiffRequestProcessor.toListIfNotMany(ChangeViewDiffRequestProcessor.this.iterateAllChanges(), true);
            return allChanges == null || allChanges.size() > 1;
        }

        @Override
        protected void onSelected(@NotNull Wrapper change) {
            if (change == null) {
                MyGoToChangePopupAction.$$$reportNull$$$0(1);
            }
            ChangeViewDiffRequestProcessor.this.setCurrentChange(change);
            ChangeViewDiffRequestProcessor.this.selectChange(change);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$MyGoToChangePopupAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$MyGoToChangePopupAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DumbPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        public static final DumbPrevNextDifferenceIterable INSTANCE = new DumbPrevNextDifferenceIterable();

        private DumbPrevNextDifferenceIterable() {
        }

        public boolean canGoPrev() {
            return true;
        }

        public boolean canGoNext() {
            return true;
        }

        public void goPrev() {
            throw new UnsupportedOperationException();
        }

        public void goNext() {
            throw new UnsupportedOperationException();
        }
    }

    private class ChangesNavigatable
    implements PrevNextDifferenceIterable {
        @NotNull
        private final List<? extends Wrapper> myChanges;
        @NotNull
        private final Wrapper myFallback;
        private final boolean myUpdateSelection;

        ChangesNavigatable(@NotNull List<? extends Wrapper> allChanges, Wrapper fallback, boolean updateSelection) {
            if (allChanges == null) {
                ChangesNavigatable.$$$reportNull$$$0(0);
            }
            if (fallback == null) {
                ChangesNavigatable.$$$reportNull$$$0(1);
            }
            this.myChanges = allChanges;
            this.myFallback = fallback;
            this.myUpdateSelection = updateSelection;
        }

        public boolean canGoNext() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index == -1 || index < this.myChanges.size() - 1;
        }

        public boolean canGoPrev() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index == -1 || index > 0;
        }

        public void goNext() {
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index != -1) {
                this.select(this.myChanges.get(index + 1));
            } else {
                this.select(this.myFallback);
            }
        }

        public void goPrev() {
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index != -1) {
                this.select(this.myChanges.get(index - 1));
            } else {
                this.select(this.myFallback);
            }
        }

        private void select(@NotNull Wrapper change) {
            if (change == null) {
                ChangesNavigatable.$$$reportNull$$$0(2);
            }
            ChangeViewDiffRequestProcessor.this.myCurrentChange = change;
            if (this.myUpdateSelection) {
                ChangeViewDiffRequestProcessor.this.selectChange(change);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allChanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fallback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangesNavigatable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ErrorChangeRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final Change myChange;
        @NotNull
        private final DiffRequest myRequest;

        ErrorChangeRequestProducer(@NotNull Change change, @NotNull DiffRequest request) {
            if (change == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(0);
            }
            if (request == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(1);
            }
            this.myChange = change;
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            String string = ChangeDiffRequestProducer.getRequestTitle(this.myChange);
            if (string == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            if (context == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(4);
            }
            DiffRequest diffRequest = this.myRequest;
            if (diffRequest == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ErrorChangeRequestProducer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ErrorChangeRequestProducer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }

    protected static class UnversionedFileWrapper
    extends Wrapper {
        @NotNull
        protected final FilePath path;

        public UnversionedFileWrapper(@NotNull FilePath path) {
            if (path == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(0);
            }
            this.path = path;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.path;
            if (filePath == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(2);
            }
            return fileStatus;
        }

        @Override
        @Nullable
        public ChangesBrowserNode.Tag getTag() {
            return ChangesBrowserNode.UNVERSIONED_FILES_TAG;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            FilePath filePath = this.path;
            if (filePath == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(3);
            }
            return filePath;
        }

        @Override
        @Nullable
        @Nls
        public String getPresentableName() {
            return this.path.getName();
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return UnversionedDiffRequestProducer.create(project, this.path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$UnversionedFileWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$UnversionedFileWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class ChangeWrapper
    extends Wrapper {
        @NotNull
        protected final Change change;
        @Nullable
        protected final ChangesBrowserNode.Tag nodeTag;

        public ChangeWrapper(@NotNull Change change) {
            if (change == null) {
                ChangeWrapper.$$$reportNull$$$0(0);
            }
            this(change, null);
        }

        public ChangeWrapper(@NotNull Change change, @Nullable ChangesBrowserNode.Tag nodeTag) {
            if (change == null) {
                ChangeWrapper.$$$reportNull$$$0(1);
            }
            this.change = change;
            this.nodeTag = nodeTag;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            Change change = this.change;
            if (change == null) {
                ChangeWrapper.$$$reportNull$$$0(2);
            }
            return change;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = ChangesUtil.getFilePath((Change)this.change);
            if (filePath == null) {
                ChangeWrapper.$$$reportNull$$$0(3);
            }
            return filePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.change.getFileStatus();
            if (fileStatus == null) {
                ChangeWrapper.$$$reportNull$$$0(4);
            }
            return fileStatus;
        }

        @Override
        @Nullable
        @Nls
        public String getPresentableName() {
            return this.getFilePath().getName();
        }

        @Override
        @Nullable
        public ChangesBrowserNode.Tag getTag() {
            return this.nodeTag;
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            if (this.change.getBeforeRevision() instanceof FakeRevision || this.change.getAfterRevision() instanceof FakeRevision) {
                LoadingDiffRequest request = new LoadingDiffRequest(ChangeDiffRequestProducer.getRequestTitle(this.change));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            ChangeDiffRequestProducer producer = ChangeDiffRequestProducer.create(project, this.change);
            if (producer == null) {
                ErrorDiffRequest request = new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0]));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            return producer;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ChangeWrapper wrapper2 = (ChangeWrapper)o;
            return ChangeListChange.HASHING_STRATEGY.equals((Object)wrapper2.change, (Object)this.change) && Objects.equals(wrapper2.nodeTag, this.nodeTag);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.change, this.nodeTag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangeWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangeWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserObject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

