/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.RestoredDatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.PrimaryKey;

public class PluginRestoredDatabaseSnapshot
extends RestoredDatabaseSnapshot {
    private static final String BACKING_INDEX_ATTR = "backingIndex";
    private static final String COLUMNS_ATTR = "columns";

    public PluginRestoredDatabaseSnapshot(Database database) throws DatabaseException, InvalidExampleException {
        super(database);
    }

    protected void loadObjects(Map<String, DatabaseObject> objectMap, Map<String, DatabaseObject> allObjects, ParsedNode node, ResourceAccessor resourceAccessor) throws ReflectiveOperationException, ParsedNodeException {
        DatabaseConnection connection;
        super.loadObjects(objectMap, allObjects, node, resourceAccessor);
        Database database = this.getDatabase();
        DatabaseConnection databaseConnection = connection = database == null ? null : database.getConnection();
        if (!(connection instanceof OfflineConnection)) {
            return;
        }
        for (Map.Entry<String, DatabaseObject> entry : allObjects.entrySet()) {
            List pkColumns;
            DatabaseObject databaseObject = entry.getValue();
            if (!(databaseObject instanceof PrimaryKey)) continue;
            Object value = databaseObject.getAttribute(BACKING_INDEX_ATTR, Object.class);
            if (value instanceof String && !allObjects.containsKey(value)) {
                databaseObject.setAttribute(BACKING_INDEX_ATTR, null);
            }
            if (!(pkColumns = (List)databaseObject.getAttribute(COLUMNS_ATTR, List.class)).stream().anyMatch(Objects::isNull)) continue;
            databaseObject.setAttribute(COLUMNS_ATTR, new ArrayList());
        }
    }
}

