/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.scientific.tables.DSGridColumn;
import com.intellij.scientific.tables.DSGridLoader;
import com.intellij.scientific.tables.DSHistoryForFilter;
import com.intellij.scientific.tables.api.DSTableDataProvider;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.filters.FilterComparisonType;
import com.intellij.scientific.tables.api.filters.FilterExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0012\u001a\u00020\u000fJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/scientific/tables/DSFilteringModel;", "", "loader", "Lcom/intellij/scientific/tables/DSGridLoader;", "model", "Lcom/intellij/database/datagrid/GridModel;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "<init>", "(Lcom/intellij/scientific/tables/DSGridLoader;Lcom/intellij/database/datagrid/GridModel;)V", "filterExpression", "Lcom/intellij/scientific/tables/api/filters/FilterExpression;", "filterHistory", "Lcom/intellij/scientific/tables/DSHistoryForFilter;", "setFilters", "", "filter", "getAppliedFilters", "clearFilters", "getComparisonTypes", "", "Lcom/intellij/scientific/tables/api/filters/FilterComparisonType;", "getColumns", "columnsIndexSet", "Lcom/intellij/database/datagrid/ModelIndexSet;", "logFilterToHistory", "getPreviousFilterOrNull", "filterComparisonTypesByTableType", "dataProvider", "Lcom/intellij/scientific/tables/api/DSTableDataProvider;", "filterIndexColumns", "", "columns", "intellij.scientific.tables"})
@SourceDebugExtension(value={"SMAP\nDSFilteringModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSFilteringModel.kt\ncom/intellij/scientific/tables/DSFilteringModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1617#2,9:59\n1869#2:68\n1870#2:70\n1626#2:71\n774#2:72\n865#2,2:73\n1#3:69\n*S KotlinDebug\n*F\n+ 1 DSFilteringModel.kt\ncom/intellij/scientific/tables/DSFilteringModel\n*L\n54#1:59,9\n54#1:68\n54#1:70\n54#1:71\n55#1:72\n55#1:73,2\n54#1:69\n*E\n"})
public final class DSFilteringModel {
    @NotNull
    private final DSGridLoader loader;
    @NotNull
    private final GridModel<GridRow, GridColumn> model;
    @Nullable
    private FilterExpression filterExpression;
    @Nullable
    private DSHistoryForFilter filterHistory;

    public DSFilteringModel(@NotNull DSGridLoader loader, @NotNull GridModel<GridRow, GridColumn> model) {
        Intrinsics.checkNotNullParameter((Object)((Object)loader), (String)"loader");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this.loader = loader;
        this.model = model;
    }

    public final void setFilters(@Nullable FilterExpression filter) {
        this.filterExpression = filter;
    }

    @Nullable
    public final FilterExpression getAppliedFilters() {
        return this.filterExpression;
    }

    public final void clearFilters() {
        this.filterExpression = null;
    }

    @NotNull
    public final List<FilterComparisonType> getComparisonTypes() {
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = this.loader.getTableDataRetrieverFromDataSource();
        return this.filterComparisonTypesByTableType(dSTableDataRetrieverFromDataSource != null ? dSTableDataRetrieverFromDataSource.getTableDataProvider() : null);
    }

    @NotNull
    public final List<GridColumn> getColumns() {
        List list = this.model.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        return this.filterIndexColumns(list);
    }

    @NotNull
    public final List<GridColumn> getColumns(@NotNull ModelIndexSet<GridColumn> columnsIndexSet) {
        Intrinsics.checkNotNullParameter(columnsIndexSet, (String)"columnsIndexSet");
        List list = this.model.getColumns(columnsIndexSet);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        return this.filterIndexColumns(list);
    }

    public final void logFilterToHistory(@Nullable FilterExpression filter) {
        DSHistoryForFilter dSHistoryForFilter = this.filterHistory;
        FilterExpression previousFilter = dSHistoryForFilter != null ? dSHistoryForFilter.getCurrentFilter() : null;
        this.filterHistory = new DSHistoryForFilter(previousFilter, filter);
    }

    @Nullable
    public final FilterExpression getPreviousFilterOrNull() {
        DSHistoryForFilter dSHistoryForFilter = this.filterHistory;
        return dSHistoryForFilter != null ? dSHistoryForFilter.getPreviousFilter() : null;
    }

    private final List<FilterComparisonType> filterComparisonTypesByTableType(DSTableDataProvider dataProvider) {
        Object object = dataProvider;
        if (object == null || (object = object.getSupportedFilterComparisonTypes()) == null) {
            object = CollectionsKt.toList((Iterable)((Iterable)FilterComparisonType.getEntries()));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GridColumn> filterIndexColumns(List<? extends GridColumn> columns) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = columns;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DSGridColumn it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GridColumn it = (GridColumn)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof DSGridColumn ? (DSGridColumn)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DSGridColumn it = (DSGridColumn)element$iv$iv;
            boolean bl = false;
            if (!(!it.isIndexColumn())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }
}

