/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks.ui;

import com.intellij.codeInsight.template.Template;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.spring.model.actions.patterns.frameworks.util.StandardBeansDocLinksManager;
import org.jetbrains.annotations.Nls;

public class TemplateInfo {
    private final Template myTemplate;
    @Nls
    private final String myName;
    private final String myReferenceLink;
    private final String myApiLink;
    private final String myDescription;
    private boolean myAccepted;

    public TemplateInfo(Module module, Template template, @Nls String name, String description) {
        this(module, template, name, description, true);
    }

    public TemplateInfo(Module module, Template template, @Nls String name, String description, boolean isAccepted) {
        this.myTemplate = template;
        this.myName = name;
        StandardBeansDocLinksManager linksManager = StandardBeansDocLinksManager.getInstance();
        this.myReferenceLink = linksManager.getReferenceLink(template.getId());
        this.myApiLink = linksManager.getApiLink(template.getId());
        this.myDescription = description;
        this.myAccepted = isAccepted;
    }

    public Template getTemplate() {
        return this.myTemplate;
    }

    public boolean isAccepted() {
        return this.myAccepted;
    }

    public void setAccepted(boolean accepted) {
        this.myAccepted = accepted;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription == null ? "" : this.myDescription;
    }

    @NlsSafe
    public String getReferenceLink() {
        return this.myReferenceLink;
    }

    @NlsSafe
    public String getApiLink() {
        return this.myApiLink;
    }
}

