/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters.resources;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import org.jetbrains.annotations.NotNull;

public class ResourceTypeCondition
implements Condition<PsiFileSystemItem> {
    private final String[] myFileExtensions;

    public ResourceTypeCondition(String ... fileExtensions) {
        if (fileExtensions == null) {
            ResourceTypeCondition.$$$reportNull$$$0(0);
        }
        this.myFileExtensions = fileExtensions;
    }

    public boolean value(PsiFileSystemItem psiFileSystemItem) {
        for (String fileExtension : this.myFileExtensions) {
            if (!ResourceTypeCondition.hasExtension(psiFileSystemItem, fileExtension)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExtension(PsiFileSystemItem psiFileSystemItem, String fileExtension) {
        if (FileReferenceSet.DIRECTORY_FILTER.value((Object)psiFileSystemItem)) {
            return true;
        }
        VirtualFile virtualFile = psiFileSystemItem.getVirtualFile();
        return virtualFile != null && fileExtension.equals(virtualFile.getExtension());
    }

    public String @NotNull [] getExpectedExtensions() {
        if (this.myFileExtensions == null) {
            ResourceTypeCondition.$$$reportNull$$$0(1);
        }
        return this.myFileExtensions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtensions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/converters/resources/ResourceTypeCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/converters/resources/ResourceTypeCondition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

