/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.psi.PsiField;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntryDependencyInfo;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FieldDependenciesManager {
    private final Map<PsiField, Set<PsiField>> myFieldDependencies;
    private final Map<PsiField, ArrangementEntryDependencyInfo> myFieldInfosMap;

    public FieldDependenciesManager(@NotNull Map<PsiField, Set<PsiField>> fieldDependencies, @NotNull Map<PsiField, JavaElementArrangementEntry> fields) {
        if (fieldDependencies == null) {
            FieldDependenciesManager.$$$reportNull$$$0(0);
        }
        if (fields == null) {
            FieldDependenciesManager.$$$reportNull$$$0(1);
        }
        this.myFieldInfosMap = new HashMap<PsiField, ArrangementEntryDependencyInfo>();
        this.myFieldDependencies = fieldDependencies;
        for (PsiField field : fields.keySet()) {
            JavaElementArrangementEntry entry = fields.get(field);
            this.myFieldInfosMap.put(field, new ArrangementEntryDependencyInfo(entry));
        }
    }

    @NotNull
    public List<ArrangementEntryDependencyInfo> getRoots() {
        ArrayList<ArrangementEntryDependencyInfo> list = new ArrayList<ArrangementEntryDependencyInfo>();
        for (Map.Entry<PsiField, Set<PsiField>> entry : this.myFieldDependencies.entrySet()) {
            ArrangementEntryDependencyInfo currentInfo = this.myFieldInfosMap.get(entry.getKey());
            for (PsiField usedInInitialization : entry.getValue()) {
                ArrangementEntryDependencyInfo fieldInfo = this.myFieldInfosMap.get(usedInInitialization);
                if (fieldInfo == null) continue;
                currentInfo.addDependentEntryInfo(fieldInfo);
            }
            list.add(currentInfo);
        }
        ArrayList<ArrangementEntryDependencyInfo> arrayList = list;
        if (arrayList == null) {
            FieldDependenciesManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldDependencies";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/FieldDependenciesManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/FieldDependenciesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

