/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.AnnotationInitializerBlocksBuilder;
import com.intellij.psi.formatter.java.ArrayInitializerBlocksBuilder;
import com.intellij.psi.formatter.java.BlockContainingJavaBlock;
import com.intellij.psi.formatter.java.BlockFactory;
import com.intellij.psi.formatter.java.CStyleCommentBlock;
import com.intellij.psi.formatter.java.ChainMethodCallsBlockBuilder;
import com.intellij.psi.formatter.java.ChildAlignmentStrategyProvider;
import com.intellij.psi.formatter.java.CodeBlockBlock;
import com.intellij.psi.formatter.java.CommentWithInjectionBlock;
import com.intellij.psi.formatter.java.CompositeAligner;
import com.intellij.psi.formatter.java.DocCommentBlock;
import com.intellij.psi.formatter.java.ExtendsListBlock;
import com.intellij.psi.formatter.java.JavaBlock;
import com.intellij.psi.formatter.java.JavaFormatterRecordUtil;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.JavaSpacePropertyProcessor;
import com.intellij.psi.formatter.java.LabeledJavaBlock;
import com.intellij.psi.formatter.java.LeafBlock;
import com.intellij.psi.formatter.java.LegacyChainedMethodCallsBlockBuilder;
import com.intellij.psi.formatter.java.MultipleFieldDeclarationHelper;
import com.intellij.psi.formatter.java.PartialWhitespaceBlock;
import com.intellij.psi.formatter.java.SimpleJavaBlock;
import com.intellij.psi.formatter.java.SubsequentClassMemberAlignment;
import com.intellij.psi.formatter.java.SubsequentVariablesAlignerConfigurations;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.formatter.java.TextBlockBlock;
import com.intellij.psi.formatter.java.WrappingStrategy;
import com.intellij.psi.formatter.java.wrap.ReservedWrapsProvider;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ShiftIndentInsideHelper;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.java.ClassElement;
import com.intellij.psi.javadoc.PsiMarkdownCodeBlock;
import com.intellij.psi.jsp.JspClassLevelDeclarationStatementType;
import com.intellij.psi.jsp.JspCodeBlockType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaBlock
extends AbstractBlock
implements JavaBlock,
ReservedWrapsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractJavaBlock.class);
    @NotNull
    protected final CommonCodeStyleSettings mySettings;
    @NotNull
    protected final JavaCodeStyleSettings myJavaSettings;
    protected final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final Indent myIndent;
    protected Indent myChildIndent;
    protected Alignment myChildAlignment;
    protected boolean myUseChildAttributes;
    @NotNull
    protected final AlignmentStrategy myAlignmentStrategy;
    private boolean myIsAfterClassKeyword;
    protected Alignment myReservedAlignment;
    protected Alignment myReservedAlignment2;
    private Map<IElementType, Wrap> myPreferredWraps;
    private AbstractJavaBlock myParentBlock;
    private final FormattingMode myFormattingMode;
    private final BlockFactory myBlockFactory;

    protected AbstractJavaBlock(@NotNull ASTNode node, Wrap wrap, Alignment alignment, Indent indent, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (node == null) {
            AbstractJavaBlock.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(1);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(2);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(3);
        }
        this(node, wrap, indent, settings, javaSettings, AlignmentStrategy.wrap((Alignment)alignment, (IElementType[])new IElementType[0]), formattingMode);
    }

    protected AbstractJavaBlock(@NotNull ASTNode node, Wrap wrap, @NotNull AlignmentStrategy alignmentStrategy, Indent indent, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (node == null) {
            AbstractJavaBlock.$$$reportNull$$$0(4);
        }
        if (alignmentStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(6);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(7);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(8);
        }
        this(node, wrap, indent, settings, javaSettings, alignmentStrategy, formattingMode);
    }

    private AbstractJavaBlock(@NotNull ASTNode ignored, @NotNull CommonCodeStyleSettings commonSettings, @NotNull JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (ignored == null) {
            AbstractJavaBlock.$$$reportNull$$$0(9);
        }
        if (commonSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(10);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(11);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(12);
        }
        super(ignored, null, null);
        this.myBlockFactory = new BlockFactory(){

            @Override
            public Block createBlock(ASTNode node, Indent indent, Alignment alignment, Wrap wrap, @NotNull FormattingMode formattingMode) {
                if (formattingMode == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new SimpleJavaBlock(node, wrap, AlignmentStrategy.wrap((Alignment)alignment, (IElementType[])new IElementType[0]), indent, AbstractJavaBlock.this.mySettings, AbstractJavaBlock.this.myJavaSettings, formattingMode);
            }

            @Override
            public CommonCodeStyleSettings getSettings() {
                return AbstractJavaBlock.this.mySettings;
            }

            @Override
            public JavaCodeStyleSettings getJavaSettings() {
                return AbstractJavaBlock.this.myJavaSettings;
            }

            @Override
            public FormattingMode getFormattingMode() {
                return AbstractJavaBlock.this.myFormattingMode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingMode", "com/intellij/psi/formatter/java/AbstractJavaBlock$1", "createBlock"));
            }
        };
        this.mySettings = commonSettings;
        this.myJavaSettings = javaSettings;
        this.myIndentSettings = commonSettings.getIndentOptions();
        this.myIndent = null;
        this.myAlignmentStrategy = AlignmentStrategy.getNullStrategy();
        this.myFormattingMode = formattingMode;
    }

    protected AbstractJavaBlock(@NotNull ASTNode node, Wrap wrap, Indent indent, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @NotNull AlignmentStrategy alignmentStrategy, @NotNull FormattingMode formattingMode) {
        if (node == null) {
            AbstractJavaBlock.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(14);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(15);
        }
        if (alignmentStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(16);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(17);
        }
        super(node, wrap, AbstractJavaBlock.createBlockAlignment(alignmentStrategy, node));
        this.myBlockFactory = new /* invalid duplicate definition of identical inner class */;
        this.mySettings = settings;
        this.myJavaSettings = javaSettings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myIndent = indent;
        this.myAlignmentStrategy = alignmentStrategy;
        this.myFormattingMode = formattingMode;
    }

    @Nullable
    private static Alignment createBlockAlignment(@NotNull AlignmentStrategy strategy, @NotNull ASTNode node) {
        if (strategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(18);
        }
        if (node == null) {
            AbstractJavaBlock.$$$reportNull$$$0(19);
        }
        if (node.getElementType() == JavaElementType.IMPLEMENTS_LIST) {
            return null;
        }
        return strategy.getAlignment(node.getElementType());
    }

    @NotNull
    public Block createJavaBlock(@NotNull ASTNode child, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @Nullable Indent indent, @Nullable Wrap wrap, Alignment alignment, @NotNull FormattingMode formattingMode) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(20);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(21);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(22);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(23);
        }
        Block block = this.createJavaBlock(child, settings, javaSettings, indent, wrap, AlignmentStrategy.wrap((Alignment)alignment, (IElementType[])new IElementType[0]), formattingMode);
        if (block == null) {
            AbstractJavaBlock.$$$reportNull$$$0(24);
        }
        return block;
    }

    @NotNull
    public Block createJavaBlock(@NotNull ASTNode child, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, Indent indent, @Nullable Wrap wrap, @NotNull AlignmentStrategy alignmentStrategy, @NotNull FormattingMode formattingMode) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(25);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(26);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(27);
        }
        if (alignmentStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(28);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(29);
        }
        return this.createJavaBlock(child, settings, javaSettings, indent, wrap, alignmentStrategy, -1, formattingMode);
    }

    @NotNull
    private Block createJavaBlock(@NotNull ASTNode child, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @Nullable Indent indent, Wrap wrap, @NotNull AlignmentStrategy alignmentStrategy, int startOffset, @NotNull FormattingMode formattingMode) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(30);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(31);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(32);
        }
        if (alignmentStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(33);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(34);
        }
        Indent actualIndent = indent == null ? AbstractJavaBlock.getDefaultSubtreeIndent(child, settings, javaSettings) : indent;
        IElementType elementType = child.getElementType();
        Alignment alignment = alignmentStrategy.getAlignment(elementType);
        PsiElement childPsi = child.getPsi();
        if (childPsi instanceof PsiWhiteSpace) {
            int end;
            String text = child.getText();
            int start = CharArrayUtil.shiftForward((CharSequence)text, (int)0, (String)" \t\n");
            LOG.assertTrue(start < (end = CharArrayUtil.shiftBackward((CharSequence)text, (int)(text.length() - 1), (String)" \t\n") + 1));
            TextRange range = new TextRange(start + child.getStartOffset(), end + child.getStartOffset());
            return new PartialWhitespaceBlock(child, range, wrap, alignment, actualIndent, settings, javaSettings, this.myFormattingMode);
        }
        if (childPsi instanceof PsiImplicitClass) {
            return new SimpleJavaBlock(child, wrap, alignmentStrategy, Indent.getNoneIndent(), settings, javaSettings, formattingMode);
        }
        if (childPsi instanceof PsiClass || childPsi instanceof PsiJavaModule) {
            return new CodeBlockBlock(child, wrap, alignment, actualIndent, settings, javaSettings, formattingMode);
        }
        if (child.getElementType() == JavaElementType.METHOD) {
            return new BlockContainingJavaBlock(child, actualIndent, alignmentStrategy, this.mySettings, this.myJavaSettings, formattingMode);
        }
        if (AbstractJavaBlock.isBlockType(elementType)) {
            return new BlockContainingJavaBlock(child, wrap, alignment, actualIndent, settings, javaSettings, formattingMode);
        }
        if (AbstractJavaBlock.isStatement(child, child.getTreeParent())) {
            return new CodeBlockBlock(child, wrap, alignment, actualIndent, settings, javaSettings, this.myFormattingMode);
        }
        if (!this.isBuildIndentsOnly() && child instanceof PsiComment && child instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)child))) {
            return new CommentWithInjectionBlock(child, wrap, alignment, indent, settings, javaSettings, formattingMode);
        }
        if (child instanceof LeafElement || child instanceof PsiMarkdownCodeBlock) {
            if (child.getElementType() == JavaTokenType.C_STYLE_COMMENT) {
                return new CStyleCommentBlock(child, actualIndent);
            }
            LeafBlock block = new LeafBlock(child, wrap, alignment, actualIndent);
            block.setStartOffset(startOffset);
            LeafBlock leafBlock = block;
            if (leafBlock == null) {
                AbstractJavaBlock.$$$reportNull$$$0(35);
            }
            return leafBlock;
        }
        if (AbstractJavaBlock.isLikeExtendsList(elementType)) {
            return new ExtendsListBlock(child, wrap, alignmentStrategy, settings, javaSettings, formattingMode);
        }
        if (elementType == JavaElementType.CODE_BLOCK) {
            return new CodeBlockBlock(child, wrap, alignment, actualIndent, settings, javaSettings, formattingMode);
        }
        if (elementType == JavaElementType.LABELED_STATEMENT) {
            return new LabeledJavaBlock(child, wrap, alignment, actualIndent, settings, javaSettings, formattingMode);
        }
        if (elementType == JavaDocElementType.DOC_COMMENT) {
            return new DocCommentBlock(child, wrap, alignment, actualIndent, settings, javaSettings, formattingMode);
        }
        if (AbstractJavaBlock.isTextBlock(childPsi)) {
            return new TextBlockBlock(child, wrap, alignmentStrategy, actualIndent, settings, javaSettings, formattingMode);
        }
        SimpleJavaBlock simpleJavaBlock = new SimpleJavaBlock(child, wrap, alignmentStrategy, actualIndent, settings, javaSettings, this.myFormattingMode);
        simpleJavaBlock.setStartOffset(startOffset);
        SimpleJavaBlock simpleJavaBlock2 = simpleJavaBlock;
        if (simpleJavaBlock2 == null) {
            AbstractJavaBlock.$$$reportNull$$$0(36);
        }
        return simpleJavaBlock2;
    }

    @NotNull
    public static Block newJavaBlock(@NotNull ASTNode child, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(37);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(38);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(39);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(40);
        }
        Indent indent = AbstractJavaBlock.getDefaultSubtreeIndent(child, settings, javaSettings);
        return AbstractJavaBlock.newJavaBlock(child, settings, javaSettings, indent, null, AlignmentStrategy.getNullStrategy(), formattingMode);
    }

    @NotNull
    public static Block newJavaBlock(@NotNull ASTNode child, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull AlignmentStrategy strategy, @NotNull FormattingMode formattingMode) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(41);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(42);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(43);
        }
        if (strategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(44);
        }
        if (formattingMode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(45);
        }
        Block block = new AbstractJavaBlock(child, settings, javaSettings, formattingMode){

            protected List<Block> buildChildren() {
                return null;
            }
        }.createJavaBlock(child, settings, javaSettings, indent, wrap, strategy, formattingMode);
        if (block == null) {
            AbstractJavaBlock.$$$reportNull$$$0(46);
        }
        return block;
    }

    @NotNull
    private static CommonCodeStyleSettings.IndentOptions getJavaIndentOptions(CommonCodeStyleSettings settings) {
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions();
        assert (indentOptions != null) : "Java indent options are not initialized";
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        if (indentOptions2 == null) {
            AbstractJavaBlock.$$$reportNull$$$0(47);
        }
        return indentOptions2;
    }

    private static boolean isLikeExtendsList(IElementType elementType) {
        return elementType == JavaElementType.EXTENDS_LIST || elementType == JavaElementType.IMPLEMENTS_LIST || elementType == JavaElementType.THROWS_LIST || elementType == JavaElementType.PERMITS_LIST;
    }

    private static boolean isBlockType(IElementType elementType) {
        return elementType == JavaElementType.SWITCH_STATEMENT || elementType == JavaElementType.FOR_STATEMENT || elementType == JavaElementType.WHILE_STATEMENT || elementType == JavaElementType.DO_WHILE_STATEMENT || elementType == JavaElementType.TRY_STATEMENT || elementType == JavaElementType.CATCH_SECTION || elementType == JavaElementType.IF_STATEMENT || elementType == JavaElementType.METHOD || elementType == JavaElementType.ARRAY_INITIALIZER_EXPRESSION || elementType == JavaElementType.ANNOTATION_ARRAY_INITIALIZER || elementType == JavaElementType.CLASS_INITIALIZER || elementType == JavaElementType.SYNCHRONIZED_STATEMENT || elementType == JavaElementType.SWITCH_LABELED_RULE || elementType == JavaElementType.FOREACH_STATEMENT;
    }

    @Nullable
    private static Indent getDefaultSubtreeIndent(@NotNull ASTNode child, @NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(48);
        }
        if (settings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(49);
        }
        if (javaSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(50);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = AbstractJavaBlock.getJavaIndentOptions(settings);
        ASTNode parent = child.getTreeParent();
        IElementType childNodeType = child.getElementType();
        if (childNodeType == JavaElementType.ANNOTATION) {
            if (parent.getPsi() instanceof PsiArrayInitializerMemberValue) {
                return Indent.getNormalIndent();
            }
            if (JavaFormatterRecordUtil.shouldAdjustIndentForRecordComponentChild(child, javaSettings)) {
                return Indent.getContinuationIndent();
            }
            return Indent.getNoneIndent();
        }
        ASTNode prevElement = AbstractJavaBlock.skipCommentsAndWhitespacesBackwards(child);
        if (prevElement != null) {
            if (JavaFormatterRecordUtil.shouldAdjustIndentForRecordComponentChild(child, javaSettings)) {
                return Indent.getContinuationIndent();
            }
            if (prevElement.getElementType() == JavaElementType.MODIFIER_LIST) {
                return Indent.getNoneIndent();
            }
        }
        if (childNodeType == JavaDocElementType.DOC_TAG) {
            return Indent.getNoneIndent();
        }
        if (childNodeType == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
            if (PsiUtil.isInMarkdownDocComment(child.getPsi())) {
                return Indent.getNoneIndent();
            }
            return Indent.getSpaceIndent((int)1);
        }
        if (child.getPsi() instanceof PsiFile) {
            return Indent.getNoneIndent();
        }
        if (parent != null) {
            Indent defaultChildIndent = AbstractJavaBlock.getChildIndent(parent, indentOptions);
            if (defaultChildIndent != null) {
                return defaultChildIndent;
            }
            if (parent.getPsi() instanceof PsiLambdaExpression && child instanceof PsiCodeBlock) {
                if (settings.LAMBDA_BRACE_STYLE == 3 || settings.LAMBDA_BRACE_STYLE == 4) {
                    return Indent.getNormalIndent();
                }
                return Indent.getNoneIndent();
            }
            if (parent.getPsi() instanceof PsiSwitchExpression && child instanceof PsiCodeBlock) {
                if (settings.BRACE_STYLE == 3 || settings.BRACE_STYLE == 4) {
                    return Indent.getNormalIndent();
                }
                return Indent.getNoneIndent();
            }
        }
        return null;
    }

    @Nullable
    private static ASTNode skipCommentsAndWhitespacesBackwards(@NotNull ASTNode node) {
        ASTNode currNode;
        if (node == null) {
            AbstractJavaBlock.$$$reportNull$$$0(51);
        }
        for (currNode = node.getTreePrev(); currNode != null && (currNode.getElementType() == JavaTokenType.END_OF_LINE_COMMENT || FormatterUtil.isWhitespaceOrEmpty((ASTNode)currNode)); currNode = currNode.getTreePrev()) {
        }
        return currNode;
    }

    @Nullable
    private static Indent getChildIndent(@NotNull ASTNode parent, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        IElementType parentType;
        if (parent == null) {
            AbstractJavaBlock.$$$reportNull$$$0(52);
        }
        if (indentOptions == null) {
            AbstractJavaBlock.$$$reportNull$$$0(53);
        }
        if ((parentType = parent.getElementType()) == JavaElementType.MODIFIER_LIST) {
            return Indent.getNoneIndent();
        }
        if (parentType instanceof JspCodeBlockType) {
            return Indent.getNormalIndent();
        }
        if (parentType instanceof JspClassLevelDeclarationStatementType) {
            return Indent.getNormalIndent();
        }
        if (parentType == TokenType.DUMMY_HOLDER) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.CLASS) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.IF_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.TRY_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.CATCH_SECTION) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.FOR_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.FOREACH_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.BLOCK_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.DO_WHILE_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.WHILE_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.SWITCH_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.METHOD) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaDocElementType.DOC_COMMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaDocElementType.DOC_TAG) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaDocElementType.DOC_INLINE_TAG) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.IMPORT_LIST) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.FIELD) {
            return Indent.getContinuationWithoutFirstIndent((boolean)indentOptions.USE_RELATIVE_INDENTS);
        }
        if (parentType == JavaElementType.EXPRESSION_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.IMPLICIT_CLASS) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.RECORD_COMPONENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.PACKAGE_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (SourceTreeToPsiMap.treeElementToPsi((ASTNode)parent) instanceof PsiFile) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    protected static boolean isRBrace(@NotNull ASTNode child) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(54);
        }
        return child.getElementType() == JavaTokenType.RBRACE;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            AbstractJavaBlock.$$$reportNull$$$0(55);
        }
        return JavaSpacePropertyProcessor.getSpacing(child2, this.mySettings, this.myJavaSettings);
    }

    @Override
    public ASTNode getFirstTreeNode() {
        return this.myNode;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    protected static boolean isStatement(ASTNode child, @Nullable ASTNode parentNode) {
        if (parentNode != null) {
            IElementType parentType = parentNode.getElementType();
            if (parentType == JavaElementType.CODE_BLOCK) {
                return false;
            }
            int role = ((CompositeElement)parentNode).getChildRole(child);
            if (parentType == JavaElementType.IF_STATEMENT) {
                return role == 33 || role == 34;
            }
            if (parentType == JavaElementType.FOR_STATEMENT) {
                return role == 38;
            }
            if (parentType == JavaElementType.WHILE_STATEMENT) {
                return role == 38;
            }
            if (parentType == JavaElementType.DO_WHILE_STATEMENT) {
                return role == 38;
            }
            if (parentType == JavaElementType.FOREACH_STATEMENT) {
                return role == 38;
            }
        }
        return false;
    }

    @Nullable
    protected Wrap createChildWrap() {
        return this.isBuildIndentsOnly() ? null : JavaFormatterUtil.createDefaultWrap((ASTBlock)this, this.mySettings, this.myJavaSettings, this);
    }

    @Nullable
    protected Alignment createChildAlignment() {
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.POLYADIC_EXPRESSION) {
            nodeType = JavaElementType.BINARY_EXPRESSION;
        }
        if (nodeType == JavaElementType.ASSIGNMENT_EXPRESSION) {
            if (this.myNode.getTreeParent() != null && this.myNode.getTreeParent().getElementType() == JavaElementType.ASSIGNMENT_EXPRESSION && this.myAlignment != null) {
                return this.myAlignment;
            }
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_ASSIGNMENT, null);
        }
        if (nodeType == JavaElementType.PARENTH_EXPRESSION) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION, null);
        }
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION, null);
        }
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_FOR, null);
        }
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST || nodeType == JavaElementType.PERMITS_LIST) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST, null);
        }
        if (nodeType == JavaElementType.THROWS_LIST) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_THROWS_LIST, null);
        }
        if (nodeType == JavaElementType.PARAMETER_LIST) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_PARAMETERS, null);
        }
        if (nodeType == JavaElementType.RESOURCE_LIST) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_RESOURCES, null);
        }
        if (nodeType == JavaElementType.BINARY_EXPRESSION) {
            Alignment defaultAlignment = null;
            if (this.shouldInheritAlignment()) {
                defaultAlignment = this.myAlignment;
            }
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_BINARY_OPERATION, defaultAlignment);
        }
        if (JavaFormatterUtil.isTopLevelTypeInCatchSection(nodeType, this.myNode)) {
            return AbstractJavaBlock.createAlignment(this.myJavaSettings.ALIGN_TYPES_IN_MULTI_CATCH, null);
        }
        if (AbstractJavaBlock.isTextBlock(this.myNode.getPsi())) {
            return AbstractJavaBlock.createAlignment(this.myJavaSettings.ALIGN_MULTILINE_TEXT_BLOCKS, null);
        }
        return null;
    }

    @Nullable
    protected Alignment chooseAlignment(@Nullable Alignment alignment, @Nullable Alignment alignment2, @NotNull ASTNode child) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(56);
        }
        if (this.isTernaryOperatorToken(child)) {
            return alignment2;
        }
        return alignment;
    }

    private boolean isTernaryOperatorToken(@NotNull ASTNode child) {
        IElementType nodeType;
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(57);
        }
        if ((nodeType = this.myNode.getElementType()) == JavaElementType.CONDITIONAL_EXPRESSION) {
            IElementType childType = child.getElementType();
            return childType == JavaTokenType.QUEST || childType == JavaTokenType.COLON;
        }
        return false;
    }

    private static boolean isTextBlock(@NotNull PsiElement childPsi) {
        PsiLiteralExpression literal;
        if (childPsi == null) {
            AbstractJavaBlock.$$$reportNull$$$0(58);
        }
        return (literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)childPsi, PsiLiteralExpression.class)) != null && literal.isTextBlock();
    }

    private boolean shouldInheritAlignment() {
        ASTNode treeParent;
        if (this.myNode instanceof PsiPolyadicExpression && (treeParent = this.myNode.getTreeParent()) instanceof PsiPolyadicExpression) {
            return JavaFormatterUtil.areSamePriorityBinaryExpressions(this.myNode, treeParent);
        }
        return false;
    }

    @Nullable
    protected ASTNode processChild(@NotNull List<Block> result, @NotNull ASTNode child, Alignment defaultAlignment, Wrap defaultWrap, Indent childIndent) {
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(59);
        }
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(60);
        }
        return this.processChild(result, child, AlignmentStrategy.wrap((Alignment)defaultAlignment, (IElementType[])new IElementType[0]), defaultWrap, childIndent, -1);
    }

    @Nullable
    protected ASTNode processChild(@NotNull List<Block> result, @NotNull ASTNode child, @NotNull AlignmentStrategy alignmentStrategy, @Nullable Wrap defaultWrap, Indent childIndent) {
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(61);
        }
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(62);
        }
        if (alignmentStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(63);
        }
        return this.processChild(result, child, alignmentStrategy, defaultWrap, childIndent, -1);
    }

    @Nullable
    protected ASTNode processChild(@NotNull List<Block> result, @NotNull ASTNode child, @NotNull AlignmentStrategy alignmentStrategy, Wrap defaultWrap, Indent childIndent, int childOffset) {
        IElementType childType;
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(64);
        }
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(65);
        }
        if (alignmentStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(66);
        }
        if ((childType = child.getElementType()) == JavaTokenType.CLASS_KEYWORD || childType == JavaTokenType.INTERFACE_KEYWORD) {
            this.myIsAfterClassKeyword = true;
        }
        if (childType == JavaElementType.METHOD_CALL_EXPRESSION) {
            Alignment alignment = this.shouldAlignChild(child) ? alignmentStrategy.getAlignment(childType) : null;
            result.add(this.createMethodCallExpressionBlock(child, this.arrangeChildWrap(child, defaultWrap), alignment, childIndent));
        } else {
            IElementType nodeType = this.myNode.getElementType();
            if (nodeType == JavaElementType.POLYADIC_EXPRESSION) {
                nodeType = JavaElementType.BINARY_EXPRESSION;
            }
            if (childType == JavaTokenType.LBRACE && nodeType == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
                ArrayInitializerBlocksBuilder builder = new ArrayInitializerBlocksBuilder(this.myNode, this.myBlockFactory);
                List<Block> newlyCreated = builder.buildBlocks();
                child = this.myNode.getLastChildNode();
                result.addAll(newlyCreated);
            } else if (childType == JavaTokenType.LBRACE && nodeType == JavaElementType.ANNOTATION_ARRAY_INITIALIZER) {
                Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.ARRAY_INITIALIZER_WRAP), (boolean)false);
                child = this.processParenthesisBlock(JavaTokenType.LBRACE, JavaTokenType.RBRACE, result, child, WrappingStrategy.createDoNotWrapCommaStrategy(wrap), this.mySettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION, JavaTokenType.COMMA);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.EXPRESSION_LIST) {
                Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.CALL_PARAMETERS_WRAP), (boolean)false);
                if (this.mySettings.PREFER_PARAMETERS_WRAP && !AbstractJavaBlock.isInsideMethodCall(this.myNode.getPsi())) {
                    wrap.ignoreParentWraps();
                }
                child = this.processParenthesisBlock(result, child, WrappingStrategy.createDoNotWrapCommaAndCommentStrategy(wrap), this.mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS, JavaTokenType.COMMA, JavaTokenType.END_OF_LINE_COMMENT, JavaTokenType.C_STYLE_COMMENT);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.PARAMETER_LIST) {
                ASTNode parent = this.myNode.getTreeParent();
                boolean isLambdaParameterList = parent != null && parent.getElementType() == JavaElementType.LAMBDA_EXPRESSION;
                Wrap wrapToUse = isLambdaParameterList ? null : this.getMethodParametersWrap();
                WrappingStrategy wrapStrategy = WrappingStrategy.createDoNotWrapCommaStrategy(wrapToUse);
                child = this.processParenthesisBlock(result, child, wrapStrategy, this.mySettings.ALIGN_MULTILINE_PARAMETERS);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.RECORD_HEADER) {
                Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.myJavaSettings.RECORD_COMPONENTS_WRAP), (boolean)false);
                WrappingStrategy wrapStrategy = WrappingStrategy.createDoNotWrapCommaStrategy(wrap);
                child = this.processParenthesisBlock(result, child, wrapStrategy, this.myJavaSettings.ALIGN_MULTILINE_RECORDS);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.DECONSTRUCTION_LIST) {
                Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.myJavaSettings.DECONSTRUCTION_LIST_WRAP), (boolean)false);
                WrappingStrategy wrapStrategy = WrappingStrategy.createDoNotWrapCommaStrategy(wrap);
                child = this.processParenthesisBlock(result, child, wrapStrategy, this.myJavaSettings.ALIGN_MULTILINE_DECONSTRUCTION_LIST_COMPONENTS);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.RESOURCE_LIST) {
                Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.RESOURCE_LIST_WRAP), (boolean)false);
                child = this.processParenthesisBlock(result, child, WrappingStrategy.createDoNotWrapCommaStrategy(wrap), this.mySettings.ALIGN_MULTILINE_RESOURCES);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.ANNOTATION_PARAMETER_LIST) {
                AnnotationInitializerBlocksBuilder builder = new AnnotationInitializerBlocksBuilder(this.myNode, this.myBlockFactory);
                List<Block> newlyCreated = builder.buildBlocks();
                child = this.myNode.getLastChildNode();
                result.addAll(newlyCreated);
            } else if (childType == JavaTokenType.OR && nodeType == JavaElementType.TYPE) {
                Wrap wrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                result.add((Block)new SimpleJavaBlock(child, wrap, alignmentStrategy, childIndent, this.mySettings, this.myJavaSettings, this.myFormattingMode));
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.PARENTH_EXPRESSION) {
                child = this.processParenthesisBlock(result, child, WrappingStrategy.DO_NOT_WRAP, this.mySettings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION);
            } else if (childType == JavaElementType.ENUM_CONSTANT && this.myNode instanceof ClassElement) {
                child = this.processEnumBlock(result, child, ((ClassElement)this.myNode).findEnumConstantListDelimiterPlace());
            } else if (this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && this.isTernaryOperationSign(child)) {
                child = this.processTernaryOperationRange(result, child, defaultWrap, childIndent);
            } else if (childType == JavaElementType.FIELD) {
                child = this.processField(result, child, alignmentStrategy, defaultWrap, childIndent);
            } else if (childType == JavaElementType.LOCAL_VARIABLE || childType == JavaElementType.DECLARATION_STATEMENT && (nodeType == JavaElementType.METHOD || nodeType == JavaElementType.CODE_BLOCK) || this.mySettings.ALIGN_CONSECUTIVE_ASSIGNMENTS && childType == JavaElementType.EXPRESSION_STATEMENT) {
                result.add((Block)new SimpleJavaBlock(child, defaultWrap, alignmentStrategy, childIndent, this.mySettings, this.myJavaSettings, this.myFormattingMode));
            } else if (childType == JavaElementType.METHOD) {
                Wrap wrap = this.arrangeChildWrap(child, defaultWrap);
                Block block = this.createJavaBlock(child, this.mySettings, this.myJavaSettings, childIndent, wrap, alignmentStrategy, this.myFormattingMode);
                result.add(block);
            } else if (nodeType == JavaElementType.CASE_LABEL_ELEMENT_LIST) {
                Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.SWITCH_EXPRESSIONS_WRAP), (boolean)false);
                WrappingStrategy wrapStrategy = WrappingStrategy.createDoNotWrapCommaStrategy(wrap);
                child = this.processSwitchExpression(result, child, wrapStrategy);
            } else {
                Wrap wrap;
                Block block;
                AlignmentStrategy alignmentStrategyToUse;
                Alignment alignment = alignmentStrategy.getAlignment(childType);
                ChildAttributes delegateAttributes = this.getDelegateAttributes(result);
                if (delegateAttributes != null) {
                    alignment = delegateAttributes.getAlignment();
                    if (delegateAttributes.getChildIndent() != null) {
                        childIndent = delegateAttributes.getChildIndent();
                    }
                }
                AlignmentStrategy alignmentStrategy2 = alignmentStrategyToUse = this.shouldAlignChild(child) ? AlignmentStrategy.wrap((Alignment)alignment, (IElementType[])new IElementType[0]) : AlignmentStrategy.getNullStrategy();
                if (this.myAlignmentStrategy.getAlignment(nodeType, childType) != null && (nodeType == JavaElementType.IMPLEMENTS_LIST || nodeType == JavaElementType.CLASS) || this.mySettings.ALIGN_CONSECUTIVE_ASSIGNMENTS && (nodeType == JavaElementType.EXPRESSION_STATEMENT && childType == JavaElementType.ASSIGNMENT_EXPRESSION || nodeType == JavaElementType.ASSIGNMENT_EXPRESSION)) {
                    alignmentStrategyToUse = this.myAlignmentStrategy;
                }
                if ((block = this.createJavaBlock(child, this.mySettings, this.myJavaSettings, childIndent, wrap = this.arrangeChildWrap(child, defaultWrap), alignmentStrategyToUse, childOffset, this.myFormattingMode)) instanceof AbstractJavaBlock) {
                    AbstractJavaBlock javaBlock = (AbstractJavaBlock)block;
                    if (nodeType == JavaElementType.METHOD_CALL_EXPRESSION && childType == JavaElementType.REFERENCE_EXPRESSION) {
                        javaBlock.setReservedWrap(this.getReservedWrap(nodeType), nodeType);
                        javaBlock.setReservedWrap(this.getReservedWrap(childType), childType);
                    } else if (nodeType == JavaElementType.BINARY_EXPRESSION) {
                        javaBlock.setReservedWrap(defaultWrap, nodeType);
                    }
                }
                result.add(block);
            }
        }
        return child;
    }

    @Nullable
    private ChildAttributes getDelegateAttributes(@NotNull List<? extends Block> result) {
        int lastIndex;
        Block lastBlock;
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(67);
        }
        if (FormattingMode.ADJUST_INDENT_ON_ENTER.equals((Object)this.myFormattingMode) && !result.isEmpty() && (lastBlock = result.get(lastIndex = result.size() - 1)).isIncomplete()) {
            return lastBlock.getChildAttributes(lastBlock.getSubBlocks().size());
        }
        return null;
    }

    private static boolean isAfterErrorElement(@NotNull ASTNode currNode) {
        if (currNode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(68);
        }
        for (ASTNode prev = currNode.getTreePrev(); prev != null && (prev instanceof PsiWhiteSpace || prev.getTextLength() == 0); prev = prev.getTreePrev()) {
            if (!(prev instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInsideMethodCall(@NotNull PsiElement element) {
        if (element == null) {
            AbstractJavaBlock.$$$reportNull$$$0(69);
        }
        PsiElement e = element.getParent();
        for (int parentsVisited = 0; e != null && !(e instanceof PsiStatement) && parentsVisited < 5; e = e.getParent(), ++parentsVisited) {
            if (!(e instanceof PsiExpressionList)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Wrap getMethodParametersWrap() {
        Wrap preferredWrap = this.getModifierListWrap();
        if (preferredWrap == null) {
            Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_PARAMETERS_WRAP), (boolean)false);
            if (wrap == null) {
                AbstractJavaBlock.$$$reportNull$$$0(70);
            }
            return wrap;
        }
        Wrap wrap = Wrap.createChildWrap((Wrap)preferredWrap, (WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_PARAMETERS_WRAP), (boolean)false);
        if (wrap == null) {
            AbstractJavaBlock.$$$reportNull$$$0(71);
        }
        return wrap;
    }

    @Nullable
    private Wrap getModifierListWrap() {
        AbstractJavaBlock parentBlock = this.getParentBlock();
        if (parentBlock != null) {
            return parentBlock.getReservedWrap(JavaElementType.MODIFIER_LIST);
        }
        return null;
    }

    private ASTNode processField(@NotNull List<? super Block> result, ASTNode child, @NotNull AlignmentStrategy alignmentStrategy, Wrap defaultWrap, Indent childIndent) {
        ASTNode lastFieldInGroup;
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(72);
        }
        if (alignmentStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(73);
        }
        if ((lastFieldInGroup = MultipleFieldDeclarationHelper.findLastFieldInGroup(child)) == child) {
            Wrap wrap = this.arrangeChildWrap(child, defaultWrap);
            result.add((Block)this.createJavaBlock(child, this.getSettings(), this.myJavaSettings, childIndent, wrap, alignmentStrategy, this.myFormattingMode));
            return child;
        }
        ArrayList<Block> localResult = new ArrayList<Block>();
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)child)) {
                localResult.add(this.createJavaBlock(child, this.getSettings(), this.myJavaSettings, Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS), this.arrangeChildWrap(child, defaultWrap), alignmentStrategy, this.myFormattingMode));
            }
            if (child == lastFieldInGroup) break;
            child = child.getTreeNext();
        }
        if (!localResult.isEmpty()) {
            result.add(new SyntheticCodeBlock(localResult, null, this.getSettings(), this.myJavaSettings, childIndent, null));
        }
        return lastFieldInGroup;
    }

    @Nullable
    private ASTNode processSwitchExpression(@NotNull List<? super Block> result, ASTNode child, WrappingStrategy wrappingStrategy) {
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(74);
        }
        AlignmentStrategy alignmentStrategy = AlignmentStrategy.wrap((Alignment)AbstractJavaBlock.createAlignment(true, null), (IElementType[])new IElementType[]{JavaTokenType.COMMA});
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) && child.getTextLength() > 0) {
                result.add((Block)this.createJavaBlock(child, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), wrappingStrategy.getWrap(child.getElementType()), alignmentStrategy, this.myFormattingMode));
            }
            child = child.getTreeNext();
        }
        return child;
    }

    @Nullable
    private ASTNode processTernaryOperationRange(@NotNull List<? super Block> result, @NotNull ASTNode child, Wrap defaultWrap, Indent childIndent) {
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(75);
        }
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(76);
        }
        ArrayList<Block> localResult = new ArrayList<Block>();
        Wrap wrap = this.arrangeChildWrap(child, defaultWrap);
        Alignment alignment = this.myReservedAlignment;
        Alignment alignment2 = this.myReservedAlignment2;
        localResult.add((Block)new LeafBlock(child, wrap, this.chooseAlignment(alignment, alignment2, child), childIndent));
        ASTNode current = child.getTreeNext();
        while (current != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)current) && current.getTextLength() > 0) {
                if (this.isTernaryOperationSign(current)) break;
                current = this.processChild(localResult, current, this.chooseAlignment(alignment, alignment2, current), defaultWrap, childIndent);
            }
            if (current == null) continue;
            current = current.getTreeNext();
        }
        result.add(new SyntheticCodeBlock(localResult, this.chooseAlignment(alignment, alignment2, child), this.getSettings(), this.myJavaSettings, null, wrap));
        if (current == null) {
            return null;
        }
        return current.getTreePrev();
    }

    private boolean isTernaryOperationSign(@NotNull ASTNode child) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(77);
        }
        if (this.myNode.getElementType() != JavaElementType.CONDITIONAL_EXPRESSION) {
            return false;
        }
        int role = ((CompositeElement)child.getTreeParent()).getChildRole(child);
        return role == 63 || role == 87;
    }

    @NotNull
    private Block createMethodCallExpressionBlock(@NotNull ASTNode node, Wrap blockWrap, Alignment alignment, Indent indent) {
        if (node == null) {
            AbstractJavaBlock.$$$reportNull$$$0(78);
        }
        ArrayList nodes = new ArrayList();
        JavaFormatterUtil.collectCallExpressionNodes(nodes, node);
        if (nodes.isEmpty()) {
            return new LeafBlock(node, blockWrap, alignment, indent);
        }
        if (Registry.is((String)"java.formatter.chained.calls.pre212.compatibility")) {
            Block block = new LegacyChainedMethodCallsBlockBuilder(alignment, blockWrap, indent, this.mySettings, this.myJavaSettings, this.myFormattingMode).build(nodes);
            if (block == null) {
                AbstractJavaBlock.$$$reportNull$$$0(79);
            }
            return block;
        }
        Block block = new ChainMethodCallsBlockBuilder(alignment, blockWrap, indent, this.mySettings, this.myJavaSettings, this.myFormattingMode).build(nodes);
        if (block == null) {
            AbstractJavaBlock.$$$reportNull$$$0(80);
        }
        return block;
    }

    private boolean shouldAlignChild(@NotNull ASTNode child) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(81);
        }
        int role = AbstractJavaBlock.getChildRole(child);
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            return role == 39 || role == 32 || role == 40;
        }
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST || nodeType == JavaElementType.PERMITS_LIST || nodeType == JavaElementType.THROWS_LIST) {
            return role == 29;
        }
        if (nodeType == JavaElementType.CLASS) {
            if (role == 11) {
                return true;
            }
            if (this.myIsAfterClassKeyword) {
                return false;
            }
            return role == 8;
        }
        if (JavaElementType.FIELD == nodeType) {
            return this.shouldAlignFieldInColumns(child);
        }
        if (nodeType == JavaElementType.METHOD) {
            if (role == 8) {
                return true;
            }
            if (role == 245) {
                return true;
            }
            if (role == 10) {
                return true;
            }
            if (role == 9) {
                return true;
            }
            if (role == 16 && this.mySettings.ALIGN_THROWS_KEYWORD) {
                return true;
            }
            if (role == 17) {
                return !this.getNode().textContains('\n');
            }
            return false;
        }
        if (nodeType == JavaElementType.ASSIGNMENT_EXPRESSION) {
            if (role == 61) {
                return true;
            }
            return role == 62 && child.getElementType() == JavaElementType.ASSIGNMENT_EXPRESSION;
        }
        if (child.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            CharSequence prevChars;
            ASTNode previous = child.getTreePrev();
            return previous == null || previous.getElementType() != TokenType.WHITE_SPACE || (prevChars = previous.getChars()).isEmpty() || prevChars.charAt(prevChars.length() - 1) != '\n';
        }
        if (nodeType == JavaElementType.MODIFIER_LIST) {
            ASTNode previous = child.getTreePrev();
            return previous == null || previous.getTreeParent() != this.myNode;
        }
        return true;
    }

    private static int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(82);
        }
        return ((CompositeElement)child.getTreeParent()).getChildRole(child);
    }

    private boolean shouldAlignFieldInColumns(@NotNull ASTNode child) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(83);
        }
        if (!this.mySettings.ALIGN_GROUP_FIELD_DECLARATIONS) {
            return false;
        }
        IElementType childType = child.getElementType();
        ASTNode previousNode = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
        return childType != JavaTokenType.IDENTIFIER || previousNode != null && previousNode.getElementType() != JavaTokenType.COMMA;
    }

    @Nullable
    public static Alignment createAlignment(boolean alignOption, @Nullable Alignment defaultAlignment) {
        return alignOption ? AbstractJavaBlock.createAlignmentOrDefault(null, defaultAlignment) : defaultAlignment;
    }

    @Nullable
    public static Alignment createAlignment(Alignment base, boolean alignOption, @Nullable Alignment defaultAlignment) {
        return alignOption ? AbstractJavaBlock.createAlignmentOrDefault(base, defaultAlignment) : defaultAlignment;
    }

    @Nullable
    protected Wrap arrangeChildWrap(ASTNode child, Wrap defaultWrap) {
        return this.isBuildIndentsOnly() ? null : JavaFormatterUtil.arrangeChildWrap(child, this.myNode, this.mySettings, this.myJavaSettings, defaultWrap, this);
    }

    @NotNull
    private ASTNode processParenthesisBlock(@NotNull List<Block> result, @NotNull ASTNode child, @NotNull WrappingStrategy wrappingStrategy, boolean doAlign) {
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(84);
        }
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(85);
        }
        if (wrappingStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(86);
        }
        return this.processParenthesisBlock(result, child, wrappingStrategy, doAlign, JavaTokenType.COMMA);
    }

    @NotNull
    private ASTNode processParenthesisBlock(@NotNull List<Block> result, @NotNull ASTNode child, @NotNull WrappingStrategy wrappingStrategy, boolean doAlign, IElementType ... ignoreAlignmentTypes) {
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(87);
        }
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(88);
        }
        if (wrappingStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(89);
        }
        if (ignoreAlignmentTypes == null) {
            AbstractJavaBlock.$$$reportNull$$$0(90);
        }
        this.myUseChildAttributes = true;
        IElementType from = JavaTokenType.LPARENTH;
        IElementType to = JavaTokenType.RPARENTH;
        return this.processParenthesisBlock(from, to, result, child, wrappingStrategy, doAlign, ignoreAlignmentTypes);
    }

    @NotNull
    private ASTNode processParenthesisBlock(@NotNull IElementType from, @Nullable IElementType to, @NotNull List<Block> result, @NotNull ASTNode child, @NotNull WrappingStrategy wrappingStrategy, boolean doAlign, IElementType ... ignoreAlignmentTypes) {
        if (from == null) {
            AbstractJavaBlock.$$$reportNull$$$0(91);
        }
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(92);
        }
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(93);
        }
        if (wrappingStrategy == null) {
            AbstractJavaBlock.$$$reportNull$$$0(94);
        }
        if (ignoreAlignmentTypes == null) {
            AbstractJavaBlock.$$$reportNull$$$0(95);
        }
        Indent externalIndent = Indent.getNoneIndent();
        Indent internalIndent = Indent.getContinuationWithoutFirstIndent((boolean)false);
        if (AbstractJavaBlock.isInsideMethodCallParenthesis(child) || AbstractJavaBlock.isInsideMethodDeclarationParenthesis(child)) {
            internalIndent = Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
        }
        AlignmentStrategy alignmentStrategy = AlignmentStrategy.wrap((Alignment)AbstractJavaBlock.createAlignment(doAlign, null), (IElementType[])ignoreAlignmentTypes);
        this.setChildIndent(internalIndent);
        this.setChildAlignment(alignmentStrategy.getAlignment(null));
        boolean methodParametersBlock = true;
        ASTNode lBracketParent = child.getTreeParent();
        if (lBracketParent != null) {
            ASTNode methodCandidate = lBracketParent.getTreeParent();
            methodParametersBlock = methodCandidate != null && (methodCandidate.getElementType() == JavaElementType.METHOD || methodCandidate.getElementType() == JavaElementType.METHOD_CALL_EXPRESSION);
        }
        Alignment bracketAlignment = methodParametersBlock && this.mySettings.ALIGN_MULTILINE_METHOD_BRACKETS ? Alignment.createAlignment() : null;
        AlignmentStrategy anonymousClassStrategy = doAlign ? alignmentStrategy : AlignmentStrategy.wrap((Alignment)Alignment.createAlignment(), (boolean)false, (IElementType[])new IElementType[]{JavaTokenType.NEW_KEYWORD, JavaElementType.NEW_EXPRESSION, JavaTokenType.RBRACE});
        this.setChildIndent(internalIndent);
        this.setChildAlignment(alignmentStrategy.getAlignment(null));
        ASTNode prev = child;
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) && child.getTextLength() > 0) {
                if (child.getElementType() == from) {
                    result.add(this.createJavaBlock(child, this.mySettings, this.myJavaSettings, externalIndent, null, bracketAlignment, this.myFormattingMode));
                } else {
                    if (child.getElementType() == to) {
                        boolean isAfterIncomplete = AbstractJavaBlock.isAfterErrorElement(child);
                        Indent parenIndent = isAfterIncomplete ? internalIndent : externalIndent;
                        Alignment parenAlignment = isAfterIncomplete ? alignmentStrategy.getAlignment(null) : bracketAlignment;
                        ChildAttributes attributes = this.getDelegateAttributes(result);
                        if (attributes != null) {
                            parenIndent = attributes.getChildIndent();
                            parenAlignment = attributes.getAlignment();
                        }
                        Block block = this.createJavaBlock(child, this.mySettings, this.myJavaSettings, parenIndent, null, parenAlignment, this.myFormattingMode);
                        result.add(block);
                        ASTNode aSTNode = child;
                        if (aSTNode == null) {
                            AbstractJavaBlock.$$$reportNull$$$0(96);
                        }
                        return aSTNode;
                    }
                    IElementType elementType = child.getElementType();
                    AlignmentStrategy alignmentStrategyToUse = AbstractJavaBlock.canUseAnonymousClassAlignment(child) ? anonymousClassStrategy : alignmentStrategy;
                    this.processChild(result, child, alignmentStrategyToUse.getAlignment(elementType), wrappingStrategy.getWrap(elementType), internalIndent);
                    if (to == null) {
                        ASTNode aSTNode = child;
                        if (aSTNode == null) {
                            AbstractJavaBlock.$$$reportNull$$$0(97);
                        }
                        return aSTNode;
                    }
                }
            }
            prev = child;
            child = child.getTreeNext();
        }
        ASTNode aSTNode = prev;
        if (aSTNode == null) {
            AbstractJavaBlock.$$$reportNull$$$0(98);
        }
        return aSTNode;
    }

    private static boolean isInsideMethodCallParenthesis(ASTNode child) {
        ASTNode currentPredecessor = child.getTreeParent();
        if (currentPredecessor != null) {
            return (currentPredecessor = currentPredecessor.getTreeParent()) != null && currentPredecessor.getElementType() == JavaElementType.METHOD_CALL_EXPRESSION;
        }
        return false;
    }

    private static boolean isInsideMethodDeclarationParenthesis(@NotNull ASTNode child) {
        ASTNode parent;
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(99);
        }
        if ((parent = child.getTreeParent()) == null || parent.getElementType() != JavaElementType.PARAMETER_LIST) {
            return false;
        }
        ASTNode grandParent = parent.getTreeParent();
        return grandParent != null && grandParent.getElementType() == JavaElementType.METHOD;
    }

    private static boolean canUseAnonymousClassAlignment(@NotNull ASTNode child) {
        if (child == null) {
            AbstractJavaBlock.$$$reportNull$$$0(100);
        }
        if (!AbstractJavaBlock.isAnonymousClass(child)) {
            return false;
        }
        for (ASTNode node = child.getTreePrev(); node != null; node = node.getTreePrev()) {
            if (node.getElementType() == TokenType.WHITE_SPACE) {
                if (StringUtil.countNewLines((CharSequence)node.getChars()) <= 0) continue;
                return false;
            }
            if (node.getElementType() == JavaTokenType.LPARENTH) {
                return true;
            }
            if (node.getElementType() == JavaTokenType.COMMA || AbstractJavaBlock.isAnonymousClass(node)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAnonymousClass(@Nullable ASTNode node) {
        if (node == null || node.getElementType() != JavaElementType.NEW_EXPRESSION) {
            return false;
        }
        ASTNode lastChild = node.getLastChildNode();
        return lastChild != null && lastChild.getElementType() == JavaElementType.ANONYMOUS_CLASS;
    }

    @Nullable
    private ASTNode processEnumBlock(@NotNull List<? super Block> result, @Nullable ASTNode child, ASTNode last) {
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(101);
        }
        WrappingStrategy wrappingStrategy = new WrappingStrategy(this, Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.ENUM_CONSTANTS_WRAP), (boolean)true)){

            @Override
            protected boolean shouldWrap(IElementType type) {
                return type == JavaElementType.ENUM_CONSTANT;
            }
        };
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) && child.getTextLength() > 0) {
                result.add((Block)this.createJavaBlock(child, this.mySettings, this.myJavaSettings, Indent.getNormalIndent(), wrappingStrategy.getWrap(child.getElementType()), AlignmentStrategy.getNullStrategy(), this.myFormattingMode));
                if (child == last) {
                    return child;
                }
            }
            child = child.getTreeNext();
        }
        return null;
    }

    private void setChildAlignment(Alignment alignment) {
        this.myChildAlignment = alignment;
    }

    private void setChildIndent(Indent internalIndent) {
        this.myChildIndent = internalIndent;
    }

    @Nullable
    private static Alignment createAlignmentOrDefault(@Nullable Alignment base, @Nullable Alignment defaultAlignment) {
        if (defaultAlignment == null) {
            return base == null ? Alignment.createAlignment() : Alignment.createChildAlignment((Alignment)base);
        }
        return defaultAlignment;
    }

    private int getBraceStyle() {
        PsiElement psiNode = SourceTreeToPsiMap.treeElementToPsi((ASTNode)this.myNode);
        if (psiNode instanceof PsiClass) {
            return this.mySettings.CLASS_BRACE_STYLE;
        }
        if (psiNode instanceof PsiMethod || psiNode instanceof PsiCodeBlock && psiNode.getParent() != null && psiNode.getParent() instanceof PsiMethod) {
            return this.mySettings.METHOD_BRACE_STYLE;
        }
        return this.mySettings.BRACE_STYLE;
    }

    protected Indent getCodeBlockInternalIndent(int baseChildrenIndent) {
        if (this.isTopLevelClass() && this.mySettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS) {
            return Indent.getNoneIndent();
        }
        int braceStyle = this.getBraceStyle();
        int shift = braceStyle == 3 ? 1 : 0;
        return AbstractJavaBlock.createNormalIndent(baseChildrenIndent - shift);
    }

    protected static Indent createNormalIndent() {
        return AbstractJavaBlock.createNormalIndent(1);
    }

    protected static Indent createNormalIndent(int baseChildrenIndent) {
        assert (baseChildrenIndent <= 1) : baseChildrenIndent;
        if (baseChildrenIndent <= 0) {
            return Indent.getNoneIndent();
        }
        return Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)false);
    }

    private boolean isTopLevelClass() {
        return this.myNode.getElementType() == JavaElementType.CLASS && SourceTreeToPsiMap.treeElementToPsi((ASTNode)this.myNode.getTreeParent()) instanceof PsiFile;
    }

    protected Indent getCodeBlockExternalIndent() {
        int braceStyle = this.getBraceStyle();
        if (braceStyle == 1 || braceStyle == 2 || braceStyle == 5) {
            return Indent.getNoneIndent();
        }
        return Indent.getNormalIndent();
    }

    protected Indent getCodeBlockChildExternalIndent(int newChildIndex) {
        int braceStyle = this.getBraceStyle();
        if (!this.isAfterCodeBlock(newChildIndex)) {
            return Indent.getNormalIndent();
        }
        if (braceStyle == 2 || braceStyle == 5 || braceStyle == 1) {
            return Indent.getNoneIndent();
        }
        return Indent.getNormalIndent();
    }

    private boolean isAfterCodeBlock(int newChildIndex) {
        if (newChildIndex == 0) {
            return false;
        }
        Block blockBefore = (Block)this.getSubBlocks().get(newChildIndex - 1);
        return blockBefore instanceof CodeBlockBlock;
    }

    @Override
    @Nullable
    public Wrap getReservedWrap(IElementType elementType) {
        return this.myPreferredWraps != null ? this.myPreferredWraps.get(elementType) : null;
    }

    public void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
        if (this.myPreferredWraps == null) {
            this.myPreferredWraps = new HashMap<IElementType, Wrap>();
        }
        this.myPreferredWraps.put(operationType, reservedWrap);
    }

    @Nullable
    protected static ASTNode getTreeNode(Block block) {
        if (block instanceof JavaBlock) {
            return ((JavaBlock)block).getFirstTreeNode();
        }
        if (block instanceof LeafBlock) {
            return ((LeafBlock)block).getTreeNode();
        }
        if (block instanceof CStyleCommentBlock) {
            return ((CStyleCommentBlock)block).getNode();
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myUseChildAttributes) {
            return new ChildAttributes(this.myChildIndent, this.myChildAlignment);
        }
        if (this.isAfter(newChildIndex, new IElementType[]{JavaDocElementType.DOC_COMMENT})) {
            return new ChildAttributes(Indent.getNoneIndent(), this.myChildAlignment);
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            AbstractJavaBlock.$$$reportNull$$$0(102);
        }
        return childAttributes;
    }

    @Nullable
    protected Indent getChildIndent() {
        return AbstractJavaBlock.getChildIndent(this.myNode, this.myIndentSettings);
    }

    @NotNull
    public CommonCodeStyleSettings getSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = this.mySettings;
        if (commonCodeStyleSettings == null) {
            AbstractJavaBlock.$$$reportNull$$$0(103);
        }
        return commonCodeStyleSettings;
    }

    protected boolean isAfter(int newChildIndex, IElementType @NotNull [] elementTypes) {
        if (elementTypes == null) {
            AbstractJavaBlock.$$$reportNull$$$0(104);
        }
        if (newChildIndex == 0) {
            return false;
        }
        Block previousBlock = (Block)this.getSubBlocks().get(newChildIndex - 1);
        if (!(previousBlock instanceof AbstractBlock)) {
            return false;
        }
        IElementType previousElementType = ((AbstractBlock)previousBlock).getNode().getElementType();
        return ArrayUtil.contains((Object)previousElementType, (Object[])elementTypes);
    }

    @Nullable
    protected Alignment getUsedAlignment(int newChildIndex) {
        List subBlocks = this.getSubBlocks();
        for (int i = 0; i < newChildIndex; ++i) {
            if (i >= subBlocks.size()) {
                return null;
            }
            Block block = (Block)subBlocks.get(i);
            Alignment alignment = block.getAlignment();
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }

    public boolean isLeaf() {
        return ShiftIndentInsideHelper.mayShiftIndentInside(this.myNode);
    }

    @Nullable
    protected ASTNode composeCodeBlock(@NotNull List<? super Block> result, ASTNode child, Indent indent, int childrenIndent, @Nullable Wrap childWrap) {
        if (result == null) {
            AbstractJavaBlock.$$$reportNull$$$0(105);
        }
        ArrayList<Block> localResult = new ArrayList<Block>();
        this.processChild(localResult, child, AlignmentStrategy.getNullStrategy(), null, Indent.getNoneIndent());
        child = child.getTreeNext();
        ChildAlignmentStrategyProvider alignmentStrategyProvider = this.getStrategyProvider();
        while (child != null) {
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)child)) {
                child = child.getTreeNext();
                continue;
            }
            Indent childIndent = this.getIndentForCodeBlock(child, childrenIndent);
            AlignmentStrategy alignmentStrategyToUse = alignmentStrategyProvider.getNextChildStrategy(child);
            boolean isRBrace = AbstractJavaBlock.isRBrace(child);
            child = this.processChild(localResult, child, alignmentStrategyToUse, childWrap, childIndent);
            if (isRBrace) {
                result.add(this.createCodeBlockBlock(localResult, indent, childrenIndent));
                return child;
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
        result.add(this.createCodeBlockBlock(localResult, indent, childrenIndent));
        return null;
    }

    protected ChildAlignmentStrategyProvider getStrategyProvider() {
        IElementType parentType;
        if (this.myNode.getElementType() == JavaElementType.CLASS || this.myNode.getElementType() == JavaElementType.ANONYMOUS_CLASS) {
            return new SubsequentClassMemberAlignment(this.mySettings);
        }
        ASTNode parent = this.myNode.getTreeParent();
        IElementType iElementType = parentType = parent != null ? parent.getElementType() : null;
        if ((parentType == JavaElementType.METHOD || this.myNode instanceof PsiCodeBlock) && (this.mySettings.ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS || this.mySettings.ALIGN_CONSECUTIVE_ASSIGNMENTS)) {
            SmartList configuration = new SmartList();
            if (this.mySettings.ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS) {
                configuration.add(SubsequentVariablesAlignerConfigurations.subsequentVariableAligner);
            }
            if (this.mySettings.ALIGN_CONSECUTIVE_ASSIGNMENTS) {
                configuration.add(SubsequentVariablesAlignerConfigurations.subsequentAssignmentAligner);
            }
            return new CompositeAligner((List<CompositeAligner.AlignerConfiguration>)configuration);
        }
        return ChildAlignmentStrategyProvider.NULL_STRATEGY_PROVIDER;
    }

    private Indent getIndentForCodeBlock(ASTNode child, int childrenIndent) {
        if (child.getElementType() == JavaElementType.CODE_BLOCK && (this.getBraceStyle() == 3 || this.getBraceStyle() == 4)) {
            return Indent.getNormalIndent();
        }
        return AbstractJavaBlock.isRBrace(child) ? Indent.getNoneIndent() : this.getCodeBlockInternalIndent(childrenIndent);
    }

    public AbstractJavaBlock getParentBlock() {
        return this.myParentBlock;
    }

    public void setParentBlock(@NotNull AbstractJavaBlock parentBlock) {
        if (parentBlock == null) {
            AbstractJavaBlock.$$$reportNull$$$0(106);
        }
        this.myParentBlock = parentBlock;
    }

    @NotNull
    public SyntheticCodeBlock createCodeBlockBlock(List<Block> localResult, Indent indent, int childrenIndent) {
        SyntheticCodeBlock result = new SyntheticCodeBlock(localResult, null, this.getSettings(), this.myJavaSettings, indent, null);
        result.setChildAttributes(new ChildAttributes(this.getCodeBlockInternalIndent(childrenIndent), null));
        SyntheticCodeBlock syntheticCodeBlock = result;
        if (syntheticCodeBlock == null) {
            AbstractJavaBlock.$$$reportNull$$$0(107);
        }
        return syntheticCodeBlock;
    }

    protected FormattingMode getFormattingMode() {
        return this.myFormattingMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 35, 36, 46, 47, 70, 71, 79, 80, 96, 97, 98, 102, 103, 107 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 6: 
            case 14: 
            case 21: 
            case 26: 
            case 31: 
            case 38: 
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: 
            case 22: 
            case 27: 
            case 32: 
            case 39: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSettings";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 17: 
            case 23: 
            case 29: 
            case 34: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 5: 
            case 16: 
            case 28: 
            case 33: 
            case 63: 
            case 66: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignmentStrategy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 18: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 20: 
            case 25: 
            case 30: 
            case 37: 
            case 41: 
            case 48: 
            case 54: 
            case 56: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 88: 
            case 93: 
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 24: 
            case 35: 
            case 36: 
            case 46: 
            case 47: 
            case 70: 
            case 71: 
            case 79: 
            case 80: 
            case 96: 
            case 97: 
            case 98: 
            case 102: 
            case 103: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/AbstractJavaBlock";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childPsi";
                break;
            }
            case 59: 
            case 61: 
            case 64: 
            case 67: 
            case 72: 
            case 74: 
            case 75: 
            case 84: 
            case 87: 
            case 92: 
            case 101: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currNode";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 86: 
            case 89: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappingStrategy";
                break;
            }
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreAlignmentTypes";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/AbstractJavaBlock";
                break;
            }
            case 24: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBlock";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "newJavaBlock";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaIndentOptions";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodParametersWrap";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodCallExpressionBlock";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "processParenthesisBlock";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createBlockAlignment";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createJavaBlock";
                break;
            }
            case 24: 
            case 35: 
            case 36: 
            case 46: 
            case 47: 
            case 70: 
            case 71: 
            case 79: 
            case 80: 
            case 96: 
            case 97: 
            case 98: 
            case 102: 
            case 103: 
            case 107: {
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "newJavaBlock";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSubtreeIndent";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "skipCommentsAndWhitespacesBackwards";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isRBrace";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "chooseAlignment";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isTernaryOperatorToken";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isTextBlock";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processChild";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getDelegateAttributes";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isAfterErrorElement";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMethodCall";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processField";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "processSwitchExpression";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "processTernaryOperationRange";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isTernaryOperationSign";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCallExpressionBlock";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "shouldAlignChild";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "shouldAlignFieldInColumns";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "processParenthesisBlock";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMethodDeclarationParenthesis";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "canUseAnonymousClassAlignment";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "processEnumBlock";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "isAfter";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "composeCodeBlock";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "setParentBlock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24, 35, 36, 46, 47, 70, 71, 79, 80, 96, 97, 98, 102, 103, 107 -> new IllegalStateException(string);
        };
    }
}

