/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import org.jetbrains.annotations.NotNull;

public class ImportHelperBase {
    protected final JavaCodeStyleSettings mySettings;

    public ImportHelperBase(@NotNull JavaCodeStyleSettings settings) {
        if (settings == null) {
            ImportHelperBase.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
    }

    public int getEmptyLinesBetween(@NotNull PsiImportStatementBase statement1, @NotNull PsiImportStatementBase statement2) {
        int index2;
        int index1;
        if (statement1 == null) {
            ImportHelperBase.$$$reportNull$$$0(1);
        }
        if (statement2 == null) {
            ImportHelperBase.$$$reportNull$$$0(2);
        }
        if ((index1 = this.findEntryIndex(statement1)) == (index2 = this.findEntryIndex(statement2))) {
            return 0;
        }
        if (index1 > index2) {
            int t = index1;
            index1 = index2;
            index2 = t;
        }
        PackageEntry[] entries = this.mySettings.IMPORT_LAYOUT_TABLE.getEntries();
        int maxSpace = 0;
        for (int i = index1 + 1; i < index2; ++i) {
            if (entries[i] != PackageEntry.BLANK_LINE_ENTRY) continue;
            int space = 0;
            do {
                ++space;
            } while (entries[++i] == PackageEntry.BLANK_LINE_ENTRY);
            maxSpace = Math.max(maxSpace, space);
        }
        return maxSpace;
    }

    protected static int findEntryIndex(@NotNull String packageName, boolean isStatic, boolean isModule, PackageEntry @NotNull [] entries) {
        if (packageName == null) {
            ImportHelperBase.$$$reportNull$$$0(3);
        }
        if (entries == null) {
            ImportHelperBase.$$$reportNull$$$0(4);
        }
        PackageEntry bestEntry = null;
        int bestEntryIndex = -1;
        int allOtherStaticIndex = -1;
        int allOtherIndex = -1;
        for (int i = 0; i < entries.length; ++i) {
            PackageEntry entry = entries[i];
            if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                allOtherStaticIndex = i;
            }
            if (!isModule && entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY) {
                allOtherIndex = i;
            }
            if (!isModule && entry.isBetterMatchForPackageThan(bestEntry, packageName, isStatic)) {
                bestEntry = entry;
                bestEntryIndex = i;
            }
            if (!isModule || entry != PackageEntry.ALL_MODULE_IMPORTS) continue;
            bestEntry = entry;
            bestEntryIndex = i;
        }
        if (bestEntryIndex == -1 && isStatic && allOtherStaticIndex == -1 && allOtherIndex != -1) {
            bestEntryIndex = allOtherIndex;
        }
        return bestEntryIndex;
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement) {
        if (statement == null) {
            ImportHelperBase.$$$reportNull$$$0(5);
        }
        PsiJavaCodeReferenceElement ref = statement.getImportReference();
        if (statement instanceof PsiImportModuleStatement) {
            return ImportHelperBase.findEntryIndex("", this.mySettings.LAYOUT_STATIC_IMPORTS_SEPARATELY && statement instanceof PsiImportStaticStatement, true, this.mySettings.IMPORT_LAYOUT_TABLE.getEntries());
        }
        if (ref == null) {
            return -1;
        }
        String packageName = statement.isOnDemand() ? ref.getCanonicalText() : StringUtil.getPackageName((String)ref.getCanonicalText());
        return ImportHelperBase.findEntryIndex(packageName, this.mySettings.LAYOUT_STATIC_IMPORTS_SEPARATELY && statement instanceof PsiImportStaticStatement, false, this.mySettings.IMPORT_LAYOUT_TABLE.getEntries());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/formatter/java/ImportHelperBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEmptyLinesBetween";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findEntryIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

