/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.enumd.indexing;

import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.QueryUtil;
import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class EnumSearch {
    private static final Logger LOGGER = Logger.getInstance(EnumSearch.class);
    private final Project project;
    private final SearchHelper searchHelper;
    private final JavaPsiFacade javaPsiFacade;

    public EnumSearch(Project project) {
        this.project = project;
        this.searchHelper = SearchHelper.getInstance(project);
        this.javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
    }

    public static EnumSearch getInstance(Project project) {
        return (EnumSearch)project.getService(EnumSearch.class);
    }

    public Collection<PsiClass> allEnums() {
        ArrayList<PsiClass> enums = new ArrayList<PsiClass>(this.getProjectEnums());
        enums.addAll(this.getLibrariesEnums());
        return enums;
    }

    public Collection<PsiClass> getLibrariesEnums() {
        return this.getEnums(ProjectScope.getLibrariesScope((Project)this.project));
    }

    @Nullable
    public PsiClass findByQualifiedName(String qualifiedName) {
        return (PsiClass)EntityUtil.ra(() -> {
            PsiClass theClass = this.searchHelper.findClass(qualifiedName);
            return theClass != null && theClass.isEnum() ? theClass : null;
        });
    }

    public Collection<PsiClass> getProjectEnums() {
        return this.getEnums(GlobalSearchScopesCore.projectProductionScope((Project)this.project));
    }

    public Collection<PsiClass> getEnums(GlobalSearchScope globalSearchScope) {
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        EntityUtil.ra(() -> {
            try {
                String enumClassFqn = this.getEnumClassFqn();
                PsiClass enumClass = this.javaPsiFacade.findClass(enumClassFqn, GlobalSearchScope.allScope((Project)this.project));
                if (enumClass == null) {
                    LOGGER.debug(enumClassFqn + " not found");
                    return;
                }
                Query baseQuery = ClassInheritorsSearch.search((PsiClass)enumClass, (SearchScope)globalSearchScope, (boolean)true, (boolean)true, (boolean)false);
                FilteredQuery filteredQuery = new FilteredQuery(baseQuery, EntityUtil::isEnum);
                QueryUtil.uniqueByFqn((Query<PsiClass>)filteredQuery).forEach((Processor)collectProcessor);
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("IndexNotReady on EnumSearchImpl.getEnums", (Throwable)e);
            }
        });
        return collectProcessor.getResults();
    }

    public String getEnumClassFqn() {
        return Enum.class.getName();
    }
}

