/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ed;

import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.core.multilanguage.SupportedLanguagesManager;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpaEntitySearch
extends EntitySearch {
    private static final Logger LOGGER = Logger.getInstance(JpaEntitySearch.class);
    private final Project project;
    private final SearchHelper searchHelper;
    private final JavaPsiFacade javaPsiFacade;
    private final EntityUtil entityUtil;

    public JpaEntitySearch(Project project) {
        super(project);
        this.project = project;
        this.searchHelper = SearchHelper.getInstance(project);
        this.javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        this.entityUtil = EntityUtil.getInstance(project);
    }

    public List<PsiClass> getChildEntities(String baseEntityFqn, EntitySearch.SearchScope searchScope, boolean checkDeep) {
        String keyValue = "EntitySearch#getChildEntities:" + baseEntityFqn + ":" + searchScope.name() + ":" + checkDeep;
        Key key = CacheKeyStore.getKeys(this.project, (UserDataHolder)this.project).get(keyValue);
        return (List)CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, key, () -> {
            ArrayList classes = new ArrayList();
            this.walkEntityClasses(JpaEntitySearch.getGlobalSearchScope(this.project, searchScope), (Processor<PsiClass>)((Processor)psiClass -> {
                PsiClass superClass = psiClass.getSuperClass();
                if (checkDeep || superClass != null && baseEntityFqn.equals(superClass.getQualifiedName())) {
                    classes.add(psiClass);
                }
                return true;
            }), baseEntityFqn);
            return CachedValueProvider.Result.create(classes, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    @Override
    public Collection<PsiClass> getProjectEntities() {
        return (Collection)CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, () -> {
            Collection<PsiClass> entities = this.getEntities(GlobalSearchScopesCore.projectProductionScope((Project)this.project));
            return CachedValueProvider.Result.create(entities, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Override
    public Collection<PsiClass> getBaseEntities() {
        return this.getEntities(ProjectScope.getLibrariesScope((Project)this.project));
    }

    @Override
    public Collection<PsiClass> getEntities(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JpaEntitySearch.$$$reportNull$$$0(0);
        }
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        SupportedLanguagesManager languagesManager = SupportedLanguagesManager.getInstance(this.project);
        this.walkEntityClasses(scope, (Processor<PsiClass>)((Processor)psiClass -> {
            if (languagesManager.isLanguageSupported(psiClass.getLanguage())) {
                classes.add((PsiClass)psiClass);
            }
            return true;
        }));
        return classes;
    }

    @Override
    public void walkProjectEntityClasses(Processor<PsiClass> processor) {
        this.walkEntityClasses(GlobalSearchScopesCore.projectProductionScope((Project)this.project), processor);
    }

    @Override
    public void walkEntityClasses(GlobalSearchScope scope, Processor<PsiClass> processor) {
        this.walkEntityClasses(scope, processor, null);
    }

    @Override
    public void walkEntityClasses(GlobalSearchScope scope, Processor<PsiClass> processor, @Nullable String baseEntityFqn) {
        EntityUtil.ra(() -> {
            try {
                this.getEntitiesQuery(scope, baseEntityFqn).forEach(processor);
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("Index not ready exception during entity search", (Throwable)e);
            }
        });
    }

    private void processEntities(String entityName, Processor<PsiClass> processor, GlobalSearchScope scope) {
        this.walkEntityClasses(scope, (Processor<PsiClass>)this.filterByEntityName(entityName, processor));
    }

    @NotNull
    private FilteringProcessor<PsiClass> filterByEntityName(String entityName, Processor<PsiClass> processor) {
        Condition condition = psiClass -> entityName.equals(this.entityUtil.getEntityName((PsiClass)psiClass));
        return new FilteringProcessor(condition, processor);
    }

    @Override
    @Contract(value="null, null -> null")
    @Nullable
    public PsiClass find(@Nullable String qualifiedName, @Nullable String entityName) {
        if (qualifiedName != null) {
            return this.findByQualifiedName(qualifiedName);
        }
        if (entityName != null) {
            return this.findByName(entityName);
        }
        return null;
    }

    @Override
    @Nullable
    public PsiClass findByQualifiedName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            JpaEntitySearch.$$$reportNull$$$0(1);
        }
        return (PsiClass)EntityUtil.ra(() -> {
            PsiClass theClass = this.searchHelper.findClass(qualifiedName);
            if (EntityUtil.isEntity(theClass)) {
                return theClass;
            }
            return null;
        });
    }

    @Override
    @Nullable
    public Entity findEntityByQualifiedName(@NotNull String qualifiedName) {
        PsiClass psiClass;
        if (qualifiedName == null) {
            JpaEntitySearch.$$$reportNull$$$0(2);
        }
        if ((psiClass = this.findByQualifiedName(qualifiedName)) == null) {
            return null;
        }
        return EntityPsi.getInstance(psiClass);
    }

    @Override
    @Nullable
    public PsiClass findByQualifiedName(String qualifiedName, GlobalSearchScope searchScope) {
        return (PsiClass)EntityUtil.ra(() -> {
            try {
                PsiClass theClass = this.javaPsiFacade.findClass(qualifiedName, searchScope);
                if (EntityUtil.isEntity(theClass)) {
                    return theClass;
                }
                return null;
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("Index not ready exception during entity search", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    @Nullable
    public PsiClass findByName(String entityName) {
        return this.findByName(entityName, GlobalSearchScope.allScope((Project)this.project));
    }

    @Override
    @Nullable
    public PsiClass findByName(String entityName, GlobalSearchScope globalSearchScope) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        return (PsiClass)EntityUtil.ra(() -> {
            try {
                this.processEntities(entityName, (Processor<PsiClass>)finder, globalSearchScope);
                return (PsiClass)finder.getFoundValue();
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("Index not ready exception during entity search", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    @Nullable
    public PsiClass getPropertyReferenceClass(PsiClass psiClass, String name) {
        return (PsiClass)EntityUtil.ra(() -> {
            String className = EntityUtil.getPropertyTypeName(psiClass, name);
            if (className == null) {
                return null;
            }
            return this.findByQualifiedName(className);
        });
    }

    @Override
    @Nullable
    public PsiClass findByClassName(String className, GlobalSearchScope globalSearchScope) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        return (PsiClass)EntityUtil.ra(() -> {
            try {
                this.walkEntityClasses(globalSearchScope, (Processor<PsiClass>)this.filterByEntityClassName(className, (Processor<PsiClass>)finder));
                return (PsiClass)finder.getFoundValue();
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("Index not ready exception during entity search", (Throwable)e);
                return null;
            }
        });
    }

    @NotNull
    private FilteringProcessor<PsiClass> filterByEntityClassName(String className, Processor<PsiClass> processor) {
        Condition condition = psiClass -> className.equals(psiClass.getName());
        return new FilteringProcessor(condition, processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/ed/JpaEntitySearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEntities";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findByQualifiedName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findEntityByQualifiedName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

