/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.jpa.jpb.model.core.util.JpbVfsUtil;
import com.intellij.jpa.jpb.model.ui.component.DirectoryWithBrowseField;
import com.intellij.jpa.jpb.model.ui.component.SourceRootField;
import com.intellij.jpa.jpb.model.ui.dialog.HDialogWrapper;
import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0007H\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010)\u001a\u00020\u00052\b\u0010*\u001a\u0004\u0018\u00010\u0007H&J\b\u0010+\u001a\u00020\u0005H&J\b\u0010,\u001a\u00020&H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\u0005H\u0017J\n\u0010.\u001a\u0004\u0018\u00010\u0007H\u0002J\u000f\u0010/\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b0H\u0004J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u000203H\u0014J\n\u00104\u001a\u0004\u0018\u00010$H\u0016J\b\u00105\u001a\u00020&H\u0014J\b\u00106\u001a\u0004\u0018\u00010\u0007J\n\u00107\u001a\u0004\u0018\u000108H\u0014J\u0014\u00109\u001a\u0004\u0018\u0001082\b\b\u0001\u0010-\u001a\u00020\u0005H\u0002J\b\u0010:\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006;"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/CreationSourceFileDialog;", "Lcom/intellij/jpa/jpb/model/ui/dialog/HDialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "directoryPath", "", "selectedResourcesDir", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "getPsiManager", "()Lcom/intellij/psi/PsiManager;", "suitableDestinationResourceRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceRootField", "Lcom/intellij/jpa/jpb/model/ui/component/SourceRootField;", "getSourceRootField", "()Lcom/intellij/jpa/jpb/model/ui/component/SourceRootField;", "setSourceRootField", "(Lcom/intellij/jpa/jpb/model/ui/component/SourceRootField;)V", "directoryField", "Lcom/intellij/jpa/jpb/model/ui/component/DirectoryWithBrowseField;", "getDirectoryField", "()Lcom/intellij/jpa/jpb/model/ui/component/DirectoryWithBrowseField;", "setDirectoryField", "(Lcom/intellij/jpa/jpb/model/ui/component/DirectoryWithBrowseField;)V", "fileNameField", "Lcom/intellij/ui/components/JBTextField;", "getFileNameField", "()Lcom/intellij/ui/components/JBTextField;", "setFileNameField", "(Lcom/intellij/ui/components/JBTextField;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "selectSourceRoot", "", "dirSourceRoot", "getLastSelectedDirectoryPath", "getInitFileName", "completedDirectory", "getFileExt", "saveSettings", "duplicateFileErrorMsg", "getCompletedDirectory", "getSelectedSourceRoot", "Lorg/jetbrains/annotations/NotNull;", "initFormBuilder", "formBuilder", "Lcom/intellij/util/ui/FormBuilder;", "getPreferredFocusedComponent", "doOKAction", "getDirectory", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "validateFileName", "getFileNameWithoutExt", "intellij.javaee.jpa.jpb.model"})
public abstract class CreationSourceFileDialog
extends HDialogWrapper {
    @NotNull
    private final String directoryPath;
    @Nullable
    private final PsiDirectory selectedResourcesDir;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final List<VirtualFile> suitableDestinationResourceRoots;
    protected SourceRootField sourceRootField;
    protected DirectoryWithBrowseField directoryField;
    protected JBTextField fileNameField;

    public CreationSourceFileDialog(@NotNull Project project, @NotNull String directoryPath, @Nullable PsiDirectory selectedResourcesDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        super(project);
        this.directoryPath = directoryPath;
        this.selectedResourcesDir = selectedResourcesDir;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
        List<VirtualFile> list = JpbVfsUtil.getAllSourceRoots(project, true);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSourceRoots(...)");
        this.suitableDestinationResourceRoots = list;
        this.init();
    }

    @NotNull
    protected final PsiManager getPsiManager() {
        return this.psiManager;
    }

    @NotNull
    protected final SourceRootField getSourceRootField() {
        SourceRootField sourceRootField = this.sourceRootField;
        if (sourceRootField != null) {
            return sourceRootField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sourceRootField");
        return null;
    }

    protected final void setSourceRootField(@NotNull SourceRootField sourceRootField) {
        Intrinsics.checkNotNullParameter((Object)((Object)sourceRootField), (String)"<set-?>");
        this.sourceRootField = sourceRootField;
    }

    @NotNull
    protected final DirectoryWithBrowseField getDirectoryField() {
        DirectoryWithBrowseField directoryWithBrowseField = this.directoryField;
        if (directoryWithBrowseField != null) {
            return directoryWithBrowseField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
        return null;
    }

    protected final void setDirectoryField(@NotNull DirectoryWithBrowseField directoryWithBrowseField) {
        Intrinsics.checkNotNullParameter((Object)((Object)directoryWithBrowseField), (String)"<set-?>");
        this.directoryField = directoryWithBrowseField;
    }

    @NotNull
    protected final JBTextField getFileNameField() {
        JBTextField jBTextField = this.fileNameField;
        if (jBTextField != null) {
            return jBTextField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fileNameField");
        return null;
    }

    protected final void setFileNameField(@NotNull JBTextField jBTextField) {
        Intrinsics.checkNotNullParameter((Object)jBTextField, (String)"<set-?>");
        this.fileNameField = jBTextField;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        CharSequence relativePath;
        CharSequence charSequence;
        VirtualFile sourceRoot;
        PsiDirectory completedDirectory = this.getCompletedDirectory();
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.setSourceRootField(new SourceRootField(project, this.suitableDestinationResourceRoots, completedDirectory));
        PsiDirectory psiDirectory = completedDirectory;
        PsiDirectory dirSourceRoot = psiDirectory != null ? HPsiUtil.getSourceRoot((PsiElement)psiDirectory) : null;
        String defaultDirectoryPath = this.directoryPath;
        if (dirSourceRoot == null && (sourceRoot = JpbVfsUtil.findSourceRoot(defaultDirectoryPath, this.project, true)) != null) {
            dirSourceRoot = PsiManager.getInstance((Project)this.project).findDirectory(sourceRoot);
        }
        if (dirSourceRoot != null) {
            this.selectSourceRoot(dirSourceRoot);
        }
        sourceRoot = this.project;
        this.setDirectoryField(new DirectoryWithBrowseField(this, (Project)sourceRoot){
            final /* synthetic */ CreationSourceFileDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public VirtualFile getRootDirectory() {
                VirtualFile virtualFile = this.this$0.getSelectedSourceRoot();
                if (virtualFile == null) {
                    throw new IllegalStateException("Source root not found");
                }
                return virtualFile;
            }
        });
        CharSequence lastSelectedDirectory = this.getLastSelectedDirectoryPath();
        if (completedDirectory != null && !((charSequence = (relativePath = JpbVfsUtil.getRelativePathToSourceRoot(this.project, completedDirectory.getVirtualFile(), null))) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            lastSelectedDirectory = relativePath;
        }
        if (!((relativePath = (CharSequence)lastSelectedDirectory) == null || StringsKt.isBlank((CharSequence)relativePath)) && completedDirectory != null) {
            this.getDirectoryField().setText((String)lastSelectedDirectory);
        } else if (dirSourceRoot != null) {
            this.getDirectoryField().setText(((Object)Paths.get(dirSourceRoot.getVirtualFile().getPath(), new String[0]).relativize(Paths.get(defaultDirectoryPath, new String[0]))).toString());
        }
        this.setFileNameField(new JBTextField());
        this.getFileNameField().setText(this.getInitFileName(completedDirectory));
        FormBuilder formBuilder = FormBuilder.createFormBuilder();
        Intrinsics.checkNotNull((Object)formBuilder);
        this.initFormBuilder(formBuilder);
        return formBuilder.getPanel();
    }

    private final void selectSourceRoot(PsiDirectory dirSourceRoot) {
        int n = this.getSourceRootField().getItemCount();
        for (int i = 0; i < n; ++i) {
            DirectoryChooser.ItemWrapper item;
            if ((DirectoryChooser.ItemWrapper)this.getSourceRootField().getItemAt(i) == null || !Intrinsics.areEqual((Object)item.getDirectory(), (Object)dirSourceRoot)) continue;
            this.getSourceRootField().setSelectedItem(item);
            break;
        }
    }

    @Nullable
    public abstract String getLastSelectedDirectoryPath();

    @NotNull
    public abstract String getInitFileName(@Nullable PsiDirectory var1);

    @NotNull
    public abstract String getFileExt();

    public void saveSettings() {
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String duplicateFileErrorMsg() {
        return null;
    }

    private final PsiDirectory getCompletedDirectory() {
        PsiDirectory psiDirectory;
        if (this.selectedResourcesDir != null) {
            return this.selectedResourcesDir;
        }
        VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(this.directoryPath, new String[0]), (boolean)true);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiDirectory = this.psiManager.findDirectory(it);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    @Nullable
    protected final VirtualFile getSelectedSourceRoot() {
        PsiDirectory psiDirectory = this.getSourceRootField().getSelectedDirectory();
        return psiDirectory != null ? psiDirectory.getVirtualFile() : null;
    }

    protected void initFormBuilder(@NotNull FormBuilder formBuilder) {
        Intrinsics.checkNotNullParameter((Object)formBuilder, (String)"formBuilder");
        formBuilder.addLabeledComponent(JpaModelBundle.messageWithColon("source.root", new Object[0]), (JComponent)((Object)this.getSourceRootField())).addLabeledComponent(JpaModelBundle.messageWithColon("directory", new Object[0]), (JComponent)((Object)this.getDirectoryField())).addLabeledComponent(JpaModelBundle.messageWithColon("file.name", new Object[0]), (JComponent)this.getFileNameField());
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.selectedResourcesDir == null ? (JComponent)((Object)this.getDirectoryField()) : (JComponent)this.getFileNameField();
    }

    @Override
    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.close(0);
        }
    }

    @Nullable
    public final PsiDirectory getDirectory() {
        String directoryPath = this.getDirectoryField().getDirectory();
        String string = FileUtil.toSystemIndependentName((String)directoryPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String path = string;
        return (PsiDirectory)WriteAction.compute(() -> CreationSourceFileDialog.getDirectory$lambda$0(this, path));
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String string = this.getFileNameField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            Object[] objectArray = new Object[]{JpaModelBundle.message("file.name", new Object[0])};
            return new ValidationInfo(JpaModelBundle.message("field.required", objectArray), (JComponent)this.getFileNameField());
        }
        String string2 = this.duplicateFileErrorMsg();
        if (string2 == null) {
            return null;
        }
        String duplicateFileErrorMsg = string2;
        return this.validateFileName(duplicateFileErrorMsg);
    }

    private final ValidationInfo validateFileName(@NlsContexts.DialogMessage String duplicateFileErrorMsg) {
        String[] stringArray = new String[]{this.getFileNameWithoutExt() + "." + this.getFileExt()};
        Path changeLogPath = Paths.get(this.getDirectoryField().getDirectory(), stringArray);
        return Files.exists(changeLogPath, new LinkOption[0]) ? new ValidationInfo(duplicateFileErrorMsg, (JComponent)this.getFileNameField()) : null;
    }

    @NotNull
    public String getFileNameWithoutExt() {
        String fileName;
        String string = fileName = this.getFileNameField().getText();
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.endsWith$default((String)string, (String)("." + this.getFileExt()), (boolean)false, (int)2, null)) {
            fileName = StringUtil.substringBefore((String)fileName, (String)("." + this.getFileExt()));
        }
        string = fileName;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final PsiDirectory getDirectory$lambda$0(CreationSourceFileDialog this$0, String $path) {
        try {
            return DirectoryUtil.mkdirs((PsiManager)this$0.psiManager, (String)$path);
        }
        catch (IncorrectOperationException e) {
            Object[] objectArray = new Object[]{$path};
            HNotificationManager.getInstance(this$0.project).showNotification(JpaModelBundle.message("notification.content.exception.during.create.directory", objectArray));
            return null;
        }
    }
}

