/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamingUtil {
    public static final Pattern NON_WORD_CHAR_PATTERN = Pattern.compile("\\W");
    public static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");

    public static String divideWordsBySpaces(String className) {
        return NamingUtil.replaceWords(className, false, false, " ");
    }

    public static String divideWordsBy(String className, String symbol) {
        return NamingUtil.replaceWords(className, true, false, symbol);
    }

    public static String createPropertyDescription(String property) {
        return NamingUtil.replaceWords(property, false, true, " ");
    }

    public static String decapitalFirst(String className) {
        if (className.isEmpty()) {
            return className;
        }
        return Character.toLowerCase(className.charAt(0)) + className.substring(1);
    }

    public static String replaceWords(String str, boolean decapital, boolean capitalFirst, String replacing) {
        StringBuilder sb = new StringBuilder(str);
        int i = 0;
        while (i < sb.length()) {
            while (++i < sb.length() && !Character.isUpperCase(sb.charAt(i))) {
            }
            if (i >= sb.length()) continue;
            sb.replace(i, i + 1, replacing + sb.charAt(i));
            i += 2;
        }
        Object res = sb.toString();
        if (decapital) {
            res = ((String)res).toLowerCase();
        }
        if (capitalFirst) {
            res = Character.toUpperCase(sb.charAt(0)) + ((String)res).substring(1);
        }
        return res;
    }

    public static String removeBrackets(String source2) {
        return source2.replace("[", "").replace("]", "");
    }

    public static String convertEnumLabel(String fieldName) {
        return StringUtil.capitalizeWords((String)fieldName.toLowerCase().replace('_', ' '), (boolean)true);
    }

    public static String entityNameToTableName(String entityName) {
        entityName = entityName.replace("$", "").replace("_", "");
        entityName = NamingUtil.divideWordsBy(entityName, "_");
        return entityName.toUpperCase();
    }

    public static String propertyToColumnName(String name) {
        return NamingUtil.divideWordsBy(name, "_").toUpperCase();
    }

    public static String normalizePath(String path) {
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    public static String convertToPackageName(String path) {
        String packageName = path.replace('/', '.');
        if (packageName.startsWith(".")) {
            return packageName.substring(1);
        }
        return packageName;
    }

    @NlsSafe
    public static String getShortClassName(String className) {
        if (className == null) {
            return null;
        }
        int position = className.lastIndexOf(46);
        return className.substring(position + 1);
    }

    @Nullable
    public static String methodNameToPropertyName(String methodName) {
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return null;
    }

    @NotNull
    public static String[] splitListOfFiles(@Nullable String list) {
        String[] stringArray = StringUtils.isBlank((CharSequence)list) ? ArrayUtilRt.EMPTY_STRING_ARRAY : SPACE_PATTERN.split(list.trim());
        if (stringArray == null) {
            NamingUtil.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public static String convertToJavaIdentifier(@NotNull String value, PsiNameHelper nameHelper) {
        if (value == null) {
            NamingUtil.$$$reportNull$$$0(1);
        }
        String[] split = NON_WORD_CHAR_PATTERN.split(value);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (s.isEmpty()) continue;
            if (i == 0) {
                result.append(s);
                continue;
            }
            char firstChar = s.charAt(0);
            if (firstChar == '_') continue;
            result.append(Character.toUpperCase(firstChar)).append(s.substring(1));
        }
        String str = result.toString();
        return nameHelper.isIdentifier(str) ? str : "_" + str;
    }

    @Contract(value="null -> null")
    @Nullable
    public static String fromAdditiveProperty(@Nullable String property) {
        if (property == null) {
            return null;
        }
        if (property.startsWith("+")) {
            return property.substring(1).trim();
        }
        return property;
    }

    public static String concatPackageNames(String packageName, String subName) {
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            return subName;
        }
        return packageName + "." + subName;
    }

    public static String concatPackageWithClass(@Nullable String packageName, String className) {
        return NamingUtil.concatPackageNames(packageName, className);
    }

    public static String getPackageName(String classFqn) {
        int position = classFqn.lastIndexOf(46);
        if (position == -1) {
            return "";
        }
        return classFqn.substring(0, position);
    }

    @NotNull
    public static String getUniqueClassNameInPackage(@NotNull String className, @NotNull PsiPackage classPackage, GlobalSearchScope globalSearchScope) {
        if (className == null) {
            NamingUtil.$$$reportNull$$$0(2);
        }
        if (classPackage == null) {
            NamingUtil.$$$reportNull$$$0(3);
        }
        PsiClass[] foundClasses = classPackage.findClassByShortName(className, globalSearchScope);
        int idxClassName = 1;
        Object finalClassName = className;
        while (foundClasses.length > 0) {
            finalClassName = className + idxClassName++;
            foundClasses = classPackage.findClassByShortName((String)finalClassName, globalSearchScope);
        }
        if (!((String)finalClassName).equals(className)) {
            Object object = finalClassName;
            if (object == null) {
                NamingUtil.$$$reportNull$$$0(4);
            }
            return object;
        }
        String string = className;
        if (string == null) {
            NamingUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static String getEntityNameForProjectionName(Project project, String projectionName) {
        Pattern projectionNamePattern = Pattern.compile(JpaPluginProjectConfig.getInstance((Project)project).getState().projectionNamePatternRegexp);
        Matcher matcher = projectionNamePattern.matcher(projectionName);
        if (matcher.matches()) {
            return matcher.group("entity");
        }
        return null;
    }

    @Nullable
    public static String getEntityNameForDtoName(Project project, String projectionName) {
        Pattern dtoNamePattern = Pattern.compile(JpaPluginProjectConfig.getInstance((Project)project).getState().dtoNamePatternRegexp);
        Matcher matcher = dtoNamePattern.matcher(projectionName);
        if (matcher.matches()) {
            return matcher.group("entity");
        }
        return null;
    }

    @NotNull
    public static String generateUniqueName(@NotNull String defaultName, String ... existingNames) {
        if (defaultName == null) {
            NamingUtil.$$$reportNull$$$0(6);
        }
        if (existingNames == null) {
            NamingUtil.$$$reportNull$$$0(7);
        }
        if (existingNames.length == 0 || !Arrays.asList(existingNames).contains(defaultName)) {
            String string = defaultName;
            if (string == null) {
                NamingUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        int i = 1;
        String name = defaultName + i++;
        while (Arrays.asList(existingNames).contains(name)) {
            name = defaultName + i++;
        }
        String string = name;
        if (string == null) {
            NamingUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/util/NamingUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPackage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "splitListOfFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/util/NamingUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueClassNameInPackage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertToJavaIdentifier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueClassNameInPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

