/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.JdbcPlaceholder;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.MultiPredicateValue;
import com.intellij.database.data.types.NotEqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.ObjectPredicateValue;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.ValueWrapper;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.DatabaseFormatterCreator;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0003\u001aX\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a,\u0010\u0004\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001aN\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\f\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u0007\u001a2\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0007\u001a\n\u0010\"\u001a\u00020#*\u00020\u0003\u001a\f\u0010$\u001a\u0004\u0018\u00010%*\u00020\u0003\u001a\f\u0010&\u001a\u0004\u0018\u00010'*\u00020\u0003\u001a\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0012\u001a\u00020\u0003\u001a\u001a\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070/\u001a \u00100\u001a\u0004\u0018\u00010-2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u00101\u001a\u000202\"\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"defaultEqualsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "quote", "", "dbms", "Lcom/intellij/database/Dbms;", "alias", "", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "valueWrapper", "Lcom/intellij/database/data/types/ValueWrapper;", "identifier", "Lcom/intellij/database/util/DdlBuilder;", "columnRef", "composeWhereItem", "builder", "decorator", "Lcom/intellij/database/util/DbImplUtilCore$StringLiteralDecorator;", "likeWord", "defaultLikePredicate", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "version", "Lcom/intellij/database/util/Version;", "inUpdate", "getLikeKeyword", "matchCase", "isNotLike", "toGridColumn", "Lcom/intellij/database/datagrid/GridColumn;", "toDasColumn", "Lcom/intellij/database/model/DasColumn;", "toBasicColumn", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "formatter", "Lcom/intellij/database/extractors/DbObjectFormatter;", "getDescriptor", "Lcom/intellij/database/datagrid/mutating/ColumnDescriptor;", "simpleFormat", "Lcom/intellij/database/data/types/FormatTester;", "test", "Lkotlin/Function1;", "getFormatTester", "logicType", "Lcom/intellij/database/data/types/LogicalType;", "intellij.database.core.impl"})
public final class PredicatesUtilKt {
    @NotNull
    private static final DbObjectFormatter formatter = new DbObjectFormatter(Dbms.UNKNOWN);

    @NotNull
    public static final PredicatesHelper.PredicateProducer defaultEqualsPredicate(@NotNull ColumnRef column, @NotNull PredicateValue value, boolean quote, @NotNull Dbms dbms, @Nullable String alias, @NotNull ComparePredicateOperation op, @Nullable ValueWrapper valueWrapper) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column), value, op, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> PredicatesUtilKt.defaultEqualsPredicate$lambda$0(dbms, column, value, quote, alias, op, valueWrapper, arg_0)));
    }

    @NotNull
    public static final DdlBuilder identifier(@NotNull DdlBuilder $this$identifier, @Nullable String alias, @NotNull ColumnRef columnRef) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$identifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        if (columnRef instanceof DasColumnRef) {
            if (alias != null) {
                $this$identifier.alias(alias).symbol(".");
            }
            DdlBuilder ddlBuilder2 = $this$identifier.identifier((DasObject)((DasColumnRef)columnRef).getCol());
            Intrinsics.checkNotNull((Object)ddlBuilder2);
            ddlBuilder = ddlBuilder2;
        } else if (columnRef instanceof ConsumerColumnRef && GridUtilCore.isRowId((GridColumn)((ConsumerColumnRef)columnRef).getCol())) {
            DdlBuilder ddlBuilder3 = $this$identifier.plain(((ConsumerColumnRef)columnRef).getName());
            Intrinsics.checkNotNull((Object)ddlBuilder3);
            ddlBuilder = ddlBuilder3;
        } else {
            if (alias != null) {
                $this$identifier.alias(alias).symbol(".");
            }
            DdlBuilder ddlBuilder4 = $this$identifier.identifier(columnRef.getName());
            Intrinsics.checkNotNull((Object)ddlBuilder4);
            ddlBuilder = ddlBuilder4;
        }
        return ddlBuilder;
    }

    private static final DdlBuilder composeWhereItem(DdlBuilder builder, Dbms dbms, ColumnRef column, PredicateValue value, DbImplUtilCore.StringLiteralDecorator decorator, String likeWord, String alias, ComparePredicateOperation op, ValueWrapper valueWrapper) {
        PredicatesUtilKt.identifier(builder, alias, column).space();
        PredicateValue predicateValue = value;
        if (Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) {
            ComparePredicateOperation comparePredicateOperation = op;
            if (comparePredicateOperation instanceof EqualsPredicateOperation) {
                String[] stringArray = new String[]{"IS", "NULL"};
                DdlBuilder ddlBuilder = builder.keywords(stringArray);
                v1 = ddlBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"keywords(...)");
            } else if (comparePredicateOperation instanceof NotEqualsPredicateOperation) {
                String[] stringArray = new String[]{"IS", "NOT", "NULL"};
                DdlBuilder ddlBuilder = builder.keywords(stringArray);
                v1 = ddlBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"keywords(...)");
            } else {
                v1 = Unit.INSTANCE;
            }
        } else if (predicateValue instanceof MultiPredicateValue) {
            builder.keyword("IN").space().symbol("(");
            boolean first2 = true;
            for (PredicateValue v : ((MultiPredicateValue)value).getValues()) {
                if (first2) {
                    first2 = false;
                    v3 = Unit.INSTANCE;
                } else {
                    DdlBuilder ddlBuilder = builder.symbol(",").space();
                    v3 = ddlBuilder;
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
                }
                if (valueWrapper != null) {
                    valueWrapper.getBefore().invoke((Object)builder);
                }
                PredicatesUtilKt.value(builder, v, column, dbms, decorator);
                if (valueWrapper == null) continue;
                valueWrapper.getAfter().invoke((Object)builder);
            }
            DdlBuilder ddlBuilder = builder.symbol(")");
            Intrinsics.checkNotNull((Object)ddlBuilder);
            v1 = ddlBuilder;
        } else {
            String string = likeWord;
            DdlBuilder ddlBuilder = string != null ? builder.keyword(string).space() : builder.symbol(op.getOperator()).space();
            if (valueWrapper != null) {
                valueWrapper.getBefore().invoke((Object)builder);
            }
            PredicatesUtilKt.value(builder, value, column, dbms, decorator);
            if (valueWrapper != null) {
                valueWrapper.getAfter().invoke((Object)builder);
            }
            v1 = Unit.INSTANCE;
        }
        return builder;
    }

    @NotNull
    public static final DdlBuilder value(@NotNull DdlBuilder $this$value, @NotNull PredicateValue value, @NotNull ColumnRef columnRef, @NotNull Dbms dbms, @Nullable DbImplUtilCore.StringLiteralDecorator decorator) {
        Intrinsics.checkNotNullParameter((Object)$this$value, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        PredicateValue predicateValue = value;
        if (Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) {
            $this$value.placeholder();
            if (decorator != null && decorator != DbImplUtilCore.StringLiteralDecorator.PLAIN) {
                boolean supportsEscape = DbImplUtilCore.getJdbcHelper(dbms).supportsEscape();
                DbSqlUtilCore.SqlRegexDecorator sqlRegexDecorator = supportsEscape ? DbSqlUtilCore.SqlRegexDecorator.WITH_ESCAPE_CLAUSE : DbSqlUtilCore.SqlRegexDecorator.DEFAULT;
                $this$value.plain(sqlRegexDecorator.getTail(dbms));
            }
        } else if (predicateValue instanceof CustomPlaceholder) {
            DdlBuilder ddlBuilder = $this$value.plain(((CustomPlaceholder)value).getPlaceholder());
            Intrinsics.checkNotNull((Object)ddlBuilder);
        } else if (predicateValue instanceof StringPredicateValue) {
            Object object = decorator;
            if (object == null || (object = object.decorate(((StringPredicateValue)value).getStr(), dbms)) == null) {
                object = ((StringPredicateValue)value).getStr();
            }
            DdlBuilder ddlBuilder = $this$value.literal((String)object);
            Intrinsics.checkNotNull((Object)ddlBuilder);
        } else if (predicateValue instanceof ObjectPredicateValue) {
            DdlBuilder ddlBuilder;
            String literal = formatter.objectToString(((ObjectPredicateValue)value).getO(), PredicatesUtilKt.toGridColumn(columnRef), DatabaseObjectFormatterConfig.get((ObjectFormatterMode)PredicatesHelperKt.predicatesHelper(dbms).getMode()));
            if (literal == null) {
                ddlBuilder = $this$value.literal("null");
            } else {
                Object object = decorator;
                if (object == null || (object = object.decorate(literal, dbms)) == null) {
                    object = literal;
                }
                ddlBuilder = $this$value.literal((String)object);
            }
            DdlBuilder ddlBuilder2 = ddlBuilder;
            Intrinsics.checkNotNull((Object)ddlBuilder2);
        }
        return $this$value;
    }

    @Nullable
    public static final PredicatesHelper.PredicateProducer defaultLikePredicate(@NotNull ColumnRef column, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, @NotNull Dbms dbms, @Nullable Version version, @Nullable String alias, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        if (domain != null && !domain.supports(OperationKt.LIKE_OPERATION)) {
            return null;
        }
        if (!(domain != null || column instanceof ConsumerColumnRef && ObjectFormatterUtil.isStringType((int)((ConsumerColumnRef)column).getCol().getType()))) {
            return null;
        }
        if (Intrinsics.areEqual((Object)value, (Object)NullPredicateValue.INSTANCE) || value instanceof ObjectPredicateValue) {
            return null;
        }
        String string = PredicatesUtilKt.getLikeKeyword(op.getMatchCase(), op.isNotLike(), dbms, version, inUpdate);
        if (string == null) {
            return null;
        }
        String likeWord = string;
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column), value, op, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> PredicatesUtilKt.defaultLikePredicate$lambda$0(dbms, column, value, op, likeWord, alias, arg_0)));
    }

    @Nullable
    public static final String getLikeKeyword(boolean matchCase, boolean isNotLike, @NotNull Dbms dbms, @Nullable Version version, boolean inUpdate) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        boolean supportsLike = DbImplUtilCore.getDatabaseDialect(dbms).getLikeSupport(version).isSupported(inUpdate);
        if (!matchCase && supportsLike && DbImplUtilCore.getJdbcHelper(dbms).supportsIlike()) {
            string = "ILIKE";
        } else if (supportsLike) {
            string = "LIKE";
        } else {
            return null;
        }
        String like = string;
        return isNotLike ? "NOT " + like : like;
    }

    @NotNull
    public static final GridColumn toGridColumn(@NotNull ColumnRef $this$toGridColumn) {
        GridColumn gridColumn;
        Intrinsics.checkNotNullParameter((Object)$this$toGridColumn, (String)"<this>");
        ColumnRef columnRef = $this$toGridColumn;
        if (columnRef instanceof ConsumerColumnRef) {
            gridColumn = ((ConsumerColumnRef)$this$toGridColumn).getCol();
        } else if (columnRef instanceof DasColumnRef) {
            DasColumn column = ((DasColumnRef)$this$toGridColumn).getCol();
            DataType dataType = column.getDasType().toDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
            DataType dataType2 = dataType;
            gridColumn = (GridColumn)new DataConsumer.Column((int)column.getPosition(), column.getName(), 1111, dataType2.typeName, "", dataType2.getPrecision(), dataType2.scale, null, null, null);
        } else {
            gridColumn = (GridColumn)new DataConsumer.Column(0, $this$toGridColumn.getName(), 1111, $this$toGridColumn.getTypeName(), "");
        }
        return gridColumn;
    }

    @Nullable
    public static final DasColumn toDasColumn(@NotNull ColumnRef $this$toDasColumn) {
        Intrinsics.checkNotNullParameter((Object)$this$toDasColumn, (String)"<this>");
        ColumnRef columnRef = $this$toDasColumn;
        return columnRef instanceof ConsumerColumnRef ? (DasColumn)DasUtil.findChild((DasObject)((ConsumerColumnRef)$this$toDasColumn).getTable(), DasColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)((ConsumerColumnRef)$this$toDasColumn).getName()) : (columnRef instanceof DasColumnRef ? ((DasColumnRef)$this$toDasColumn).getCol() : null);
    }

    @Nullable
    public static final BasicTableOrViewColumn toBasicColumn(@NotNull ColumnRef $this$toBasicColumn) {
        Intrinsics.checkNotNullParameter((Object)$this$toBasicColumn, (String)"<this>");
        DasColumn dasColumn = PredicatesUtilKt.toDasColumn($this$toBasicColumn);
        Object object = DbImplUtilCore.unwrap((DasObject)dasColumn);
        return object instanceof BasicTableOrViewColumn ? (BasicTableOrViewColumn)object : null;
    }

    @Nullable
    public static final ColumnDescriptor getDescriptor(@NotNull ColumnRef columnRef) {
        ColumnDescriptor columnDescriptor;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        ColumnRef columnRef2 = columnRef;
        if (columnRef2 instanceof DasColumnRef) {
            DasType dasType = ((DasColumnRef)columnRef).getCol().getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            columnDescriptor = new TypeNameColumnDescriptor(DasTypeUtilsKt.getTypeName(dasType));
        } else {
            columnDescriptor = columnRef2 instanceof ConsumerColumnRef ? (ColumnDescriptor)((ConsumerColumnRef)columnRef).getCol() : null;
        }
        return columnDescriptor;
    }

    @NotNull
    public static final FormatTester simpleFormat(@NotNull Function1<? super String, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        return new FormatTester(true, false, arg_0 -> PredicatesUtilKt.simpleFormat$lambda$0(test, arg_0), 2, null);
    }

    @Nullable
    public static final FormatTester getFormatTester(@NotNull ColumnRef columnRef, @NotNull Dbms dbms, @NotNull LogicalType logicType) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)logicType, (String)"logicType");
        GridColumn col = PredicatesUtilKt.toGridColumn(columnRef);
        switch (WhenMappings.$EnumSwitchMapping$0[logicType.ordinal()]) {
            case 1: 
            case 2: {
                return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)PredicatesUtilKt::getFormatTester$lambda$0));
            }
            case 3: {
                return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)PredicatesUtilKt::getFormatTester$lambda$1));
            }
            case 4: {
                return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)PredicatesUtilKt::getFormatTester$lambda$2));
            }
            case 5: {
                return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)PredicatesUtilKt::getFormatTester$lambda$3));
            }
        }
        Formatter formatter = switch (WhenMappings.$EnumSwitchMapping$0[logicType.ordinal()]) {
            case 6 -> (Formatter)new DatabaseFormatterCreator(dbms).create(FormatterCreator.getZonedTimeKey((GridColumn)col, null, (FormatsCache)new FormatsCache()));
            case 7 -> (Formatter)new DatabaseFormatterCreator(dbms).create(FormatterCreator.getZonedTimestampKey((GridColumn)col, null, (FormatsCache)new FormatsCache()));
            case 8 -> (Formatter)new DatabaseFormatterCreator(dbms).create(FormatterCreator.getTimestampKey((GridColumn)col, null, (FormatsCache)new FormatsCache()));
            case 9 -> (Formatter)new DatabaseFormatterCreator(dbms).create(FormatterCreator.getTimeKey((GridColumn)col, null, (FormatsCache)new FormatsCache()));
            case 10 -> (Formatter)new DatabaseFormatterCreator(dbms).create(FormatterCreator.getDateKey((GridColumn)col, null, (FormatsCache)new FormatsCache()));
            default -> null;
        };
        if (formatter == null) {
            return null;
        }
        Formatter format = formatter;
        return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)arg_0 -> PredicatesUtilKt.getFormatTester$lambda$4(format, arg_0)));
    }

    private static final Unit defaultEqualsPredicate$lambda$0(Dbms $dbms, ColumnRef $column, PredicateValue $value, boolean $quote, String $alias, ComparePredicateOperation $op, ValueWrapper $valueWrapper, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PredicatesUtilKt.composeWhereItem(builder, $dbms, $column, $value, $quote ? DbImplUtilCore.StringLiteralDecorator.PLAIN : null, null, $alias, $op, $valueWrapper);
        return Unit.INSTANCE;
    }

    private static final Unit defaultLikePredicate$lambda$0(Dbms $dbms, ColumnRef $column, PredicateValue $value, LikePredicateOperation $op, String $likeWord, String $alias, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PredicatesUtilKt.composeWhereItem(builder, $dbms, $column, $value, $op.getLikeType().getDecorator(), $likeWord, $alias, new EqualsPredicateOperation(null, 1, null), null);
        return Unit.INSTANCE;
    }

    private static final FormatTestResult simpleFormat$lambda$0(Function1 $test, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$test.invoke((Object)it) != false ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
    }

    private static final boolean getFormatTester$lambda$0(String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            bl = UUID.fromString(value) != null;
        }
        catch (IllegalArgumentException e) {
            bl = false;
        }
        return bl;
    }

    private static final boolean getFormatTester$lambda$1(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return StringUtil.equalsIgnoreCase((CharSequence)value, (CharSequence)"true") || StringUtil.equalsIgnoreCase((CharSequence)value, (CharSequence)"false");
    }

    private static final boolean getFormatTester$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final boolean getFormatTester$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JsonUtilKt.isJsonString((String)it);
    }

    private static final boolean getFormatTester$lambda$4(Formatter $format, String it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            bl = $format.parse(it) != null;
        }
        catch (ParseException ignored) {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogicalType.values().length];
            try {
                nArray[LogicalType.UUID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.TEXT_UUID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.BOOLEAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.GEOMETRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.JSON.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.TIME_WITH_TIMEZONE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.TIMESTAMP_WITH_TIMEZONE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.TIME.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.DATE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

