/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public final class DatabaseDriverManagerUtil {
    public static final String DRIVER_DIR = "jdbc-drivers";
    public static final String PROPERTY_DRIVER_PATH = "datagrip.driver.path";
    @Nullable
    private static String ourDownloadPath;

    @Nullable
    public static File existentTestPath(String file) {
        Application application = ApplicationManager.getApplication();
        if (application == null || !application.isInternal() || application.isUnitTestMode() && file.endsWith("test-database-drivers.xml")) {
            return null;
        }
        File testFile = new File(PathManager.getHomePath() + "/dbe/database/testResources/" + file);
        if (testFile.exists()) {
            return testFile;
        }
        testFile = new File(PathManager.getConfigPath() + "/options/" + file);
        if (testFile.exists()) {
            return testFile;
        }
        return null;
    }

    @NotNull
    public static @SystemDependent String getDownloadPath() {
        if (ourDownloadPath == null) {
            String propertyValue = System.getProperty(PROPERTY_DRIVER_PATH);
            ourDownloadPath = propertyValue != null ? PathManager.getAbsolutePath((String)StringUtil.unquoteString((String)propertyValue, (char)'\"')) : PathManager.getConfigPath() + File.separator + DRIVER_DIR;
        }
        String string = ourDownloadPath;
        if (string == null) {
            DatabaseDriverManagerUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DatabaseDriverManagerUtil", "getDownloadPath"));
    }
}

