/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbConsoleRootTypeCore;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbVFSUtils {
    @Deprecated(since="2025.3", forRemoval=true)
    @Nullable
    public abstract VirtualFile getConsoleVirtualFile(@NotNull DasDataSource var1);

    @Nullable
    public abstract VirtualFile getQueryVirtualFile(@NotNull Project var1, @NotNull LocalDataSource var2);

    public abstract boolean isJSAttachedToMongo(@NotNull Project var1, @NotNull VirtualFile var2);

    public abstract boolean isStoredInQueryFolder(@NotNull VirtualFile var1, @NotNull Project var2);

    public static DbVFSUtils getInstance() {
        return (DbVFSUtils)ApplicationManager.getApplication().getService(DbVFSUtils.class);
    }

    public static boolean isConsoleFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return !QueryFilesUtilsKt.isQueryFilesFlagEnabled() && ScratchFileService.findRootType((VirtualFile)file) instanceof DbConsoleRootTypeCore;
    }

    @Nullable
    public static VirtualFile getDataSourceRoot(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DbVFSUtils.$$$reportNull$$$0(0);
        }
        ScratchFileService service = ScratchFileService.getInstance();
        VirtualFile o1 = null;
        VirtualFile o2 = null;
        for (VirtualFile o = virtualFile; o != null; o = o.getParent()) {
            if (!(service.getRootType(o) instanceof DbConsoleRootTypeCore)) {
                return o2;
            }
            o2 = o1;
            o1 = o;
        }
        return null;
    }

    @Nullable
    public static DbDataSource getDataSource(@NotNull Project project, @NotNull VirtualFile original) {
        String uuid;
        if (project == null) {
            DbVFSUtils.$$$reportNull$$$0(1);
        }
        if (original == null) {
            DbVFSUtils.$$$reportNull$$$0(2);
        }
        return (uuid = DbVFSUtils.getDataSourceId(original)) == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(uuid);
    }

    @Nullable
    public static String getDataSourceId(@NotNull VirtualFile original) {
        VirtualFile rootDir;
        if (original == null) {
            DbVFSUtils.$$$reportNull$$$0(3);
        }
        if ((rootDir = DbVFSUtils.getDataSourceRoot(original)) == null) {
            return null;
        }
        String name = rootDir.isDirectory() ? rootDir.getName() : rootDir.getNameWithoutExtension();
        return name.substring(0, Math.min(36, name.length()));
    }

    public static boolean isMongo(@NotNull Project project, @NotNull VirtualFile file) {
        DbDataSource dataSource;
        if (project == null) {
            DbVFSUtils.$$$reportNull$$$0(4);
        }
        if (file == null) {
            DbVFSUtils.$$$reportNull$$$0(5);
        }
        return (dataSource = DbVFSUtils.getDataSource(project, file)) != null && dataSource.getDbms().isMongo();
    }

    @Deprecated(forRemoval=true)
    public static boolean isAssociatedWithDataSource(@NotNull VirtualFile file) {
        if (file == null) {
            DbVFSUtils.$$$reportNull$$$0(6);
        }
        return DbVFSUtils.isConsoleFile(file) || DbVFSUtils.isAssociatedWithDataSourceAndSchema(file);
    }

    public static boolean isAssociatedWithDataSource(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            DbVFSUtils.$$$reportNull$$$0(7);
        }
        if (project == null) {
            DbVFSUtils.$$$reportNull$$$0(8);
        }
        return !QueryFilesUtilsKt.isQueryFilesFlagEnabled() && (DbVFSUtils.isConsoleFile(file) || DbVFSUtils.isAssociatedWithDataSourceAndSchema(file));
    }

    public static boolean isAssociatedWithDataSourceAndSchema(@NotNull VirtualFile file) {
        if (file == null) {
            DbVFSUtils.$$$reportNull$$$0(9);
        }
        return DbSrcUtilsCore.isDbSrcFile(file) || file instanceof DatabaseElementVirtualFileImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vfs/DbVFSUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataSourceRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataSourceId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMongo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssociatedWithDataSource";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssociatedWithDataSourceAndSchema";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

