/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.snapshot;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.snapshot.JestUpdateSnapshotHyperlinkInfo;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class JestSnapshotEventsListener
extends SMTRunnerEventsAdapter {
    private static final Logger LOG = Logger.getInstance(JestSnapshotEventsListener.class);
    private static final String FILE_SCHEME = "file://";
    public static final List<@NlsSafe String> EXTERNAL_SNAPSHOT_METHOD_NAMES = List.of("toMatchSnapshot", "toThrowErrorMatchingSnapshot");
    private static final List<@NlsSafe String> ALL_SNAPSHOT_METHOD_NAMES = List.copyOf(ContainerUtil.concat(EXTERNAL_SNAPSHOT_METHOD_NAMES, List.of("toMatchInlineSnapshot")));
    private static final List<@NlsSafe String> SNAPSHOT_METHOD_CALL_PATTERN = ContainerUtil.map(ALL_SNAPSHOT_METHOD_NAMES, methodName -> ")." + methodName + "(");
    @NonNls
    private static final String LINK_START = "<link>";
    @NonNls
    private static final String LINK_END = "</link>";
    private final Multiset<SMTestProxy> myFailedFileProxies = HashMultiset.create();
    private final NodeTargetRun myTargetRun;
    private boolean myAllTestsLinkAdded = false;

    public JestSnapshotEventsListener(@Nullable NodeTargetRun targetRun) {
        this.myTargetRun = targetRun;
    }

    public void onTestingStarted(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(0);
        }
        this.myFailedFileProxies.clear();
        this.myAllTestsLinkAdded = false;
    }

    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(1);
        }
        if (test.isDefect() && JestSnapshotEventsListener.isSnapshotMatchFailed(test)) {
            List<String> testLocationPath = JestUtil.getTestLocationPath((AbstractTestProxy)test);
            if (testLocationPath == null || testLocationPath.size() <= 1) {
                return;
            }
            String testFilePath = this.getLocalTestFilePath(Objects.requireNonNull(testLocationPath.get(0)));
            List<String> testFqn = testLocationPath.subList(1, testLocationPath.size());
            test.insert(printer -> JestSnapshotEventsListener.printLink(printer, JavaScriptBundle.message((String)"jest.snapshot.update.single.test.text", (Object[])new Object[]{Objects.requireNonNull((String)ContainerUtil.getLastItem((List)testFqn))}) + "\n", new JestUpdateSnapshotHyperlinkInfo(testFilePath, testFqn)), 0);
            SMTestProxy fileProxy = JestSnapshotEventsListener.findTestFileProxy(test);
            if (fileProxy != null && this.myFailedFileProxies.add((Object)fileProxy, 1) == 1) {
                fileProxy.insert(printer -> JestSnapshotEventsListener.printLink(printer, JavaScriptBundle.message((String)"jest.snapshot.update.test.file.text", (Object[])new Object[]{PathUtil.getFileName((String)testFilePath)}) + "\n\n", new JestUpdateSnapshotHyperlinkInfo(testFilePath, null)), 0);
            }
            if (fileProxy != null && fileProxy.getParent() instanceof SMTestProxy.SMRootTestProxy && !this.myAllTestsLinkAdded && this.myFailedFileProxies.entrySet().size() > 1) {
                this.myAllTestsLinkAdded = true;
                fileProxy.getParent().insert(printer -> JestSnapshotEventsListener.printLink(printer, JavaScriptBundle.message((String)"jest.snapshot.update.all.tests.text", (Object[])new Object[0]) + "\n\n", new JestUpdateSnapshotHyperlinkInfo(null, null)), 1);
            }
        }
    }

    @NotNull
    private String getLocalTestFilePath(@NotNull String targetTestFilePath) {
        if (targetTestFilePath == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(2);
        }
        if (this.myTargetRun != null) {
            String string;
            Promise<String> promise = this.myTargetRun.convertTargetPathToLocal(targetTestFilePath);
            if (promise.getState() == Promise.State.PENDING) {
                throw new RuntimeException("Still pending for " + targetTestFilePath);
            }
            try {
                string = Objects.requireNonNull((String)promise.blockingGet(0));
            }
            catch (ExecutionException | TimeoutException e) {
                LOG.info("Cannot convert target path " + targetTestFilePath + " to local", (Throwable)e);
            }
            if (string == null) {
                JestSnapshotEventsListener.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = targetTestFilePath;
        if (string == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void printLink(@NotNull Printer printer, @NotNull String message, @NotNull JestUpdateSnapshotHyperlinkInfo linkInfo) {
        if (printer == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(5);
        }
        if (message == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(6);
        }
        if (linkInfo == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(7);
        }
        int linkStartInd = message.indexOf(LINK_START);
        int linkEndInd = message.indexOf(LINK_END, linkStartInd + LINK_START.length());
        if (linkStartInd >= 0 && linkEndInd >= 0) {
            if (linkStartInd > 0) {
                printer.print(message.substring(0, linkStartInd), ConsoleViewContentType.NORMAL_OUTPUT);
            }
            printer.printHyperlink(message.substring(linkStartInd + LINK_START.length(), linkEndInd), (HyperlinkInfo)linkInfo);
            message = message.substring(linkEndInd + LINK_END.length());
        }
        if (!message.isEmpty()) {
            printer.print(message, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    private static boolean isSnapshotMatchFailed(@NotNull SMTestProxy test) {
        String text;
        if (test == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(8);
        }
        if ((text = test.getErrorMessage()) == null || text.isEmpty()) {
            text = test.getStacktrace();
        }
        if (text != null && JestSnapshotEventsListener.containsAny(text, ALL_SNAPSHOT_METHOD_NAMES)) {
            StringBuilder result2 = new StringBuilder();
            AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
            decoder.escapeText(text, ProcessOutputTypes.STDOUT, (chunk, attributes) -> result2.append(chunk));
            return JestSnapshotEventsListener.containsAny(result2.toString(), SNAPSHOT_METHOD_CALL_PATTERN);
        }
        return false;
    }

    private static boolean containsAny(@NotNull String text, @NotNull List<String> patterns) {
        if (text == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(9);
        }
        if (patterns == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(10);
        }
        return patterns.stream().anyMatch(pattern -> text.contains((CharSequence)pattern));
    }

    @Nullable
    private static SMTestProxy findTestFileProxy(@NotNull SMTestProxy test) {
        if (test == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(11);
        }
        for (SMTestProxy proxy = test; proxy != null; proxy = proxy.getParent()) {
            String locationUrl = proxy.getLocationUrl();
            if (locationUrl == null || !locationUrl.startsWith(FILE_SCHEME)) continue;
            return proxy;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRoot";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTestFilePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/snapshot/JestSnapshotEventsListener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/snapshot/JestSnapshotEventsListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalTestFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onTestingStarted";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onTestFailed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLocalTestFilePath";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printLink";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSnapshotMatchFailed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsAny";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTestFileProxy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

