/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.frameworks.amd.JSAmdBaseUrlIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdRequirePathIndex;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAmdIndexingHandler
extends FrameworkIndexingHandler {
    private static final String[] INTERESTED_PROPERTIES = new String[]{"baseUrl", "paths"};
    private static final String DEFINE = "define";
    private static final String[] INTERESTED_METHOD_NAMES = new String[]{"define"};
    public static final String BASE_URL_USER_STRING = "abu";
    public static final String REQUIRE_PATH_USER_STRING = "arp";

    public String @NotNull [] interestedProperties() {
        if (INTERESTED_PROPERTIES == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(0);
        }
        return INTERESTED_PROPERTIES;
    }

    public boolean processProperty(@Nullable String name, @NotNull JSProperty property, @NotNull JSElementIndexingData outData) {
        PsiElement argList;
        if (property == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(1);
        }
        if (outData == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(2);
        }
        if (!((argList = property.getParent().getParent()) instanceof JSArgumentList)) {
            return true;
        }
        PsiElement callExpr = argList.getParent();
        if (!(callExpr instanceof JSCallExpression)) {
            return true;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpr).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return true;
        }
        if (!"config".equals(((JSReferenceExpression)methodExpression).getReferenceName())) {
            return true;
        }
        JSExpression value = property.getValue();
        if ("baseUrl".equals(name) && value instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            String url = StringUtil.unquoteString((String)value.getText());
            if (!url.contains(":")) {
                outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl.Builder("jsRequireBaseUrl", (PsiElement)value).setUserStringWithData((FrameworkIndexingHandler)this, BASE_URL_USER_STRING, url).toImplicitElement());
            }
        } else if ("paths".equals(name) && value instanceof JSObjectLiteralExpression) {
            HashMap<String, String> paths = new HashMap<String, String>();
            for (JSProperty path2 : ((JSObjectLiteralExpression)value).getProperties()) {
                JSExpression pathValue = path2.getValue();
                if (!(pathValue instanceof JSLiteralExpression) || !((JSLiteralExpression)pathValue).isQuotedLiteral()) continue;
                paths.put(path2.getName(), StringUtil.unquoteString((String)pathValue.getText()));
            }
            outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl.Builder("jsRequirePathAliases", (PsiElement)value).setUserStringWithData((FrameworkIndexingHandler)this, REQUIRE_PATH_USER_STRING, JSAmdIndexingHandler.serializeMap(paths)).toImplicitElement());
        }
        return true;
    }

    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element2, @Nullable IndexSink sink) {
        if (element2 == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(3);
        }
        if (sink == null) {
            return false;
        }
        String string = element2.getUserString();
        if (BASE_URL_USER_STRING.equals(string)) {
            sink.occurrence(JSAmdBaseUrlIndex.KEY, (Object)element2.getName());
        } else if (REQUIRE_PATH_USER_STRING.equals(string)) {
            sink.occurrence(JSAmdRequirePathIndex.KEY, (Object)element2.getName());
        }
        return super.indexImplicitElement(element2, sink);
    }

    private static String serializeMap(Map<String, String> map) {
        StringBuilder builder2 = new StringBuilder();
        String separator = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtil.containsAnyChar((String)key, (String)"*|") || StringUtil.containsAnyChar((String)value, (String)"*|")) continue;
            builder2.append(separator).append(key).append("*").append(value);
            separator = "|";
        }
        return builder2.toString();
    }

    public static Map<String, String> deserializeMap(String serialized) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : StringUtil.split((String)serialized, (String)"|")) {
            int separatorIndex = entry.indexOf(42);
            assert (separatorIndex >= 0);
            map.put(entry.substring(0, separatorIndex), entry.substring(separatorIndex + 1));
        }
        return map;
    }

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(4);
        }
        if (JSAmdPsiUtil.isDefineCall((JSCallExpression)callExpression)) {
            String referenceName;
            Collection returnedExpressions;
            JSReferenceExpression returnedReference;
            String localAlias = "";
            JSExpression moduleInitializer = JSAmdPsiUtil.getModuleInitializer((JSCallExpression)callExpression);
            if (moduleInitializer instanceof JSFunctionExpression && (returnedReference = (JSReferenceExpression)ContainerUtil.getFirstItem((Collection)(returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunctionExpression)moduleInitializer), (Class[])new Class[]{JSReferenceExpression.class})))) != null && returnedReference.getQualifier() == null && (referenceName = returnedReference.getReferenceName()) != null) {
                localAlias = referenceName;
            }
            this.putUserString(outData, localAlias);
        }
    }

    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        if (node == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(5);
        }
        return JSAmdPsiUtil.isDefineCall((ASTNode)node);
    }

    public String @NotNull [] implicitProviderMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(6);
        }
        return INTERESTED_METHOD_NAMES;
    }

    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(7);
        }
        if (DEFINE.equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    if (argument == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (callExpression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outIndexingData == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (!JSAmdPsiUtil.isDefineCall((JSCallExpression)callExpression)) {
                        return;
                    }
                    JSExpression[] arguments = callExpression.getArguments();
                    if (arguments[0] != argument) {
                        return;
                    }
                    String name = JSAmdPsiUtil.unifyModuleName((JSLiteralExpression)argument);
                    JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(name, (PsiElement)argument).setNamespace(JSNamedTypeFactory.createNamespace(null, (JSContext)JSContext.STATIC, null, (boolean)true)).setType(JSImplicitElement.Type.Namespace).setUserString((FrameworkIndexingHandler)JSAmdIndexingHandler.this, "amd");
                    outIndexingData.addImplicitElement((JSImplicitElement)builder2.toImplicitElement());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "argument";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outIndexingData";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler$1";
                    objectArray[2] = "fillIndexingData";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }

    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(8);
        }
        if (!((parent = expression.getParent()) instanceof JSArgumentList)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSCallExpression) || !((JSCallExpression)grandParent).isDefineCall()) {
            return false;
        }
        JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
        return arguments.length >= 2 && arguments[0] == expression;
    }

    @Nullable
    protected String getJSElementIndexingDataUserStringKey() {
        return "def";
    }

    @NotNull
    protected @NotNull Set<@NotNull String> computeJSImplicitElementUserStringKeys() {
        Set<String> set = Set.of("amd", BASE_URL_USER_STRING, REQUIRE_PATH_USER_STRING);
        if (set == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledMethodName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "interestedProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "implicitProviderMethodNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeJSImplicitElementUserStringKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "indexImplicitElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForCallExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralImplicitElementProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasSignificantValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

