/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspection.JSUnusedAssignmentInspection;
import com.intellij.lang.javascript.inspections.ES6RedundantAwaitInspection;
import com.intellij.lang.javascript.inspections.JSJoinVariableDeclarationAndAssignmentInspection;
import com.intellij.lang.javascript.inspections.JSRemoveElementLocalQuickFix;
import com.intellij.lang.javascript.inspections.JSUnnecessarySemicolonInspection;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.intentions.InspectionBasedCodeOptimization;
import com.intellij.lang.javascript.intentions.JSAnonymousToNamedFunctionIntention;
import com.intellij.lang.javascript.intentions.JSNamedToFunctionExpressionIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.JSJoinDeclarationAndAssignmentFix;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.lang.javascript.validation.fixes.RemoveUnusedAssignmentFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.sixrr.inspectjs.dataflow.UnnecessaryLocalVariableJSInspection;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JSPromiseToAsyncIntention
extends JavaScriptIntention {
    private static final String THEN = "then";
    private static final String CATCH = "catch";
    private static final String FINALLY = "finally";
    private static final Set<String> HANDLERS = Set.of("then", "catch", "finally");
    private static final String TYPE_MACRO = "TyPeLvL";
    private static final String DEFAULT_CATCH_VAR_NAME = "e";

    public JSPromiseToAsyncIntention() {
        this.setText(this.getFamilyName());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(1);
        }
        PsiFile file = element2.getContainingFile();
        JSFunction function = JSPromiseToAsyncIntention.findFunction(element2);
        assert (function != null);
        HashSet<String> introducedVars = new HashSet<String>();
        ApplicationManager.getApplication().runWriteAction(() -> JSPromiseToAsyncIntention.doRefactor(function, introducedVars));
        JSPromiseToAsyncIntention.optimizeCode(project, file, function, introducedVars);
        ApplicationManager.getApplication().runWriteAction(() -> FormatFixer.create((PsiElement)function, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat());
    }

    private static void optimizeCode(@NotNull Project project, @NotNull PsiFile file, @NotNull JSFunction function, @NotNull Set<String> introducedVars) {
        if (project == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(3);
        }
        if (function == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(4);
        }
        if (introducedVars == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(5);
        }
        Condition condition = e -> introducedVars.contains(e.getText());
        List<InspectionBasedCodeOptimization> optimizations = Arrays.asList(new InspectionBasedCodeOptimization(new JSUnusedAssignmentInspection(), RemoveUnusedAssignmentFix.class, (Condition<? super PsiElement>)condition), new InspectionBasedCodeOptimization(new JSUnusedLocalSymbolsInspection(), JSRemoveElementLocalQuickFix.class, (Condition<? super PsiElement>)condition), new InspectionBasedCodeOptimization(new JSJoinVariableDeclarationAndAssignmentInspection(true), JSJoinDeclarationAndAssignmentFix.class, (Condition<? super PsiElement>)((Condition)e -> e instanceof JSVarStatement && ((JSVarStatement)e).getVariables().length > 0 && introducedVars.contains(((JSVarStatement)e).getVariables()[0].getName()))), new InspectionBasedCodeOptimization(new UnnecessaryLocalVariableJSInspection(){

            @Override
            protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
                return false;
            }
        }, UnnecessaryLocalVariableJSInspection.Fix.class, (Condition<? super PsiElement>)condition), new InspectionBasedCodeOptimization(new JSUnnecessarySemicolonInspection(), RemoveASTNodeFix.class, (Condition<? super PsiElement>)((Condition)e -> true)), new InspectionBasedCodeOptimization(new ES6RedundantAwaitInspection(), ES6RedundantAwaitInspection.SimplifyAwaitFix.class, (Condition<? super PsiElement>)((Condition)e -> true)));
        JSBlockStatement block = function.getBlock();
        assert (block != null);
        for (InspectionBasedCodeOptimization optimization : optimizations) {
            if (!optimization.perform(project, file, (PsiElement)block)) break;
        }
    }

    private static JSFunction findFunction(@NotNull PsiElement element2) {
        JSFunction function;
        if (element2 == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(6);
        }
        if ((function = (JSFunction)ObjectUtils.coalesce((Object)JSNamedToFunctionExpressionIntention.getFunction(element2), (Object)JSAnonymousToNamedFunctionIntention.getParentFunctionExpression(element2))) != null) {
            return function;
        }
        PsiElement parent = element2.getParent();
        IElementType type2 = PsiUtilCore.getElementType((PsiElement)element2);
        if (parent instanceof JSFieldVariable) {
            JSExpression initializer = ((JSFieldVariable)parent).getInitializer();
            return (JSFunction)ObjectUtils.tryCast((Object)initializer, JSFunction.class);
        }
        if (type2 == JSTokenTypes.FUNCTION_KEYWORD || type2 == JSTokenTypes.IDENTIFIER || JSTokenTypes.ARROWS.contains(type2)) {
            return (JSFunction)ObjectUtils.tryCast((Object)parent, JSFunction.class);
        }
        return null;
    }

    private static void doRefactor(JSFunction function, Set<String> introducedVars) {
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper((JSAttributeListOwner)function);
        wrapper.overrideModifier(JSAttributeList.ModifierType.ASYNC, true);
        wrapper.applyTo((JSAttributeListOwner)function);
        JSPromiseToAsyncIntention.getReturnStatementsWithPromiseHandlers(function).forEach(statement -> JSPromiseToAsyncIntention.transformMethodSequence(statement, introducedVars));
    }

    private static void transformMethodSequence(JSReturnStatement statement, Set<String> introducedVars) {
        boolean hasTypes = DialectDetector.hasFeature((PsiElement)statement, (JSLanguageFeature)JSLanguageFeature.TYPES);
        JSCallExpression expression = (JSCallExpression)statement.getExpression();
        assert (expression != null);
        String replacedPromiseChain = JSPromiseToAsyncIntention.replacePromiseChain(introducedVars, hasTypes, expression, 0, null);
        if (replacedPromiseChain == null) {
            return;
        }
        PsiElement element2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
        if (element2 instanceof PsiComment && !JSPromiseToAsyncIntention.hasNewline(false, element2.getPrevSibling())) {
            element2.delete();
        }
        JSBlockStatement newStatement = (JSBlockStatement)statement.replace(JSPsiElementFactory.createJSStatement((String)("{" + replacedPromiseChain + "}"), (PsiElement)statement));
        JSSourceElement[] statements = newStatement.getStatementListItems();
        PsiElement anchor = newStatement.replace((PsiElement)statements[0]);
        for (int i = 1; i < statements.length; ++i) {
            anchor = anchor.getParent().addAfter((PsiElement)statements[i], anchor);
        }
    }

    @Nullable
    private static String replacePromiseChain(Set<String> introducedVars, boolean hasTypes, JSCallExpression expression, int globalIndex, @Nullable String nextLevelParam) {
        String referenceName;
        JSCallExpression call;
        JSReferenceExpression methodExpression;
        ArrayList<Segment> chain = new ArrayList<Segment>();
        JSCallExpression lastCall = expression;
        Segment currentPart = new Segment();
        while (lastCall instanceof JSCallExpression && (methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)(call = lastCall).getMethodExpression(), JSReferenceExpression.class)) != null && (referenceName = methodExpression.getReferenceName()) != null) {
            if (THEN.equals(referenceName)) {
                arguments = call.getArguments();
                if (arguments.length > 0) {
                    currentPart.thenExpression = arguments[0];
                    JSPromiseToAsyncIntention.collectComments(currentPart, currentPart.thenExpression, methodExpression.getReferenceNameElement(), call);
                }
                if (arguments.length > 1) {
                    currentPart.catchExpressions.add(arguments[1]);
                    JSPromiseToAsyncIntention.collectComments(currentPart, arguments[1], methodExpression.getReferenceNameElement(), call);
                    currentPart.sameBlockThenCatch = true;
                }
                chain.add(currentPart);
                currentPart = new Segment();
            } else if (CATCH.equals(referenceName)) {
                arguments = call.getArguments();
                if (arguments.length > 0) {
                    JSExpression catchExp = arguments[0];
                    currentPart.catchExpressions.add(catchExp);
                    JSPromiseToAsyncIntention.collectComments(currentPart, catchExp, methodExpression.getReferenceNameElement(), call);
                    if (!currentPart.otherFinallyExpressions.isEmpty()) {
                        JSExpression lastExpr = (JSExpression)ContainerUtil.getLastItem(currentPart.otherFinallyExpressions);
                        currentPart.finallyExpressions.put(catchExp, lastExpr);
                        currentPart.otherFinallyExpressions.remove(currentPart.otherFinallyExpressions.size() - 1);
                    }
                }
            } else {
                if (!FINALLY.equals(referenceName)) break;
                arguments = call.getArguments();
                if (arguments.length > 0) {
                    JSPromiseToAsyncIntention.collectComments(currentPart, arguments[0], methodExpression.getReferenceNameElement(), call);
                    currentPart.otherFinallyExpressions.add(arguments[0]);
                }
            }
            lastCall = methodExpression.getQualifier();
        }
        JSCallExpression body = lastCall;
        boolean hadEmptyThen = false;
        if (!(currentPart.thenExpression != null || currentPart.catchExpressions.isEmpty() && currentPart.otherFinallyExpressions.isEmpty())) {
            chain.add(currentPart);
            hadEmptyThen = true;
        }
        if (body == null || chain.isEmpty()) {
            return null;
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)expression);
        if (StringUtil.isEmpty((String)semicolon)) {
            semicolon = "\n";
        }
        String lastPart = null;
        int level = 0;
        int chainSize = chain.size();
        HashMap<CallSite, JSType> typesByLevel = new HashMap<CallSite, JSType>();
        List reversedChain = ContainerUtil.reverse(chain);
        String prevVar = null;
        for (Segment part : reversedChain) {
            boolean addNextResultVar;
            StringBuilder blockBuilder = new StringBuilder();
            Object postfix = globalIndex == 0 ? "" : "_" + globalIndex;
            String resultVar = prevVar != null ? prevVar : JSPromiseToAsyncIntention.createVariableName((PsiElement)expression, (PsiElement)part.thenExpression, "result" + level + (String)postfix, introducedVars);
            Segment nextSegment = reversedChain.size() > level + 1 ? (Segment)reversedChain.get(level + 1) : null;
            String resultVarNext = JSPromiseToAsyncIntention.createVariableName((PsiElement)expression, (PsiElement)(nextSegment != null ? nextSegment.thenExpression : null), "result" + (level + 1) + (String)postfix, introducedVars);
            boolean bl = addNextResultVar = level + 1 != chainSize && (nextSegment == null || !nextSegment.sameBlockThenCatch);
            if (nextLevelParam == null || addNextResultVar) {
                prevVar = resultVarNext;
            }
            String nextVarName = nextLevelParam == null || addNextResultVar ? resultVarNext : nextLevelParam;
            List<JSExpression> catchExpressions = part.catchExpressions;
            if (addNextResultVar || part.sameBlockThenCatch) {
                blockBuilder.append("let ").append(addNextResultVar ? resultVarNext : resultVar);
                if (hasTypes && (nextSegment == null || !JSPromiseToAsyncIntention.isNullOrUndefined(nextSegment.thenExpression))) {
                    blockBuilder.append(": ").append(TYPE_MACRO).append(addNextResultVar ? level + 1 : level).append((String)postfix);
                }
                blockBuilder.append(semicolon);
            }
            int catchCount = catchExpressions.size();
            JSPromiseToAsyncIntention.appendTryHeader(blockBuilder, catchCount - 1);
            JSPromiseToAsyncIntention.appendTryHeader(blockBuilder, part.otherFinallyExpressions.size());
            String caughtVarName = null;
            if (catchCount >= 1) {
                if (part.sameBlockThenCatch) {
                    caughtVarName = JSPromiseToAsyncIntention.createVariableName((PsiElement)expression, null, "caught", introducedVars);
                    blockBuilder.append("let ").append(caughtVarName).append(" = false").append(semicolon);
                }
                JSPromiseToAsyncIntention.appendTryHeader(blockBuilder, 1);
            }
            if (level == 0) {
                JSPromiseToAsyncIntention.appendComments(blockBuilder, (JSExpression)body, part.commentsBefore, true);
                if (hadEmptyThen && !part.sameBlockThenCatch) {
                    if (chain.size() == 1 && nextLevelParam == null) {
                        blockBuilder.append("return await ");
                    } else {
                        blockBuilder.append(nextVarName).append(" = await ");
                    }
                } else {
                    if (!part.sameBlockThenCatch) {
                        blockBuilder.append("let ");
                    }
                    blockBuilder.append(resultVar).append(" = await ");
                }
                Ref isSingleExpression = Ref.create();
                blockBuilder.append(JSPromiseToAsyncIntention.transformElement((PsiElement)body, globalIndex, nextLevelParam == null ? resultVarNext : nextLevelParam, introducedVars, semicolon, (Ref<Boolean>)isSingleExpression));
                if (isSingleExpression.get() == Boolean.TRUE) {
                    blockBuilder.append(semicolon);
                }
                JSPromiseToAsyncIntention.appendComments(blockBuilder, (JSExpression)body, part.commentsAfter, false);
                if (part.sameBlockThenCatch) {
                    JSType type2 = JSPromiseToAsyncIntention.fixPromiseType(null, JSResolveUtil.getExpressionJSType((JSExpression)body));
                    if (type2 instanceof JSVoidType) {
                        type2 = Holder.HACKY_VOID;
                    }
                    typesByLevel.put((CallSite)((Object)(level + (String)postfix)), type2);
                }
            } else {
                blockBuilder.append(lastPart);
            }
            boolean shouldReturn = nextLevelParam == null && level + 1 == chainSize;
            List reverseCatchExpressions = ContainerUtil.reverse(catchExpressions);
            if (part.sameBlockThenCatch) {
                JSExpression catchExpression = (JSExpression)reverseCatchExpressions.get(0);
                String catchVarName = JSPromiseToAsyncIntention.createVariableName((PsiElement)expression, (PsiElement)catchExpression, DEFAULT_CATCH_VAR_NAME, introducedVars);
                blockBuilder.append("} catch (").append(catchVarName).append(") {");
                String catchCall = JSPromiseToAsyncIntention.createCall(catchExpression, catchVarName, semicolon, shouldReturn, nextVarName, null, true, false, globalIndex, introducedVars, expression.getTypeArguments(), false);
                if (JSPromiseToAsyncIntention.allPartsReturn(catchCall, catchExpression)) {
                    caughtVarName = null;
                }
                if (caughtVarName != null) {
                    blockBuilder.append(caughtVarName).append(" = true").append(semicolon);
                }
                JSPromiseToAsyncIntention.appendComments(blockBuilder, catchExpression, part.commentsBefore, true);
                if (catchCall == null) {
                    return null;
                }
                blockBuilder.append(catchCall);
                JSPromiseToAsyncIntention.appendComments(blockBuilder, catchExpression, part.commentsAfter, false);
                blockBuilder.append("}");
            }
            ArrayList<JSType> types2 = new ArrayList<JSType>();
            if (caughtVarName != null) {
                blockBuilder.append("if (!").append(caughtVarName).append(") {");
            }
            JSPromiseToAsyncIntention.appendComments(blockBuilder, part.thenExpression, part.commentsBefore, true);
            String thenCall = JSPromiseToAsyncIntention.createCall(part.thenExpression, resultVar, semicolon, shouldReturn, nextVarName, types2, true, true, globalIndex, introducedVars, expression.getTypeArguments(), part.sameBlockThenCatch);
            if (thenCall == null) {
                return null;
            }
            blockBuilder.append(thenCall);
            JSPromiseToAsyncIntention.appendComments(blockBuilder, part.thenExpression, part.commentsAfter, false);
            if (caughtVarName != null) {
                blockBuilder.append("}");
            }
            boolean first = true;
            for (JSExpression catchExpression : reverseCatchExpressions) {
                if (first) {
                    first = false;
                    if (part.sameBlockThenCatch) continue;
                }
                String catchVarName = JSPromiseToAsyncIntention.createVariableName((PsiElement)expression, (PsiElement)catchExpression, DEFAULT_CATCH_VAR_NAME, introducedVars);
                blockBuilder.append("} catch (").append(catchVarName).append(") {");
                JSPromiseToAsyncIntention.appendComments(blockBuilder, catchExpression, part.commentsBefore, true);
                String catchCall = JSPromiseToAsyncIntention.createCall(catchExpression, catchVarName, semicolon, shouldReturn, nextVarName, types2, true, false, globalIndex, introducedVars, expression.getTypeArguments(), false);
                if (catchCall == null) {
                    return null;
                }
                blockBuilder.append(catchCall);
                JSPromiseToAsyncIntention.appendComments(blockBuilder, catchExpression, part.commentsAfter, false);
                blockBuilder.append("}");
                JSExpression finallyExpr = part.finallyExpressions.get(catchExpression);
                if (finallyExpr == null) continue;
                blockBuilder.append(" finally {");
                JSPromiseToAsyncIntention.appendComments(blockBuilder, finallyExpr, part.commentsBefore, true);
                String finallyCall = JSPromiseToAsyncIntention.createCall(finallyExpr, null, semicolon, shouldReturn, nextVarName, null, false, false, globalIndex, introducedVars, expression.getTypeArguments(), false);
                if (finallyCall == null) {
                    return null;
                }
                blockBuilder.append(finallyCall);
                JSPromiseToAsyncIntention.appendComments(blockBuilder, finallyExpr, part.commentsAfter, false);
                blockBuilder.append("}");
            }
            if (catchExpressions.isEmpty()) {
                for (JSExpression finallyExpr : ContainerUtil.reverse(part.otherFinallyExpressions)) {
                    blockBuilder.append("}");
                    blockBuilder.append(" finally {");
                    JSPromiseToAsyncIntention.appendComments(blockBuilder, finallyExpr, part.commentsBefore, true);
                    String finallyCall = JSPromiseToAsyncIntention.createCall(finallyExpr, null, semicolon, shouldReturn, nextVarName, types2, false, false, globalIndex, introducedVars, expression.getTypeArguments(), false);
                    if (finallyCall == null) {
                        return null;
                    }
                    blockBuilder.append(finallyCall);
                    JSPromiseToAsyncIntention.appendComments(blockBuilder, finallyExpr, part.commentsAfter, false);
                    blockBuilder.append("}");
                }
            }
            if (nextLevelParam != null && addNextResultVar) {
                blockBuilder.append(nextLevelParam).append(" = ").append(nextVarName).append(semicolon);
            }
            lastPart = blockBuilder.toString();
            ++level;
            JSType type3 = JSTypeUtils.getCommonType((Collection)ContainerUtil.map(types2, t -> () -> t), (PsiElement)expression, (boolean)true);
            if (nextSegment != null && nextSegment.sameBlockThenCatch && type3 instanceof JSVoidType) {
                type3 = Holder.HACKY_VOID;
            }
            typesByLevel.put((CallSite)((Object)(level + (String)postfix)), type3);
        }
        if (lastPart == null) {
            return null;
        }
        if (hasTypes) {
            for (String key : typesByLevel.keySet()) {
                JSType type4 = JSPromiseToAsyncIntention.simplifyType((JSType)typesByLevel.get(key));
                if (type4 instanceof JSVoidType) {
                    lastPart = lastPart.replace(": TyPeLvL" + key, " = undefined /*FIXME: there was a mistake in the initial Promise chain*/");
                    continue;
                }
                lastPart = lastPart.replace(TYPE_MACRO + key, type4 == Holder.HACKY_VOID ? "void" : (type4 instanceof JSUnknownType ? "any" : type4.getTypeText(JSType.TypeTextFormat.CODE)));
            }
        }
        return lastPart;
    }

    private static boolean allPartsReturn(String callText, JSExpression catchExpression) {
        JSStatement psi = JSPsiElementFactory.createJSStatement((String)("{" + callText + "}"), (PsiElement)catchExpression);
        if (!(psi instanceof JSBlockStatement)) {
            return false;
        }
        JSSourceElement[] statements = ((JSBlockStatement)psi).getStatementListItems();
        if (statements.length != 1) {
            return false;
        }
        return statements[0] instanceof JSReturnStatement || statements[0] instanceof JSThrowStatement;
    }

    private static void appendTryHeader(StringBuilder blockBuilder, int size) {
        for (int i = 0; i < size; ++i) {
            blockBuilder.append("try {").append("\n");
        }
    }

    private static void appendComments(StringBuilder blockBuilder, JSExpression expression, MultiMap<JSExpression, LeafPsiElement> comments, boolean before) {
        if (comments.containsKey((Object)expression)) {
            Collection elements = comments.get((Object)expression);
            if (before) {
                elements = ContainerUtil.reverse(new ArrayList(elements));
            }
            if (before && !elements.isEmpty()) {
                blockBuilder.append("\n");
            }
            for (LeafPsiElement element2 : elements) {
                blockBuilder.append(element2.getText()).append("\n");
            }
        }
    }

    private static void collectComments(Segment part, JSExpression argument, PsiElement name, JSCallExpression call) {
        if (argument == null) {
            return;
        }
        PsiElement prev = JSPromiseToAsyncIntention.iterateComments(part.commentsBefore, argument, PsiTreeUtil.skipWhitespacesBackward((PsiElement)name), false);
        if (PsiUtilCore.getElementType((PsiElement)prev) == JSTokenTypes.DOT) {
            prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)prev);
            JSPromiseToAsyncIntention.iterateComments(part.commentsBefore, argument, prev, false);
        }
        JSPromiseToAsyncIntention.iterateComments(part.commentsAfter, argument, PsiTreeUtil.skipWhitespacesForward((PsiElement)call), true);
        PsiElement parent = call.getParent();
        if (parent instanceof JSReturnStatement) {
            JSPromiseToAsyncIntention.iterateComments(part.commentsAfter, argument, PsiTreeUtil.skipWhitespacesForward((PsiElement)parent), true);
        }
    }

    private static PsiElement iterateComments(MultiMap<JSExpression, LeafPsiElement> part, JSExpression argument, PsiElement prev, boolean forward) {
        while (prev instanceof PsiComment) {
            boolean hasNewline = JSPromiseToAsyncIntention.hasNewline(forward, forward ? prev.getPrevSibling() : prev.getNextSibling());
            if (!forward && JSPromiseToAsyncIntention.hasNewline(false, prev.getPrevSibling())) {
                part.putValue((Object)argument, (Object)((LeafPsiElement)prev));
            }
            if (hasNewline) {
                return prev;
            }
            if (forward) {
                part.putValue((Object)argument, (Object)((LeafPsiElement)prev));
            }
            prev = forward ? PsiTreeUtil.skipWhitespacesForward((PsiElement)prev) : PsiTreeUtil.skipWhitespacesBackward((PsiElement)prev);
        }
        return prev;
    }

    private static boolean hasNewline(boolean forward, PsiElement sibling) {
        while (sibling instanceof PsiWhiteSpace) {
            String text = sibling.getText();
            if (StringUtil.containsAnyChar((String)text, (String)"\r\n")) {
                return true;
            }
            sibling = forward ? sibling.getPrevSibling() : sibling.getNextSibling();
        }
        return false;
    }

    @NotNull
    private static String createVariableName(PsiElement expression, PsiElement extractedExpression, String defaultVarName, Set<String> introducedVars) {
        String name;
        JSParameterListElement[] parameters2;
        JSFunction function = (JSFunction)ObjectUtils.tryCast((Object)extractedExpression, JSFunction.class);
        if (function == null) {
            function = JSPsiImplUtils.getPossibleFunction((PsiElement)(extractedExpression instanceof JSReferenceExpression ? ((JSReferenceExpression)extractedExpression).resolve() : extractedExpression));
        }
        if (function != null && (parameters2 = function.getParameters()).length == 1 && parameters2[0] instanceof JSParameter && (name = parameters2[0].getName()) != null) {
            defaultVarName = name;
        }
        defaultVarName = JSNameSuggestionsUtil.ensureUniqueVariableName(defaultVarName, expression, introducedVars, false, extractedExpression);
        introducedVars.add(defaultVarName);
        String string = defaultVarName;
        if (string == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static JSType simplifyType(JSType type2) {
        if (type2 instanceof JSAnyType || type2 == null) {
            return type2;
        }
        if (JSTypeUtils.isAnyType((JSType)type2)) {
            return JSAnyType.get((JSTypeSource)type2.getSource());
        }
        return JSCompositeTypeFactory.optimizeTypeIfComposite((JSType)type2.transformTypeHierarchy(el -> {
            if (el instanceof JSLiteralType && el.isTypeScript() && ((JSLiteralType)el).allowWidening()) {
                return ((JSLiteralType)el).widen(false);
            }
            return el;
        }));
    }

    public static Map<String, String> createSingleValueMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return map;
    }

    private static Pair<String, String> copyReplacingParam(JSFunctionExpression arg, PsiElement element2, String argName, int globalIndex, String nextVarName, Set<String> introducedVars, String semicolon, Ref<Boolean> isSingleExpression) {
        JSFunctionExpression tempFunction;
        JSBlockStatement bodyStatement;
        Object body = JSPromiseToAsyncIntention.transformElement(element2, globalIndex, nextVarName, introducedVars, semicolon, isSingleExpression);
        if (argName == null) {
            return Pair.create((Object)body, null);
        }
        JSParameterListElement[] parameters2 = arg.getParameters();
        if (parameters2.length == 0) {
            return Pair.create((Object)body, null);
        }
        if (parameters2.length != 1) {
            return null;
        }
        JSParameterListElement singleParam = parameters2[0];
        String paramName = singleParam.getName();
        if (paramName == null) {
            return null;
        }
        Map newNames = singleParam instanceof JSDestructuringParameter ? ContainerUtil.map2Map((Object[])arg.getParameterVariables(), p -> Pair.create((Object)p.getName(), (Object)JSPromiseToAsyncIntention.createVariableName(arg.getParent(), (PsiElement)arg, p.getName(), introducedVars))) : JSPromiseToAsyncIntention.createSingleValueMap(paramName, argName);
        body = JSPromiseToAsyncIntention.unwrapBlock((String)body);
        boolean isExtraReturn = false;
        if (JSPromiseToAsyncIntention.isSingleExpression((String)body, arg)) {
            isExtraReturn = true;
            body = "return " + (String)body;
        }
        if ((bodyStatement = (tempFunction = (JSFunctionExpression)JSPsiElementFactory.createJSExpression((String)("function f(" + singleParam.getText() + ") {" + (String)body + "}"), (PsiElement)arg, JSFunctionExpression.class)).getBlock()) == null) {
            return null;
        }
        JSSourceElement[] statements = bodyStatement.getStatementListItems();
        isSingleExpression.set((Object)(statements.length == 1 && (statements[0] instanceof JSExpressionStatement || isExtraReturn && statements[0] instanceof JSReturnStatement) ? 1 : 0));
        JSParameterListElement param = tempFunction.getParameters()[0];
        HashSet variables = ContainerUtil.newHashSet((Object[])tempFunction.getParameterVariables());
        JSPromiseToAsyncIntention.doReplaceRefs(tempFunction, (Condition<JSReferenceExpression>)((Condition)e1 -> newNames.containsKey(e1.getReferenceName()) && variables.contains(e1.resolve())), r1 -> JSPromiseToAsyncIntention.doReplaceSingleRef(r1, (String)newNames.get(r1.getReferenceName()), (PsiElement)arg));
        for (JSSourceElement statement : statements) {
            String name;
            String originalName;
            if (!(statement instanceof JSNamedElement) || (originalName = statement.getName()) == null || !JSRefactoringUtil.isValidIdentifier(originalName, arg.getProject()) || (name = JSNameSuggestionsUtil.ensureUniqueVariableName(originalName, arg.getParent(), introducedVars, false, (PsiElement)arg)).equals(originalName)) continue;
            JSPromiseToAsyncIntention.doReplaceRefs(tempFunction, (Condition<JSReferenceExpression>)((Condition)e -> originalName.equals(e.getReferenceName()) && e.resolve() == statement), r -> JSPromiseToAsyncIntention.doReplaceSingleRef(r, name, (PsiElement)statement));
            ((JSNamedElement)statement).setName(name);
        }
        String text = bodyStatement.getText();
        String bodyText = JSPromiseToAsyncIntention.unwrapBlock(text);
        if (isExtraReturn) {
            bodyText = JSPromiseToAsyncIntention.trimReturn(bodyText);
        }
        if (param instanceof JSDestructuringParameter) {
            return Pair.create((Object)bodyText, (Object)("const " + JSPromiseToAsyncIntention.replaceNamesInDestructuring((JSElement)param, newNames, false) + " = " + argName + semicolon));
        }
        return Pair.create((Object)bodyText, null);
    }

    public static void doReplaceSingleRef(@NotNull JSReferenceExpression expression, @NotNull String newName, @NotNull PsiElement context2) {
        PsiElement parent;
        if (expression == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(10);
        }
        if ((parent = expression.getParent()) instanceof JSProperty && ((JSProperty)parent).isShorthanded()) {
            if (!newName.equals(((JSProperty)parent).getName())) {
                ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)((JSProperty)parent), (String)newName);
            }
        } else {
            expression.replace(JSPsiElementFactory.createJSExpression((String)newName, (PsiElement)context2));
        }
    }

    private static void doReplaceRefs(JSFunctionExpression tempFunction, Condition<JSReferenceExpression> acceptsRef, Consumer<JSReferenceExpression> doReplaceRef) {
        SyntaxTraverser.psiTraverser((PsiElement)tempFunction).filter(JSReferenceExpression.class).filter(e -> e.getQualifier() == null && acceptsRef.value(e)).forEach(doReplaceRef);
    }

    @NotNull
    private static String trimReturn(@NotNull String bodyText) {
        int retIndex;
        if (bodyText == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(11);
        }
        if ((retIndex = bodyText.indexOf("return ")) != -1) {
            String string = bodyText.substring(retIndex + "return ".length());
            if (string == null) {
                JSPromiseToAsyncIntention.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = bodyText;
        if (string == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static boolean isSingleExpression(@NotNull String body, JSFunctionExpression arg) {
        JSStatement statement;
        if (body == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(14);
        }
        if (!((statement = JSPsiElementFactory.createJSStatement((String)("{ return " + body + "}"), (PsiElement)arg)) instanceof JSBlockStatement)) {
            return false;
        }
        JSSourceElement[] allStatements = ((JSBlockStatement)statement).getStatementListItems();
        if (allStatements.length != 1) {
            return false;
        }
        JSSourceElement singleStatement = allStatements[0];
        return singleStatement instanceof JSReturnStatement && ((JSReturnStatement)singleStatement).getExpression() != null;
    }

    @NotNull
    private static String unwrapBlock(@NotNull String body) {
        if (body == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(15);
        }
        if (!body.isEmpty() && body.charAt(0) == '{' && body.charAt(body.length() - 1) == '}') {
            String string = body.substring(1, body.length() - 1);
            if (string == null) {
                JSPromiseToAsyncIntention.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = body;
        if (string == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static String replaceNamesInDestructuring(JSElement parameter, @Unmodifiable Map<String, String> newNames, boolean expandSingleVar) {
        StringBuilder builder2 = new StringBuilder();
        JSPromiseToAsyncIntention.appendDestructuringItem(builder2, parameter, newNames, expandSingleVar);
        return builder2.toString();
    }

    private static void appendDestructuringItem(StringBuilder builder2, JSElement item, @Unmodifiable Map<String, String> names, boolean expandSingleVar) {
        if (item instanceof JSDestructuringArrayRestElement) {
            builder2.append("...");
            item = (JSElement)ObjectUtils.coalesce((Object)((JSDestructuringArrayRestElement)item).getVariable(), (Object)((JSDestructuringArrayRestElement)item).getPattern());
        }
        if (item instanceof JSVariable) {
            String ownName = item.getName();
            String newName = names.get(ownName);
            if (expandSingleVar) {
                ES6ComputedName computedName;
                String propName;
                JSDestructuringProperty parentProp = (JSDestructuringProperty)ObjectUtils.tryCast((Object)item.getParent(), JSDestructuringProperty.class);
                String string = propName = parentProp == null ? ownName : JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)parentProp, (boolean)false);
                if (propName == null && parentProp != null && (computedName = parentProp.getComputedPropertyName()) != null) {
                    propName = computedName.getText();
                }
                builder2.append(propName);
                if (!Objects.equals(propName, newName)) {
                    builder2.append(": ").append(newName);
                }
            } else {
                builder2.append(names.get(ownName));
            }
        } else if (item instanceof JSDestructuringElement) {
            JSDestructuringContainer target = ((JSDestructuringElement)item).getTarget();
            if (target instanceof JSDestructuringObject) {
                builder2.append("{");
                JSDestructuringProperty[] properties2 = ((JSDestructuringObject)target).getProperties();
                for (int i = 0; i < properties2.length; ++i) {
                    JSDestructuringProperty property = properties2[i];
                    if (property instanceof JSDestructuringShorthandedProperty) {
                        String newName;
                        String name = property.getName();
                        if (!Objects.equals(name, newName = names.get(name))) {
                            builder2.append(name).append(": ").append(newName);
                        } else {
                            builder2.append(name);
                        }
                    } else {
                        if (property.isRest()) {
                            builder2.append("...");
                        } else {
                            builder2.append(property.getName()).append(": ");
                        }
                        JSPromiseToAsyncIntention.appendDestructuringItem(builder2, (JSElement)property.getDestructuringElement(), names, false);
                    }
                    if (i == properties2.length - 1) continue;
                    builder2.append(", ");
                }
                builder2.append("}");
            } else if (target instanceof JSDestructuringArray) {
                builder2.append("[");
                JSElement[] elements = ((JSDestructuringArray)target).getElementsWithRest();
                for (int i = 0; i < elements.length; ++i) {
                    JSElement element2 = elements[i];
                    JSPromiseToAsyncIntention.appendDestructuringItem(builder2, element2, names, false);
                    if (i == elements.length - 1) continue;
                    builder2.append(", ");
                }
                builder2.append("]");
            }
        }
    }

    private static String transformElement(PsiElement element2, int globalIndex, String nextVarName, Set<String> introducedVars, String semicolon, Ref<Boolean> isSingleExpression) {
        boolean hasTypes = DialectDetector.hasFeature((PsiElement)element2, (JSLanguageFeature)JSLanguageFeature.TYPES);
        if (element2 instanceof JSCallExpression) {
            String chain = JSPromiseToAsyncIntention.replacePromiseChain(introducedVars, hasTypes, (JSCallExpression)element2, globalIndex + 1, nextVarName);
            if (chain != null) {
                isSingleExpression.set((Object)true);
                return chain;
            }
        } else if (element2 instanceof JSSourceElement) {
            HashMap chains = new HashMap();
            ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)element2).forceIgnore(e -> e instanceof JSFunction)).filter(e -> e instanceof JSReturnStatement || e instanceof JSPrefixExpression && ((JSPrefixExpression)e).getOperationSign() == JSTokenTypes.AWAIT_KEYWORD)).forEach(s -> {
                JSExpression expression;
                JSExpression jSExpression = expression = s instanceof JSReturnStatement ? ((JSReturnStatement)s).getExpression() : ((JSPrefixExpression)s).getExpression();
                if (expression instanceof JSCallExpression) {
                    chains.put(s, JSPromiseToAsyncIntention.replacePromiseChain(introducedVars, hasTypes, (JSCallExpression)expression, globalIndex + 1, nextVarName));
                }
            });
            String text = element2.getText();
            for (Map.Entry entry : chains.entrySet()) {
                int i;
                String possibleAssignment;
                int i2;
                String value = (String)entry.getValue();
                if (value == null) continue;
                String returnText = ((PsiElement)entry.getKey()).getText();
                boolean replaced = false;
                if (nextVarName != null && (i2 = text.indexOf(possibleAssignment = nextVarName + " = " + returnText + semicolon)) >= 0) {
                    text = StringUtil.replaceSubstring((String)text, (TextRange)new TextRange(i2, i2 + possibleAssignment.length()), (String)value);
                    replaced = true;
                }
                if (replaced || (i = text.indexOf(returnText)) < 0) continue;
                text = StringUtil.replaceSubstring((String)text, (TextRange)new TextRange(i, i + returnText.length()), (String)value);
            }
            return text;
        }
        isSingleExpression.set((Object)true);
        return element2.getText();
    }

    private static String createCall(JSExpression arg, String argName, String semicolon, boolean shouldReturn, String nextLevelVar, @Nullable List<JSType> types2, boolean allowUndefined, boolean allowEmpty, int globalIndex, @NotNull Set<String> introducedVars, JSTypeDeclaration @NotNull [] typeArguments2, boolean shouldReturnForUndefined) {
        boolean shouldAwait;
        JSType funcType;
        Object returnStatementStart;
        if (introducedVars == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(18);
        }
        if (typeArguments2 == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(19);
        }
        if (allowEmpty && arg == null) {
            return "";
        }
        if (allowUndefined && JSPromiseToAsyncIntention.isNullOrUndefined(arg)) {
            if (shouldReturnForUndefined) {
                return shouldReturn ? "return " + argName + semicolon : nextLevelVar + " = " + argName + semicolon;
            }
            return "";
        }
        Object object = returnStatementStart = shouldReturn ? "return " : nextLevelVar + " = ";
        if (arg instanceof JSFunctionExpression) {
            ASTNode statement;
            Object textOfElement;
            boolean shouldAwait2;
            JSType returnType2 = ((JSFunctionExpression)arg).getReturnType();
            boolean bl = shouldAwait2 = JSPromiseToAsyncIntention.isAsync((JSFunction)arg) || JSPromiseToAsyncIntention.isPromiseOrAny(returnType2);
            if (shouldAwait2) {
                returnStatementStart = (String)returnStatementStart + "await ";
            }
            if (((JSFunctionExpression)arg).isShorthandArrowFunction()) {
                String prefix;
                Ref isSingleExpression;
                JSExpression exp = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)((JSFunction)arg));
                if (exp == null) {
                    return null;
                }
                Pair<String, String> copy = JSPromiseToAsyncIntention.copyReplacingParam((JSFunctionExpression)arg, (PsiElement)exp, argName, globalIndex, shouldReturn ? null : nextLevelVar, introducedVars, semicolon, (Ref<Boolean>)(isSingleExpression = Ref.create()));
                if (copy == null) {
                    return null;
                }
                if (types2 != null) {
                    types2.add(shouldAwait2 ? JSPromiseToAsyncIntention.fixPromiseType((PsiElement)arg, returnType2) : returnType2);
                }
                String string = prefix = copy.second == null ? "" : (String)copy.second;
                if (isSingleExpression.get() == Boolean.TRUE) {
                    return prefix + (String)returnStatementStart + (String)copy.first + semicolon;
                }
                return prefix + (String)copy.first;
            }
            StringBuilder allStatements = new StringBuilder();
            JSBlockStatement element2 = ((JSFunctionExpression)arg).getBlock();
            if (element2 == null) {
                return null;
            }
            JSBlockStatement copy = element2;
            if (!shouldReturn) {
                copy = element2.copy();
                Object start = returnStatementStart;
                ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)copy).forceIgnore(e -> e instanceof JSFunction)).filter(JSReturnStatement.class).filter(s -> s.getExpression() != null).forEach(arg_0 -> JSPromiseToAsyncIntention.lambda$createCall$21((String)start, semicolon, element2, arg_0));
            }
            Ref isSingleExpression = Ref.create();
            Pair<String, String> copyOf = JSPromiseToAsyncIntention.copyReplacingParam((JSFunctionExpression)arg, (PsiElement)copy, argName, globalIndex, shouldReturn ? null : nextLevelVar, introducedVars, semicolon, (Ref<Boolean>)isSingleExpression);
            Object object2 = textOfElement = copyOf == null ? null : (String)copyOf.first;
            if (!(textOfElement == null || isSingleExpression.get() != Boolean.TRUE || StringUtil.isEmpty((String)semicolon) || StringUtil.endsWith((CharSequence)((String)textOfElement).trim(), (CharSequence)semicolon) || JSPromiseToAsyncIntention.terminatesBySemicolon(statement = JSChangeUtil.createStatementFromTextWithContext((String)((String)textOfElement).trim(), (PsiElement)arg)))) {
                textOfElement = (String)textOfElement + semicolon;
            }
            if (!StringUtil.isEmptyOrSpaces((String)textOfElement)) {
                if (copyOf.second != null) {
                    allStatements.append((String)copyOf.second);
                }
                allStatements.append(JSPromiseToAsyncIntention.unwrapBlock((String)textOfElement));
            }
            if (types2 != null) {
                types2.add(shouldAwait2 ? JSPromiseToAsyncIntention.fixPromiseType((PsiElement)arg, returnType2) : returnType2);
            }
            return allStatements.toString();
        }
        JSFunction possibleFunction = JSPsiImplUtils.getPossibleFunction((PsiElement)(arg instanceof JSReferenceExpression ? ((JSReferenceExpression)arg).resolve() : arg));
        Object type2 = possibleFunction != null ? possibleFunction.getReturnType() : ((funcType = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive((JSExpression)arg)) instanceof JSFunctionTypeImpl ? ((JSFunctionTypeImpl)funcType).getReturnType() : JSAnyType.get((PsiElement)arg));
        boolean bl = shouldAwait = JSPromiseToAsyncIntention.isAsync(possibleFunction) || JSPromiseToAsyncIntention.isPromiseOrAny(type2);
        if (shouldAwait) {
            returnStatementStart = (String)returnStatementStart + "await ";
        }
        String callText = arg instanceof JSReferenceExpression || arg instanceof JSCallExpression ? arg.getText() : "(" + arg.getText() + ")";
        String callPart = JSPromiseToAsyncIntention.getGenericText(typeArguments2, possibleFunction) + "(" + (argName == null ? "" : argName) + ")";
        if (types2 != null) {
            types2.add(shouldAwait ? JSPromiseToAsyncIntention.fixPromiseType((PsiElement)possibleFunction, type2) : type2);
        }
        return (String)(type2 == null ? "" : returnStatementStart) + callText + callPart + semicolon;
    }

    @Contract(value="null -> false")
    private static boolean terminatesBySemicolon(ASTNode statement) {
        if (statement == null) {
            return false;
        }
        ASTNode childNode = statement.getLastChildNode();
        return childNode != null && childNode.getElementType() == JSTokenTypes.SEMICOLON;
    }

    private static boolean isNullOrUndefined(JSExpression arg) {
        return JSSymbolUtil.isUndefinedExpression((JSExpression)arg) || arg instanceof JSLiteralExpression && ((JSLiteralExpression)arg).isNullLiteral();
    }

    private static String getGenericText(JSTypeDeclaration[] arguments, JSFunction function) {
        TypeScriptTypeParameter[] parameters2;
        if (function instanceof TypeScriptFunction && (parameters2 = ((TypeScriptFunction)function).getTypeParameters()).length == arguments.length && parameters2.length > 0) {
            return "<" + StringUtil.join((Object[])arguments, a -> a.getText(), (String)", ") + ">";
        }
        return "";
    }

    @NotNull
    private static JSType fixPromiseType(PsiElement possibleFunction, JSType type2) {
        List arguments;
        if ((type2 = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)type2, (PsiElement)possibleFunction)) instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType((JSType)((JSGenericTypeImpl)type2).getType()) && (arguments = ((JSGenericTypeImpl)type2).getArguments()).size() == 1) {
            JSType argumentType = (JSType)arguments.get(0);
            if (JSTypeUtils.isAwaitedNamedType((JSType)argumentType)) {
                argumentType = (JSType)((JSGenericTypeImpl)argumentType).getArguments().get(0);
            }
            JSType jSType = argumentType;
            if (jSType == null) {
                JSPromiseToAsyncIntention.$$$reportNull$$$0(20);
            }
            return jSType;
        }
        JSAnyType jSAnyType = possibleFunction == null ? JSAnyType.get((JSTypeSource)type2.getSource()) : JSAnyType.get((PsiElement)possibleFunction);
        if (jSAnyType == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(21);
        }
        return jSAnyType;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        JSFunction function;
        if (project == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(22);
        }
        if (element2 == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(23);
        }
        if ((function = JSPromiseToAsyncIntention.findFunction(element2)) == null || JSPromiseToAsyncIntention.isAsync(function)) {
            return false;
        }
        return (Boolean)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)element2, () -> {
            JSType returnType2 = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)function.getReturnType(), (PsiElement)element2);
            if (DialectDetector.isTypeScript((PsiElement)element2) && !JSTypeUtils.isPromiseLikeType((JSType)returnType2) || DialectDetector.isJavaScript((PsiElement)element2) && !JSPromiseToAsyncIntention.isPromiseOrAny(returnType2)) {
                return false;
            }
            return JSPromiseToAsyncIntention.getReturnStatementsWithPromiseHandlers(function).isNotEmpty();
        });
    }

    private static boolean isAsync(JSFunction function) {
        return JSPsiImplUtils.hasModifier((JSAttributeListOwner)function, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.ASYNC);
    }

    @NotNull
    private static JBIterable<JSReturnStatement> getReturnStatementsWithPromiseHandlers(JSFunction function) {
        JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function).forceIgnore(f -> f instanceof JSFunction)).filter(JSReturnStatement.class).filter(s -> JSPromiseToAsyncIntention.containsPromiseHandler(s.getExpression()));
        if (jBIterable == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    private static boolean containsPromiseHandler(JSExpression expression) {
        JSReferenceExpression jsRef;
        if (!(expression instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression) || (jsRef = (JSReferenceExpression)methodExpression).getReferenceName() == null || !HANDLERS.contains(jsRef.getReferenceName())) {
            return false;
        }
        JSExpression[] arguments = ((JSCallExpression)expression).getArguments();
        return arguments.length > 0 && (arguments[0] instanceof JSFunction || arguments[0] instanceof JSReferenceExpression || arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isNullLiteral());
    }

    private static boolean isPromiseOrAny(@Nullable JSType type2) {
        if (type2 == null) {
            return false;
        }
        if (JSTypeUtils.isExactlyPromiseLikeType((JSType)(type2 = type2.substitute()))) {
            return true;
        }
        if (JSTypeUtils.isAnyType((JSType)type2)) {
            return true;
        }
        if (type2 instanceof JSCodeBasedType) {
            return true;
        }
        return type2 instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType((JSType)((JSGenericTypeImpl)type2).getType());
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.intention.promise.to.async.name", (Object[])new Object[0]);
        if (string == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(25);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            JSPromiseToAsyncIntention.$$$reportNull$$$0(26);
        }
        return currentFile;
    }

    private static /* synthetic */ void lambda$createCall$21(String start, String semicolon, JSBlockStatement element2, JSReturnStatement s) {
        s.replace(JSPsiElementFactory.createJSStatement((String)(start + Objects.requireNonNull(s.getExpression()).getText() + semicolon), (PsiElement)element2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 13, 16, 17, 20, 21, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedVars";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSPromiseToAsyncIntention";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyText";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSPromiseToAsyncIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "trimReturn";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapBlock";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fixPromiseType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStatementsWithPromiseHandlers";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "optimizeCode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFunction";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doReplaceSingleRef";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trimReturn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSingleExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unwrapBlock";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createCall";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 13, 16, 17, 20, 21, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static final class Segment {
        JSExpression thenExpression;
        List<JSExpression> catchExpressions = new ArrayList<JSExpression>();
        Map<JSExpression, JSExpression> finallyExpressions = new HashMap<JSExpression, JSExpression>();
        List<JSExpression> otherFinallyExpressions = new ArrayList<JSExpression>();
        MultiMap<JSExpression, LeafPsiElement> commentsBefore = MultiMap.create();
        MultiMap<JSExpression, LeafPsiElement> commentsAfter = MultiMap.create();
        boolean sameBlockThenCatch = false;

        private Segment() {
        }
    }

    private static class Holder {
        private static final JSType HACKY_VOID = JSNamedTypeFactory.createType((String)"_$_$_VOID", (JSTypeSource)JSTypeSource.EMPTY_TS, (JSTypeContext)JSTypeContext.INSTANCE);

        private Holder() {
        }
    }
}

