/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.rhino;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptableObject;

public final class RhinoUtil {
    private RhinoUtil() {
    }

    @NotNull
    public static Object toRhinoAnyNotNull(@NotNull Object object) {
        if (object == null) {
            RhinoUtil.$$$reportNull$$$0(0);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return RhinoUtil.toRhinoMap(map);
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof String) {
            Object object2 = object;
            if (object2 == null) {
                RhinoUtil.$$$reportNull$$$0(1);
            }
            return object2;
        }
        if (object instanceof List) {
            NativeArray nativeArray = RhinoUtil.toRhinoArray((List)object);
            if (nativeArray == null) {
                RhinoUtil.$$$reportNull$$$0(2);
            }
            return nativeArray;
        }
        if (object instanceof Object[]) {
            throw new RuntimeException("Java arrays aren't supported, please use " + String.valueOf(List.class));
        }
        throw new RuntimeException("Unexpected rhino object " + String.valueOf(object));
    }

    @Nullable
    public static Object toRhinoAny(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return RhinoUtil.toRhinoAnyNotNull(object);
    }

    public static NativeArray toRhinoArray(@NotNull List<Object> list) {
        if (list == null) {
            RhinoUtil.$$$reportNull$$$0(3);
        }
        Object[] resArray = new Object[list.size()];
        int i = 0;
        for (Object o : list) {
            Object res;
            resArray[i] = res = RhinoUtil.toRhinoAny(o);
            ++i;
        }
        return new NativeArray(resArray);
    }

    @NotNull
    public static NativeObject toRhinoMap(@NotNull Map<String, ?> map) {
        if (map == null) {
            RhinoUtil.$$$reportNull$$$0(4);
        }
        NativeObject object = new NativeObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object nativeObj = RhinoUtil.toRhinoAny(entry.getValue());
            object.defineProperty(entry.getKey(), nativeObj, 1);
        }
        NativeObject nativeObject = object;
        if (nativeObject == null) {
            RhinoUtil.$$$reportNull$$$0(5);
        }
        return nativeObject;
    }

    @Nullable
    public static Object toJavaAny(@Nullable Object rhinoObject) {
        if (rhinoObject instanceof NativeObject) {
            return RhinoUtil.toJavaMap((NativeObject)rhinoObject);
        }
        if (rhinoObject instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)rhinoObject;
            return Arrays.asList(nativeArray.toArray());
        }
        return rhinoObject;
    }

    @NotNull
    public static Map<Object, Object> toJavaMap(@NotNull NativeObject nativeObject) {
        if (nativeObject == null) {
            RhinoUtil.$$$reportNull$$$0(6);
        }
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (Map.Entry entry : nativeObject.entrySet()) {
            Object regularKey = RhinoUtil.toJavaAny(entry.getKey());
            Object regularValue = RhinoUtil.toJavaAny(entry.getValue());
            copy.put(regularKey, regularValue);
        }
        HashMap<Object, Object> hashMap = copy;
        if (hashMap == null) {
            RhinoUtil.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @Nullable
    public static String getStringKey(@NotNull ScriptableObject object, @NotNull String key) {
        if (object == null) {
            RhinoUtil.$$$reportNull$$$0(8);
        }
        if (key == null) {
            RhinoUtil.$$$reportNull$$$0(9);
        }
        Object value = object.get((Object)key);
        String str = null;
        if (value instanceof String) {
            str = (String)value;
        } else if (value instanceof ConsString) {
            ConsString consString = (ConsString)value;
            str = consString.toString();
        }
        return str;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/rhino/RhinoUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeObject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/rhino/RhinoUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toRhinoAnyNotNull";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toRhinoMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toJavaMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toRhinoAnyNotNull";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toRhinoArray";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toRhinoMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toJavaMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStringKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 7 -> new IllegalStateException(string);
        };
    }
}

