/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagram;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.BaseDiagramProvider;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.diagram.JSDiagramColorManager;
import com.intellij.lang.javascript.modules.diagram.JSModuleDependencyData;
import com.intellij.lang.javascript.modules.diagram.JSModulesDiagramUtils;
import com.intellij.lang.javascript.modules.diagram.JSModulesDiagramVfsResolver;
import com.intellij.lang.javascript.modules.diagram.JSModulesVisibilityManager;
import com.intellij.lang.javascript.modules.diagram.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagram.JSStructuralDiagramModel;
import com.intellij.lang.javascript.modules.diagram.JSStructuralUiEdge;
import com.intellij.lang.javascript.modules.diagram.JSStructuralUiNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.GotItMessage;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LazyKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Lazy;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSModulesDiagramProvider
extends BaseDiagramProvider<JSStructuralDiagramItem> {
    private static final String FIRST_SHOW_KEY = "js.modules.notification.shown";
    public static final String JAVASCRIPT_MODULES_DIAGRAM = "JavaScript-modules-diagram";
    private volatile boolean myGotItMessageActive;
    private final DiagramElementManager<JSStructuralDiagramItem> myElementManager;
    private final Lazy<DiagramNodeContentManager> myNodeContentManager = LazyKt.lazyPub(this::createNodeContentManager);

    public JSModulesDiagramProvider() {
        this.myElementManager = new AbstractDiagramElementManager<JSStructuralDiagramItem>(this){

            public Object @NotNull [] getNodeItems(JSStructuralDiagramItem parent) {
                Object[] objectArray = ArrayUtil.toObjectArray(parent.getUsedExported());
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @Nullable
            public JSStructuralDiagramItem findInDataContext(@NotNull DataContext context2) {
                Project project;
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((project = (Project)CommonDataKeys.PROJECT.getData(context2)) == null) {
                    return null;
                }
                VirtualFile[] data2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context2);
                SmartPointerManager spm = SmartPointerManager.getInstance((Project)project);
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                if (data2 != null) {
                    List<VirtualFile> files = 1.checkFilesTypesAndFilterExcluded(project, data2);
                    if (files.isEmpty()) {
                        return null;
                    }
                    if (files.size() == 1) {
                        VirtualFile file = files.get(0);
                        if (file.isDirectory()) {
                            PsiDirectory psiDirectory = psiManager.findDirectory(file);
                            if (psiDirectory == null || !JSModulesDiagramProvider.containsJsOrTsFiles(psiDirectory)) {
                                return null;
                            }
                            return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiDirectory), file.getName(), true);
                        }
                        PsiFile psiFile = psiManager.findFile(file);
                        if (psiFile == null) {
                            return null;
                        }
                        return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), file.getName(), true);
                    }
                    JSStructuralDiagramItem item = JSModulesDiagramProvider.createProjectItem(project, spm);
                    if (item == null) {
                        return null;
                    }
                    for (VirtualFile file : files) {
                        PsiDirectory psiFile;
                        Object object = psiFile = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
                        if (psiFile == null) continue;
                        item.addImportedOrExported(new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), file.getName(), true), true);
                    }
                    return item;
                }
                PsiElement element2 = (PsiElement)CommonDataKeys.PSI_FILE.getData(context2);
                return element2 == null ? null : new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)element2.getContainingFile()), JSModulesDiagramUtils.getFileNamePart(element2.getContainingFile()), true);
            }

            private static @Unmodifiable List<VirtualFile> checkFilesTypesAndFilterExcluded(Project project, VirtualFile @NotNull [] files) {
                if (files == null) {
                    1.$$$reportNull$$$0(2);
                }
                ProjectFileIndex fi = ProjectRootManager.getInstance((Project)project).getFileIndex();
                return ContainerUtil.filter((Object[])files, file -> {
                    if (fi.isExcluded(file)) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    FileType type2 = file.getFileType();
                    if (type2 instanceof LanguageFileType) {
                        Language language = ((LanguageFileType)type2).getLanguage();
                        return language.isKindOf((Language)HTMLLanguage.INSTANCE) || DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type2) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type2);
                    }
                    return false;
                });
            }

            public boolean isAcceptableAsNode(@Nullable Object element2) {
                return element2 instanceof JSStructuralDiagramItem;
            }

            @Nullable
            public String getElementTitle(JSStructuralDiagramItem element2) {
                return JSModulesDiagramProvider.getElementTitleStatic(element2);
            }

            @Nullable
            public SimpleColoredText getItemName(@Nullable Object element2, @NotNull DiagramState presentation) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (element2 instanceof JSStructuralDiagramItem) {
                    SimpleTextAttributes attributes = StartupUiUtil.isUnderDarcula() ? new SimpleTextAttributes(0, (Color)JBColor.black) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    return new SimpleColoredText(JSModulesDiagramProvider.getElementTitleStatic((JSStructuralDiagramItem)element2), attributes);
                }
                return null;
            }

            @Nullable
            public SimpleColoredText getItemType(@Nullable Object element2) {
                if (element2 instanceof JSStructuralDiagramItem && ((JSStructuralDiagramItem)element2).getParent() != null) {
                    boolean isExported = ((JSStructuralDiagramItem)element2).getParent().isExported((JSStructuralDiagramItem)element2);
                    SimpleColoredText text = new SimpleColoredText(this){
                        private Icon myIcon;

                        public void setIcon(@Nullable Icon icon) {
                            this.myIcon = icon;
                        }

                        public void appendToComponent(@NotNull ColoredTextContainer component) {
                            if (component == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.appendToComponent(component);
                            if (this.myIcon != null) {
                                component.setIcon(this.myIcon);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$1$1", "appendToComponent"));
                        }
                    };
                    if (isExported) {
                        text.setIcon(AllIcons.ToolbarDecorator.Export);
                    } else {
                        text.setIcon(AllIcons.ToolbarDecorator.Import);
                    }
                    return text;
                }
                return super.getItemType(element2);
            }

            @Nullable
            public Icon getItemIcon(@Nullable Object element2, @NotNull DiagramState presentation) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (element2 instanceof JSStructuralDiagramItem) {
                    JSStructuralDiagramItem item = (JSStructuralDiagramItem)element2;
                    if (item.getIcon() != null) {
                        return item.getIcon();
                    }
                    return (Icon)ReadAction.compute(() -> JSStructuralUiNode.calculateIcon(item));
                }
                return super.getItemIcon(element2, presentation);
            }

            @Nullable
            @Nls
            public String getNodeTooltip(JSStructuralDiagramItem element2) {
                return JSModulesDiagramUtils.getJSStructuralItemTooltip(element2);
            }

            @Nls
            @Nullable
            public String getEditorTitle(JSStructuralDiagramItem element2, @NotNull Collection<JSStructuralDiagramItem> additionalElements) {
                if (additionalElements == null) {
                    1.$$$reportNull$$$0(5);
                }
                return this.getElementTitle(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 4, 5 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "files";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "additionalElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodeItems";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "findInDataContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "checkFilesTypesAndFilterExcluded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemIcon";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getEditorTitle";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static boolean containsJsOrTsFiles(@NotNull PsiDirectory element2) {
        if (element2 == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(0);
        }
        return !DumbService.isDumb((Project)element2.getProject()) && (FileTypeIndex.containsFileOfType((FileType)JavaScriptFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)element2, (boolean)true)) || FileTypeIndex.containsFileOfType((FileType)TypeScriptFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)element2, (boolean)true)));
    }

    @Nullable
    static JSStructuralDiagramItem createProjectItem(Project project, SmartPointerManager spm) {
        VirtualFile baseDir = project.getBaseDir();
        PsiDirectory projectPsiFile = PsiManager.getInstance((Project)project).findDirectory(baseDir);
        if (projectPsiFile == null) {
            return null;
        }
        SmartPsiElementPointer pointer = spm.createSmartPsiElementPointer((PsiElement)projectPsiFile);
        return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)pointer, JavaScriptBundle.message((String)"modules.selected", (Object[])new Object[0]), false);
    }

    @Nullable
    static JSStructuralDiagramItem deserializeOneItem(@NlsSafe String fqn, Project project) {
        int offset;
        PsiDirectory psiFile;
        if (StringUtil.isEmptyOrSpaces((String)fqn)) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (!fqn.contains("#")) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fqn);
            if (file != null) {
                PsiDirectory psiFile2;
                Object object = psiFile2 = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
                if (psiFile2 == null) {
                    return null;
                }
                String name = psiFile2 instanceof PsiFile ? JSModulesDiagramUtils.getFileNamePart((PsiFile)psiFile2) : file.getName();
                return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)psiFile2), name, true);
            }
            return new JSStructuralDiagramItem(null, fqn, true);
        }
        String[] strings = fqn.split("#");
        if (strings.length != 1 && strings.length != 3) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(strings[0]);
        if (file == null) {
            return null;
        }
        Object object = psiFile = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (strings.length == 1) {
            String name = psiFile instanceof PsiFile ? JSModulesDiagramUtils.getFileNamePart((PsiFile)psiFile) : file.getName();
            return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)psiFile), name, true);
        }
        String name = strings[1];
        try {
            offset = Integer.parseInt(strings[2]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        PsiElement element2 = psiFile.findElementAt(offset);
        if (element2 == null || !element2.isValid()) {
            return null;
        }
        return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element2), name, false);
    }

    @NotNull
    static String serializeOneItem(JSStructuralDiagramItem element2) {
        if (element2.getElementPointer() == null) {
            String string = element2.getName();
            if (string == null) {
                JSModulesDiagramProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        PsiElement psiElement = element2.getElementPointer().getElement();
        if (psiElement == null) {
            return "";
        }
        String path2 = psiElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement).getVirtualFile().getPath() : psiElement.getContainingFile().getVirtualFile().getPath();
        StringBuilder sb = new StringBuilder(path2);
        if (!(psiElement instanceof PsiFileSystemItem) && !element2.isFile()) {
            if (psiElement.getTextRange() == null) {
                String string = path2;
                if (string == null) {
                    JSModulesDiagramProvider.$$$reportNull$$$0(2);
                }
                return string;
            }
            sb.append("#").append(element2.getName()).append("#").append(String.format("%d", psiElement.getTextRange().getStartOffset()));
        }
        String string = sb.toString();
        if (string == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    @NotNull
    public String getID() {
        return JAVASCRIPT_MODULES_DIAGRAM;
    }

    @NotNull
    public DiagramVisibilityManager createVisibilityManager() {
        DiagramVisibilityManager diagramVisibilityManager = (DiagramVisibilityManager)ApplicationManager.getApplication().getService(JSModulesVisibilityManager.class);
        if (diagramVisibilityManager == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(4);
        }
        return diagramVisibilityManager;
    }

    @NotNull
    public DiagramNodeContentManager getNodeContentManager() {
        DiagramNodeContentManager diagramNodeContentManager = (DiagramNodeContentManager)this.myNodeContentManager.getValue();
        if (diagramNodeContentManager == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(5);
        }
        return diagramNodeContentManager;
    }

    @NotNull
    public DiagramNodeContentManager createNodeContentManager() {
        return new AbstractDiagramNodeContentManager(this){
            {
                this.setCategoryEnabled(Holder.myAllCategory, true);
            }

            public boolean isInCategory(@Nullable Object nodeElement, @Nullable Object item, @NotNull DiagramCategory category, @Nullable DiagramBuilder builder2) {
                if (category == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            public DiagramCategory @NotNull [] getContentCategories() {
                DiagramCategory[] diagramCategoryArray = new DiagramCategory[]{Holder.myAllCategory};
                if (diagramCategoryArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return diagramCategoryArray;
            }

            public boolean isEditCategoriesSettings() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "category";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentCategories";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isInCategory";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public DiagramPresentationModel createPresentationModel(@NotNull Project project, @NotNull Graph2D graph) {
        if (project == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(6);
        }
        if (graph == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(7);
        }
        return new DiagramPresentationModelImpl(graph, project, (DiagramProvider)this){

            public boolean allowChangeVisibleCategories() {
                return false;
            }

            public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
                if (view == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (editMode == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.customizeSettings(view, editMode);
                DiagramBuilder builder2 = this.getBuilder();
                Objects.requireNonNull(builder2.getDataModel().getNodeContentManager()).setCategoryEnabled(Holder.myAllCategory, true);
                JComponent component = builder2.getView().getJComponent();
                if (!PropertiesComponent.getInstance().isTrueValue(JSModulesDiagramProvider.FIRST_SHOW_KEY)) {
                    this.showGotItMessage(component, JavaScriptBundle.message((String)"javascript.module.dependencies.got.it.text", (Object[])new Object[0]));
                } else if (this.getBuilder().getDataModel().getNodes().isEmpty()) {
                    this.showGotItMessage(component, JavaScriptBundle.message((String)"javascript.module.dependencies.empty.got.it.text", (Object[])new Object[0]));
                }
            }

            private void showGotItMessage(JComponent component, @NlsContexts.PopupContent String message) {
                UiNotifyConnector.doWhenFirstShown((JComponent)component, () -> {
                    if (JSModulesDiagramProvider.this.myGotItMessageActive) {
                        return;
                    }
                    JSModulesDiagramProvider.this.myGotItMessageActive = true;
                    GotItMessage.createMessage((String)JavaScriptBundle.message((String)"javascript.module.dependencies.got.it.title", (Object[])new Object[0]), (String)message).setCallback(() -> {
                        JSModulesDiagramProvider.this.myGotItMessageActive = false;
                        PropertiesComponent.getInstance().setValue(JSModulesDiagramProvider.FIRST_SHOW_KEY, true);
                    }).setDisposable((Disposable)this.getBuilder()).show(RelativePoint.getSouthEastOf((JComponent)component), Balloon.Position.below);
                });
            }

            @NotNull
            protected DefaultUmlRenderer createRenderer() {
                return new DefaultUmlRenderer(this.getBuilder(), this.getModificationTrackerOfViewUpdates()){

                    public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
                        Border border = JBUI.Borders.customLine((Color)Gray._190);
                        DiagramNode object = this.getBuilder().getNodeObject(realizer.getNode());
                        if (object instanceof JSStructuralUiNode) {
                            JSStructuralDiagramItem element2 = ((JSStructuralUiNode)object).getIdentifyingElement();
                            if (element2.isInScope()) {
                                PsiFile file;
                                PsiFile psiFile = file = element2.getElementPointer() != null ? element2.getElementPointer().getContainingFile() : null;
                                if (file != null && !JSLibraryUtil.isProbableLibraryFile((VirtualFile)file.getVirtualFile())) {
                                    border = JBUI.Borders.customLine((Color)JBColor.black);
                                }
                            } else if (element2.getElementPointer() == null && !JSModulesDiagramUtils.startsWithHttpProtocol(element2.getName())) {
                                border = JBUI.Borders.customLine((Color)JBColor.red);
                            }
                        }
                        wrapper.setBorder(border);
                        if (wrapper.getParent() instanceof JComponent) {
                            ((JComponent)wrapper.getParent()).setBorder((Border)JBUI.Borders.empty());
                        }
                        super.tuneNode(realizer, wrapper);
                    }
                };
            }

            @Nullable
            public String getNodeTooltip(@Nullable DiagramNode node) {
                return node.getTooltip();
            }

            @Nullable
            public String getEdgeTooltip(DiagramEdge edge) {
                if (edge instanceof JSStructuralUiEdge) {
                    return ((JSStructuralUiEdge)edge).getTooltip();
                }
                return super.getEdgeTooltip(edge);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "view";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editMode";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$3";
                objectArray[2] = "customizeSettings";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public DiagramColorManager getColorManager() {
        JSDiagramColorManager jSDiagramColorManager = JSDiagramColorManager.INSTANCE;
        if (jSDiagramColorManager == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(8);
        }
        return jSDiagramColorManager;
    }

    @NotNull
    public DiagramElementManager<JSStructuralDiagramItem> getElementManager() {
        DiagramElementManager<JSStructuralDiagramItem> diagramElementManager = this.myElementManager;
        if (diagramElementManager == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(9);
        }
        return diagramElementManager;
    }

    @NotNull
    public DiagramVfsResolver<JSStructuralDiagramItem> getVfsResolver() {
        DiagramVfsResolver diagramVfsResolver = (DiagramVfsResolver)ApplicationManager.getApplication().getService(JSModulesDiagramVfsResolver.class);
        if (diagramVfsResolver == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(10);
        }
        return diagramVfsResolver;
    }

    @NotNull
    public String getPresentableName() {
        String string = JavaScriptBundle.message((String)"js.module.uml.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public DiagramExtras<JSStructuralDiagramItem> getExtras() {
        return new DiagramExtras<JSStructuralDiagramItem>(this){

            @NotNull
            public List<AnAction> getExtraActions() {
                List<AnAction> list = Collections.singletonList(new MyEditSourceAction());
                if (list == null) {
                    4.$$$reportNull$$$0(0);
                }
                return list;
            }

            public void uiDataSnapshot(@NotNull DataSink sink, @NotNull List<DiagramNode<JSStructuralDiagramItem>> nodes, @NotNull DiagramBuilder builder2) {
                if (sink == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (nodes == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (builder2 == null) {
                    4.$$$reportNull$$$0(3);
                }
                sink.set(JSModulesDiagramUtils.DIAGRAM_BUILDER, (Object)builder2);
                DiagramNode single = (DiagramNode)ContainerUtil.getOnlyItem(nodes);
                sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
                    JSStructuralDiagramItem element2 = (JSStructuralDiagramItem)single.getIdentifyingElement();
                    SmartPsiElementPointer<PsiElement> target = element2.getElementPointer();
                    return target == null ? null : target.getElement();
                });
                sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
                    final JSStructuralDiagramItem element2 = (JSStructuralDiagramItem)single.getIdentifyingElement();
                    if (element2.getElementPointer() != null || !JSModulesDiagramUtils.startsWithHttpProtocol(element2.getName())) {
                        return null;
                    }
                    return new Navigatable(){

                        public void navigate(boolean requestFocus) {
                            BrowserUtil.open((String)element2.getName());
                        }

                        public boolean canNavigate() {
                            return true;
                        }

                        public boolean canNavigateToSource() {
                            return true;
                        }
                    };
                });
            }

            @NotNull
            public JComponent createNodeComponent(@NotNull DiagramNode<JSStructuralDiagramItem> node, @NotNull DiagramBuilder builder2, @NotNull NodeRealizer nodeRealizer, @NotNull JPanel wrapper) {
                if (node == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (builder2 == null) {
                    4.$$$reportNull$$$0(5);
                }
                if (nodeRealizer == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (wrapper == null) {
                    4.$$$reportNull$$$0(7);
                }
                DiagramNodeContainer container = new DiagramNodeContainer(node, builder2, nodeRealizer);
                if (!((JSStructuralDiagramItem)node.getIdentifyingElement()).getUsedExported().isEmpty()) {
                    container.getHeader().setBorder(JBUI.Borders.customLine((Color)Gray._190, (int)0, (int)0, (int)1, (int)0));
                }
                container.setForcedBackground((Color)JBColor.WHITE);
                DiagramNodeContainer diagramNodeContainer = container;
                if (diagramNodeContainer == null) {
                    4.$$$reportNull$$$0(8);
                }
                return diagramNodeContainer;
            }

            @NotNull
            public Layouter getCustomLayouter(GraphSettings settings, Project project) {
                SmartOrganicLayouter layouter = GraphLayoutService.getInstance().getOrganicLayouter();
                layouter.setNodeEdgeOverlapAvoided(true);
                layouter.setDeterministic(true);
                SmartOrganicLayouter smartOrganicLayouter = layouter;
                if (smartOrganicLayouter == null) {
                    4.$$$reportNull$$$0(9);
                }
                return smartOrganicLayouter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 4, 5, 6, 7 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sink";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nodes";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nodeRealizer";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wrapper";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExtraActions";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$4";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNodeComponent";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCustomLayouter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "uiDataSnapshot";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "createNodeComponent";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    public DiagramDataModel<JSStructuralDiagramItem> createDataModel(@NotNull Project project, @Nullable JSStructuralDiagramItem element2, @Nullable VirtualFile file, @NotNull DiagramPresentationModel presentationModel) {
        GlobalSearchScope scope2;
        if (project == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(12);
        }
        if (presentationModel == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(13);
        }
        if (element2 != null && !element2.getUsedExported().isEmpty()) {
            GlobalSearchScope current = GlobalSearchScope.EMPTY_SCOPE;
            for (JSStructuralDiagramItem item : element2.getUsedExported()) {
                PsiElement child;
                if (item.getElementPointer() == null || !((child = item.getElementPointer().getElement()) instanceof PsiFileSystemItem)) continue;
                if (child instanceof PsiDirectory) {
                    current = current.union((SearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)((PsiDirectory)child), (boolean)true));
                    continue;
                }
                if (!(child instanceof PsiFile)) continue;
                current = current.union((SearchScope)GlobalSearchScope.fileScope((PsiFile)((PsiFile)child)));
            }
            scope2 = current;
        } else if (element2 != null && element2.getElementPointer() != null) {
            PsiElement psiElement = element2.getElementPointer().getElement();
            if (psiElement instanceof PsiFileSystemItem) {
                scope2 = psiElement instanceof PsiDirectory ? GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)((PsiDirectory)psiElement).getVirtualFile(), (boolean)true) : (psiElement instanceof PsiFile ? GlobalSearchScope.fileScope((PsiFile)((PsiFile)psiElement)) : GlobalSearchScope.projectScope((Project)project));
            } else {
                PsiFile psiFile = element2.getElementPointer().getContainingFile();
                if (psiFile == null) {
                    if (null == null) {
                        JSModulesDiagramProvider.$$$reportNull$$$0(14);
                    }
                    return null;
                }
                scope2 = GlobalSearchScope.fileScope((Project)project, (VirtualFile)psiFile.getVirtualFile());
            }
        } else {
            scope2 = GlobalSearchScope.projectScope((Project)project);
        }
        JSModuleDependencyData data2 = new JSModuleDependencyData(project, scope2);
        data2.calculate();
        Pair<List<JSStructuralUiNode>, List<JSStructuralUiEdge>> nodesAndEdges = data2.getNodesAndEdges(this);
        return new JSStructuralDiagramModel(project, this, (List)nodesAndEdges.getFirst(), (List)nodesAndEdges.getSecond());
    }

    @NlsContexts.Label
    public static String getElementTitleStatic(JSStructuralDiagramItem element2) {
        if (element2 != null) {
            return JSModulesDiagramProvider.getElementNamePart(element2);
        }
        return "";
    }

    @NlsContexts.Label
    private static String getElementNamePart(JSStructuralDiagramItem element2) {
        SmartPsiElementPointer<PsiElement> pointer = element2.getElementPointer();
        if (pointer == null) {
            return JSModulesDiagramProvider.onlyName(element2);
        }
        PsiElement target = pointer.getElement();
        if (target instanceof PsiFile) {
            PsiFile file = (PsiFile)target;
            if (JSModulesDiagramUtils.startsWithHttpProtocol(element2.getName())) {
                return JSModulesDiagramProvider.onlyName(element2);
            }
            return JSModulesDiagramUtils.getFileNamePart(file);
        }
        return element2.getName();
    }

    @Nls
    private static String onlyName(JSStructuralDiagramItem element2) {
        String[] split = element2.getName().replace("\\", "/").split("/");
        return split.length == 0 ? element2.getName() : split[split.length - 1];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 9, 10, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeOneItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibilityManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVfsResolver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsJsOrTsFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPresentationModel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 9, 10, 11, 14 -> new IllegalStateException(string);
        };
    }

    private static class MyEditSourceAction
    extends AnAction {
        MyEditSourceAction() {
            super(JavaScriptBundle.message((String)"action.jump.to.text", (Object[])new Object[0]), JavaScriptBundle.message((String)"action.jump.to.text", (Object[])new Object[0]), AllIcons.Actions.EditSource);
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                MyEditSourceAction.$$$reportNull$$$0(0);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            List<DiagramNode<?>> nodes = JSModulesDiagramUtils.getSelectedNodes(e);
            e.getPresentation().setEnabled(nodes != null && nodes.size() == 1 && nodes.get(0) instanceof JSStructuralUiNode);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyEditSourceAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEditSourceAction.$$$reportNull$$$0(2);
            }
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            List<DiagramNode<?>> nodes = JSModulesDiagramUtils.getSelectedNodes(e);
            if (project == null || nodes == null || nodes.size() != 1 || !(nodes.get(0) instanceof JSStructuralUiNode)) {
                return;
            }
            JSStructuralDiagramItem main = (JSStructuralDiagramItem)nodes.get(0).getIdentifyingElement();
            List<JSStructuralDiagramItem> exported = main.getUsedExported();
            if (exported.isEmpty()) {
                return;
            }
            JSModulesDiagramUtils.showMembersSelectionPopup(StringUtil.notNullize((String)JSModulesDiagramProvider.getElementTitleStatic(main)), main.getElementPointer(), JSStructuralUiNode.calculateIcon(main), ContainerUtil.map(exported, el -> new JSModulesDiagramUtils.ChildData(StringUtil.notNullize((String)JSModulesDiagramProvider.getElementTitleStatic(el)), el.getElementPointer(), JSStructuralUiNode.calculateIcon(el))), e.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$MyEditSourceAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSModulesDiagramProvider$MyEditSourceAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Holder {
        static final DiagramCategory myAllCategory = new DiagramCategory(DiagramBundle.messagePointer((String)"category.name.all", (Object[])new Object[0]), null);

        private Holder() {
        }
    }
}

