/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.extensions;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.config.JSModuleResolution;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.imports.path.JSImportModulePathStrategy;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeImportModulePathStrategy
implements JSImportModulePathStrategy {
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable JSModuleNameInfo.ExtensionSettings getPathSettings(@NotNull PsiElement place, @NotNull String extensionWithDot, boolean auto) {
        if (place == null) {
            NodeImportModulePathStrategy.$$$reportNull$$$0(0);
        }
        if (extensionWithDot == null) {
            NodeImportModulePathStrategy.$$$reportNull$$$0(1);
        }
        if (!auto || !NodeImportModulePathStrategy.isModuleContext(place, extensionWithDot)) {
            return null;
        }
        if (!DialectDetector.isTypeScript((PsiElement)place)) {
            return JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile((PsiFile)place.getContainingFile());
        if (config == null) {
            return null;
        }
        JSModuleResolution moduleResolution = config.getEffectiveModuleResolution();
        if (moduleResolution != JSModuleResolution.NODENEXT) {
            return null;
        }
        boolean allowTsExtensions = config.allowImportingTsExtensions();
        return allowTsExtensions ? JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION : JSModuleNameInfo.ExtensionSettings.FORCE_JS_EXTENSION;
    }

    private static boolean isModuleContext(@NotNull PsiElement place, @NotNull String extensionWithDot) {
        PsiFile placeFile;
        if (place == null) {
            NodeImportModulePathStrategy.$$$reportNull$$$0(2);
        }
        if (extensionWithDot == null) {
            NodeImportModulePathStrategy.$$$reportNull$$$0(3);
        }
        if ((placeFile = place.getContainingFile()) == null) {
            return false;
        }
        String placeExtension = JSFileReferencesUtil.findImplicitExtension((String)placeFile.getName());
        if (".mjs".equals(extensionWithDot) || ".mjs".equals(placeExtension) && !ArrayUtil.contains((String)extensionWithDot, (String[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS)) {
            return true;
        }
        if (".mts".equals(extensionWithDot)) {
            return true;
        }
        if (".cts".equals(extensionWithDot)) {
            return true;
        }
        return NodeImportModulePathStrategy.isModuleType(place);
    }

    private static boolean isModuleType(@NotNull PsiElement place) {
        VirtualFile virtualFile;
        if (place == null) {
            NodeImportModulePathStrategy.$$$reportNull$$$0(4);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)place)) == null) {
            return false;
        }
        VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(virtualFile);
        if (packageJson == null) {
            return false;
        }
        PackageJsonData data2 = PackageJsonData.getOrCreate(packageJson);
        return data2.isModuleType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionWithDot";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/extensions/NodeImportModulePathStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isModuleContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isModuleType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

