/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.exceptions.UnexpectedDBException;
import com.intellij.database.remote.jdba.exceptions.UnexpectedReflectionException;
import com.intellij.database.remote.jdba.jdbc.JdbcRowFetcher;
import com.intellij.database.remote.jdba.jdbc.JdbcUtil;
import com.intellij.database.remote.jdba.jdbc.JdbcValueGetter;
import com.intellij.database.remote.jdba.jdbc.JdbcValueGetters;
import com.intellij.database.remote.jdba.util.NameAndClass;
import com.intellij.util.ArrayUtilRt;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public final class JdbcRowFetchers {
    public static <V> OneValueFetcher<V> createOneValueFetcher(int position, JdbcValueGetter<V> getter) {
        return new OneValueFetcher<V>(position, getter);
    }

    public static <V> ArrayFetcher<V> createArrayFetcher(int position, Class<V> commonClass, JdbcValueGetter<? extends V>[] getters) {
        return new ArrayFetcher(position, commonClass, getters);
    }

    public static IntArrayFetcher createIntArrayFetcher(int position) {
        return new IntArrayFetcher(position);
    }

    public static LongArrayFetcher createLongArrayFetcher(int position) {
        return new LongArrayFetcher(position);
    }

    public static TupleFetcher createTupleFetcher(NameAndClass[] components, boolean useLabels, boolean expandMaps) {
        return new TupleFetcher(components, useLabels, expandMaps);
    }

    public static TupleFetcher createTupleFetcher(NameAndClass[] components, boolean useLabels) {
        return JdbcRowFetchers.createTupleFetcher(components, useLabels, false);
    }

    public static <S> StructFetcher<S> createStructFetcher(Class<S> structClass, NameAndClass[] components, boolean useLabels, boolean expandMaps) {
        return new StructFetcher<S>(structClass, components, useLabels, expandMaps);
    }

    private static Field getClassField(@NotNull Class<?> structClass, String name) throws NoSuchFieldException {
        if (structClass == null) {
            JdbcRowFetchers.$$$reportNull$$$0(0);
        }
        return structClass.getDeclaredField(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structClass", "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers", "getClassField"));
    }

    public static final class OneValueFetcher<V>
    extends JdbcRowFetcher<V> {
        private final int position;
        private final JdbcValueGetter<V> getter;

        OneValueFetcher(int position, JdbcValueGetter<V> getter) {
            this.position = position;
            this.getter = getter;
        }

        @Override
        V fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (rset == null) {
                OneValueFetcher.$$$reportNull$$$0(0);
            }
            return this.getter.getValue(rset, this.position);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers$OneValueFetcher", "fetchRow"));
        }
    }

    public static final class ArrayFetcher<V>
    extends JdbcRowFetcher<V[]> {
        private final int position;
        private final Class<V> commonClass;
        private final JdbcValueGetter<? extends V>[] getters;

        private ArrayFetcher(int position, Class<V> commonClass, JdbcValueGetter<? extends V>[] getters) {
            this.position = position;
            this.commonClass = commonClass;
            this.getters = getters;
        }

        @Override
        V[] fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (rset == null) {
                ArrayFetcher.$$$reportNull$$$0(0);
            }
            int n = this.getters.length;
            Object[] array = (Object[])Array.newInstance(this.commonClass, n);
            for (int j = 0; j < n; ++j) {
                array[j] = this.getters[j].getValue(rset, this.position + j);
            }
            return array;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers$ArrayFetcher", "fetchRow"));
        }
    }

    public static final class IntArrayFetcher
    extends JdbcRowFetcher<int[]> {
        private final int position;
        private JdbcValueGetter<Integer>[] getters;

        private IntArrayFetcher(int position) {
            this.position = position;
        }

        private void init(@NotNull ResultSetMetaData md) throws SQLException {
            if (md == null) {
                IntArrayFetcher.$$$reportNull$$$0(0);
            }
            int n = Math.max(md.getColumnCount() - (this.position - 1), 0);
            this.getters = new JdbcValueGetter[n];
            for (int i = 0; i < n; ++i) {
                int jdbcType = md.getColumnType(this.position + i);
                JdbcValueGetter<Integer> valueGetter = JdbcValueGetters.of(jdbcType, Integer.TYPE);
                this.getters[i] = valueGetter;
            }
        }

        @Override
        int[] fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (rset == null) {
                IntArrayFetcher.$$$reportNull$$$0(1);
            }
            if (this.getters == null) {
                this.init(rset.getMetaData());
            }
            int n = this.getters.length;
            int[] array = new int[n];
            for (int j = 0; j < n; ++j) {
                Integer value = this.getters[j].getValue(rset, this.position + j);
                array[j] = value == null ? 0 : value;
            }
            return array;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "md";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rset";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers$IntArrayFetcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "init";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchRow";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class LongArrayFetcher
    extends JdbcRowFetcher<long[]> {
        private final int position;
        private JdbcValueGetter<Long>[] getters;

        private LongArrayFetcher(int position) {
            this.position = position;
        }

        private void init(@NotNull ResultSetMetaData md) throws SQLException {
            if (md == null) {
                LongArrayFetcher.$$$reportNull$$$0(0);
            }
            int n = Math.max(md.getColumnCount() - (this.position - 1), 0);
            this.getters = new JdbcValueGetter[n];
            for (int i = 0; i < n; ++i) {
                int jdbcType = md.getColumnType(this.position + i);
                JdbcValueGetter<Long> valueGetter = JdbcValueGetters.of(jdbcType, Long.TYPE);
                this.getters[i] = valueGetter;
            }
        }

        @Override
        long[] fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (rset == null) {
                LongArrayFetcher.$$$reportNull$$$0(1);
            }
            if (this.getters == null) {
                this.init(rset.getMetaData());
            }
            int n = this.getters.length;
            long[] array = new long[n];
            for (int j = 0; j < n; ++j) {
                Long value = this.getters[j].getValue(rset, this.position + j);
                array[j] = value == null ? 0L : value;
            }
            return array;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "md";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rset";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers$LongArrayFetcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "init";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchRow";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class TupleFetcher
    extends ComplexFetcher<Object[]> {
        public TupleFetcher(@NotNull @NotNull NameAndClass @NotNull [] components, boolean useLabels, boolean expandMaps) {
            if (components == null) {
                TupleFetcher.$$$reportNull$$$0(0);
            }
            super(components, useLabels, expandMaps);
        }

        @Override
        protected Object @NotNull [] instantiate() {
            return new Object[this.components.length];
        }

        @Override
        protected void assign(Object @NotNull [] res, int idx, Object val) {
            if (res == null) {
                TupleFetcher.$$$reportNull$$$0(1);
            }
            res[idx] = val;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "res";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers$TupleFetcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assign";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class StructFetcher<S>
    extends ComplexFetcher<S> {
        private final Class<S> structClass;
        private final Constructor<S> structConstructor;
        private final Field[] fields;

        public StructFetcher(@NotNull Class<S> structClass, @NotNull @NotNull NameAndClass @NotNull [] components, boolean useLabels, boolean expandMaps) {
            if (structClass == null) {
                StructFetcher.$$$reportNull$$$0(0);
            }
            if (components == null) {
                StructFetcher.$$$reportNull$$$0(1);
            }
            super(components, useLabels, expandMaps);
            this.structClass = structClass;
            int n = components.length;
            this.fields = new Field[n];
            try {
                this.structConstructor = structClass.getDeclaredConstructor(new Class[0]);
                this.structConstructor.setAccessible(true);
                for (int i = 0; i < n; ++i) {
                    String name = components[i].name;
                    Field f = JdbcRowFetchers.getClassField(structClass, name);
                    f.setAccessible(true);
                    this.fields[i] = f;
                }
            }
            catch (Exception e) {
                throw new UnexpectedReflectionException("Failed to analyze class " + structClass.getName(), e);
            }
        }

        @Override
        @NotNull
        protected S instantiate() {
            S s;
            try {
                s = this.structConstructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new UnexpectedReflectionException("Failed to create class " + this.structClass, e);
            }
            if (s == null) {
                StructFetcher.$$$reportNull$$$0(2);
            }
            return s;
        }

        @Override
        protected void assign(@NotNull S res, int idx, Object val) {
            Field f;
            if (res == null) {
                StructFetcher.$$$reportNull$$$0(3);
            }
            if ((f = this.fields[idx]) == null) {
                return;
            }
            if (val != null) {
                try {
                    f.set(res, val);
                }
                catch (ReflectiveOperationException e) {
                    throw new UnexpectedReflectionException("Failed to populate class " + this.structClass, e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers$StructFetcher";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "res";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers$StructFetcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "assign";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ComplexFetcher<X>
    extends JdbcRowFetcher<X> {
        protected final NameAndClass[] components;
        protected final int[] columnIndices;
        protected final JdbcValueGetter<?>[] getters;
        protected int[] unassignedRsColumns;
        protected boolean myRequiresInit;
        protected boolean myUseLabels;

        public ComplexFetcher(@NotNull @NotNull NameAndClass @NotNull [] components, boolean useLabels, boolean expandMaps) {
            if (components == null) {
                ComplexFetcher.$$$reportNull$$$0(0);
            }
            this.myRequiresInit = true;
            this.components = components;
            this.myUseLabels = useLabels;
            int n = components.length;
            this.columnIndices = new int[n];
            this.getters = new JdbcValueGetter[n];
            if (!expandMaps) {
                this.unassignedRsColumns = ArrayUtilRt.EMPTY_INT_ARRAY;
            }
        }

        protected void initGetters(@NotNull ResultSetMetaData md) {
            if (md == null) {
                ComplexFetcher.$$$reportNull$$$0(1);
            }
            try {
                String name;
                int n = this.components.length;
                TreeMap<String, Integer> columnNames = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
                int cn = md.getColumnCount();
                for (int j = 1; j <= cn; ++j) {
                    name = JdbcUtil.getColumnName(md, j, this.myUseLabels);
                    columnNames.put(name, j);
                }
                boolean hasUnassignedColumns = false;
                for (int i = 0; i < n; ++i) {
                    name = this.components[i].name;
                    Integer columnIndex = (Integer)columnNames.remove(name);
                    if (columnIndex == null) {
                        hasUnassignedColumns = true;
                        continue;
                    }
                    int jdbcType = md.getColumnType(columnIndex);
                    JdbcValueGetter<?> valueGetter = JdbcValueGetters.of(jdbcType, this.components[i].clazz);
                    this.columnIndices[i] = columnIndex;
                    this.getters[i] = valueGetter;
                }
                if (hasUnassignedColumns && this.unassignedRsColumns == null) {
                    this.unassignedRsColumns = new int[columnNames.size()];
                    int idx = 0;
                    for (Integer rsIdx : columnNames.values()) {
                        this.unassignedRsColumns[idx++] = rsIdx;
                    }
                }
            }
            catch (SQLException sqle) {
                throw new UnexpectedDBException("Analysing metadata of the query result", sqle, null);
            }
            this.myRequiresInit = false;
        }

        @Override
        X fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (rset == null) {
                ComplexFetcher.$$$reportNull$$$0(2);
            }
            if (this.myRequiresInit) {
                this.initGetters(rset.getMetaData());
            }
            X res = this.instantiate();
            int n = this.columnIndices.length;
            for (int i = 0; i < n; ++i) {
                int columnIndex = this.columnIndices[i];
                JdbcValueGetter<?> g = this.getters[i];
                if (columnIndex <= 0 || g == null) continue;
                Object value = g.getValue(rset, columnIndex);
                this.assign(res, i, value);
            }
            this.expandMapColumns(rset, res);
            return res;
        }

        private void expandMapColumns(@NotNull ResultSet rset, X res) throws SQLException {
            if (rset == null) {
                ComplexFetcher.$$$reportNull$$$0(3);
            }
            if (this.unassignedRsColumns == null) {
                return;
            }
            for (int rsColumn : this.unassignedRsColumns) {
                Object object = rset.getObject(rsColumn);
                if (!(object instanceof Map)) continue;
                int n = this.columnIndices.length;
                for (int i = 0; i < n; ++i) {
                    int columnIndex = this.columnIndices[i];
                    JdbcValueGetter<?> g = this.getters[i];
                    if (columnIndex > 0 || g != null) continue;
                    Object value = ((Map)object).get(this.components[i].name);
                    this.assign(res, i, value);
                }
            }
        }

        @NotNull
        protected abstract X instantiate();

        protected abstract void assign(@NotNull X var1, int var2, Object var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "md";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rset";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcRowFetchers$ComplexFetcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initGetters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchRow";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expandMapColumns";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

