/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.RemoteJdbcServer;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JdbcClassLoader {
    private static final Class<?> mainClass = RemoteJdbcServer.class;

    public static ClassLoader getClassLoader(List<String> cp) {
        return JdbcClassLoader.createJdbcClassLoader(cp);
    }

    @NotNull
    private static ClassLoader createJdbcClassLoader(List<String> cp) {
        ClassLoader appLoader = Thread.currentThread().getContextClassLoader();
        if (cp == null || cp.isEmpty()) {
            ClassLoader classLoader = appLoader;
            if (classLoader == null) {
                JdbcClassLoader.$$$reportNull$$$0(0);
            }
            return classLoader;
        }
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        ClassLoader platformOrExt = systemLoader.getParent();
        if (platformOrExt == null) {
            JdbcNativeUtil.logInfo("Failed to isolate classpath. No parent for " + systemLoader);
            ClassLoader classLoader = appLoader;
            if (classLoader == null) {
                JdbcClassLoader.$$$reportNull$$$0(1);
            }
            return classLoader;
        }
        JdbcNativeUtil.logInfo("Using classpath: " + cp + "\n\tand base loader " + platformOrExt);
        return new JdbcClassLoaderImpl(platformOrExt, appLoader, JdbcClassLoader.parseClassPath(cp));
    }

    private static URL @NotNull [] parseClassPath(List<String> cp) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String path : cp) {
                urls.add(new File(path).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to parse JDBC classpath", e);
        }
        URL[] uRLArray = urls.toArray(new URL[0]);
        if (uRLArray == null) {
            JdbcClassLoader.$$$reportNull$$$0(2);
        }
        return uRLArray;
    }

    public static ClassLoader createAppAndJdbcClassLoader(final ClassLoader classLoader) {
        return new ClassLoader(){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                return classLoader.loadClass(name);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/remote/jdbc/impl/JdbcClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createJdbcClassLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassPath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class JdbcClassLoaderImpl
    extends URLClassLoader {
        private final ClassLoader myAppLoader;

        private JdbcClassLoaderImpl(ClassLoader cleanClassLoader, ClassLoader appLoader, URL @NotNull [] urls) {
            if (urls == null) {
                JdbcClassLoaderImpl.$$$reportNull$$$0(0);
            }
            super(urls, cleanClassLoader);
            this.myAppLoader = appLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (JdbcClassLoaderImpl.shareWithJdbc(name)) {
                return this.myAppLoader.loadClass(name);
            }
            return super.findClass(name);
        }

        private static boolean shareWithJdbc(String name) {
            if (mainClass.getName().equals(name)) {
                return true;
            }
            return name.startsWith("com.intellij.execution.rmi.ssl.") || name.startsWith("com.intellij.database.remote.jdbc.helpers.RemoteLogHelper");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/database/remote/jdbc/impl/JdbcClassLoader$JdbcClassLoaderImpl", "<init>"));
        }
    }
}

