/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.javascript.karma.execution.KarmaConfigurationType;
import com.intellij.javascript.karma.execution.KarmaDetector;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KarmaRunConfigurationProducer
extends JsTestRunConfigurationProducer<KarmaRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        KarmaConfigurationType karmaConfigurationType = KarmaConfigurationType.getInstance();
        if (karmaConfigurationType == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return karmaConfigurationType;
    }

    public KarmaDetector getTestFrameworkDetector() {
        return KarmaDetector.Companion.getInstance();
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull KarmaRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement element;
        if (configuration == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = context.getPsiLocation()) == null || !this.isTestRunnerAvailableFor(element, context)) {
            return false;
        }
        Pair<KarmaRunSettings, PsiElement> pair = KarmaRunConfigurationProducer.setup(element, configuration.getRunSettings());
        if (pair != null) {
            configuration.setRunSettings((KarmaRunSettings)pair.getFirst());
            sourceElement.set((Object)((PsiElement)pair.getSecond()));
            configuration.setGeneratedName();
            configuration.onNewConfigurationCreated();
            return true;
        }
        return false;
    }

    @Nullable
    private static Pair<KarmaRunSettings, PsiElement> setup(@Nullable PsiElement element, @NotNull KarmaRunSettings templateSettings) {
        Pair<KarmaRunSettings, PsiElement> suiteOrTestConfiguration;
        JSFile file;
        VirtualFile virtualFile;
        if (templateSettings == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)(file = (JSFile)ObjectUtils.tryCast((Object)(element != null ? element.getContainingFile() : null), JSFile.class)))) == null) {
            return null;
        }
        if (!(element instanceof PsiFileSystemItem) && (suiteOrTestConfiguration = KarmaRunConfigurationProducer.setupAsSuiteOrTest(file, virtualFile, element, templateSettings)) != null) {
            return suiteOrTestConfiguration;
        }
        if (KarmaUtil.isKarmaConfigFile(virtualFile.getNameSequence(), false)) {
            return Pair.create((Object)templateSettings.toBuilder().setScopeKind(KarmaScopeKind.ALL).setConfigPath(virtualFile.getPath()).build(), (Object)file);
        }
        if (KarmaDetector.Companion.getInstance().hasTestsInFile(file)) {
            KarmaRunSettings settings = KarmaRunConfigurationProducer.guessConfigFileIfNeeded(templateSettings, virtualFile, element.getProject());
            return Pair.create((Object)settings.toBuilder().setScopeKind(KarmaScopeKind.TEST_FILE).setTestFilePath(virtualFile.getPath()).build(), (Object)file);
        }
        return null;
    }

    @Nullable
    private static Pair<KarmaRunSettings, PsiElement> setupAsSuiteOrTest(@NotNull JSFile file, @NotNull VirtualFile virtualFile, @NotNull PsiElement element, @NotNull KarmaRunSettings templateSettings) {
        TextRange textRange;
        if (file == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (element == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (templateSettings == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if ((textRange = element.getTextRange()) == null || !file.isTestFile()) {
            return null;
        }
        AbstractTestFileStructure testsStructure = KarmaDetector.Companion.getInstance().findTestsStructure(file);
        if (testsStructure == null) {
            return null;
        }
        JsTestElementPath path = testsStructure.findTestElementPath(textRange);
        if (path != null) {
            templateSettings = KarmaRunConfigurationProducer.guessConfigFileIfNeeded(templateSettings, virtualFile, element.getProject());
            KarmaRunSettings.Builder builder = templateSettings.toBuilder();
            builder.setTestFilePath(virtualFile.getPath());
            String testName = path.getTestName();
            if (testName == null) {
                builder.setScopeKind(KarmaScopeKind.SUITE);
                builder.setTestNames(path.getSuiteNames());
            } else {
                builder.setScopeKind(KarmaScopeKind.TEST);
                builder.setTestNames(path.getAllNames());
            }
            return Pair.create((Object)builder.build(), (Object)path.getTestElement());
        }
        return null;
    }

    @NotNull
    private static KarmaRunSettings guessConfigFileIfNeeded(@NotNull KarmaRunSettings settings, @NotNull VirtualFile contextFile, @NotNull Project project) {
        VirtualFile dir;
        if (settings == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (contextFile == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (project == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (!settings.getConfigPathSystemDependent().isEmpty()) {
            KarmaRunSettings karmaRunSettings = settings;
            if (karmaRunSettings == null) {
                KarmaRunConfigurationProducer.$$$reportNull$$$0(12);
            }
            return karmaRunSettings;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile virtualFile = dir = contextFile.isDirectory() ? contextFile : contextFile.getParent();
        if (dir == null) {
            KarmaRunSettings karmaRunSettings = settings;
            if (karmaRunSettings == null) {
                KarmaRunConfigurationProducer.$$$reportNull$$$0(13);
            }
            return karmaRunSettings;
        }
        VirtualFile contentRoot = fileIndex.getContentRootForFile(dir, false);
        while (dir != null && contentRoot != null) {
            VirtualFile[] children;
            for (VirtualFile child : children = dir.getChildren()) {
                if (!KarmaUtil.isKarmaConfigFile(child.getNameSequence(), true)) continue;
                KarmaRunSettings karmaRunSettings = settings.toBuilder().setConfigPath(child.getPath()).build();
                if (karmaRunSettings == null) {
                    KarmaRunConfigurationProducer.$$$reportNull$$$0(14);
                }
                return karmaRunSettings;
            }
            if (dir.equals(contentRoot)) {
                dir = dir.getParent();
                contentRoot = fileIndex.getContentRootForFile(dir, false);
                continue;
            }
            dir = dir.getParent();
        }
        KarmaRunSettings karmaRunSettings = settings;
        if (karmaRunSettings == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        return karmaRunSettings;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull KarmaRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (context == null) {
            KarmaRunConfigurationProducer.$$$reportNull$$$0(17);
        }
        KarmaRunSettings confSettings = configuration.getRunSettings();
        Pair<KarmaRunSettings, PsiElement> data = KarmaRunConfigurationProducer.setup(context.getPsiLocation(), confSettings);
        return data != null && confSettings.equals(data.first);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        PreferableRunConfiguration otherRc;
        PsiFile psiFile = self.getSourceElement().getContainingFile();
        return psiFile == null || other == null || (otherRc = (PreferableRunConfiguration)ObjectUtils.tryCast((Object)other.getConfiguration(), PreferableRunConfiguration.class)) == null || !otherRc.isPreferredOver(self.getConfiguration(), (PsiElement)psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunConfigurationProducer";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunConfigurationProducer";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "guessConfigFileIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromCompatibleContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setup";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupAsSuiteOrTest";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "guessConfigFileIfNeeded";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromCompatibleContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

