/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.python;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class PyFileReferenceContext {
    private final QualifiedName fileLocalSymbol;
    private final PyFile file;

    private PyFileReferenceContext(PyFile file, QualifiedName fileLocalSymbol) {
        this.file = file;
        this.fileLocalSymbol = fileLocalSymbol;
    }

    @Nullable
    static PyFileReferenceContext findContext(PsiElement pyElement) {
        PyReferenceExpression referenceExpression = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)pyElement, PyReferenceExpression.class);
        ArrayList<String> reversedQualifiers = new ArrayList<String>();
        while (referenceExpression != null) {
            PsiFile resolvedFile;
            PsiElement resolved = referenceExpression.getReference().resolve();
            if (resolved instanceof PyFile) {
                return new PyFileReferenceContext((PyFile)resolved, QualifiedName.fromComponents((Collection)Lists.reverse(reversedQualifiers)));
            }
            String refName = referenceExpression.getReferencedName();
            if (refName == null) {
                return null;
            }
            reversedQualifiers.add(refName);
            PyExpression qualifier = referenceExpression.getQualifier();
            if (qualifier == null && resolved != null && (resolvedFile = resolved.getContainingFile()) instanceof PyFile) {
                return new PyFileReferenceContext((PyFile)resolvedFile, QualifiedName.fromComponents((Collection)Lists.reverse(reversedQualifiers)));
            }
            if (!(qualifier instanceof PyReferenceExpression)) {
                return null;
            }
            referenceExpression = (PyReferenceExpression)qualifier;
        }
        return null;
    }

    PyFile getFile() {
        return this.file;
    }

    QualifiedName getFileLocalSymbol() {
        return this.fileLocalSymbol;
    }
}

