/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.shared.gencode;

import com.google.common.collect.ImmutableList;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.resolve.PbFileResolver;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public final class ProtoFromSourceComments {
    private static final List<String> GENERATED_COMMENTS = ImmutableList.of((Object)"Generated by the protocol buffer compiler.  DO NOT EDIT!", (Object)"Code generated by protoc-gen-go. DO NOT EDIT.", (Object)"Code generated by protoc-gen-gogo. DO NOT EDIT.");
    private static final Pattern SOURCE_PATTERN = Pattern.compile(".* source: (.*\\.proto)$");

    private ProtoFromSourceComments() {
    }

    @Nullable
    public static PbFile findProtoOfGeneratedCode(String commentPrefix, PsiFile file) {
        boolean foundGeneratedComment = false;
        String source = null;
        PsiElement element = file.getFirstChild();
        while (ProtoFromSourceComments.isWhitespaceOrComment(element)) {
            if (ProtoFromSourceComments.isGeneratedComment(element)) {
                foundGeneratedComment = true;
            } else {
                String extractedSource = ProtoFromSourceComments.extractSource(element);
                if (extractedSource != null) {
                    source = extractedSource;
                    break;
                }
            }
            element = element.getNextSibling();
        }
        if (!foundGeneratedComment || source == null) {
            return null;
        }
        List<PbFile> pbFiles = PbFileResolver.findFilesForContext(source, (PsiElement)file);
        if (!pbFiles.isEmpty()) {
            return pbFiles.get(0);
        }
        return null;
    }

    private static boolean isGeneratedComment(PsiElement element) {
        String text = element.getText();
        for (String alt : GENERATED_COMMENTS) {
            if (!text.contains(alt)) continue;
            return true;
        }
        return false;
    }

    private static String extractSource(PsiElement element) {
        Matcher matcher = SOURCE_PATTERN.matcher(element.getText());
        return matcher.matches() ? matcher.group(1) : null;
    }

    private static boolean isWhitespaceOrComment(@Nullable PsiElement node) {
        return node instanceof PsiWhiteSpace || node instanceof PsiComment;
    }
}

