/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.view.dblookup.models;

import com.intellij.code.provenance.dev.ProvenanceDevBundle;
import com.intellij.code.provenance.dev.view.dblookup.models.InspectionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0014\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u000eJ\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0012\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/code/provenance/dev/view/dblookup/models/DatabaseLookupTableModel;", "Ljavax/swing/table/AbstractTableModel;", "<init>", "()V", "rows", "", "Lcom/intellij/code/provenance/dev/view/dblookup/models/InspectionResult;", "columnNames", "", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "[Ljava/lang/String;", "getRowCount", "", "getColumnCount", "getColumnName", "column", "getValueAt", "", "rowIndex", "columnIndex", "getColumnClass", "Ljava/lang/Class;", "setRows", "", "newRows", "", "getRowData", "formatKey", "key", "intellij.code.provenance.dev"})
public final class DatabaseLookupTableModel
extends AbstractTableModel {
    @NotNull
    private final List<InspectionResult> rows = new ArrayList();
    @NotNull
    private final String[] columnNames;

    public DatabaseLookupTableModel() {
        String[] stringArray = new String[]{ProvenanceDevBundle.INSTANCE.message("provenance.dev.db.column.index", new Object[0]), ProvenanceDevBundle.INSTANCE.message("provenance.dev.db.column.key", new Object[0]), ProvenanceDevBundle.INSTANCE.message("provenance.dev.db.column.value", new Object[0]), ProvenanceDevBundle.INSTANCE.message("provenance.dev.db.column.entryid", new Object[0])};
        this.columnNames = stringArray;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object object;
        if (rowIndex >= this.rows.size()) {
            return null;
        }
        InspectionResult row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                object = rowIndex + 1;
                break;
            }
            case 1: {
                object = this.formatKey(row.getKey());
                break;
            }
            case 2: {
                object = row.getPreview();
                break;
            }
            case 3: {
                InspectionResult inspectionResult = row;
                if (inspectionResult instanceof InspectionResult.ReferenceResult) {
                    object = String.valueOf(((InspectionResult.ReferenceResult)row).getEntryId());
                    break;
                }
                if (inspectionResult instanceof InspectionResult.EntryResult) {
                    Object object2 = ((InspectionResult.EntryResult)row).getKey();
                    object = object2 instanceof Long ? (Long)object2 : null;
                    if (object != null && (object = String.valueOf((Long)object)) != null) break;
                    object = "-";
                    break;
                }
                if (inspectionResult instanceof InspectionResult.MetadataResult) {
                    Object object3 = ((InspectionResult.MetadataResult)row).getKey();
                    object = object3 instanceof Long ? (Long)object3 : null;
                    if (object != null && (object = String.valueOf((Long)object)) != null) break;
                    object = "-";
                    break;
                }
                if (inspectionResult instanceof InspectionResult.FilePathResult) {
                    object = String.valueOf(((InspectionResult.FilePathResult)row).getHash());
                    break;
                }
                if (inspectionResult instanceof InspectionResult.ErrorResult) {
                    object = "-";
                    break;
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Integer.class : String.class;
    }

    public final void setRows(@NotNull List<? extends InspectionResult> newRows) {
        Intrinsics.checkNotNullParameter(newRows, (String)"newRows");
        this.rows.clear();
        this.rows.addAll((Collection<InspectionResult>)newRows);
        this.fireTableDataChanged();
    }

    @Nullable
    public final InspectionResult getRowData(int rowIndex) {
        return (InspectionResult)CollectionsKt.getOrNull(this.rows, (int)rowIndex);
    }

    private final String formatKey(Object key) {
        Object object = key;
        return object instanceof Long ? String.valueOf(((Number)key).longValue()) : (object instanceof String ? (((String)key).length() > 50 ? StringsKt.take((String)((String)key), (int)50) + "..." : (String)key) : key.toString());
    }
}

