/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.welcome;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.api.XLocalAttachProfiler;
import com.intellij.profiler.api.monitor.CpuAndMemoryError;
import com.intellij.profiler.api.monitor.CpuAndMemoryPanel;
import com.intellij.profiler.api.monitor.JMXProcessMonitor;
import com.intellij.profiler.statistics.CaptureMemorySnapshotOrigin;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.JavaLocalAttachProfilerProvider;
import com.intellij.profiler.ultimate.JavaTargetProcess;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.welcome.CpuAndMemoryTab;
import com.intellij.profiler.ultimate.welcome.actions.CaptureMemorySnapshot;
import com.intellij.profiler.ultimate.welcome.actions.DumpThreads;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/profiler/ultimate/welcome/CpuAndMemoryTab;", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "Lcom/intellij/openapi/Disposable;", "targetProcess", "Lcom/intellij/profiler/ultimate/JavaTargetProcess;", "shortName", "", "<init>", "(Lcom/intellij/profiler/ultimate/JavaTargetProcess;Ljava/lang/String;)V", "getTargetProcess", "()Lcom/intellij/profiler/ultimate/JavaTargetProcess;", "getShortName", "()Ljava/lang/String;", "panel", "Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel;", "toolbar", "Ljavax/swing/JComponent;", "addAll", "", "createActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createRunProfilerActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "PerformGCAction", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nCpuAndMemoryTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuAndMemoryTab.kt\ncom/intellij/profiler/ultimate/welcome/CpuAndMemoryTab\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,166:1\n13#2:167\n*S KotlinDebug\n*F\n+ 1 CpuAndMemoryTab.kt\ncom/intellij/profiler/ultimate/welcome/CpuAndMemoryTab\n*L\n60#1:167\n*E\n"})
public final class CpuAndMemoryTab
extends JBPanelWithEmptyText
implements Disposable {
    @NotNull
    private final JavaTargetProcess targetProcess;
    @NotNull
    private final String shortName;
    @NotNull
    private final CpuAndMemoryPanel panel;
    @NotNull
    private final JComponent toolbar;

    /*
     * WARNING - void declaration
     */
    public CpuAndMemoryTab(@NotNull JavaTargetProcess targetProcess, @NotNull String shortName) {
        void it;
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        super((LayoutManager)new BorderLayout());
        this.targetProcess = targetProcess;
        this.shortName = shortName;
        this.panel = new CpuAndMemoryPanel(this.targetProcess.getPid());
        DefaultActionGroup actions = this.createActions();
        ActionToolbar actionToolbar2 = actionToolbar = ActionManager.getInstance().createActionToolbar("CpuAndMemoryToolbar", (ActionGroup)actions, false);
        CpuAndMemoryTab cpuAndMemoryTab = this;
        boolean bl = false;
        it.setTargetComponent((JComponent)this.panel);
        JComponent jComponent = actionToolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        cpuAndMemoryTab.toolbar = jComponent;
        this.panel.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)0));
        this.addAll();
        this.panel.setErrorHandler((arg_0, arg_1) -> CpuAndMemoryTab._init_$lambda$1(this, arg_0, arg_1));
        this.panel.restart();
    }

    @NotNull
    public final JavaTargetProcess getTargetProcess() {
        return this.targetProcess;
    }

    @NotNull
    public final String getShortName() {
        return this.shortName;
    }

    private final void addAll() {
        this.add((Component)this.panel, "Center");
        this.add(this.toolbar, "West");
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultActionGroup createActions() {
        void $this$createActions_u24lambda_u240_u241_u240;
        void $this$createActions_u24lambda_u240_u241;
        DefaultActionGroup $this$createActions_u24lambda_u240_u240;
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2;
        DefaultActionGroup $this$createActions_u24lambda_u240 = defaultActionGroup2 = new DefaultActionGroup();
        boolean bl = false;
        DefaultActionGroup defaultActionGroup3 = defaultActionGroup = new DefaultActionGroup();
        DefaultActionGroup defaultActionGroup4 = $this$createActions_u24lambda_u240;
        boolean bl2 = false;
        $this$createActions_u24lambda_u240_u240.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
        $this$createActions_u24lambda_u240_u240.getTemplatePresentation().setText(CommonProfilerBundleKt.profilerMessage((String)"settings.callTree.viewSettings", (Object[])new Object[0]));
        $this$createActions_u24lambda_u240_u240.setPopup(true);
        Object object = UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.charts.showAll", new Object[0]);
        $this$createActions_u24lambda_u240_u240.add((AnAction)new DumbAwareToggleAction(this, (String)object){
            final /* synthetic */ CpuAndMemoryTab this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return CpuAndMemoryTab.access$getPanel$p(this.this$0).getSeconds() == -1;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CpuAndMemoryTab.access$getPanel$p(this.this$0).setSeconds(0);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        });
        object = UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.charts.lastMinute", new Object[0]);
        $this$createActions_u24lambda_u240_u240.add((AnAction)new DumbAwareToggleAction(this, (String)object){
            final /* synthetic */ CpuAndMemoryTab this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return CpuAndMemoryTab.access$getPanel$p(this.this$0).getSeconds() == 60;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CpuAndMemoryTab.access$getPanel$p(this.this$0).setSeconds(60);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        });
        object = UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.charts.lastFiveMinute", new Object[0]);
        $this$createActions_u24lambda_u240_u240.add((AnAction)new DumbAwareToggleAction(this, (String)object){
            final /* synthetic */ CpuAndMemoryTab this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return CpuAndMemoryTab.access$getPanel$p(this.this$0).getSeconds() == 300;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CpuAndMemoryTab.access$getPanel$p(this.this$0).setSeconds(300);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        });
        $this$createActions_u24lambda_u240_u240.addSeparator();
        object = UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.charts.clear", new Object[0]);
        $this$createActions_u24lambda_u240_u240.add((AnAction)new DumbAwareAction(this, (String)object){
            final /* synthetic */ CpuAndMemoryTab this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CpuAndMemoryTab.access$getPanel$p(this.this$0).clear();
            }
        });
        defaultActionGroup4.add((AnAction)defaultActionGroup);
        $this$createActions_u24lambda_u240.add(this.createRunProfilerActions());
        $this$createActions_u24lambda_u240_u240 = defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup4 = $this$createActions_u24lambda_u240;
        boolean bl3 = false;
        $this$createActions_u24lambda_u240_u241.getTemplatePresentation().setIcon(AllIcons.Actions.Dump);
        $this$createActions_u24lambda_u240_u241.setPopup(true);
        Object object2 = object = new CaptureMemorySnapshot(this){
            final /* synthetic */ CpuAndMemoryTab this$0;
            {
                this.this$0 = $receiver;
            }

            public int getProcessId(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.this$0.getTargetProcess().getPid();
            }

            public String getExecutableName(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.this$0.getTargetProcess().getProcessInfo().getExecutableName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableName(...)");
                return string;
            }

            public String getApplicationName(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.this$0.getShortName();
            }

            public void afterDumpCreated(Project project, File file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ProfilerUsageTriggerCollector.logMemorySnapshotGenerated((Project)project, (long)file.length(), (CaptureMemorySnapshotOrigin)CaptureMemorySnapshotOrigin.CPU_MEMORY_TAB);
                ImportProfilerResultAction.Companion.importProfilerDump$default((ImportProfilerResultAction.Companion)ImportProfilerResultAction.Companion, (Project)project, (File)file, null, null, null, null, (int)60, null);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(CpuAndMemoryTab.access$getPanel$p(this.this$0).isEnabled());
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        void var10_10 = $this$createActions_u24lambda_u240_u241;
        boolean bl4 = false;
        $this$createActions_u24lambda_u240_u241_u240.getTemplatePresentation().setIcon(null);
        var10_10.add((AnAction)object);
        $this$createActions_u24lambda_u240_u241.add((AnAction)new DumpThreads(this){
            final /* synthetic */ CpuAndMemoryTab this$0;
            {
                this.this$0 = $receiver;
            }

            public JavaTargetProcess getJavaProcess(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.this$0.getTargetProcess();
            }
        });
        defaultActionGroup4.add((AnAction)defaultActionGroup);
        $this$createActions_u24lambda_u240.add((AnAction)new PerformGCAction());
        return defaultActionGroup2;
    }

    private final AnAction createRunProfilerActions() {
        return (AnAction)new DefaultActionGroup(this){
            final /* synthetic */ CpuAndMemoryTab this$0;
            {
                this.this$0 = $receiver;
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Profile);
                this.getTemplatePresentation().setText(CommonProfilerBundleKt.commonProfilerMessage((String)"run.profiler.action", (Object[])new Object[0]));
                this.setPopup(true);
            }

            /*
             * WARNING - void declaration
             */
            public AnAction[] getChildren(AnActionEvent e) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = JavaLocalAttachProfilerProvider.Companion.profilersFactory$intellij_profiler_ultimate(this.this$0.getTargetProcess());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    XLocalAttachProfiler xLocalAttachProfiler = (XLocalAttachProfiler)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"com/intellij/profiler/ultimate/welcome/CpuAndMemoryTab$createRunProfilerActions$1$getChildren$MyAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "attach", "Lcom/intellij/profiler/api/XLocalAttachProfiler;", "<init>", "(Lcom/intellij/profiler/api/XLocalAttachProfiler;)V", "getAttach", "()Lcom/intellij/profiler/api/XLocalAttachProfiler;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.profiler.ultimate"})
                    @SourceDebugExtension(value={"SMAP\nCpuAndMemoryTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuAndMemoryTab.kt\ncom/intellij/profiler/ultimate/welcome/CpuAndMemoryTab$createRunProfilerActions$1$getChildren$MyAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
                    public final class MyAction
                    extends DumbAwareAction {
                        private final XLocalAttachProfiler attach;

                        public MyAction(XLocalAttachProfiler attach2) {
                            Intrinsics.checkNotNullParameter((Object)attach2, (String)"attach");
                            super(attach2.getProfilerDisplayName());
                            this.attach = attach2;
                        }

                        public final XLocalAttachProfiler getAttach() {
                            return this.attach;
                        }

                        public void actionPerformed(AnActionEvent e) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                Project project = e.getProject();
                                if (project == null) break block0;
                                Project project2 = project;
                                XLocalAttachProfiler xLocalAttachProfiler = this.attach;
                                Project p0 = project2;
                                boolean bl = false;
                                XLocalAttachProfiler.attachProfilerSession$default((XLocalAttachProfiler)xLocalAttachProfiler, (Project)p0, null, (int)2, null);
                            }
                        }
                    }
                    collection.add(new MyAction((XLocalAttachProfiler)p0));
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new AnAction[0]);
            }
        };
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.panel));
    }

    private static final Unit _init_$lambda$1(CpuAndMemoryTab this$0, CpuAndMemoryError cpuAndMemoryError, Throwable exc) {
        Intrinsics.checkNotNullParameter((Object)cpuAndMemoryError, (String)"<unused var>");
        this$0.panel.setEnabled(false);
        this$0.getEmptyText().clear();
        String title = UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.charts.cannot.load", new Object[0]);
        this$0.getEmptyText().appendText(title);
        Object object = exc;
        if (object != null && (object = ((Throwable)object).getLocalizedMessage()) != null) {
            Object msg = object;
            boolean bl = false;
            this$0.getEmptyText().appendLine((String)msg, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
        }
        this$0.getEmptyText().appendLine("");
        this$0.getEmptyText().appendLine(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.charts.reshow", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> CpuAndMemoryTab.lambda$1$1(this$0, arg_0));
        this$0.removeAll();
        this$0.repaint();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CpuAndMemoryTab.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error(title, exc);
        return Unit.INSTANCE;
    }

    private static final void lambda$1$1(CpuAndMemoryTab this$0, ActionEvent it) {
        this$0.addAll();
        this$0.repaint();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/welcome/CpuAndMemoryTab$PerformGCAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/profiler/ultimate/welcome/CpuAndMemoryTab;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.profiler.ultimate"})
    private final class PerformGCAction
    extends DumbAwareAction {
        public PerformGCAction() {
            super(PerformGCAction::_init_$lambda$0, AllIcons.Actions.GC);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ApplicationManager.getApplication().executeOnPooledThread(() -> PerformGCAction.actionPerformed$lambda$0(CpuAndMemoryTab.this));
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(CpuAndMemoryTab.this.panel.isEnabled());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        private static final String _init_$lambda$0() {
            return UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.charts.gc", new Object[0]);
        }

        private static final void actionPerformed$lambda$0(CpuAndMemoryTab this$0) {
            JMXProcessMonitor.Companion.connect(this$0.getTargetProcess().getPid(), PerformGCAction::actionPerformed$lambda$0$0);
        }

        private static final Unit actionPerformed$lambda$0$0(JMXProcessMonitor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.getMemoryBean().gc();
            return Unit.INSTANCE;
        }
    }
}

