/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.diagnostics;

import com.intellij.ml.diagnostics.FeatureDiagnosticEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0000H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/diagnostics/TextMessage;", "Lcom/intellij/ml/diagnostics/FeatureDiagnosticEvent;", "text", "", "featureId", "timestamp", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;J)V", "getText", "()Ljava/lang/String;", "getFeatureId", "getTimestamp", "()J", "toTextMessage", "formattedMessage", "getFormattedMessage", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.diagnostics"})
@ApiStatus.Internal
public final class TextMessage
implements FeatureDiagnosticEvent {
    @NotNull
    private final String text;
    @NotNull
    private final String featureId;
    private final long timestamp;

    public TextMessage(@NotNull String text2, @NotNull String featureId, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)featureId, (String)"featureId");
        this.text = text2;
        this.featureId = featureId;
        this.timestamp = timestamp;
    }

    public /* synthetic */ TextMessage(String string, String string2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = System.currentTimeMillis();
        }
        this(string, string2, l);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public TextMessage toTextMessage() {
        return this;
    }

    @NotNull
    public final String getFormattedMessage() {
        return "[" + this.getFeatureId() + "] " + this.text;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final String component2() {
        return this.featureId;
    }

    public final long component3() {
        return this.timestamp;
    }

    @NotNull
    public final TextMessage copy(@NotNull String text2, @NotNull String featureId, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)featureId, (String)"featureId");
        return new TextMessage(text2, featureId, timestamp);
    }

    public static /* synthetic */ TextMessage copy$default(TextMessage textMessage, String string, String string2, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = textMessage.text;
        }
        if ((n & 2) != 0) {
            string2 = textMessage.featureId;
        }
        if ((n & 4) != 0) {
            l = textMessage.timestamp;
        }
        return textMessage.copy(string, string2, l);
    }

    @NotNull
    public String toString() {
        return "TextMessage(text=" + this.text + ", featureId=" + this.featureId + ", timestamp=" + this.timestamp + ")";
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + this.featureId.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.timestamp);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextMessage)) {
            return false;
        }
        TextMessage textMessage = (TextMessage)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)textMessage.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.featureId, (Object)textMessage.featureId)) {
            return false;
        }
        return this.timestamp == textMessage.timestamp;
    }
}

