/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.web.xml;

import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexeme;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J(\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0013\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/inline/completion/web/xml/XmlMLCompletionLexerBase;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosures", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "getLexingResult", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexer$LexingResult;", "lexemes", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexeme;", "lexer", "Lcom/intellij/lexer/Lexer;", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "onBracketToken", "collectBracket", "findStringMarkers", "bracketsSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.fullLine.web"})
public abstract class XmlMLCompletionLexerBase
extends MLCompletionLexerAdapter {
    @NotNull
    private final TokenSet bracketsSet;

    public XmlMLCompletionLexerBase(@NotNull MLCompletionEnclosuresDefinition enclosures) {
        Intrinsics.checkNotNullParameter((Object)enclosures, (String)"enclosures");
        super(enclosures);
        IElementType[] iElementTypeArray = new IElementType[]{XmlTokenType.XML_TAG_END, XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_EMPTY_ELEMENT_END};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.bracketsSet = tokenSet;
    }

    @Override
    @NotNull
    protected MLCompletionLexer.LexingResult getLexingResult(@NotNull List<? extends MLCompletionLexeme> lexemes, @NotNull Lexer lexer2) {
        Intrinsics.checkNotNullParameter(lexemes, (String)"lexemes");
        Intrinsics.checkNotNullParameter((Object)lexer2, (String)"lexer");
        CharSequence charSequence = lexer2.getBufferSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
        return new MLCompletionLexer.LexingResult(lexemes, new MLCompletionLexer.LexingContext(charSequence));
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text2, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        if (this.bracketsSet.contains(token)) {
            this.onBracketToken(token, text2, offset, collector2);
        } else if (Intrinsics.areEqual((Object)text2, (Object)"<") && Intrinsics.areEqual((Object)token, (Object)XmlTokenType.XML_DATA_CHARACTERS)) {
            this.onBracketToken(token, text2, offset, collector2);
        } else {
            this.findStringMarkers(token, text2, offset, collector2);
        }
    }

    private final void onBracketToken(IElementType token, String text2, int offset, MLCompletionLexerAdapter.LexemesCollector collector2) {
        MLCompletionLexerAdapter.Location location = collector2.getCurrentLocation();
        if (location instanceof MLCompletionLexerAdapter.Location.Global) {
            this.collectBracket(token, text2, offset, collector2);
        } else if (!(location instanceof MLCompletionLexerAdapter.Location.StringLiteral) && !(location instanceof MLCompletionLexerAdapter.Location.StringTemplate)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void collectBracket(IElementType token, String text2, int offset, MLCompletionLexerAdapter.LexemesCollector collector2) {
        if (!(((CharSequence)text2).length() > 0)) {
            throw new IllegalStateException("Check failed.");
        }
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_END_TAG_START)) {
            if (Intrinsics.areEqual((Object)text2, (Object)"</")) {
                collector2.bracket('<', offset);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_EMPTY_ELEMENT_END)) {
            if (Intrinsics.areEqual((Object)text2, (Object)"/>")) {
                collector2.bracket('>', offset + 1);
            }
        } else if (text2.length() == 1) {
            collector2.bracket(StringsKt.first((CharSequence)text2), offset);
        }
    }

    private final void findStringMarkers(IElementType token, String text2, int offset, MLCompletionLexerAdapter.LexemesCollector collector2) {
        IElementType iElementType = token;
        if ((Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) || Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER)) && (Intrinsics.areEqual((Object)text2, (Object)"'") || Intrinsics.areEqual((Object)text2, (Object)"\""))) {
            MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, StringsKt.first((CharSequence)text2), offset, null, 4, null);
        }
    }
}

