/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.hardware;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.impl.local.HostApi;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsFilesService;
import org.jetbrains.completion.full.line.local.services.SignManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/completion/full/line/impl/hardware/CpuDetector;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "detectorExecutable", "Ljava/nio/file/Path;", "getDetectorExecutable", "()Ljava/nio/file/Path;", "detectorExecutable$delegate", "Lkotlin/Lazy;", "getCpuInfo", "", "intellij.fullLine.core.impl"})
@SourceDebugExtension(value={"SMAP\nCpuDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuDetector.kt\norg/jetbrains/completion/full/line/impl/hardware/CpuDetector\n+ 2 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n50#2:84\n13#3:85\n*S KotlinDebug\n*F\n+ 1 CpuDetector.kt\norg/jetbrains/completion/full/line/impl/hardware/CpuDetector\n*L\n22#1:84\n22#1:85\n*E\n"})
public final class CpuDetector {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Lazy detectorExecutable$delegate;

    public CpuDetector() {
        CpuDetector $this$thisMLCompletionLogger$iv = this;
        boolean $i$f$thisMLCompletionLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CpuDetector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = MLCompletionLogger.constructor-impl(logger);
        this.detectorExecutable$delegate = LazyKt.lazy(() -> CpuDetector.detectorExecutable_delegate$lambda$0(this));
    }

    private final Path getDetectorExecutable() {
        Lazy lazy = this.detectorExecutable$delegate;
        return (Path)lazy.getValue();
    }

    @Nullable
    public final String getCpuInfo() {
        Path executable = this.getDetectorExecutable();
        if (executable == null) {
            return null;
        }
        if (executable.getParent() == null) {
            DiagnosticsLogger.warn$default(MLCompletionLogger.box-impl(this.LOG), "There's no parent dir for CPU detector", null, 2, null);
            return null;
        }
        try {
            SignManager signManager = SignManager.Companion.getInstance();
            Path path = executable.resolveSibling("sign");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
            signManager.verify(executable, path);
        }
        catch (Throwable e) {
            DiagnosticsLogger.warn$default(MLCompletionLogger.box-impl(this.LOG), "CPU detector check failed: " + e, null, 2, null);
            return null;
        }
        try {
            String[] stringArray = new String[]{((Object)executable.toAbsolutePath()).toString()};
            ProcessOutput res = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(stringArray));
            String string = res.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            if (!(((CharSequence)string).length() == 0)) {
                DiagnosticsLogger.warn$default(MLCompletionLogger.box-impl(this.LOG), "CPU detector call stderr: " + res.getStderr(), null, 2, null);
            }
            return res.getStdout();
        }
        catch (Throwable e) {
            DiagnosticsLogger.warn$default(MLCompletionLogger.box-impl(this.LOG), "CPU detector call failed: " + e, null, 2, null);
            return null;
        }
    }

    private static final Path detectorExecutable_delegate$lambda$0(CpuDetector this$0) {
        if (!SystemInfoRt.isWindows) {
            return null;
        }
        if (!CpuArch.isIntel64() && !CpuArch.isIntel32()) {
            return null;
        }
        String baseName = "cpu-detector";
        Path path = LocalModelsFilesService.Companion.getInstance().getRoot().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path serviceRoot = path2;
        Path path3 = serviceRoot.resolve(baseName);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path root = PathKt.createParentDirectories((Path)path3);
        Path fullPath = root.resolve(baseName + ".exe");
        Intrinsics.checkNotNull((Object)fullPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(fullPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            MLCompletionLogger.box-impl(this$0.LOG).info("CPU detector found: " + fullPath);
            return fullPath;
        }
        try {
            File file = PluginPathManager.getPluginResource(this$0.getClass(), (String)("full-line-cpu-detector-" + HostApi.Companion.getOs() + "-" + HostApi.Companion.getCpu() + ".zip"));
            if (file == null) {
                return null;
            }
            File bundledDetectorArchive = file;
            MLCompletionLogger.box-impl(this$0.LOG).info("Getting CPU detector from: " + bundledDetectorArchive);
            NioFiles.deleteRecursively((Path)root);
            PathKt.createDirectories((Path)root);
            ZipUtil.extract((Path)bundledDetectorArchive.toPath(), (Path)root, null, (boolean)true);
        }
        catch (Throwable e) {
            DiagnosticsLogger.warn$default(MLCompletionLogger.box-impl(this$0.LOG), "Cannot extract CPU detector: " + e, null, 2, null);
            return null;
        }
        MLCompletionLogger.box-impl(this$0.LOG).info("CPU detector is ready: " + fullPath);
        return fullPath;
    }
}

