/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public abstract class ToTemporalDurationNode
extends JavaScriptBaseNode {
    protected ToTemporalDurationNode() {
    }

    public abstract JSTemporalDurationObject execute(Object var1);

    @Specialization
    protected JSTemporalDurationObject toTemporalDuration(Object item, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode) {
        JSTemporalDurationRecord result;
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)item;
            if (JSTemporalDuration.isJSTemporalDuration(itemObj)) {
                return (JSTemporalDurationObject)itemObj;
            }
            result = JSTemporalDuration.toTemporalDurationRecord(itemObj);
        } else {
            TruffleString string = toStringNode.executeString(item);
            result = JSTemporalDuration.parseTemporalDurationString(string);
        }
        return JSTemporalDuration.createTemporalDuration(this.getLanguage().getJSContext(), this.getRealm(), result.getYears(), result.getMonths(), result.getWeeks(), result.getDays(), result.getHours(), result.getMinutes(), result.getSeconds(), result.getMilliseconds(), result.getMicroseconds(), result.getNanoseconds(), this, errorBranch);
    }
}

