/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.X11Forwarding;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\n\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\bH\u0002\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"tryConnect", "Ljava/net/Socket;", "Lcom/intellij/ssh/X11Forwarding;", "minimalX11Port", "", "n", "", "value", "", "Ljava/net/SocketAddress;", "n", "d", "n", "s", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nX11Forwarding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 X11Forwarding.kt\ncom/intellij/ssh/X11ForwardingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class X11ForwardingKt {
    private static final int minimalX11Port = 6000;
    @NotNull
    private static final Logger LOG;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Socket tryConnect(@NotNull X11Forwarding $this$tryConnect) throws IOException {
        Object object;
        Object object2;
        block5: {
            block4: {
                String string;
                Intrinsics.checkNotNullParameter((Object)$this$tryConnect, (String)"<this>");
                String string2 = $this$tryConnect.getDisplayName();
                object2 = string2;
                boolean bl = false;
                String string3 = string = ((CharSequence)object2).length() > 0 ? string2 : null;
                if (string == null) break block4;
                object2 = string;
                String string4 = object2;
                boolean bl2 = false;
                X11ForwardingKt.n(string4);
                String string5 = object2;
                boolean bl3 = false;
                Socket socket = X11ForwardingKt.s(string5);
                if (socket == null) {
                    socket = X11ForwardingKt.n(string5);
                }
                if ((object2 = socket) != null) break block5;
            }
            Socket socket = X11ForwardingKt.n();
            object = socket;
            if (socket != null) return object;
            X11Forwarding x11Forwarding = $this$tryConnect;
            boolean bl = false;
            LOG.info("Can't extract path to X11 socket from DISPLAY=" + x11Forwarding.getDisplayName());
            return null;
        }
        object = object2;
        return object;
    }

    private static final void n(String string) {
        if (((CharSequence)string).length() > 0) {
            CharSequence charSequence = string;
            if (!new Regex("^[A-Za-z0-9:/._-]+$").matches(charSequence)) {
                boolean bl = false;
                String string2 = "DISPLAY = `" + string + "` contains invalid character";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!(string.length() < 512)) {
                boolean bl = false;
                String string3 = "DISPLAY is too long";
                throw new IllegalArgumentException(string3.toString());
            }
        }
    }

    private static final Socket n(SocketAddress socketAddress) {
        Socket socket;
        Socket socket2 = socket = new Socket();
        boolean bl = false;
        socket2.connect(socketAddress);
        return socket;
    }

    private static final Socket n(String string) {
        Object object = string;
        if (new Regex("^:[0-9]+$").matches((CharSequence)object)) {
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = "/tmp/.X11-unix/X" + string2;
            LOG.info("DISPLAY=" + string + " points to unix:" + (String)object);
            UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
            return X11ForwardingKt.n(unixDomainSocketAddress);
        }
        if (StringsKt.startsWith$default((String)string, (String)"unix:", (boolean)false, (int)2, null)) {
            LOG.info("DISPLAY=" + string + " points to " + string);
            String string3 = string.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(string3);
            Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
            return X11ForwardingKt.n(unixDomainSocketAddress);
        }
        int n = StringsKt.lastIndexOf$default((CharSequence)string, (char)':', (int)0, (boolean)false, (int)6, null);
        if (n >= 0) {
            Object object2;
            Object object3;
            Object object4;
            String string4 = string.substring(0, n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String string5 = string4;
            try {
                boolean bl = false;
                object4 = Result.constructor-impl((Object)InetAddress.getByName(string5));
            }
            catch (Throwable throwable) {
                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
            if (throwable == null) {
                object3 = object4;
            } else {
                object2 = throwable;
                boolean bl = false;
                LOG.warn("Can't resolve " + string5, (Throwable)object2);
                object3 = null;
            }
            InetAddress inetAddress = (InetAddress)object3;
            try {
                boolean bl = false;
                String string6 = string.substring(n + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                object2 = Result.constructor-impl((Object)(Integer.parseInt(string6) + 6000));
            }
            catch (Throwable throwable2) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Integer n2 = -1;
            int n3 = ((Number)(Result.isFailure-impl((Object)object2) ? n2 : object2)).intValue();
            if (inetAddress != null) {
                boolean bl = 6000 <= n3 ? n3 < 65536 : false;
                if (bl) {
                    LOG.info("DISPLAY=" + string + " points to " + inetAddress + ":" + n3);
                    return X11ForwardingKt.n(new InetSocketAddress(inetAddress, n3));
                }
            }
        }
        return null;
    }

    private static final Socket n() {
        Socket socket;
        if (SystemInfo.isWindows) {
            Socket socket2;
            LOG.info("Trying tcp:localhost:6000 on Windows");
            try {
                socket2 = X11ForwardingKt.n(new InetSocketAddress(InetAddress.getLoopbackAddress(), 6000));
            }
            catch (IOException iOException) {
                socket2 = null;
            }
            socket = socket2;
        } else {
            socket = null;
        }
        return socket;
    }

    private static final Socket s(String string) {
        Socket socket;
        if (!SystemInfo.isMac) {
            socket = null;
        } else if (string.charAt(0) != '/') {
            socket = null;
        } else if (new File(string).exists()) {
            LOG.info("DISPLAY=" + string + " is a macOS socket that points to unix:" + string);
            UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(string);
            Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
            socket = X11ForwardingKt.n(unixDomainSocketAddress);
        } else {
            String string2 = StringsKt.substringBeforeLast((String)string, (char)'.', (String)"");
            if (!Intrinsics.areEqual((Object)string2, (Object)"")) {
                LOG.info("DISPLAY=" + string + " is a Mac X socket that points to unix:" + string2);
                UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(string2);
                Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
                socket = X11ForwardingKt.n(unixDomainSocketAddress);
            } else {
                socket = null;
            }
        }
        return socket;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$verifyDisplay(String value) {
        X11ForwardingKt.n(value);
    }

    static {
        Logger logger = Logger.getInstance(X11Forwarding.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

