/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.context;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.Iterator;
import java.util.NoSuchElementException;

class DirectoryIterator
implements Iterator<XmlFile> {
    private final PsiFile[] files;
    private int currentIndex = 0;
    private XmlFile nextFile = null;

    DirectoryIterator(PsiDirectory directory) {
        this.files = directory.getFiles();
        this.fetchNextFile();
    }

    @Override
    public boolean hasNext() {
        return this.nextFile != null;
    }

    @Override
    public XmlFile next() {
        if (this.nextFile == null) {
            throw new NoSuchElementException();
        }
        XmlFile out = this.nextFile;
        this.fetchNextFile();
        return out;
    }

    @Override
    public void remove() {
    }

    private void fetchNextFile() {
        while (this.currentIndex < this.files.length) {
            if (this.files[this.currentIndex] instanceof XmlFile) {
                this.nextFile = (XmlFile)this.files[this.currentIndex];
                ++this.currentIndex;
                return;
            }
            ++this.currentIndex;
        }
        this.nextFile = null;
    }
}

